/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.helper;

import com.prelytis.dashboard.dao.DaoFactory;
import com.prelytis.dashboard.dao.EntityDao;
import com.prelytis.dashboard.dao.LanguageDao;
import com.prelytis.dashboard.dao.PersFieldDao;
import com.prelytis.dashboard.dao.ThemeDao;
import com.prelytis.dashboard.dao.UserDao;
import com.prelytis.dashboard.dao.WorkspaceDao;
import com.prelytis.dashboard.helper.ConnectionInformationHelper;
import com.prelytis.dashboard.helper.ExceptionHelper;
import com.prelytis.dashboard.interfaces.DashboardException;
import com.prelytis.dashboard.interfaces.DashboardRuntimeException;
import com.prelytis.dashboard.interfaces.Element;
import com.prelytis.dashboard.interfaces.ErrorCode;
import com.prelytis.dashboard.persistence.Configuration;
import com.prelytis.dashboard.util.sql.ConnectionInformation;
import com.prelytis.dashboard.value.data.Bean;
import com.prelytis.dashboard.value.data.BeanEntity;
import com.prelytis.dashboard.value.data.BeanExecutionContext;
import com.prelytis.dashboard.value.data.BeanLanguage;
import com.prelytis.dashboard.value.data.BeanPRPInfo;
import com.prelytis.dashboard.value.data.BeanPersFieldValue;
import com.prelytis.dashboard.value.data.BeanTheme;
import com.prelytis.dashboard.value.data.BeanUser;
import com.prelytis.dashboard.value.data.BeanUserExecutionContext;
import com.prelytis.dashboard.value.data.BeanWorkspace;
import com.prelytis.dashboard.value.util.ExpressionEvaluationData;
import com.prelytis.dashboard.value.util.ExpressionEvaluationDataDefault;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;

public final class ExpressionEvaluationDataHelper {
    private final DaoFactory daoFactory;

    private ExpressionEvaluationDataHelper(DaoFactory daoFactory) {
        this.daoFactory = daoFactory;
    }

    public static ExpressionEvaluationDataHelper getInstance(DaoFactory daoFactory) {
        return new ExpressionEvaluationDataHelper(daoFactory);
    }

    @Deprecated
    public ExpressionEvaluationData getExpressionEvaluationData(BeanUser user) {
        UserDao userDao = this.daoFactory.getUserDao();
        Configuration configuration = Configuration.getInstance();
        BeanExecutionContext uec = (BeanExecutionContext)user.getExecutionContextList().get(0);
        return this.getExpressionEvaluationData(user, null, uec.getName(), configuration.getBaseDir(), userDao);
    }

    public ExpressionEvaluationData getExpressionEvaluationData(BeanUser user, String executionContext) {
        UserDao userDao = this.daoFactory.getUserDao();
        Configuration configuration = Configuration.getInstance();
        return this.getExpressionEvaluationData(user, null, executionContext, configuration.getBaseDir(), userDao);
    }

    public ExpressionEvaluationData getExpressionEvaluationData(String userSessionGuid, String executionContext) throws DashboardException {
        UserDao userDao = this.daoFactory.getUserDao();
        Configuration configuration = Configuration.getInstance();
        ConnectionInformationHelper helper = ConnectionInformationHelper.getInstance(this.daoFactory);
        ConnectionInformation ci = helper.getConnectedUser(userSessionGuid);
        if (ci == null) {
            throw ExceptionHelper.getInstance(Locale.ENGLISH).createInvalidSessionGUIDException();
        }
        if (executionContext == null) {
            executionContext = ci.getExecutionContextName();
        }
        BeanUser user = (BeanUser)userDao.getCore(ci.getUserName());
        return this.getExpressionEvaluationData(user, userSessionGuid, executionContext != null ? executionContext : ci.getExecutionContextName(), configuration.getBaseDir(), userDao);
    }

    private ExpressionEvaluationData getExpressionEvaluationData(BeanUser user, String userSessionGuid, String executionContext, String baseDir, UserDao userDao) {
        BeanUserExecutionContext ec = null;
        for (BeanUserExecutionContext bec : user.getExecutionContextList()) {
            if ((executionContext != null || user.getDefaultExecutionContextOID() != bec.getObjectID()) && (executionContext == null || !executionContext.equals(bec.getName()))) continue;
            ec = bec;
            break;
        }
        if (ec == null) {
            throw new DashboardRuntimeException(ErrorCode.INSIGHT_UNKNOWN, "Unknown execution context");
        }
        EntityDao entityDao = this.daoFactory.getEntityDao();
        Bean entity = entityDao.getCore(ec.getEntityOid());
        LanguageDao languageDao = this.daoFactory.getLanguageDao();
        BeanLanguage language = (BeanLanguage)languageDao.getCore(user.getLanguageOID());
        WorkspaceDao workspaceDao = this.daoFactory.getWorkspaceDao();
        BeanWorkspace workspace = (BeanWorkspace)workspaceDao.getCore(ec.getWorkspaceOid());
        ThemeDao themeDao = this.daoFactory.getThemeDao();
        BeanTheme theme = (BeanTheme)themeDao.getCore(user.getThemeOID());
        ExpressionEvaluationDataDefault data = new ExpressionEvaluationDataDefault();
        data.setEntityName(entity.getName());
        data.setEntityOid(Integer.valueOf(ec.getEntityOid()));
        data.setLanguage(language.getLanguage());
        data.setLanguageOid(Integer.valueOf(user.getLanguageOID()));
        data.setLanguageName(language.getName());
        data.setLocale(new Locale(language.getLanguage()));
        data.setPersFieldList(userDao.getPersFieldList(user.getObjectID(), ec.getEntityOid(), ec.getWorkspaceOid()));
        data.setProfile(Integer.valueOf(ec.getProfile()));
        data.setTimeZone(TimeZone.getTimeZone(user.getTimeZone()));
        data.setUserName(user.getName());
        data.setUserOid(Integer.valueOf(user.getObjectID()));
        data.setUserSessionGuid(userSessionGuid);
        data.setWorkspaceName(workspace.getName());
        data.setWorkspaceOid(Integer.valueOf(ec.getWorkspaceOid()));
        data.setThemeName(theme.getName());
        data.setThemeOid(Integer.valueOf(theme.getObjectID()));
        data.setExecutionContextName(ec.getName());
        data.setExecutionContextOid(Integer.valueOf(ec.getObjectID()));
        data.setBaseDir(baseDir);
        return data;
    }

    public ExpressionEvaluationData getExpressionEvaluationData(BeanEntity entity) {
        ExpressionEvaluationDataDefault data = new ExpressionEvaluationDataDefault();
        data.setEntityName(entity.getName());
        data.setEntityOid(Integer.valueOf(entity.getObjectID()));
        BeanPRPInfo info = this.daoFactory.getPrelytisInfoDao().getPrelytisInfo();
        LanguageDao languageDao = this.daoFactory.getLanguageDao();
        BeanLanguage language = (BeanLanguage)languageDao.getCore(info.getLanguageOID());
        data.setLanguage(language.getLanguage());
        data.setLanguageOid(Integer.valueOf(language.getObjectID()));
        data.setLanguageName(language.getName());
        data.setLocale(new Locale(language.getLanguage()));
        EntityDao entityDao = this.daoFactory.getEntityDao();
        data.setPersFieldList(entityDao.getPersFieldList(entity.getObjectID()));
        data.setProfile(null);
        data.setTimeZone(TimeZone.getTimeZone("GMT"));
        data.setUserName(null);
        data.setUserOid(null);
        data.setThemeName("Axway");
        data.setThemeOid(Integer.valueOf(1));
        data.setUserSessionGuid(null);
        data.setWorkspaceName(null);
        data.setWorkspaceOid(null);
        Configuration configuration = Configuration.getInstance();
        data.setBaseDir(configuration.getBaseDir());
        return data;
    }

    @Deprecated
    public ExpressionEvaluationData getDefaultData() {
        PersFieldDao persFieldDao = this.daoFactory.getPersFieldDao();
        List list = persFieldDao.listAll(null, 1);
        ArrayList<BeanPersFieldValue> defaultList = new ArrayList<BeanPersFieldValue>();
        for (Element elt : list) {
            BeanPersFieldValue dst = new BeanPersFieldValue(elt);
            defaultList.add(dst);
        }
        return this.getExpressionEvaluationData(defaultList);
    }

    private ExpressionEvaluationData getExpressionEvaluationData(List<BeanPersFieldValue> persFieldValueList) {
        ExpressionEvaluationDataDefault data = new ExpressionEvaluationDataDefault();
        data.setEntityName(null);
        data.setEntityOid(null);
        BeanPRPInfo info = this.daoFactory.getPrelytisInfoDao().getPrelytisInfo();
        LanguageDao languageDao = this.daoFactory.getLanguageDao();
        BeanLanguage language = (BeanLanguage)languageDao.getCore(info.getLanguageOID());
        data.setLanguage(language.getLanguage());
        data.setLanguageOid(Integer.valueOf(language.getObjectID()));
        data.setLanguageName(language.getName());
        data.setLocale(new Locale(language.getLanguage()));
        data.setPersFieldList(persFieldValueList);
        data.setProfile(null);
        data.setTimeZone(TimeZone.getDefault());
        data.setUserName(null);
        data.setUserOid(null);
        data.setThemeName("Axway");
        data.setThemeOid(Integer.valueOf(1));
        data.setUserSessionGuid(null);
        data.setWorkspaceName(null);
        data.setWorkspaceOid(null);
        Configuration configuration = Configuration.getInstance();
        data.setBaseDir(configuration.getBaseDir());
        return data;
    }
}

