/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.helper;

import com.prelytis.dashboard.dao.DaoFactory;
import com.prelytis.dashboard.dao.WorkspaceDao;
import com.prelytis.dashboard.dao.WorldDao;
import com.prelytis.dashboard.data.engine.CommandParameter;
import com.prelytis.dashboard.data.engine.ExecutionContext;
import com.prelytis.dashboard.data.helper.EngineHelper;
import com.prelytis.dashboard.db.operator.WorldHelper;
import com.prelytis.dashboard.db.sql.Result;
import com.prelytis.dashboard.db.value.Value;
import com.prelytis.dashboard.helper.ExceptionHelper;
import com.prelytis.dashboard.helper.FormSelectHelper;
import com.prelytis.dashboard.helper.ValueListHelper;
import com.prelytis.dashboard.interfaces.DashboardException;
import com.prelytis.dashboard.interfaces.SessionParameterType;
import com.prelytis.dashboard.persistence.Configuration;
import com.prelytis.dashboard.persistence.DataSourceConfiguration;
import com.prelytis.dashboard.task.execution.TableExecutionAutoCommit;
import com.prelytis.dashboard.task.execution.TableExecutionDataSource;
import com.prelytis.dashboard.task.execution.TableExecutionDirectDelete;
import com.prelytis.dashboard.task.execution.TableExecutionDirectInsert;
import com.prelytis.dashboard.task.execution.TableExecutionDirectUpdate;
import com.prelytis.dashboard.util.ConversionHelper;
import com.prelytis.dashboard.util.ExpressionEvaluationHelper;
import com.prelytis.dashboard.util.sql.SQLTable;
import com.prelytis.dashboard.util.sql.SQLTableHelper;
import com.prelytis.dashboard.value.data.AbstractBeanReport;
import com.prelytis.dashboard.value.data.AbstractBeanReportAvlField;
import com.prelytis.dashboard.value.data.BeanFormDefinition;
import com.prelytis.dashboard.value.data.BeanFormField;
import com.prelytis.dashboard.value.data.BeanFormFieldSelect;
import com.prelytis.dashboard.value.data.BeanFormFieldSelectFinal;
import com.prelytis.dashboard.value.data.BeanFormFieldValue;
import com.prelytis.dashboard.value.data.BeanQueryDataStructure;
import com.prelytis.dashboard.value.data.BeanQueryDataStructureTable;
import com.prelytis.dashboard.value.data.BeanQueryDataStructureTableField;
import com.prelytis.dashboard.value.data.BeanQueryDataStructureTableKey;
import com.prelytis.dashboard.value.data.BeanQuerySQLField;
import com.prelytis.dashboard.value.data.BeanQuerySQLFieldDataStructure;
import com.prelytis.dashboard.value.data.BeanReportAvlField;
import com.prelytis.dashboard.value.data.BeanReportAvlGroup;
import com.prelytis.dashboard.value.data.BeanReportStd;
import com.prelytis.dashboard.value.data.BeanReportStdSortField;
import com.prelytis.dashboard.value.data.BeanReportStdUsedField;
import com.prelytis.dashboard.value.data.BeanWorldDefinition;
import com.prelytis.dashboard.value.data.ReportFilter;
import com.prelytis.dashboard.value.data.ValueListElt;
import com.prelytis.dashboard.value.query.ComparisonExpression;
import com.prelytis.dashboard.value.query.Expression;
import com.prelytis.dashboard.value.query.FieldOperand;
import com.prelytis.dashboard.value.query.LogicalExpression;
import com.prelytis.dashboard.value.query.Operand;
import com.prelytis.dashboard.value.query.PromptOperand;
import com.prelytis.dashboard.value.structure.FormDocument;
import com.prelytis.dashboard.value.structure.FormRow;
import com.prelytis.dashboard.value.util.DataType;
import com.prelytis.dashboard.value.util.ExpressionEvaluationData;
import com.prelytis.dashboard.value.util.FieldMetaData;
import com.prelytis.dashboard.value.util.IPoolDBInfo;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import javax.sql.DataSource;

public final class FormDocumentHelper {
    private final BeanFormDefinition form;
    private final BeanQueryDataStructure ds;
    private final Map<String, BeanReportAvlField> avlFields;
    private ExpressionEvaluationData data;
    private final Map<String, ReportFilter> filterMap;
    private final List<BeanFormField> formFieldList;
    private final List<BeanFormField> hiddenFormFieldList;
    private final BeanReportStd report;
    private final FormSelectHelper formSelectHelper;
    private final DaoFactory daoFactory;

    private FormDocumentHelper(DaoFactory daoFactory, BeanFormDefinition form, BeanQueryDataStructure ds, ExpressionEvaluationData data, Map<String, ReportFilter> filterMap, List<BeanFormField> formFieldList, List<BeanFormField> hiddenFormFieldList, BeanReportStd report, Map<String, BeanReportAvlField> avlFields, FormSelectHelper formSelectHelper) {
        this.daoFactory = daoFactory;
        this.form = form;
        this.ds = ds;
        this.avlFields = avlFields;
        this.data = data;
        this.filterMap = filterMap;
        this.formFieldList = formFieldList;
        this.hiddenFormFieldList = hiddenFormFieldList;
        this.report = report;
        this.formSelectHelper = formSelectHelper;
    }

    public static final FormDocumentHelper getInstance(DaoFactory daoFactory, BeanFormDefinition form, BeanQueryDataStructure ds, ExpressionEvaluationData data, List<? extends ReportFilter> filterList) throws DashboardException {
        HashMap<String, BeanReportAvlField> avlFields = new HashMap<String, BeanReportAvlField>();
        BeanQueryDataStructureTable table = FormDocumentHelper.getTable(ds.getTableFact(), form.getTableName());
        FormSelectHelper formSelectHelper = FormSelectHelper.getInstance(table);
        BeanQueryDataStructureTableKey pk = formSelectHelper.getPrimaryKey();
        if (pk == null || pk.getFieldList().isEmpty()) {
            throw ExceptionHelper.getInstance(data.getLocale()).createDashboardException("missingPrimaryKey", null, null);
        }
        HashSet pkFields = new HashSet();
        pkFields.addAll(pk.getFieldList());
        FormDocumentHelper.fill(table, avlFields);
        ExpressionEvaluationHelper eeh = ExpressionEvaluationHelper.getInstance();
        ConversionHelper ch = ConversionHelper.getConverter((Locale)data.getLocale(), (TimeZone)data.getTimeZone(), (boolean)true);
        HashMap<String, ReportFilter> filterMap = new HashMap<String, ReportFilter>();
        BeanReportStd report = new BeanReportStd();
        if (filterList != null) {
            for (ReportFilter reportFilter : filterList) {
                filterMap.put(reportFilter.getName(), reportFilter);
            }
        }
        BeanReportAvlGroup group = new BeanReportAvlGroup();
        group.setName("Attribut");
        group.getFields().addAll(avlFields.values());
        report.getAvlGroupList().add(group);
        report.setQueryOID(form.getQueryOID());
        report.setQueryName(form.getQueryName());
        LogicalExpression logicalExpression = new LogicalExpression();
        logicalExpression.setOperator(1);
        ArrayList<BeanFormField> vl = new ArrayList<BeanFormField>();
        ArrayList<BeanFormField> hl = new ArrayList<BeanFormField>();
        for (BeanFormField field : form.getUsedFields()) {
            ArrayList<BeanFormField> formFieldList;
            boolean visible = field.getDisplayType() != null && field.getDisplayType().contains(BeanFormField.DisplayType.VISIBLE);
            ArrayList<BeanFormField> arrayList = formFieldList = visible ? vl : hl;
            if (field instanceof BeanFormFieldSelect) {
                BeanFormFieldSelect fs = (BeanFormFieldSelect)field;
                FormSelectHelper.FormSelect select = formSelectHelper.getFromKeyName(fs.getValueListIndexName());
                if (select != null) {
                    String fn = select.getDescField().getName();
                    BeanReportAvlField avlField = (BeanReportAvlField)avlFields.get(fn);
                    if (avlField != null) {
                        boolean linked;
                        ReportFilter rf = (ReportFilter)filterMap.get(avlField.getName());
                        boolean bl = linked = fs.isLinkable() && rf != null && rf.getUseFilter();
                        if (visible) {
                            BeanReportStdUsedField uf = new BeanReportStdUsedField();
                            uf.setField((AbstractBeanReportAvlField)avlField);
                            report.getFieldList().add(uf);
                            for (BeanQueryDataStructureTableField tf : select.getFkFields()) {
                                pkFields.remove(tf.getSqlField());
                            }
                        }
                        if (linked) {
                            logicalExpression.getExpressionList().add(FormDocumentHelper.getCE(avlField));
                            BeanFormFieldValue fv = new BeanFormFieldValue();
                            FormDocumentHelper.copy((BeanFormField)fs, fv);
                            BeanQuerySQLField sqlf = avlField.getField();
                            fv.setSqlNullable(sqlf.isNullable());
                            fv.setDataType(sqlf.getDataType());
                            fv.setFieldName(sqlf.getName());
                            fv.setDefaultValue(rf.getValue());
                            fv.setDisplayType(EnumSet.of(BeanFormField.DisplayType.VISIBLE));
                            formFieldList.add((BeanFormField)fv);
                            continue;
                        }
                        BeanFormFieldSelectFinal ff = new BeanFormFieldSelectFinal();
                        ff.setValueListIndexName(fs.getValueListIndexName());
                        ff.setSqlNullable(fs.isSqlNullable());
                        ff.setDataType(fs.getDataType());
                        ff.setCommentKey(fs.getCommentKey());
                        ff.setDescriptionKey(fs.getDescriptionKey());
                        ff.setSqlInsert(fs.isSqlInsert());
                        ff.setSqlUpdate(fs.isSqlUpdate());
                        ff.setLinkable(fs.isLinkable());
                        ff.setValueListSortOrder(fs.getValueListSortOrder());
                        ff.setDisplayType(fs.getDisplayType() == null ? null : fs.getDisplayType().clone());
                        ff.setDefaultValue(FormDocumentHelper.getResolvedValue(ch, eeh, data, fs.getDefaultValue()));
                        ff.setPrimaryKey(fs.isPrimaryKey());
                        formFieldList.add((BeanFormField)ff);
                        continue;
                    }
                    throw ExceptionHelper.getInstance(data.getLocale()).createDashboardException("fieldNotFoundInQuery", new Object[]{fn, ds.getName()}, null);
                }
                throw ExceptionHelper.getInstance(data.getLocale()).createDashboardException("indexNotFoundInQuery", new Object[]{fs.getValueListIndexName(), ds.getName()}, null);
            }
            if (field instanceof BeanFormFieldValue) {
                BeanFormFieldValue fv = (BeanFormFieldValue)field;
                BeanReportAvlField avlField = (BeanReportAvlField)avlFields.get(fv.getFieldName());
                if (avlField != null) {
                    boolean linked;
                    ReportFilter rf = (ReportFilter)filterMap.get(avlField.getName());
                    boolean bl = linked = fv.isLinkable() && rf != null && rf.getUseFilter();
                    if (linked) {
                        logicalExpression.getExpressionList().add(FormDocumentHelper.getCE(avlField));
                    }
                    if (visible) {
                        BeanReportStdUsedField uf = new BeanReportStdUsedField();
                        uf.setField((AbstractBeanReportAvlField)avlField);
                        report.getFieldList().add(uf);
                        pkFields.remove(avlField.getField().getSqlField());
                    }
                    BeanFormFieldValue nfv = new BeanFormFieldValue();
                    FormDocumentHelper.copy((BeanFormField)fv, nfv);
                    nfv.setFieldName(fv.getFieldName());
                    nfv.setMaxValue(FormDocumentHelper.getResolvedValue(ch, eeh, data, fv.getMaxValue()));
                    nfv.setMinValue(FormDocumentHelper.getResolvedValue(ch, eeh, data, fv.getMinValue()));
                    if (linked) {
                        nfv.setDefaultValue(rf.getValue());
                        if (nfv.getDisplayType() != null) {
                            nfv.setDisplayType((EnumSet)fv.getDisplayType().clone());
                            nfv.getDisplayType().remove(BeanFormField.DisplayType.UPDATABLE);
                        }
                        formFieldList.add((BeanFormField)nfv);
                        continue;
                    }
                    nfv.setDefaultValue(FormDocumentHelper.getResolvedValue(ch, eeh, data, fv.getDefaultValue()));
                    formFieldList.add((BeanFormField)nfv);
                    continue;
                }
                throw ExceptionHelper.getInstance(data.getLocale()).createDashboardException("fieldNotFoundInQuery", new Object[]{fv.getDescriptionMap().get(data.getLocale())}, null);
            }
            throw new DashboardException();
        }
        if (!pkFields.isEmpty()) {
            for (BeanReportAvlField avlField : avlFields.values()) {
                if (!pkFields.contains(avlField.getField().getSqlField())) continue;
                BeanReportStdUsedField uf = new BeanReportStdUsedField();
                uf.setField((AbstractBeanReportAvlField)avlField);
                report.getFieldList().add(uf);
            }
        }
        if (!logicalExpression.getExpressionList().isEmpty()) {
            report.setTopExpression((Expression)logicalExpression);
        }
        return new FormDocumentHelper(daoFactory, form, ds, data, filterMap, vl, hl, report, avlFields, formSelectHelper);
    }

    private static void fill(BeanQueryDataStructureTable table, Map<String, BeanReportAvlField> avlFields) {
        for (BeanQueryDataStructureTableField field : table.getTableFieldList()) {
            BeanQuerySQLFieldDataStructure sqlField = new BeanQuerySQLFieldDataStructure();
            sqlField.setSqlField(field.getSqlField());
            sqlField.setName(field.getName());
            sqlField.setDescriptionKey(field.getDescriptionKey());
            sqlField.setDataType(field.getDataType());
            sqlField.setFldGrpOid(field.getFldGrpOid());
            sqlField.setActive(field.isActive());
            sqlField.setSize(field.getSize());
            sqlField.setDigits(field.getDigits());
            sqlField.setNullable(field.isNullable());
            sqlField.setAutoIncrement(field.isAutoincrement());
            sqlField.setBeanQueryDataStructureTableField(field);
            BeanReportAvlField avlField = new BeanReportAvlField();
            avlField.setId(avlFields.size());
            avlField.setVisible(true);
            avlField.setField((BeanQuerySQLField)sqlField);
            avlFields.put(sqlField.getName(), avlField);
        }
        for (BeanQueryDataStructureTable t : table.getTableChildList()) {
            FormDocumentHelper.fill(t, avlFields);
        }
    }

    private static BeanQueryDataStructureTable getTable(BeanQueryDataStructureTable table, String tableName) {
        if (table.getName().equals(tableName)) {
            return table;
        }
        for (BeanQueryDataStructureTable t : table.getTableChildList()) {
            BeanQueryDataStructureTable st = FormDocumentHelper.getTable(t, tableName);
            if (st == null) continue;
            return st;
        }
        return null;
    }

    public void processFormDocument(FormDocument doc) throws DashboardException {
        if (doc.getFormRowList() != null && !doc.getFormRowList().isEmpty()) {
            FieldSelector s;
            SQLTable t;
            WorldDao worldDao = this.daoFactory.getWorldDao();
            BeanWorldDefinition world = (BeanWorldDefinition)worldDao.getDefinition(this.ds.getWorldOID());
            if (world.getReadOnly()) {
                throw ExceptionHelper.getInstance(this.data.getLocale()).createDashboardException("readOnlyWorld", null, null);
            }
            WorldHelper worldHelper = WorldHelper.getInstance((DaoFactory)this.daoFactory, (BeanWorldDefinition)world, (ExpressionEvaluationData)this.data);
            IPoolDBInfo dbInfo = worldHelper.getPoolDbInfo();
            BeanQueryDataStructureTable table = this.ds.getTableFact();
            String cat = worldHelper.getCatalog(table.getCatalog());
            String schema = worldHelper.getSchema(table.getSchema());
            Configuration configuration = Configuration.getInstance();
            DataSourceConfiguration dsc = configuration.getDataSourceConfiguration();
            String identifierQuoteString = worldHelper.getIdentifierQuoteString();
            SQLTableHelper sqlTableHelper = SQLTableHelper.getInstance((DataSource)dsc.getDataSource(dbInfo), (String)identifierQuoteString);
            ConversionHelper conversionHelper = ConversionHelper.getConverter((Locale)this.data.getLocale(), (TimeZone)this.data.getTimeZone(), (boolean)true);
            ArrayList<FormRow> ins = new ArrayList<FormRow>();
            ArrayList<FormRow> upd = new ArrayList<FormRow>();
            ArrayList<FormRow> del = new ArrayList<FormRow>();
            int additionalSize = this.report.getFieldList().size() - this.formFieldList.size();
            for (FormRow row : doc.getFormRowList()) {
                if (row.getAction() == null || row.getFormCellList() == null || row.getFormCellList().isEmpty()) continue;
                switch (row.getAction()) {
                    case INSERT: {
                        ins.add(row);
                        break;
                    }
                    case UPDATE: {
                        upd.add(row);
                        break;
                    }
                    case DELETE: {
                        del.add(row);
                    }
                }
            }
            BeanQueryDataStructureTableKey pk = this.formSelectHelper.getPrimaryKey();
            if (pk == null || pk.getFieldList().isEmpty()) {
                throw ExceptionHelper.getInstance(this.data.getLocale()).createDashboardException("missingPrimaryKey", null, null);
            }
            if (!ins.isEmpty()) {
                if (!this.form.isInsertAllowed()) {
                    throw ExceptionHelper.getInstance(this.data.getLocale()).createDashboardException("formInsertNotAllowed", null, null);
                }
                t = new SQLTable(cat, schema, this.form.getTableName());
                s = new FieldSelector(){

                    @Override
                    public boolean isSelected(BeanFormField f) {
                        return f.isSqlInsert();
                    }
                };
                List<String[]> newIns = this.getData(t, ins, s, conversionHelper, additionalSize);
                this.execute(new TableExecutionDirectInsert(sqlTableHelper, t, conversionHelper), newIns);
            }
            if (!upd.isEmpty()) {
                if (!this.form.isUpdateAllowed()) {
                    throw ExceptionHelper.getInstance(this.data.getLocale()).createDashboardException("formUpdateNotAllowed", null, null);
                }
                t = new SQLTable(cat, schema, this.form.getTableName());
                s = new FieldSelector(){

                    @Override
                    public boolean isSelected(BeanFormField f) {
                        return f.isSqlUpdate() || f.isPrimaryKey();
                    }
                };
                List<String[]> newUpd = this.getData(t, upd, s, conversionHelper, additionalSize);
                this.execute(new TableExecutionDirectUpdate(sqlTableHelper, t, pk.getFieldList(), conversionHelper), newUpd);
            }
            if (!del.isEmpty()) {
                if (!this.form.isDeleteAllowed()) {
                    throw ExceptionHelper.getInstance(this.data.getLocale()).createDashboardException("formDeleteNotAllowed", null, null);
                }
                t = new SQLTable(cat, schema, this.form.getTableName());
                s = new FieldSelector(){

                    @Override
                    public boolean isSelected(BeanFormField f) {
                        return f.isPrimaryKey();
                    }
                };
                List<String[]> newDel = this.getData(t, del, s, conversionHelper, additionalSize);
                this.execute(new TableExecutionDirectDelete(sqlTableHelper, t, pk.getFieldList(), conversionHelper), newDel);
            }
        }
    }

    private List<String[]> getData(SQLTable t, List<FormRow> data, FieldSelector s, ConversionHelper conversionHelper, int additionalSize) throws DashboardException {
        int nbCol = this.getNbCols(this.formFieldList, s) + this.getNbCols(this.hiddenFormFieldList, s) + additionalSize;
        List<String[]> newList = this.getData(nbCol, data.size());
        int srcCol = 0;
        int dstCol = 0;
        for (BeanFormField f : this.formFieldList) {
            if (s.isSelected(f)) {
                dstCol = this.fill(t, f, data, srcCol, newList, dstCol, conversionHelper);
            }
            ++srcCol;
        }
        if (additionalSize != 0) {
            List fieldList = this.report.getFieldList();
            int offset = this.formFieldList.size();
            for (int i = 0; i < additionalSize; ++i) {
                BeanReportStdUsedField uf = (BeanReportStdUsedField)fieldList.get(offset + i);
                BeanReportAvlField af = (BeanReportAvlField)uf.getField();
                BeanQuerySQLField sql = af.getField();
                FieldMetaData fmd = new FieldMetaData();
                fmd.setName(sql.getSqlField());
                fmd.setDataType(sql.getDataType());
                fmd.setFieldPrecision(sql.getSize());
                fmd.setFieldScale(sql.getDigits());
                fmd.setNullable(sql.isNullable());
                fmd.setAutoIncrement(sql.isAutoIncrement());
                t.getFieldList().add(fmd);
            }
            Iterator<String[]> it = newList.iterator();
            for (FormRow row : data) {
                List ac = row.getHiddenCellList();
                String[] r = it.next();
                for (int i = 0; i < additionalSize; ++i) {
                    r[dstCol + i] = (String)ac.get(i);
                }
            }
            dstCol += additionalSize;
        }
        for (BeanFormField f : this.hiddenFormFieldList) {
            if (!s.isSelected(f)) continue;
            dstCol = this.fill(t, f, null, -1, newList, dstCol, conversionHelper);
        }
        return newList;
    }

    private int getNbCols(List<BeanFormField> list, FieldSelector s) {
        int nbCol = 0;
        for (BeanFormField f : this.formFieldList) {
            if (!s.isSelected(f)) continue;
            if (f instanceof BeanFormFieldValue) {
                ++nbCol;
                continue;
            }
            if (!(f instanceof BeanFormFieldSelect)) continue;
            BeanFormFieldSelect fs = (BeanFormFieldSelect)f;
            FormSelectHelper.FormSelect select = this.formSelectHelper.getFromKeyName(fs.getValueListIndexName());
            nbCol += select.getFkFields().size();
        }
        return nbCol;
    }

    private void execute(TableExecutionDataSource tableExecution, List<String[]> rows) throws DashboardException {
        TableExecutionAutoCommit exec = new TableExecutionAutoCommit();
        exec.setTableExecution(tableExecution);
        try {
            exec.start();
            for (String[] row : rows) {
                exec.insert(row);
            }
            exec.end();
        }
        catch (DashboardException de) {
            exec.error(de);
            throw de;
        }
    }

    private List<String[]> getData(int nbCol, int nbRow) {
        ArrayList<String[]> d = new ArrayList<String[]>();
        for (int i = 0; i < nbRow; ++i) {
            d.add(new String[nbCol]);
        }
        return d;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int fill(SQLTable t, BeanFormField f, List<FormRow> list, int srcCol, List<String[]> newList, int dstCol, ConversionHelper conversionHelper) throws DashboardException {
        if (f instanceof BeanFormFieldValue) {
            BeanFormFieldValue fv = (BeanFormFieldValue)f;
            BeanReportAvlField avlField = this.avlFields.get(fv.getFieldName());
            BeanQuerySQLField sql = avlField.getField();
            FieldMetaData fmd = new FieldMetaData();
            fmd.setName(sql.getSqlField());
            fmd.setDataType(sql.getDataType());
            fmd.setFieldPrecision(sql.getSize());
            fmd.setFieldScale(sql.getDigits());
            fmd.setNullable(sql.isNullable());
            fmd.setAutoIncrement(sql.isAutoIncrement());
            t.getFieldList().add(fmd);
            ValueValidator vv = this.getValidator(conversionHelper, f.getDataType(), fv.getMinValue(), fv.getMaxValue(), (String)f.getDescriptionMap().get(this.data.getLocale()));
            if (list != null) {
                Iterator<String[]> it = newList.iterator();
                for (FormRow row : list) {
                    List formCellList = row.getFormCellList();
                    String cv = vv == null ? (String)formCellList.get(srcCol) : vv.getValue((String)formCellList.get(srcCol));
                    if (f.isRequired() && (cv == null || "".equals(cv))) {
                        throw ExceptionHelper.getInstance(this.data.getLocale()).createDashboardException("formRequiredField", new Object[]{fv.getDescriptionMap().get(this.data.getLocale())}, null);
                    }
                    it.next()[dstCol] = cv;
                }
            } else {
                for (String[] r : newList) {
                    r[dstCol] = (String)fv.getDefaultValue();
                }
            }
            return dstCol + 1;
        }
        if (f instanceof BeanFormFieldSelect) {
            BeanFormFieldSelect fs = (BeanFormFieldSelect)f;
            FormSelectHelper.FormSelect select = this.formSelectHelper.getFromKeyName(fs.getValueListIndexName());
            EngineHelper eh = EngineHelper.getInstance(this.daoFactory);
            ExecutionContext ec = eh.getExecutionContext((AbstractBeanReport)this.report, this.data, this.filterMap, false);
            CommandParameter cp = CommandParameter.getInstance(ec);
            BeanReportStd std = new BeanReportStd();
            std.setQueryOID(this.report.getObjectID());
            std.getAvlGroupList().addAll(this.report.getAvlGroupList());
            String fn = select.getDescField().getName();
            BeanReportStdUsedField uf = new BeanReportStdUsedField();
            uf.setId(0);
            uf.setName(fn);
            uf.setField(cp.getAvlField(fn));
            std.getFieldList().add(uf);
            int c = 0;
            Iterator<BeanQueryDataStructureTableField> itfk = select.getFkFields().iterator();
            for (BeanQueryDataStructureTableField tf : select.getPkFields()) {
                BeanReportStdUsedField uff = new BeanReportStdUsedField();
                uff.setId(++c);
                uff.setName(tf.getName());
                uff.setField(cp.getAvlField(tf.getName()));
                std.getFieldList().add(uff);
                BeanQueryDataStructureTableField fktf = itfk.next();
                BeanReportAvlField avlField = this.avlFields.get(fktf.getName());
                BeanQuerySQLField sql = avlField.getField();
                FieldMetaData fmd = new FieldMetaData();
                fmd.setName(sql.getSqlField());
                fmd.setDataType(sql.getDataType());
                fmd.setFieldPrecision(sql.getSize());
                fmd.setFieldScale(sql.getDigits());
                fmd.setNullable(sql.isNullable());
                fmd.setAutoIncrement(sql.isAutoIncrement());
                t.getFieldList().add(fmd);
            }
            BeanReportStdSortField sf = new BeanReportStdSortField();
            sf.setColId(0);
            sf.setSortOrder(fs.getValueListSortOrder());
            std.getSortFieldList().add(sf);
            HashMap<String, Object> valueMap = new HashMap<String, Object>();
            try (Result sr = eh.getResult(eh.getOperation((AbstractBeanReport)std, ec));){
                while (sr.next()) {
                    Value k = sr.getData(0);
                    ArrayList l = new ArrayList();
                    for (int i = 1; i <= c; ++i) {
                        Value v = sr.getData(i);
                        l.add(v.toString());
                    }
                    valueMap.put(k.toString(), l);
                }
            }
            if (list != null) {
                Iterator<String[]> it = newList.iterator();
                for (FormRow row : list) {
                    List formCellList = row.getFormCellList();
                    String cv = (String)formCellList.get(srcCol);
                    List v = (List)valueMap.get(cv);
                    String[] r = it.next();
                    if (v != null) {
                        for (int i = 0; i < c; ++i) {
                            r[dstCol + i] = (String)v.get(i);
                        }
                        continue;
                    }
                    if (!fs.isRequired() && !fs.isPrimaryKey()) continue;
                    throw ExceptionHelper.getInstance(this.data.getLocale()).createDashboardException("formRequiredField", new Object[]{f.getDescriptionMap().get(this.data.getLocale())}, null);
                }
            } else {
                String cv = (String)fs.getDefaultValue();
                List v = (List)valueMap.get(cv);
                if (v != null) {
                    for (String[] r : newList) {
                        for (int i = 0; i < c; ++i) {
                            r[dstCol + i] = (String)v.get(i);
                        }
                    }
                } else if (fs.isRequired() || fs.isPrimaryKey()) {
                    throw ExceptionHelper.getInstance(this.data.getLocale()).createDashboardException("formRequiredField", new Object[]{f.getDescriptionMap().get(this.data.getLocale())}, null);
                }
            }
            return dstCol + c;
        }
        return dstCol;
    }

    private static Object getResolvedValue(ConversionHelper conversionHelper, ExpressionEvaluationHelper helper, ExpressionEvaluationData data, Object value) throws DashboardException {
        if (value instanceof com.prelytis.dashboard.value.util.Expression) {
            return conversionHelper.format(helper.evaluateExpression((com.prelytis.dashboard.value.util.Expression)value, data));
        }
        if (value instanceof String) {
            return conversionHelper.format((Object)helper.evaluate((String)value, data));
        }
        return value;
    }

    private ValueValidator getValidator(ConversionHelper conversionHelper, DataType dataType, Object min, Object max, String fieldDesc) {
        switch (dataType) {
            case BIGINT: 
            case DECIMAL: 
            case DOUBLE: 
            case FLOAT: 
            case GENERIC_NUMERIC: 
            case INTEGER: 
            case NUMERIC: 
            case REAL: 
            case SMALLINT: 
            case TINYINT: {
                if (min instanceof Number) {
                    if (max instanceof Number) {
                        return this.getValidator((Number)min, (Number)max, fieldDesc);
                    }
                    return this.getValidator((Number)min, null, fieldDesc);
                }
                if (max instanceof Number) {
                    return this.getValidator(null, (Number)max, fieldDesc);
                }
                return null;
            }
            case DATE: 
            case TIME: 
            case TIMESTAMP: {
                if (min instanceof Date) {
                    if (max instanceof Date) {
                        return this.getValidator(conversionHelper, dataType, (Date)min, (Date)max, fieldDesc);
                    }
                    return this.getValidator(conversionHelper, dataType, (Date)min, null, fieldDesc);
                }
                if (max instanceof Date) {
                    return this.getValidator(conversionHelper, dataType, null, (Date)max, fieldDesc);
                }
                return null;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FormDocument getFormDocument() throws DashboardException {
        EngineHelper eh = EngineHelper.getInstance(this.daoFactory);
        ExecutionContext ec = eh.getExecutionContext((AbstractBeanReport)this.report, this.data, this.filterMap, false);
        ConversionHelper conversionHelper = ConversionHelper.getConverter((Locale)this.data.getLocale(), (TimeZone)this.data.getTimeZone(), (boolean)true);
        ArrayList<FormRow> formRowList = new ArrayList<FormRow>();
        try (Result result = eh.getResult(eh.getOperation((AbstractBeanReport)this.report, ec));){
            while (result.next()) {
                FormRow fr = new FormRow();
                fr.setUpdatable(this.form.isUpdateAllowed());
                fr.setDeletable(this.form.isDeleteAllowed());
                Value[] val = result.getData();
                ArrayList cells = new ArrayList();
                ArrayList pk = new ArrayList();
                int c = 0;
                int mc = this.formFieldList.size();
                for (Value v : val) {
                    Object l = ++c > mc ? pk : cells;
                    l.add(conversionHelper.format(v.getObject()));
                }
                fr.setFormCellList((List)cells);
                fr.setHiddenCellList(pk);
                formRowList.add(fr);
            }
        }
        ValueListElt empty = new ValueListElt();
        empty.setDescription("");
        FormDocument fd = new FormDocument();
        fd.setFormRowList(formRowList);
        for (BeanFormField f : this.formFieldList) {
            if (!(f instanceof BeanFormFieldSelectFinal)) continue;
            BeanFormFieldSelectFinal ff = (BeanFormFieldSelectFinal)f;
            FormSelectHelper.FormSelect select = this.formSelectHelper.getFromKeyName(ff.getValueListIndexName());
            if (select != null) {
                String fn = select.getDescField().getName();
                CommandParameter cp = CommandParameter.getInstance(ec);
                BeanReportStd std = new BeanReportStd();
                std.setQueryOID(this.report.getObjectID());
                std.setQueryName(this.report.getName());
                std.getAvlGroupList().addAll(this.report.getAvlGroupList());
                BeanReportStdUsedField uf = new BeanReportStdUsedField();
                uf.setId(0);
                uf.setName(fn);
                uf.setField(cp.getAvlField(fn));
                std.getFieldList().add(uf);
                BeanReportStdSortField sf = new BeanReportStdSortField();
                sf.setColId(0);
                sf.setSortOrder(ff.getValueListSortOrder());
                std.getSortFieldList().add(sf);
                ValueListHelper vlh = ValueListHelper.getInstance(this.daoFactory, this.data, ec.getQuery(), (AbstractBeanReport)std);
                Result sr = eh.getResult(eh.getOperation((AbstractBeanReport)std, ec));
                try {
                    List<ValueListElt> valueList = vlh.getValueList(sr, "{0}");
                    ff.getValueList().clear();
                    if (!ff.isRequired() && ff.isSqlNullable()) {
                        ff.getValueList().add(empty);
                    }
                    ff.getValueList().addAll(valueList);
                    continue;
                }
                finally {
                    sr.close();
                    continue;
                }
            }
            throw ExceptionHelper.getInstance(this.data.getLocale()).createDashboardException("indexNotFoundInQuery", new Object[]{ff.getValueListIndexName(), this.ds.getName()}, null);
        }
        fd.setObjectID(this.form.getObjectID());
        fd.setName(this.form.getName());
        fd.setDescription((String)this.form.getDescriptionMap().get(this.data.getLocale()));
        fd.getDescriptionMap().putAll(this.form.getDescriptionMap());
        fd.setFormFieldList(this.formFieldList);
        WorkspaceDao workspaceDao = this.daoFactory.getWorkspaceDao();
        boolean editable = workspaceDao.getAccessLevelForEC(this.data.getExecutionContextOid().intValue(), SessionParameterType.FORM).getAccessLevel() == 2;
        fd.setEditable(editable);
        fd.setDeletable(editable && this.form.isDeleteAllowed());
        fd.setUpdatable(editable && this.form.isUpdateAllowed());
        fd.setInsertable(editable && this.form.isInsertAllowed());
        return fd;
    }

    private static void copy(BeanFormField src, BeanFormFieldValue dst) {
        dst.setSqlNullable(src.isSqlNullable());
        dst.setDataType(src.getDataType());
        dst.setDescriptionKey(src.getDescriptionKey());
        dst.getDescriptionMap().putAll(src.getDescriptionMap());
        dst.setCommentKey(src.getCommentKey());
        dst.getCommentMap().putAll(src.getCommentMap());
        dst.setDisplayType(src.getDisplayType() == null ? null : src.getDisplayType().clone());
        dst.setLinkable(src.isLinkable());
        dst.setRequired(src.isRequired());
        dst.setSqlInsert(src.isSqlInsert());
        dst.setSqlUpdate(src.isSqlUpdate());
        dst.setDefaultValue(src.getDefaultValue());
        dst.setPrimaryKey(src.isPrimaryKey());
    }

    private static ComparisonExpression getCE(BeanReportAvlField af) {
        PromptOperand po = new PromptOperand();
        po.setName(af.getName());
        po.setDescriptionKey(af.getDescriptionKey());
        po.getDescriptionMap().putAll(af.getDescriptionMap());
        po.setLinkable(true);
        po.setPromptType(1);
        po.setMandatory(false);
        po.setUsed(false);
        po.setVisible(true);
        FieldOperand fo = new FieldOperand();
        fo.setField(af.getName());
        fo.setDescriptionKey(af.getDescriptionKey());
        return new ComparisonExpression((Operand)fo, 3, (Operand)po);
    }

    private ValueValidator getValidator(final Number min, final Number max, final String fieldDesc) {
        return new ValueValidator(){
            private BigDecimal minBD;
            private BigDecimal maxBD;
            {
                this.minBD = min == null ? null : new BigDecimal(min.toString());
                this.maxBD = max == null ? null : new BigDecimal(max.toString());
            }

            @Override
            public String getValue(String s) throws DashboardException {
                try {
                    BigDecimal oBD = new BigDecimal(s);
                    if (this.minBD != null && this.minBD.compareTo(oBD) > 0) {
                        throw ExceptionHelper.getInstance(FormDocumentHelper.this.data.getLocale()).createDashboardException("formMinValue", new Object[]{fieldDesc, this.minBD}, null);
                    }
                    if (this.maxBD != null && this.maxBD.compareTo(oBD) < 0) {
                        throw ExceptionHelper.getInstance(FormDocumentHelper.this.data.getLocale()).createDashboardException("formMaxValue", new Object[]{fieldDesc, this.maxBD}, null);
                    }
                    return oBD.toString();
                }
                catch (NumberFormatException nfe) {
                    throw new DashboardException((Throwable)nfe);
                }
            }
        };
    }

    private ValueValidator getValidator(final ConversionHelper conversionHelper, final DataType dataType, final Date min, final Date max, final String fieldDesc) {
        return new ValueValidator(){

            @Override
            public String getValue(String s) throws DashboardException {
                try {
                    Date d = (Date)conversionHelper.parse(dataType, s);
                    if (min != null && min.after(d)) {
                        throw ExceptionHelper.getInstance(FormDocumentHelper.this.data.getLocale()).createDashboardException("formMinValue", new Object[]{fieldDesc, conversionHelper.format((Object)min)}, null);
                    }
                    if (max != null && max.before(d)) {
                        throw ExceptionHelper.getInstance(FormDocumentHelper.this.data.getLocale()).createDashboardException("formMaxValue", new Object[]{fieldDesc, conversionHelper.format((Object)max)}, null);
                    }
                }
                catch (ParseException pe) {
                    throw new DashboardException((Throwable)pe);
                }
                return s;
            }
        };
    }

    private static interface ValueValidator {
        public String getValue(String var1) throws DashboardException;
    }

    private static interface FieldSelector {
        public boolean isSelected(BeanFormField var1);
    }
}

