/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.helper;

import com.prelytis.dashboard.value.data.BeanQueryDataStructureTable;
import com.prelytis.dashboard.value.data.BeanQueryDataStructureTableField;
import com.prelytis.dashboard.value.data.BeanQueryDataStructureTableJoin;
import com.prelytis.dashboard.value.data.BeanQueryDataStructureTableJoinElement;
import com.prelytis.dashboard.value.data.BeanQueryDataStructureTableKey;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class FormSelectHelper {
    private final BeanQueryDataStructureTableKey primaryKey;
    private final Map<String, FormSelect> keyMap;
    private final Map<String, List<FormSelect>> fieldMap;

    private FormSelectHelper(BeanQueryDataStructureTableKey primaryKey, Map<String, FormSelect> keyMap, Map<String, List<FormSelect>> fieldMap) {
        this.primaryKey = primaryKey;
        this.keyMap = keyMap;
        this.fieldMap = fieldMap;
    }

    public FormSelect getFromKeyName(String keyName) {
        return this.keyMap.get(keyName);
    }

    public List<FormSelect> getFromFieldName(String fieldName) {
        return this.fieldMap.get(fieldName);
    }

    public static final FormSelectHelper getInstance(BeanQueryDataStructureTable table) {
        HashMap<String, FormSelect> indexMap = new HashMap<String, FormSelect>();
        HashMap<String, List<FormSelect>> fieldMap = new HashMap<String, List<FormSelect>>();
        FormSelectHelper.fill(table, indexMap, fieldMap);
        BeanQueryDataStructureTableKey pk = null;
        for (BeanQueryDataStructureTableKey key : table.getDsTableKeyList()) {
            if (!key.isPrimaryKey()) continue;
            pk = key;
            break;
        }
        return new FormSelectHelper(pk, indexMap, fieldMap);
    }

    private static void fill(BeanQueryDataStructureTable table, Map<String, FormSelect> keyMap, Map<String, List<FormSelect>> fieldMap) {
        BeanQueryDataStructureTableJoin join = table.getJoin();
        ArrayList<BeanQueryDataStructureTableField> fkFields = new ArrayList<BeanQueryDataStructureTableField>();
        ArrayList<BeanQueryDataStructureTableField> pkFields = new ArrayList<BeanQueryDataStructureTableField>();
        for (BeanQueryDataStructureTableJoinElement je : join.getJoinElementList()) {
            pkFields.add(FormSelectHelper.getField(table, je.getRightField()));
            BeanQueryDataStructureTableField fkField = FormSelectHelper.getField(table.getParentTable(), je.getLeftField());
            fkFields.add(fkField);
        }
        for (BeanQueryDataStructureTableKey key : table.getDsTableKeyList()) {
            if (key.getFieldList().size() != 1) continue;
            String indexedField = (String)key.getFieldList().get(0);
            FormSelect r = new FormSelect();
            r.fkFields = fkFields;
            r.pkFields = pkFields;
            r.key = key;
            r.descField = FormSelectHelper.getField(table, indexedField);
            keyMap.put(key.getName(), r);
            for (BeanQueryDataStructureTableField fkField : fkFields) {
                List<FormSelect> l = fieldMap.get(fkField.getName());
                if (l == null) {
                    l = new ArrayList<FormSelect>();
                    fieldMap.put(fkField.getName(), l);
                }
                l.add(r);
            }
        }
        for (BeanQueryDataStructureTable t : table.getTableChildList()) {
            FormSelectHelper.fill(t, keyMap, fieldMap);
        }
    }

    private static BeanQueryDataStructureTableField getField(BeanQueryDataStructureTable table, String sqlField) {
        for (BeanQueryDataStructureTableField f : table.getTableFieldList()) {
            if (!sqlField.equals(f.getSqlField())) continue;
            return f;
        }
        return null;
    }

    public BeanQueryDataStructureTableKey getPrimaryKey() {
        return this.primaryKey;
    }

    public static class FormSelect {
        private BeanQueryDataStructureTableKey key;
        private List<BeanQueryDataStructureTableField> pkFields;
        private BeanQueryDataStructureTableField descField;
        private List<BeanQueryDataStructureTableField> fkFields;

        public BeanQueryDataStructureTableKey getKey() {
            return this.key;
        }

        public List<BeanQueryDataStructureTableField> getPkFields() {
            return this.pkFields;
        }

        public BeanQueryDataStructureTableField getDescField() {
            return this.descField;
        }

        public List<BeanQueryDataStructureTableField> getFkFields() {
            return this.fkFields;
        }
    }
}

