/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.helper;

import com.prelytis.dashboard.helper.FullReportFilter;
import com.prelytis.dashboard.helper.FullReportFilterDS;
import com.prelytis.dashboard.helper.FullReportFilterSQL;
import com.prelytis.dashboard.interfaces.DashboardException;
import com.prelytis.dashboard.interfaces.IQueryDefinition;
import com.prelytis.dashboard.value.data.AbstractBeanReport;
import com.prelytis.dashboard.value.data.AbstractBeanReportAvlField;
import com.prelytis.dashboard.value.data.BeanQueryDataStructureTable;
import com.prelytis.dashboard.value.data.BeanQueryDataStructureTableField;
import com.prelytis.dashboard.value.data.BeanQuerySQL;
import com.prelytis.dashboard.value.data.BeanQuerySQLFieldDataStructure;
import com.prelytis.dashboard.value.data.BeanQueryStar;
import com.prelytis.dashboard.value.data.BeanReportAvlCalcField;
import com.prelytis.dashboard.value.data.BeanReportAvlGroup;
import com.prelytis.dashboard.value.data.BeanReportFilter;
import com.prelytis.dashboard.value.query.Expression;
import com.prelytis.dashboard.value.query.FieldOperand;
import com.prelytis.dashboard.value.query.InteractiveOperand;
import com.prelytis.dashboard.value.query.LogicalExpression;
import com.prelytis.dashboard.value.query.Operand;
import com.prelytis.dashboard.value.query.OperandExpression;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

class FullFilterListHelper {
    FullFilterListHelper() {
    }

    static List<FullReportFilter> getFullFilterList(AbstractBeanReport report, IQueryDefinition query) throws DashboardException {
        if (query instanceof BeanQueryStar) {
            List<FullReportFilter> mmfl;
            BeanQueryStar ds = (BeanQueryStar)query;
            ArrayList<FullReportFilter> filterList = new ArrayList<FullReportFilter>();
            HashSet<String> set = new HashSet<String>();
            FullFilterListHelper.addField(ds.getTableFact(), set);
            FullFilterListHelper.addCalcField(report.getAvlGroupList(), set);
            FullFilterListHelper.addExpression(filterList, set, report.getTopExpression());
            if (query.getQueryType() == 3 && (mmfl = FullFilterListHelper.getSQLFilterList(report)) != null && !mmfl.isEmpty()) {
                filterList.addAll(mmfl);
            }
            return filterList;
        }
        if (query instanceof BeanQuerySQL) {
            return FullFilterListHelper.getSQLFilterList(report);
        }
        return null;
    }

    private static void addExpression(List<FullReportFilter> list, Set<String> set, Expression expression) throws DashboardException {
        block5: {
            block4: {
                if (expression == null) {
                    return;
                }
                if (!(expression instanceof OperandExpression)) break block4;
                OperandExpression operandExpression = (OperandExpression)expression;
                String fieldName = ((FieldOperand)operandExpression.getOperands()[0]).getField();
                if (!set.contains(fieldName)) break block5;
                for (Operand operand : operandExpression.getOperands()) {
                    if (!(operand instanceof InteractiveOperand)) continue;
                    InteractiveOperand interactiveOperand = (InteractiveOperand)operand;
                    FullReportFilterDS filter = new FullReportFilterDS(fieldName, interactiveOperand);
                    list.add(filter);
                }
                break block5;
            }
            if (expression instanceof LogicalExpression) {
                LogicalExpression logical = (LogicalExpression)expression;
                for (Expression e : logical.getExpressionList()) {
                    FullFilterListHelper.addExpression(list, set, e);
                }
            }
        }
    }

    private static void addField(BeanQueryDataStructureTable dsTable, Set<String> set) {
        List fieldList = dsTable.getTableFieldList();
        for (int i = 0; i < fieldList.size(); ++i) {
            BeanQueryDataStructureTableField field = (BeanQueryDataStructureTableField)fieldList.get(i);
            BeanQuerySQLFieldDataStructure sqlField = new BeanQuerySQLFieldDataStructure();
            sqlField.setSqlField(field.getSqlField());
            sqlField.setName(field.getName());
            sqlField.setDescriptionKey(field.getDescriptionKey());
            sqlField.setDataType(field.getDataType());
            sqlField.setFldGrpOid(field.getFldGrpOid());
            sqlField.setActive(field.isActive());
            sqlField.setSize(field.getSize());
            sqlField.setDigits(field.getDigits());
            sqlField.setNullable(field.isNullable());
            sqlField.setAutoIncrement(field.isAutoincrement());
            sqlField.setBeanQueryDataStructureTableField(field);
            set.add(sqlField.getName());
        }
        List childList = dsTable.getTableChildList();
        for (int i = 0; i < childList.size(); ++i) {
            BeanQueryDataStructureTable dsTableChild = (BeanQueryDataStructureTable)childList.get(i);
            FullFilterListHelper.addField(dsTableChild, set);
        }
    }

    private static void addCalcField(List<BeanReportAvlGroup> groupList, Set<String> set) {
        if (groupList != null) {
            for (BeanReportAvlGroup group : groupList) {
                for (AbstractBeanReportAvlField avlField : group.getFields()) {
                    if (!(avlField instanceof BeanReportAvlCalcField)) continue;
                    set.add(avlField.getName());
                }
            }
        }
    }

    private static List<FullReportFilter> getSQLFilterList(AbstractBeanReport report) {
        List reportFilterList = report.getFilterList();
        if (reportFilterList == null) {
            return null;
        }
        ArrayList<FullReportFilter> filterList = new ArrayList<FullReportFilter>();
        for (int i = 0; i < reportFilterList.size(); ++i) {
            BeanReportFilter filter = (BeanReportFilter)reportFilterList.get(i);
            FullReportFilterSQL reportFilterSQL = new FullReportFilterSQL(filter);
            filterList.add(reportFilterSQL);
        }
        return filterList;
    }
}

