/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.helper;

import com.prelytis.dashboard.helper.ExceptionHelper;
import com.prelytis.dashboard.interfaces.DashboardException;
import com.prelytis.dashboard.interfaces.DashboardRuntimeException;
import com.prelytis.dashboard.util.sql.ExceptionHandler;
import com.prelytis.dashboard.value.util.ExecutionMessage;
import com.prelytis.dashboard.value.util.ExecutionMessageStd;
import java.util.List;
import java.util.Locale;
import org.apache.log4j.Logger;

public class LocalizedExceptionHandler
implements ExceptionHandler {
    private final ExceptionHelper exceptionHelper;
    private final List<ExecutionMessage> msgList;
    private final boolean onErrorStop;

    private LocalizedExceptionHandler(Locale locale, List<ExecutionMessage> msgList, boolean onErrorStop) {
        this.exceptionHelper = ExceptionHelper.getInstance(locale);
        this.msgList = msgList;
        this.onErrorStop = onErrorStop;
    }

    public static final LocalizedExceptionHandler getInstance() {
        return new LocalizedExceptionHandler(Locale.ENGLISH, null, true);
    }

    public static final LocalizedExceptionHandler getInstance(Locale locale, List<ExecutionMessage> msgList, boolean onErrorStop) {
        return new LocalizedExceptionHandler(locale, msgList, onErrorStop);
    }

    public void handleException(Exception e) throws DashboardException {
        DashboardException de = this.logException(e);
        if (this.onErrorStop) {
            throw de;
        }
    }

    public DashboardException logException(Exception e) {
        DashboardException de;
        if (e instanceof DashboardRuntimeException) {
            return this.logException((Exception)((Object)this.exceptionHelper.createDashboardException((DashboardRuntimeException)((Object)e))));
        }
        if (e instanceof DashboardException && (de = (DashboardException)((Object)e)).isLogged()) {
            return de;
        }
        if (this.msgList != null) {
            this.msgList.add((ExecutionMessage)new ExecutionMessageStd(this.onErrorStop ? 3 : 2, e.getMessage()));
        }
        Logger log = Logger.getLogger(LocalizedExceptionHandler.class);
        DashboardException de2 = e instanceof DashboardException ? (DashboardException)((Object)e) : new DashboardException((Throwable)e);
        de2.log(log);
        return de2;
    }

    public void info(String message) {
        if (this.msgList != null) {
            this.msgList.add((ExecutionMessage)new ExecutionMessageStd(1, message));
        }
        Logger log = Logger.getLogger(LocalizedExceptionHandler.class);
        log.info((Object)message);
    }
}

