/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.helper;

import com.prelytis.dashboard.chart.IPaintable;
import com.prelytis.dashboard.chart.StrategyMapChart;
import com.prelytis.dashboard.document.factory.PageLayout;
import com.prelytis.dashboard.value.area.IArea;
import com.prelytis.dashboard.value.chart.PaintableProperties;
import com.prelytis.dashboard.value.structure.MetricResult;
import com.prelytis.dashboard.value.structure.Perspective;
import com.prelytis.dashboard.value.structure.StrategicObjective;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.imageio.ImageIO;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.DocumentLoader;
import org.apache.batik.bridge.GVTBuilder;
import org.apache.batik.bridge.UserAgent;
import org.apache.batik.bridge.UserAgentAdapter;
import org.apache.batik.gvt.GraphicsNode;
import org.w3c.dom.Document;

public class MetricPanel
implements IPaintable {
    private final List<Perspective> perspectives;
    private final PaintableProperties paintableProperties;
    private final PageLayout pagelayout;
    private final String metricLabel;
    private final String metricSummaryLabel;
    private final String metricSeverityLabel;
    private Dimension size = null;
    private double scale = 1.0;
    private int space = 1;
    private int leftWidth = 0;
    private int centerWidth = 0;
    private int rightWidth = 0;
    private int padding = 1;
    private int lineHeight;
    private int logoWidth;
    private Object[] icons = new Object[13];
    private boolean option = true;
    private static final String PATH = "/com/prelytis/dashboard/resources/img/";

    public MetricPanel(List<Perspective> perspectives, Locale locale, PageLayout pagelayout) {
        this.pagelayout = pagelayout;
        this.perspectives = perspectives;
        this.paintableProperties = new PaintableProperties();
        ResourceBundle bundle = ResourceBundle.getBundle("com.prelytis.dashboard.resources.Messages", locale);
        this.metricLabel = bundle.getString("metricPanel.metric");
        this.metricSummaryLabel = bundle.getString("metricPanel.summary");
        this.metricSeverityLabel = bundle.getString("metricPanel.severity");
    }

    public void init() {
    }

    private void init(Graphics2D graphics2D) {
        Font defaultFont = graphics2D.getFont();
        graphics2D.setFont(defaultFont.deriveFont((float)this.pagelayout.getFontSize()[2]));
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        this.lineHeight = fontMetrics.getHeight() + 2 * this.padding;
        this.logoWidth = fontMetrics.getHeight() - this.padding;
        UserAgentAdapter userAgent = new UserAgentAdapter();
        DocumentLoader loader = new DocumentLoader((UserAgent)userAgent);
        BridgeContext ctx = new BridgeContext((UserAgent)userAgent, loader);
        GVTBuilder builder = new GVTBuilder();
        String path = PATH;
        String[] iconName = new String[]{"info", "warning", "error", "question", "info-g", "warning-g", "error-g", "question-g", "folder-open", "task-metric", "trend-down", "trend-up", "trend-stable"};
        for (int i = 0; i < 13; ++i) {
            try {
                String file = new StringBuffer(path).append(iconName[i]).append(".svg").toString();
                Document svgDoc = loader.loadDocument(this.getURI(file));
                GraphicsNode tmp = builder.build(ctx, svgDoc);
                this.icons[i] = tmp;
                continue;
            }
            catch (Exception e) {
                URL url = this.getURL(new StringBuffer(path).append(iconName[i]).append("-16x16.png").toString());
                try {
                    this.icons[i] = ImageIO.read(url);
                    continue;
                }
                catch (Exception tmp) {
                    // empty catch block
                }
            }
        }
        int lLeftWidth = 0;
        int lCenterWidth = 0;
        int lRightWidth = 0;
        this.leftWidth = fontMetrics.stringWidth(this.metricLabel) + 2 * this.space;
        this.centerWidth = fontMetrics.stringWidth(this.metricSummaryLabel) + 2 * this.space;
        this.rightWidth = fontMetrics.stringWidth(this.metricSeverityLabel) + 2 * this.space;
        lRightWidth = this.space + this.logoWidth + this.space;
        if (lRightWidth > this.rightWidth) {
            this.rightWidth = lRightWidth;
        }
        for (Perspective perspective : this.perspectives) {
            int[] summaryTab = perspective.getSeverities();
            lLeftWidth = this.space + this.logoWidth + this.space;
            graphics2D.setFont(defaultFont.deriveFont((float)this.pagelayout.getFontSize()[2]));
            fontMetrics = graphics2D.getFontMetrics();
            if ((lLeftWidth += fontMetrics.stringWidth(perspective.getDescription())) > this.leftWidth) {
                this.leftWidth = lLeftWidth;
            }
            lCenterWidth = this.logoWidth * 4 + this.space * 3;
            for (int j = 0; j < summaryTab.length - 1; ++j) {
                lCenterWidth += fontMetrics.stringWidth(Integer.toString(summaryTab[j]));
            }
            if (lCenterWidth > this.centerWidth) {
                this.centerWidth = lCenterWidth;
            }
            List objectives = perspective.getObjectiveList();
            graphics2D.setFont(defaultFont.deriveFont((float)this.pagelayout.getFontSize()[1]));
            fontMetrics = graphics2D.getFontMetrics();
            for (StrategicObjective objective : objectives) {
                summaryTab = objective.getSeverities();
                lLeftWidth = (this.space + this.logoWidth + this.space) * 2;
                if ((lLeftWidth += fontMetrics.stringWidth(objective.getDescription())) > this.leftWidth) {
                    this.leftWidth = lLeftWidth;
                }
                lCenterWidth = this.logoWidth * 4 + this.space * 3;
                for (int k = 0; k < summaryTab.length - 1; ++k) {
                    lCenterWidth += fontMetrics.stringWidth(Integer.toString(summaryTab[k]));
                }
                if (lCenterWidth > this.centerWidth) {
                    this.centerWidth = lCenterWidth;
                }
                List metrics = objective.getResultList();
                for (MetricResult metric : metrics) {
                    lLeftWidth = (this.space + this.logoWidth + this.space) * 3 + fontMetrics.stringWidth(metric.getDescription());
                    if (lLeftWidth > this.leftWidth) {
                        this.leftWidth = lLeftWidth;
                    }
                    if (metric.getMetric() != null) {
                        try {
                            MessageFormat mf;
                            try {
                                mf = new MessageFormat(metric.getMetricFormat());
                            }
                            catch (IllegalArgumentException e) {
                                mf = new MessageFormat("{0}");
                            }
                            String label = new StringBuffer(mf.format(new Object[]{metric.getMetric()})).append(" (").append(mf.format(new Object[]{metric.getTargetValue()})).append(")").toString();
                            label = label.replaceAll("\\[euro\\]", "\u20ac");
                            lCenterWidth = fontMetrics.stringWidth(label) + (this.space + this.logoWidth + this.space);
                            if (lCenterWidth > this.centerWidth) {
                                this.centerWidth = lCenterWidth;
                            }
                        }
                        catch (RuntimeException runtimeException) {
                            // empty catch block
                        }
                    }
                    if (metric.getPreviousCalcValue() == metric.getCalcValue() || (lRightWidth = (this.space + this.logoWidth + this.space) * 2) <= this.rightWidth) continue;
                    this.rightWidth = lRightWidth;
                }
            }
        }
        Dimension preferredSize = this.size;
        if (preferredSize != null) {
            if (preferredSize.width < this.leftWidth + this.centerWidth + this.rightWidth) {
                this.scale = (double)preferredSize.width / (double)(this.leftWidth + this.centerWidth + this.rightWidth);
            } else if (this.option) {
                this.leftWidth = preferredSize.width - this.centerWidth - this.rightWidth;
            } else {
                this.scale = (double)(this.leftWidth + this.centerWidth + this.rightWidth) / (double)preferredSize.width;
            }
        }
    }

    public void paint(Graphics2D graphics2D) {
        this.init(graphics2D);
        Color savedColor = graphics2D.getColor();
        Stroke savedStroke = graphics2D.getStroke();
        Font savedFont = graphics2D.getFont();
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.scale(this.scale, this.scale);
        int width = this.leftWidth + this.centerWidth + this.rightWidth;
        Color gris = new Color(237, 237, 237);
        Color grisClair = new Color(249, 249, 249);
        Font defaultFont = graphics2D.getFont();
        graphics2D.setFont(defaultFont.deriveFont((float)this.pagelayout.getFontSize()[2]));
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        float x = 0.0f;
        float y = 0.0f;
        float baseline = y + (float)this.lineHeight - (float)this.padding - (float)fontMetrics.getDescent();
        Rectangle2D.Double rect = new Rectangle2D.Double(0.0, 0.0, width, this.lineHeight);
        graphics2D.setColor(gris);
        graphics2D.fill(rect);
        graphics2D.setColor(Color.BLACK);
        graphics2D.drawLine(0, 0, width, 0);
        graphics2D.drawLine(0, this.lineHeight - 1, width, this.lineHeight - 1);
        graphics2D.drawString(this.metricLabel, (float)(this.leftWidth / 2 - fontMetrics.stringWidth(this.metricLabel) / 2), baseline);
        graphics2D.drawString(this.metricSummaryLabel, (float)(this.leftWidth + this.centerWidth / 2 - fontMetrics.stringWidth(this.metricSummaryLabel) / 2), baseline);
        graphics2D.drawString(this.metricSeverityLabel, (float)(this.leftWidth + this.centerWidth + this.rightWidth / 2 - fontMetrics.stringWidth(this.metricSeverityLabel) / 2), baseline);
        for (Perspective perspective : this.perspectives) {
            baseline += (float)this.lineHeight;
            int[] summaryTab = perspective.getSeverities();
            graphics2D.setFont(defaultFont.deriveFont((float)this.pagelayout.getFontSize()[2]));
            fontMetrics = graphics2D.getFontMetrics();
            rect = new Rectangle2D.Double(0.0, y += (float)this.lineHeight, width, this.lineHeight - 1);
            graphics2D.setColor(gris);
            graphics2D.fill(rect);
            graphics2D.setColor(Color.BLACK);
            x = this.space;
            this.drawCategory(graphics2D, perspective.getDescription(), x, y, summaryTab);
            List objectives = perspective.getObjectiveList();
            graphics2D.setFont(defaultFont.deriveFont((float)this.pagelayout.getFontSize()[1]));
            fontMetrics = graphics2D.getFontMetrics();
            Color lineColor = Color.white;
            for (StrategicObjective objective : objectives) {
                baseline += (float)this.lineHeight;
                summaryTab = objective.getSeverities();
                rect = new Rectangle2D.Double(0.0, y += (float)this.lineHeight, width, this.lineHeight);
                graphics2D.setColor(lineColor);
                graphics2D.fill(rect);
                lineColor = lineColor == Color.white ? grisClair : Color.white;
                graphics2D.setColor(Color.black);
                x = 3 * this.space + this.logoWidth;
                this.drawCategory(graphics2D, objective.getDescription(), x, y, summaryTab);
                List metrics = objective.getResultList();
                for (MetricResult metric : metrics) {
                    baseline += (float)this.lineHeight;
                    rect = new Rectangle2D.Double(0.0, y += (float)this.lineHeight, width, this.lineHeight);
                    graphics2D.setColor(lineColor);
                    graphics2D.fill(rect);
                    lineColor = lineColor == Color.white ? grisClair : Color.white;
                    x = (2 * this.space + this.logoWidth) * 2 + this.space;
                    this.drawIcon(graphics2D, this.icons[9], (int)x, (int)y + this.padding, this.logoWidth);
                    x = (2 * this.space + this.logoWidth) * 3;
                    graphics2D.setColor(Color.black);
                    graphics2D.drawString(metric.getDescription(), x, baseline);
                    if (metric.getMetric() != null) {
                        MessageFormat mf;
                        try {
                            mf = new MessageFormat(metric.getMetricFormat());
                        }
                        catch (IllegalArgumentException e) {
                            mf = new MessageFormat("{0}");
                        }
                        String label = mf.format(new Object[]{metric.getMetric()}) + " (" + mf.format(new Object[]{metric.getTargetValue()}) + ")";
                        label = label.replaceAll("\\[euro\\]", "\u20ac");
                        x = this.leftWidth + this.centerWidth / 2 - (fontMetrics.stringWidth(label) + this.space + this.logoWidth) / 2;
                        graphics2D.drawString(label, x, baseline);
                        x += (float)(fontMetrics.stringWidth(label) + this.space);
                        switch (metric.getTrend()) {
                            case 2: {
                                this.drawIcon(graphics2D, this.icons[10], (int)x, (int)y + this.padding, this.logoWidth);
                                break;
                            }
                            case 1: {
                                this.drawIcon(graphics2D, this.icons[11], (int)x, (int)y + this.padding, this.logoWidth);
                                break;
                            }
                            case 0: {
                                this.drawIcon(graphics2D, this.icons[12], (int)x, (int)y + this.padding, this.logoWidth);
                                break;
                            }
                            default: {
                                this.drawIcon(graphics2D, this.icons[3], (int)x, (int)y + this.padding, this.logoWidth);
                            }
                        }
                    }
                    x = this.leftWidth + this.centerWidth + this.rightWidth / 2 - this.logoWidth / 2;
                    if (metric.getPreviousCalcValue() != metric.getCalcValue()) {
                        x = this.leftWidth + this.centerWidth + this.rightWidth / 2 - (2 * this.logoWidth + this.space) / 2;
                        this.drawGravite(graphics2D, metric.getPreviousCalcValue(), (int)x, (int)y + this.padding, this.logoWidth);
                        x += (float)(this.logoWidth + this.space);
                    }
                    this.drawGravite(graphics2D, metric.getCalcValue(), (int)x, (int)y + this.padding, this.logoWidth);
                }
            }
        }
        graphics2D.setColor(savedColor);
        graphics2D.setStroke(savedStroke);
        graphics2D.setFont(savedFont);
    }

    private void drawIcon(Graphics2D graphics2D, Object icon, int x, int y, int logoWidth) {
        if (icon == null) {
            return;
        }
        if (icon instanceof BufferedImage) {
            graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            graphics2D.drawImage((Image)icon, x, y, logoWidth, logoWidth, null);
        } else if (icon instanceof GraphicsNode) {
            graphics2D.translate(x, y);
            GraphicsNode gn = (GraphicsNode)icon;
            Rectangle2D bounds = gn.getGeometryBounds();
            double factor = (double)logoWidth / bounds.getWidth();
            gn.setTransform(AffineTransform.getScaleInstance(factor, factor));
            gn.paint(graphics2D);
            graphics2D.translate(-x, -y);
        }
    }

    private void drawCategory(Graphics2D graphics2D, String label, float x, float y, int[] summaryTab) {
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        float baseline = y + (float)this.lineHeight - (float)this.padding - (float)fontMetrics.getDescent();
        this.drawIcon(graphics2D, this.icons[8], (int)x, (int)y + this.padding, this.logoWidth);
        graphics2D.setColor(Color.black);
        graphics2D.drawString(label, x += (float)(this.logoWidth + this.space), baseline);
        int sumWidth = 4 * this.logoWidth + 3 * this.space;
        for (int j = 0; j < summaryTab.length - 1; ++j) {
            sumWidth += fontMetrics.stringWidth(Integer.toString(summaryTab[j]));
        }
        x = this.leftWidth + this.centerWidth / 2 - sumWidth / 2;
        if (summaryTab[2] != 0) {
            this.drawIcon(graphics2D, this.icons[2], (int)x, (int)y + this.padding, this.logoWidth);
        } else {
            this.drawIcon(graphics2D, this.icons[6], (int)x, (int)y + this.padding, this.logoWidth);
        }
        label = String.valueOf(summaryTab[2]);
        graphics2D.setColor(Color.black);
        graphics2D.drawString(label, x += (float)this.logoWidth, baseline);
        x += (float)(fontMetrics.stringWidth(label) + this.space);
        if (summaryTab[1] != 0) {
            this.drawIcon(graphics2D, this.icons[1], (int)x, (int)y + this.padding, this.logoWidth);
        } else {
            this.drawIcon(graphics2D, this.icons[5], (int)x, (int)y + this.padding, this.logoWidth);
        }
        label = String.valueOf(summaryTab[1]);
        graphics2D.setColor(Color.black);
        graphics2D.drawString(label, x += (float)this.logoWidth, baseline);
        x += (float)(fontMetrics.stringWidth(label) + this.space);
        if (summaryTab[0] != 0) {
            this.drawIcon(graphics2D, this.icons[0], (int)x, (int)y + this.padding, this.logoWidth);
        } else {
            this.drawIcon(graphics2D, this.icons[4], (int)x, (int)y + this.padding, this.logoWidth);
        }
        label = String.valueOf(summaryTab[0]);
        graphics2D.setColor(Color.black);
        graphics2D.drawString(label, x += (float)this.logoWidth, baseline);
        x += (float)(fontMetrics.stringWidth(label) + this.space);
        if (summaryTab[3] != 0) {
            this.drawIcon(graphics2D, this.icons[3], (int)x, (int)y + this.padding, this.logoWidth);
        } else {
            this.drawIcon(graphics2D, this.icons[7], (int)x, (int)y + this.padding, this.logoWidth);
        }
        label = String.valueOf(summaryTab[3]);
        graphics2D.setColor(Color.black);
        graphics2D.drawString(label, x += (float)this.logoWidth, baseline);
        x += (float)(fontMetrics.stringWidth(label) + this.space);
        x = this.leftWidth + this.centerWidth + this.rightWidth / 2 - this.logoWidth / 2;
        this.drawGravite(graphics2D, summaryTab[4], (int)x, (int)y + this.padding, this.logoWidth);
    }

    private void drawGravite(Graphics2D graphics2D, int gravite, int x, int y, int logowidth) {
        switch (gravite) {
            case 2: {
                this.drawIcon(graphics2D, this.icons[2], x, y, this.logoWidth);
                break;
            }
            case 1: {
                this.drawIcon(graphics2D, this.icons[1], x, y, this.logoWidth);
                break;
            }
            case 0: {
                this.drawIcon(graphics2D, this.icons[0], x, y, this.logoWidth);
                break;
            }
            default: {
                this.drawIcon(graphics2D, this.icons[7], x, y, this.logoWidth);
            }
        }
    }

    public List<IArea> getAreas() {
        return null;
    }

    public PaintableProperties getPaintableProperties() {
        return this.paintableProperties;
    }

    public Dimension getSize() {
        return this.size;
    }

    public void setSize(Dimension size) {
        this.size = size;
    }

    public int getCurrentPage() {
        return 0;
    }

    public int getPages() {
        return 1;
    }

    public void setCurrentPage(int currentPage) {
    }

    private String getURI(String file) {
        try {
            URL url = this.getURL(file);
            URI uri = new URI(url.toString());
            return uri.toString();
        }
        catch (URISyntaxException uRISyntaxException) {
            return null;
        }
    }

    private URL getURL(String file) {
        return StrategyMapChart.class.getResource(file);
    }
}

