/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.helper;

import com.prelytis.dashboard.interfaces.DashboardException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.sql.DataSource;
import org.apache.log4j.LogManager;

public class SystemHelper {
    public static final SystemHelper getInstance() {
        return new SystemHelper();
    }

    private SystemHelper() {
    }

    private void fill(Properties propFile, List<String> finalList, String entry) throws DashboardException {
        String list = propFile.getProperty(entry);
        if (list == null) {
            DashboardException de = new DashboardException();
            de.setLocalizedMessage("No script to convert database");
            throw de;
        }
        StringTokenizer st = new StringTokenizer(list, ":");
        while (st.hasMoreTokens()) {
            String elt = st.nextToken();
            if (elt.length() == 3 || elt.length() == 4) {
                this.fill(propFile, finalList, elt);
                continue;
            }
            finalList.add(elt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDatabaseVersion(DataSource dataSource) {
        String version = null;
        try (Connection con = dataSource.getConnection();
             Statement stmt = con.createStatement();){
            version = this.getVersion(stmt, "SELECT Version FROM BA_DBInfo WHERE ObjectID=1");
            if (version == null || "Release".equalsIgnoreCase(version)) {
                version = this.getVersion(stmt, "SELECT Release FROM BA_DBInfo WHERE ObjectID=1");
            }
            if (version == null || "Release".equalsIgnoreCase(version)) {
                version = this.getVersion(stmt, "SELECT \"Release\" FROM BA_DBInfo WHERE ObjectID=1");
            }
            if (version == null || "Release".equalsIgnoreCase(version)) {
                version = this.getVersion(stmt, "SELECT `Release` FROM BA_DBInfo WHERE ObjectID=1");
            }
            if (version == null || "Release".equalsIgnoreCase(version)) {
                version = null;
            }
        }
        catch (Exception e) {
            LogManager.getLogger(this.getClass()).error((Object)e);
        }
        return version;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getDefaultFolders(DataSource dataSource) {
        ArrayList<String> defaultFolders = new ArrayList<String>();
        try (Connection con = dataSource.getConnection();
             Statement stmt = con.createStatement();
             ResultSet rs = stmt.executeQuery("SELECT directory FROM os_folder WHERE CrUser='prelytis'");){
            String folderPath = null;
            while (rs.next()) {
                folderPath = rs.getString(1);
                defaultFolders.add(folderPath);
            }
        }
        catch (SQLException e) {
            LogManager.getLogger(this.getClass()).error((Object)e);
        }
        return defaultFolders;
    }

    private DashboardException getException(Exception e) {
        if (e instanceof DashboardException) {
            return (DashboardException)((Object)e);
        }
        return new DashboardException((Throwable)e);
    }

    public List<String> getFileList(DataSource dataSource) throws DashboardException {
        String databaseVersion = this.getDatabaseVersion(dataSource);
        return this.getFileList(this.getShortVersion(databaseVersion));
    }

    private List<String> getFileList(String version) throws DashboardException {
        ArrayList<String> list = new ArrayList<String>();
        try {
            list.add("main.sql");
        }
        catch (Exception e) {
            throw this.getException(e);
        }
        return list;
    }

    public List<String> getLanguageFileList() throws DashboardException {
        return this.getFileList("languages");
    }

    private String getShortVersion(String version) {
        if (version == null) {
            return "";
        }
        StringTokenizer st = new StringTokenizer(version, ".");
        StringBuffer str = new StringBuffer();
        while (st.hasMoreTokens()) {
            str.append(st.nextToken());
        }
        return str.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getVersion(Statement stmt, String request) {
        String version = null;
        try (ResultSet rs = stmt.executeQuery(request);){
            if (!rs.next()) return null;
            String string = version = rs.getString(1);
            return string;
        }
        catch (Exception e) {
            LogManager.getLogger(this.getClass()).debug((Object)e);
        }
        return null;
    }
}

