/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.helper;

import com.prelytis.dashboard.interfaces.DashboardException;
import com.prelytis.dashboard.value.data.BeanDashBoardDefinition;
import com.prelytis.dashboard.value.data.BeanDashBoardFilter;
import com.prelytis.dashboard.value.data.BeanDashboardFilterLinkedField;
import com.prelytis.dashboard.value.data.BeanReportFinal;
import com.prelytis.dashboard.value.data.DashBoardFilter;
import com.prelytis.dashboard.value.data.ReportFilter;
import com.prelytis.dashboard.value.data.TaskExpDocFilter;
import com.prelytis.dashboard.value.data.TaskExpDocFilterList;
import com.prelytis.dashboard.value.util.ExpressionEvaluationData;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class TaskDocExpFilterHelper {
    private TaskDocExpFilterHelper() {
    }

    public static final TaskDocExpFilterHelper getInstance() {
        return new TaskDocExpFilterHelper();
    }

    public List<ReportFilter> createReportFilterList(BeanReportFinal report, TaskExpDocFilterList taskFilter) {
        ArrayList<ReportFilter> reportFilterList = new ArrayList<ReportFilter>();
        List list = taskFilter.getTaskExpDocFilterList();
        for (int j = 0; j < list.size(); ++j) {
            TaskExpDocFilter filter = (TaskExpDocFilter)list.get(j);
            ReportFilter tmpReportFilter = this.getReportFilter(report.getFilterList(), filter.getName());
            ReportFilter reportFilter = new ReportFilter();
            reportFilter.setName(tmpReportFilter.getName());
            reportFilter.setDescription(tmpReportFilter.getDescription());
            reportFilter.setValue(filter.getValue());
            reportFilter.setDatatype(tmpReportFilter.getDatatype());
            reportFilter.setPromptType(tmpReportFilter.getPromptType());
            reportFilter.setMandatory(filter.getMandatory().booleanValue());
            reportFilter.setUseFilter(filter.isUse());
            reportFilter.setLinkable(tmpReportFilter.isLinkable());
            reportFilter.setVisible(tmpReportFilter.isVisible());
            reportFilterList.add(reportFilter);
        }
        return reportFilterList;
    }

    private ReportFilter getReportFilter(List<ReportFilter> list, String name) {
        ReportFilter reportFilter = null;
        for (int k = 0; k < list.size(); ++k) {
            reportFilter = list.get(k);
            if (!reportFilter.getName().equals(name)) continue;
            return reportFilter;
        }
        return null;
    }

    public List<DashBoardFilter> createDashFilterList(BeanDashBoardDefinition dashBoardDefinition, TaskExpDocFilterList taskFilter, ExpressionEvaluationData data) throws DashboardException {
        ArrayList<DashBoardFilter> dashFilterList = new ArrayList<DashBoardFilter>();
        List list = taskFilter.getTaskExpDocFilterList();
        for (TaskExpDocFilter filter : list) {
            BeanDashBoardFilter tmpReportFilter = this.getDashFilter(dashBoardDefinition.getFilterList(), filter.getName());
            if (tmpReportFilter.getFilterList() == null) continue;
            DashBoardFilter dashFilter = new DashBoardFilter();
            dashFilter.setName(tmpReportFilter.getName());
            dashFilter.setDescription((String)tmpReportFilter.getDescriptionMap().get(data.getLocale()));
            dashFilter.setValue(filter.getValue());
            dashFilter.setDatatype(tmpReportFilter.getDataType());
            dashFilter.setPromptType(tmpReportFilter.getPromptType());
            dashFilter.setMandatory(filter.getMandatory().booleanValue());
            dashFilter.setUseFilter(filter.isUse());
            Set map = dashFilter.getReportFilterMap();
            for (BeanDashboardFilterLinkedField field : tmpReportFilter.getFilterList()) {
                BeanDashboardFilterLinkedField newField = new BeanDashboardFilterLinkedField();
                newField.setBlockId(field.getBlockId());
                newField.setTemplateId(field.getTemplateId());
                newField.setFieldName(field.getFieldName());
                map.add(newField);
            }
            dashFilterList.add(dashFilter);
        }
        return dashFilterList;
    }

    private BeanDashBoardFilter getDashFilter(List<BeanDashBoardFilter> list, String name) {
        BeanDashBoardFilter dashFilter = null;
        for (int k = 0; k < list.size(); ++k) {
            dashFilter = list.get(k);
            if (!dashFilter.getName().equals(name)) continue;
            return dashFilter;
        }
        return null;
    }
}

