/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.helper;

import com.prelytis.dashboard.dao.TextDao;
import com.prelytis.dashboard.interfaces.DashboardException;
import com.prelytis.dashboard.interfaces.DashboardRuntimeException;
import com.prelytis.dashboard.value.data.BeanText;
import com.prelytis.dashboard.value.structure.TextDocument;
import com.prelytis.dashboard.value.util.ExpressionEvaluationData;
import java.io.IOException;
import java.io.StringReader;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.xml.sax.SAXException;

public final class TextDocumentHelper {
    private final TextDao textDao;

    private TextDocumentHelper(TextDao textDao) {
        this.textDao = textDao;
    }

    public static TextDocumentHelper getInstance(TextDao textDao) {
        return new TextDocumentHelper(textDao);
    }

    public TextDocument getDocument(String textSessionName, ExpressionEvaluationData data) throws DashboardException {
        BeanText text = (BeanText)this.textDao.getCore(textSessionName);
        return this.getDocument(text, data);
    }

    public TextDocument getDocument(BeanText text, ExpressionEvaluationData data) throws DashboardException {
        try {
            TextDocument document = new TextDocument();
            document.setObjectID(text.getObjectID());
            document.setName(text.getName());
            document.getDescriptionMap().putAll(text.getDescriptionMap());
            document.setDescription((String)text.getDescriptionMap().get(data.getLocale()));
            String t = (String)text.getTextFieldMap().get(data.getLocale());
            this.validate(t);
            document.setText(t);
            return document;
        }
        catch (Exception e) {
            if (e instanceof DashboardException) {
                throw (DashboardException)((Object)e);
            }
            if (e instanceof DashboardRuntimeException) {
                throw (DashboardRuntimeException)((Object)e);
            }
            throw new DashboardException((Throwable)e);
        }
    }

    public void validate(String text) throws DashboardException {
        try {
            String t = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<textsession xmlns=\"" + "http://www.prelytis.com/schemas/livedashboard/4.6/textsession.xsd" + "\">" + text + "</textsession>";
            SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            Schema schema = factory.newSchema(this.getClass().getResource("/com/prelytis/dashboard/util/xml/xsd/v_4_6/textsession.xsd"));
            Validator validator = schema.newValidator();
            validator.validate(new StreamSource(new StringReader(t)));
        }
        catch (SAXException e) {
            throw new DashboardException((Throwable)e);
        }
        catch (IOException e) {
            throw new DashboardRuntimeException((Throwable)e);
        }
    }
}

