/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.helper;

import com.prelytis.dashboard.interfaces.DashboardException;
import com.prelytis.dashboard.interfaces.DashboardRuntimeException;
import com.prelytis.dashboard.interfaces.ErrorCode;
import com.prelytis.dashboard.util.ExpressionEvaluationHelper;
import com.prelytis.dashboard.value.data.BeanExtSessionDefinition;
import com.prelytis.dashboard.value.data.BeanExtSessionParameter;
import com.prelytis.dashboard.value.data.BeanPersFieldValue;
import com.prelytis.dashboard.value.data.ReportFilter;
import com.prelytis.dashboard.value.util.Expression;
import com.prelytis.dashboard.value.util.ExpressionEvaluationData;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.List;

public class UrlHelper {
    private static final String UTF8 = "UTF-8";
    private final ExpressionEvaluationHelper helper = ExpressionEvaluationHelper.getInstance();
    private BeanExtSessionDefinition extSession;
    private List<ReportFilter> filterList;
    private List<BeanPersFieldValue> valueList;
    private ExpressionEvaluationData data;

    public String getUrl() throws DashboardException {
        if (this.extSession == null) {
            return null;
        }
        try {
            StringBuffer url = new StringBuffer();
            url.append(this.extSession.getUrl());
            List list = this.extSession.getParameterList();
            HashMap<String, ReportFilter> map = new HashMap<String, ReportFilter>();
            for (ReportFilter filter : this.filterList) {
                map.put(filter.getName(), filter);
            }
            boolean first = true;
            for (int i = 0; i < list.size(); ++i) {
                BeanExtSessionParameter parameter = (BeanExtSessionParameter)list.get(i);
                boolean use = parameter.isMandatory();
                ReportFilter filter = (ReportFilter)map.get(parameter.getName());
                Object[] valueList = new Object[]{parameter.getDefaultValue()};
                if (filter != null && filter.getUseFilter()) {
                    use = true;
                    valueList = filter.getValues();
                }
                for (int j = 0; j < valueList.length; ++j) {
                    Object value = valueList[j];
                    if (value instanceof Expression) {
                        value = this.helper.evaluateExpression((Expression)value, this.data);
                    }
                    if (!use) continue;
                    if (first) {
                        url.append("?");
                        first = false;
                    } else {
                        url.append("&");
                    }
                    url.append(URLEncoder.encode(parameter.getName(), UTF8));
                    url.append("=");
                    if (value == null) continue;
                    url.append(URLEncoder.encode(value.toString(), UTF8));
                }
            }
            return url.toString();
        }
        catch (Exception e) {
            throw new DashboardRuntimeException(ErrorCode.INSIGHT_UNKNOWN, "Error while building url", (Throwable)e);
        }
    }

    public ExpressionEvaluationData getData() {
        return this.data;
    }

    public void setData(ExpressionEvaluationData data) {
        this.data = data;
    }

    public BeanExtSessionDefinition getExtSession() {
        return this.extSession;
    }

    public void setExtSession(BeanExtSessionDefinition extSession) {
        this.extSession = extSession;
    }

    public List<ReportFilter> getFilterList() {
        return this.filterList;
    }

    public void setFilterList(List<ReportFilter> filterList) {
        this.filterList = filterList;
    }

    public List<BeanPersFieldValue> getValueList() {
        return this.valueList;
    }

    public void setValueList(List<BeanPersFieldValue> valueList) {
        this.valueList = valueList;
    }
}

