/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.helper;

import com.prelytis.dashboard.dao.DaoFactory;
import com.prelytis.dashboard.dao.QueryDao;
import com.prelytis.dashboard.data.engine.CommandParameter;
import com.prelytis.dashboard.data.engine.ExecutionContext;
import com.prelytis.dashboard.data.helper.EngineHelper;
import com.prelytis.dashboard.data.transformation.DataTransformer;
import com.prelytis.dashboard.data.transformation.ResultsetDataReader;
import com.prelytis.dashboard.data.transformation.ValueListDataHandler;
import com.prelytis.dashboard.db.QuerySQL;
import com.prelytis.dashboard.db.operation.OperationFinal;
import com.prelytis.dashboard.db.operation.OperationSelect;
import com.prelytis.dashboard.db.operator.Operator;
import com.prelytis.dashboard.db.operator.OperatorSelect;
import com.prelytis.dashboard.db.sql.Result;
import com.prelytis.dashboard.db.sql.StreamedResult;
import com.prelytis.dashboard.helper.FullReportFilter;
import com.prelytis.dashboard.helper.FullReportFilterDS;
import com.prelytis.dashboard.helper.FullReportFilterSQL;
import com.prelytis.dashboard.interfaces.DashboardException;
import com.prelytis.dashboard.interfaces.DashboardRuntimeException;
import com.prelytis.dashboard.interfaces.IQueryDefinition;
import com.prelytis.dashboard.persistence.Configuration;
import com.prelytis.dashboard.persistence.DataSourceConfiguration;
import com.prelytis.dashboard.value.data.AbstractBeanReport;
import com.prelytis.dashboard.value.data.AbstractBeanReportAvlField;
import com.prelytis.dashboard.value.data.Bean;
import com.prelytis.dashboard.value.data.BeanQuerySQL;
import com.prelytis.dashboard.value.data.BeanReportStd;
import com.prelytis.dashboard.value.data.BeanReportStdSortField;
import com.prelytis.dashboard.value.data.BeanReportStdUsedField;
import com.prelytis.dashboard.value.data.SortOrder;
import com.prelytis.dashboard.value.data.ValueListElt;
import com.prelytis.dashboard.value.query.ComparisonExpression;
import com.prelytis.dashboard.value.query.Expression;
import com.prelytis.dashboard.value.query.FieldOperand;
import com.prelytis.dashboard.value.query.InteractiveOperand;
import com.prelytis.dashboard.value.query.Operand;
import com.prelytis.dashboard.value.query.PromptOperand;
import com.prelytis.dashboard.value.util.DataType;
import com.prelytis.dashboard.value.util.ExpressionEvaluationData;
import com.prelytis.dashboard.value.util.FieldMetaData;
import java.sql.Connection;
import java.util.List;
import javax.sql.DataSource;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class ValueListHelper {
    private static final Logger log = LogManager.getLogger(ValueListHelper.class);
    private final IQueryDefinition query;
    private final AbstractBeanReport report;
    private final ExpressionEvaluationData data;
    private final DaoFactory daoFactory;

    private ValueListHelper(DaoFactory daoFactory, ExpressionEvaluationData data, IQueryDefinition query, AbstractBeanReport report) {
        this.daoFactory = daoFactory;
        this.data = data;
        this.query = query;
        this.report = report;
    }

    public static ValueListHelper getInstance(DaoFactory daoFactory, ExpressionEvaluationData data, IQueryDefinition query, AbstractBeanReport report) {
        return new ValueListHelper(daoFactory, data, query, report);
    }

    public IQueryDefinition getQuery() {
        return this.query;
    }

    public AbstractBeanReport getReport() {
        return this.report;
    }

    public List<ValueListElt> getValueList(FullReportFilter fullFilter) throws DashboardException {
        if (fullFilter instanceof FullReportFilterDS) {
            return this.getValueList((FullReportFilterDS)fullFilter);
        }
        return this.getValueList((FullReportFilterSQL)fullFilter);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<ValueListElt> getValueList(FullReportFilterSQL filterSQL) throws DashboardException {
        if (filterSQL == null || filterSQL.getPromptType() == 1 || filterSQL.getPromptType() == 4) {
            return null;
        }
        try {
            BeanQuerySQL sqlQuery = null;
            if (this.query == null || this.query.getObjectID() != filterSQL.getValueListOid()) {
                QueryDao queryDao = this.daoFactory.getQueryDao();
                Bean queryDef = queryDao.getDefinition(filterSQL.getValueListOid());
                if (!(queryDef instanceof BeanQuerySQL)) {
                    log.warn((Object)("Query " + queryDef.getName() + " is not a SQL Query, ignoring"));
                    return null;
                }
                sqlQuery = (BeanQuerySQL)queryDef;
            } else {
                sqlQuery = (BeanQuerySQL)this.query;
            }
            EngineHelper engineHelper = EngineHelper.getInstance(this.daoFactory);
            Result result = engineHelper.getResult(sqlQuery, this.data, null);
            return this.getValueList(result, "{0}");
        }
        catch (Exception e) {
            throw this.getDashboardException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    private List<ValueListElt> getValueList(FullReportFilterDS filterDS) throws DashboardException {
        if (filterDS == null || filterDS.getPromptType() == 1 || filterDS.getPromptType() == 4) {
            return null;
        }
        InteractiveOperand op = filterDS.getOperand();
        EngineHelper engineHelper = EngineHelper.getInstance(this.daoFactory);
        if (op.getCacheTableName() != null) {
            try {
                FieldMetaData fmd = new FieldMetaData();
                fmd.setName("Value");
                fmd.setDataType(op.getDataType());
                QuerySQL querySQL = new QuerySQL();
                StringBuilder sb = new StringBuilder("SELECT Value FROM ").append(op.getCacheTableName()).append(" ORDER BY Value ");
                if (op.getSortOrder() != null && op.getSortOrder().equals((Object)SortOrder.SORT_DESCENDING)) {
                    sb.append(" DESC");
                } else {
                    sb.append(" ASC");
                }
                querySQL.setQueryString(sb.toString());
                querySQL.setUsePreparedStatement(true);
                querySQL.getFieldList().add(fmd);
                Configuration configuration = Configuration.getInstance();
                DataSourceConfiguration dsConf = configuration.getDataSourceConfiguration();
                DataSource ds = dsConf.getDataSource();
                try (Connection con = ds.getConnection();){
                    List<ValueListElt> list;
                    OperationSelect select = new OperationSelect();
                    select.setQuerySQL(querySQL);
                    select.setUseResultsetMetadata(true);
                    OperatorSelect operator = new OperatorSelect(select);
                    try {
                        operator.setConnection(con);
                        StreamedResult result = new StreamedResult((Operator)operator, 1, operator.getFieldMetaData(), -1);
                        list = this.getValueList((Result)result, op.getFormat());
                    }
                    catch (Throwable throwable) {
                        operator.close();
                        throw throwable;
                    }
                    operator.close();
                    return list;
                }
            }
            catch (Exception sqle) {
                log.debug((Object)sqle);
            }
        }
        BeanReportStd std = new BeanReportStd();
        std.setQueryOID(this.report.getQueryOID());
        std.setQueryName(this.report.getQueryName());
        std.getAvlGroupList().addAll(this.report.getAvlGroupList());
        ExecutionContext context = engineHelper.getExecutionContext((AbstractBeanReport)std, this.data, null, !op.isCompleteList());
        CommandParameter cp = CommandParameter.getInstance(context);
        AbstractBeanReportAvlField field = cp.getAvlField(filterDS.getFieldName());
        BeanReportStdUsedField uf = new BeanReportStdUsedField();
        uf.setId(0);
        uf.setName(field.getName());
        uf.setField(field);
        uf.setBodyFormat(op.getFormat());
        std.getFieldList().add(uf);
        BeanReportStdSortField sf = new BeanReportStdSortField();
        sf.setColId(0);
        sf.setSortOrder(op.getSortOrder());
        std.getSortFieldList().add(sf);
        OperationFinal operation = engineHelper.getOperation((AbstractBeanReport)std, context);
        Result result = engineHelper.getResult(operation);
        return this.getValueList(result, op.getFormat());
    }

    public List<ValueListElt> getFirstHierarchicalValueList(FullReportFilterDS filterDS, String fieldName) throws DashboardException {
        return null;
    }

    public List<ValueListElt> getHierarchicalValueList(String currentFieldName, String precedFieldName, DataType precedDataType, Object[] precedSelectValues, String format, SortOrder sortOrder, boolean useFactTable) throws DashboardException {
        try {
            EngineHelper engineHelper = EngineHelper.getInstance(this.daoFactory);
            BeanReportStd std = new BeanReportStd();
            std.setQueryOID(this.report.getQueryOID());
            std.setQueryName(this.report.getQueryName());
            std.getAvlGroupList().addAll(this.report.getAvlGroupList());
            ExecutionContext context = engineHelper.getExecutionContext((AbstractBeanReport)std, this.data, null, useFactTable);
            CommandParameter cp = CommandParameter.getInstance(context);
            AbstractBeanReportAvlField field = cp.getAvlField(currentFieldName);
            BeanReportStdUsedField uf = new BeanReportStdUsedField();
            uf.setId(0);
            uf.setName(field.getName());
            uf.setField(field);
            uf.setBodyFormat(format);
            std.getFieldList().add(uf);
            BeanReportStdSortField sf = new BeanReportStdSortField();
            sf.setColId(0);
            sf.setSortOrder(sortOrder);
            std.getSortFieldList().add(sf);
            std.setTopExpression(this.getComparisionExpression(precedFieldName, precedDataType, precedSelectValues));
            OperationFinal operation = engineHelper.getOperation((AbstractBeanReport)std, context);
            Result result = engineHelper.getResult(operation);
            return this.getValueList(result, format);
        }
        catch (Exception e) {
            throw this.getDashboardException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ValueListElt> getValueList(Result result, String format) throws DashboardRuntimeException, DashboardException {
        try {
            ResultsetDataReader dataReader = new ResultsetDataReader(result);
            ValueListDataHandler dataHandler = new ValueListDataHandler(format, this.data.getLocale(), this.data.getTimeZone());
            DataTransformer transformer = new DataTransformer();
            transformer.transform(dataReader, dataHandler);
            List<ValueListElt> list = dataHandler.getValueList();
            return list;
        }
        finally {
            result.close();
        }
    }

    private Expression getComparisionExpression(String filterFieldName, DataType datatype, Object[] filterValues) {
        if (filterFieldName == null) {
            return null;
        }
        FieldOperand leftOp = new FieldOperand();
        leftOp.setField(filterFieldName);
        leftOp.setId(0);
        PromptOperand rightOp = new PromptOperand();
        rightOp.setName(filterFieldName);
        rightOp.setDataType(datatype);
        rightOp.setValues(filterValues);
        return new ComparisonExpression((Operand)leftOp, 3, (Operand)rightOp);
    }

    private DashboardException getDashboardException(Exception e) {
        if (e instanceof DashboardException) {
            return (DashboardException)((Object)e);
        }
        log.error((Object)e, (Throwable)e);
        return new DashboardException((Throwable)e);
    }
}

