/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.model;

import com.prelytis.dashboard.dao.DaoFactory;
import com.prelytis.dashboard.dao.SqlFunctionDao;
import com.prelytis.dashboard.interfaces.DashboardException;
import com.prelytis.dashboard.interfaces.Element;
import com.prelytis.dashboard.interfaces.I18nElement;
import com.prelytis.dashboard.model.ResponseFactory;
import com.prelytis.dashboard.model.helper.SqlFunctionHelper;
import com.prelytis.dashboard.persistence.helper.CalcOperandContainer;
import com.prelytis.dashboard.value.CalcFieldRequest;
import com.prelytis.dashboard.value.CalcFieldResponse;
import com.prelytis.dashboard.value.Request;
import com.prelytis.dashboard.value.Response;
import com.prelytis.dashboard.value.data.AbstractBeanReport;
import com.prelytis.dashboard.value.data.AbstractBeanReportAvlField;
import com.prelytis.dashboard.value.data.BeanReportAvlGroup;
import com.prelytis.dashboard.value.data.BeanSQLFunctionDefinition;
import com.prelytis.dashboard.value.data.BeanSQLFunctionParam;
import com.prelytis.dashboard.value.data.BeanSQLFunctionParamGroup;
import com.prelytis.dashboard.value.data.BeanSQLFunctionParamType;
import com.prelytis.dashboard.value.data.SecurityAdapter;
import com.prelytis.dashboard.value.query.CalcFunctionOperand;
import com.prelytis.dashboard.value.query.ICalculatedOperand;
import com.prelytis.dashboard.value.query.IOperandGroup;
import com.prelytis.dashboard.value.util.DataType;
import com.prelytis.dashboard.value.util.ExpressionEvaluationData;
import java.util.ArrayList;
import java.util.List;

class CalcFieldResponseFactory
extends ResponseFactory {
    CalcFieldResponseFactory() {
    }

    @Override
    public Response create(Request value, ExpressionEvaluationData data, DaoFactory daoFactory) throws DashboardException {
        CalcFieldRequest request = (CalcFieldRequest)value;
        CalcFieldRequest.Action action = request.getAction();
        if (action != null) {
            switch (action) {
                case ADD: {
                    if (request.getGroupId() == null) {
                        return this.getAddOperand(daoFactory, request);
                    }
                    return this.getAddGroup(daoFactory, request);
                }
                case DELETE: {
                    if (request.getGroupId() == null) {
                        return this.getDeleteOperand(request);
                    }
                    return this.getDeleteGroup(request);
                }
                case OPERAND: {
                    return this.getOperand(request);
                }
                case LIST_FUNCTIONS: {
                    return this.getFunctionList(daoFactory, request, data);
                }
            }
        }
        return new CalcFieldResponse();
    }

    private Response getFunctionList(DaoFactory daoFactory, CalcFieldRequest request, ExpressionEvaluationData data) throws DashboardException {
        CalcFieldResponse response = new CalcFieldResponse();
        CalcOperandContainer container = new CalcOperandContainer(request.getAvlCalcField(), request.getLocale(), request.getTimeZone());
        Integer operandId = request.getOperandId();
        ICalculatedOperand operand = container.get(operandId.intValue());
        SqlFunctionHelper functionHelper = SqlFunctionHelper.getInstance(daoFactory);
        List<Element> elementList = functionHelper.list(null, 2, null, null, data);
        ArrayList<SecurityAdapter> list = new ArrayList<SecurityAdapter>();
        DataType expectedDataType = operand.getExpectedDataType();
        if (request.getDatatype() != null && DataType.getCompatibility((DataType)expectedDataType, (DataType)request.getDatatype())) {
            expectedDataType = request.getDatatype();
        }
        for (Element elt : elementList) {
            BeanSQLFunctionDefinition function = (BeanSQLFunctionDefinition)elt;
            if (!this.canUseFunction(function, expectedDataType)) continue;
            SecurityAdapter sa = new SecurityAdapter();
            sa.setElement((I18nElement)function);
            list.add(sa);
        }
        response.setList(list);
        return response;
    }

    private boolean canUseFunction(BeanSQLFunctionDefinition function, DataType expectedDataType) {
        DataType dataType = this.getDataType(function.getParamTypeList(), function.getReturnParamTypeId());
        boolean fg = DataType.isGeneric((DataType)dataType) && this.isGenericValid(function, dataType);
        switch (expectedDataType) {
            case GENERIC_ANY: {
                return true;
            }
        }
        if (fg) {
            return DataType.getCompatibility((DataType)dataType, (DataType)expectedDataType);
        }
        return DataType.getCompatibility((DataType)expectedDataType, (DataType)dataType);
    }

    private DataType getDataType(List<BeanSQLFunctionParamType> list, int paramTypeId) {
        for (BeanSQLFunctionParamType paramType : list) {
            if (paramType.getParamTypeId() != paramTypeId) continue;
            return paramType.getDatatype();
        }
        return DataType.GENERIC_ANY;
    }

    private boolean isGenericValid(BeanSQLFunctionDefinition function, DataType dataType) {
        int paramTypeId = function.getReturnParamTypeId();
        for (BeanSQLFunctionParamGroup grp : function.getParamGroupList()) {
            for (BeanSQLFunctionParam param : grp.getParamList()) {
                if (param.getParamTypeId() != paramTypeId) continue;
                return true;
            }
        }
        return false;
    }

    private Response getOperand(CalcFieldRequest request) {
        CalcFieldResponse response = new CalcFieldResponse();
        CalcOperandContainer container = new CalcOperandContainer(request.getAvlCalcField(), request.getLocale(), request.getTimeZone());
        Integer operandId = request.getOperandId();
        response.setAvlCalcField(request.getAvlCalcField());
        response.setOperand(container.get(operandId.intValue()));
        return response;
    }

    private Response getDeleteGroup(CalcFieldRequest request) {
        CalcFieldResponse response = new CalcFieldResponse();
        CalcOperandContainer container = new CalcOperandContainer(request.getAvlCalcField(), request.getLocale(), request.getTimeZone());
        Integer groupId = request.getGroupId();
        container.deleteGroup(groupId.intValue());
        response.setAvlCalcField(request.getAvlCalcField());
        return response;
    }

    private Response getAddGroup(DaoFactory daoFactory, CalcFieldRequest request) {
        Integer groupId;
        IOperandGroup group;
        CalcFieldResponse response = new CalcFieldResponse();
        CalcOperandContainer container = new CalcOperandContainer(request.getAvlCalcField(), request.getLocale(), request.getTimeZone());
        ICalculatedOperand operand = container.getParent(group = container.getGroup((groupId = request.getGroupId()).intValue()));
        if (operand != null && operand.getOperand() instanceof CalcFunctionOperand) {
            CalcFunctionOperand functionOperand = (CalcFunctionOperand)operand.getOperand();
            BeanSQLFunctionDefinition function = null;
            SqlFunctionDao sqlFunctionDao = daoFactory.getSqlFunctionDao();
            try {
                function = (BeanSQLFunctionDefinition)sqlFunctionDao.getDefinition(functionOperand.getSqlFunctionName());
            }
            catch (Exception exception) {
                // empty catch block
            }
            container.addGroup(group, operand, function);
        }
        response.setAvlCalcField(request.getAvlCalcField());
        return response;
    }

    private CalcFieldResponse getAddOperand(DaoFactory daoFactory, CalcFieldRequest request) throws DashboardException {
        CalcFieldResponse response = new CalcFieldResponse();
        CalcOperandContainer container = new CalcOperandContainer(request.getAvlCalcField(), request.getLocale(), request.getTimeZone());
        Integer operandId = request.getOperandId();
        if (request.getFieldId() != null && operandId != null) {
            AbstractBeanReport report = request.getReport();
            AbstractBeanReportAvlField avlField = null;
            Integer fieldId = request.getFieldId();
            for (BeanReportAvlGroup group : report.getAvlGroupList()) {
                for (AbstractBeanReportAvlField tmp : group.getFields()) {
                    if (tmp.getId() != fieldId.intValue()) continue;
                    avlField = tmp;
                    break;
                }
                if (avlField == null) continue;
                break;
            }
            container.add(operandId.intValue(), avlField);
        } else if (request.getFunctionName() != null && operandId != null) {
            String functionName = request.getFunctionName();
            SqlFunctionDao sqlFunctionDao = daoFactory.getSqlFunctionDao();
            BeanSQLFunctionDefinition function = (BeanSQLFunctionDefinition)sqlFunctionDao.getDefinition(functionName);
            DataType expectedDatatype = DataType.GENERIC_ANY;
            if (request.getDatatype() != null) {
                expectedDatatype = request.getDatatype();
            }
            container.add(operandId.intValue(), function, expectedDatatype);
        } else if (operandId != null) {
            DataType datatype = request.getDatatype() == null ? DataType.GENERIC_ANY : request.getDatatype();
            container.add(operandId.intValue(), datatype, request.getValue());
        }
        response.setAvlCalcField(request.getAvlCalcField());
        return response;
    }

    private CalcFieldResponse getDeleteOperand(CalcFieldRequest request) {
        CalcFieldResponse response = new CalcFieldResponse();
        CalcOperandContainer container = new CalcOperandContainer(request.getAvlCalcField(), request.getLocale(), request.getTimeZone());
        container.remove(request.getOperandId().intValue());
        response.setAvlCalcField(request.getAvlCalcField());
        return response;
    }
}

