/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.model;

import com.prelytis.dashboard.dao.DaoFactory;
import com.prelytis.dashboard.dao.JdbcDriverDao;
import com.prelytis.dashboard.dao.WorldDao;
import com.prelytis.dashboard.dao.filter.DbQueryFilter;
import com.prelytis.dashboard.db.operator.ConnectionHelper;
import com.prelytis.dashboard.db.operator.WorldHelper;
import com.prelytis.dashboard.helper.ExpressionEvaluationDataHelper;
import com.prelytis.dashboard.interfaces.DashboardException;
import com.prelytis.dashboard.interfaces.DashboardRuntimeException;
import com.prelytis.dashboard.interfaces.Element;
import com.prelytis.dashboard.interfaces.ErrorCode;
import com.prelytis.dashboard.interfaces.IQueryDefinition;
import com.prelytis.dashboard.model.ResponseFactory;
import com.prelytis.dashboard.model.helper.JdbcDriverHelper;
import com.prelytis.dashboard.model.helper.QueryHelper;
import com.prelytis.dashboard.value.DatabaseRequest;
import com.prelytis.dashboard.value.DatabaseResponse;
import com.prelytis.dashboard.value.Request;
import com.prelytis.dashboard.value.Response;
import com.prelytis.dashboard.value.data.BeanJDBCDriverDefinition;
import com.prelytis.dashboard.value.data.BeanQuery;
import com.prelytis.dashboard.value.data.BeanQuerySQLField;
import com.prelytis.dashboard.value.data.BeanWorldDefinition;
import com.prelytis.dashboard.value.data.BeanWorldDriverProperty;
import com.prelytis.dashboard.value.data.DriverCharacteristics;
import com.prelytis.dashboard.value.util.ExpressionEvaluationData;
import com.prelytis.dashboard.value.util.IDBInfo;
import com.prelytis.dashboard.value.util.IPoolDBInfo;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;

class DatabaseResponseFactory
extends ResponseFactory {
    DatabaseResponseFactory() {
    }

    @Override
    public Response create(Request request, ExpressionEvaluationData data, DaoFactory daoFactory) throws DashboardException {
        DatabaseRequest databaseRequest = (DatabaseRequest)request;
        DatabaseResponse response = new DatabaseResponse();
        try {
            Integer output = 2;
            if (databaseRequest.getOutput() != null) {
                output = databaseRequest.getOutput();
            }
            switch (output) {
                case 2: {
                    if (databaseRequest.getWorld() == null && (databaseRequest.getWorldName() == null || databaseRequest.getWorldName().isEmpty())) {
                        response.setMap(this.getMapFromDataDict(daoFactory, databaseRequest));
                        break;
                    }
                    response.setMap(this.getMap(daoFactory, databaseRequest));
                    break;
                }
                case 3: {
                    this.driverInfo(daoFactory, databaseRequest, response);
                    break;
                }
                case 4: {
                    this.testConnection(daoFactory, databaseRequest, response, data);
                    break;
                }
                case 5: {
                    response.setFunctionList(this.getFunctionList(daoFactory, databaseRequest, data));
                }
            }
        }
        catch (Exception e) {
            throw this.getException(e);
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<List<String>> getFunctionList(DaoFactory daoFactory, DatabaseRequest request, ExpressionEvaluationData data) throws DashboardException {
        ArrayList<List<String>> list = new ArrayList<List<String>>();
        try (Connection con = this.getConnection(daoFactory, request, data);){
            DatabaseMetaData dmd = con.getMetaData();
            try {
                list.add(this.getList(dmd.getStringFunctions()));
            }
            catch (Exception ex) {
                log.error((Object)ex);
            }
            try {
                list.add(this.getList(dmd.getNumericFunctions()));
            }
            catch (Exception ex) {
                log.error((Object)ex);
            }
            try {
                list.add(this.getList(dmd.getTimeDateFunctions()));
            }
            catch (Exception ex) {
                log.error((Object)ex);
            }
            try {
                list.add(this.getList(dmd.getSystemFunctions()));
            }
            catch (Exception ex) {
                log.error((Object)ex);
            }
        }
        catch (Exception e) {
            throw this.getException(e);
        }
        return list;
    }

    private ExpressionEvaluationData getData(DaoFactory daoFactory, DatabaseRequest request) throws DashboardException {
        ExpressionEvaluationDataHelper helper = ExpressionEvaluationDataHelper.getInstance(daoFactory);
        return helper.getExpressionEvaluationData(request.getUserSessionGuid(), request.getExecutionContext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testConnection(DaoFactory daoFactory, DatabaseRequest request, DatabaseResponse response, ExpressionEvaluationData data) throws DashboardException {
        ArrayList<String> list = new ArrayList<String>();
        try {
            WorldHelper worldHelper = this.getWorldHelper(daoFactory, request, data);
            try (Connection con = ConnectionHelper.getInstance((WorldHelper)worldHelper).getConnection();){
                DatabaseMetaData dmd = con.getMetaData();
                if (dmd != null) {
                    String value = null;
                    try {
                        value = dmd.getDatabaseProductName();
                    }
                    catch (Exception e) {
                        log.error((Object)e);
                    }
                    if (value != null) {
                        list.add(value);
                    } else {
                        list.add("Unknown database product");
                    }
                    value = null;
                    try {
                        value = dmd.getDatabaseProductVersion();
                    }
                    catch (Exception e) {
                        log.error((Object)e);
                    }
                    if (value != null) {
                        list.add(value);
                    } else {
                        list.add("Unknown product version");
                    }
                    value = null;
                    try {
                        value = dmd.getDriverName();
                    }
                    catch (Exception e) {
                        log.error((Object)e);
                    }
                    if (value != null) {
                        list.add(value);
                    } else {
                        list.add("Unknown driver name");
                    }
                    value = null;
                    try {
                        value = dmd.getDriverVersion();
                    }
                    catch (Exception e) {
                        log.error((Object)e);
                    }
                    if (value != null) {
                        list.add(value);
                    } else {
                        list.add("Unknown driver version");
                    }
                } else {
                    list.add("No meta data");
                }
                if (worldHelper.getLimitToCatalogSchema()) {
                    String catalog = worldHelper.getCatalog(null);
                    String schema = worldHelper.getSchema(null);
                    Map<String, Set<String>> catalogSchemaMap = this.getCatalogSchemaMap(dmd);
                    this.addCatalogs(dmd, catalogSchemaMap);
                    Set<String> schemaSet = catalogSchemaMap.get(catalog);
                    if (schemaSet == null) {
                        list.add("Catalog not found");
                        Set<String> catalogSet = catalogSchemaMap.keySet();
                        String expectedCatalog = this.getIgnoreCase(catalogSet, catalog);
                        if (expectedCatalog != null) {
                            list.add("Try catalog '" + expectedCatalog + "'");
                        } else {
                            String catalogList = this.getString(catalogSet);
                            if (catalogList != null) {
                                list.add("Proposed catalog : " + this.getString(catalogSet));
                            }
                        }
                    } else {
                        list.add("Catalog found '" + catalog + "'");
                        if (catalogSchemaMap.containsKey("")) {
                            schemaSet.addAll((Collection<String>)catalogSchemaMap.get(""));
                        }
                        if (schemaSet.contains(schema)) {
                            list.add("Schema found '" + schema + "'");
                        } else {
                            list.add("Schema not found");
                            String expectedSchema = this.getIgnoreCase(schemaSet, schema);
                            if (expectedSchema != null) {
                                list.add("Try schema '" + expectedSchema + "'");
                            } else {
                                String schemaList = this.getString(schemaSet);
                                if (schemaList != null) {
                                    list.add("Proposed schema : " + this.getString(schemaSet));
                                }
                            }
                        }
                    }
                }
            }
            response.setConnectionValid(true);
        }
        catch (DashboardException de) {
            throw de;
        }
        catch (SQLException e) {
            log.info((Object)("SQLState: " + e.getSQLState()));
            SQLException sqle = e;
            for (int cpt = 0; sqle != null && cpt < 10; ++cpt) {
                sqle = e.getNextException();
                log.error((Object)sqle);
                list.add(e.getMessage());
            }
            response.setConnectionValid(false);
        }
        catch (Exception e) {
            log.error((Object)e);
            list.add(e.getMessage());
            response.setConnectionValid(false);
        }
        response.setList(list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addCatalogs(DatabaseMetaData dmd, Map<String, Set<String>> catalogSchemaMap) {
        try (ResultSet rs = dmd.getCatalogs();){
            while (rs.next()) {
                String schema = rs.getString(1);
                if (catalogSchemaMap.containsKey(schema)) continue;
                catalogSchemaMap.put(schema, new HashSet());
            }
        }
        catch (Exception e) {
            log.error((Object)e);
        }
    }

    private String getString(Set<String> set) {
        StringBuffer str = new StringBuffer();
        boolean first = true;
        for (String entry : set) {
            if (first) {
                first = false;
            } else {
                str.append(", ");
            }
            str.append(entry);
        }
        if (first) {
            return null;
        }
        return str.toString();
    }

    private String getIgnoreCase(Set<String> set, String value) {
        for (String entry : set) {
            if (!entry.equalsIgnoreCase(value)) continue;
            return entry;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Set<String>> getCatalogSchemaMap(DatabaseMetaData dmd) {
        HashMap<String, Set<String>> catalogSchemaMap = new HashMap<String, Set<String>>();
        try (ResultSet rs = dmd.getSchemas();){
            while (rs.next()) {
                String schema = rs.getString(1);
                String catalog = null;
                try {
                    catalog = rs.getString(2);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                HashSet<String> schemaSet = (HashSet<String>)catalogSchemaMap.get(catalog);
                if (schemaSet == null) {
                    schemaSet = new HashSet<String>();
                    catalogSchemaMap.put(catalog, schemaSet);
                }
                schemaSet.add(schema);
            }
        }
        catch (Exception e) {
            log.warn((Object)e);
        }
        return catalogSchemaMap;
    }

    private BeanJDBCDriverDefinition getDriver(DaoFactory daoFactory, BeanWorldDefinition world) {
        if (world == null) {
            throw new DashboardRuntimeException(ErrorCode.MISSING_ERROR, "A world is needed");
        }
        JdbcDriverDao driverDao = daoFactory.getJdbcDriverDao();
        BeanJDBCDriverDefinition driver = (BeanJDBCDriverDefinition)driverDao.getDefinition(world.getDriverName());
        return driver;
    }

    private Map<String, BeanWorldDriverProperty> getDriverPropertyMap(BeanWorldDefinition world) {
        List list = world.getDriverPropertyInfoList();
        if (list != null) {
            HashMap<String, BeanWorldDriverProperty> map = new HashMap<String, BeanWorldDriverProperty>(list.size());
            for (int i = 0; i < list.size(); ++i) {
                BeanWorldDriverProperty prop = (BeanWorldDriverProperty)list.get(i);
                map.put(prop.getName(), prop);
            }
            return map;
        }
        return new HashMap<String, BeanWorldDriverProperty>();
    }

    private void driverInfo(DaoFactory daoFactory, DatabaseRequest databaseRequest, DatabaseResponse response) {
        BeanWorldDefinition world = databaseRequest.getWorld();
        try {
            ArrayList<BeanWorldDriverProperty> list = new ArrayList<BeanWorldDriverProperty>();
            BeanJDBCDriverDefinition driver = this.getDriver(daoFactory, world);
            Map<String, BeanWorldDriverProperty> worldDriverPropertyMap = this.getDriverPropertyMap(world);
            ExpressionEvaluationData data = this.getData(daoFactory, databaseRequest);
            WorldHelper wh = WorldHelper.getInstance((BeanWorldDefinition)world, (DriverCharacteristics)driver, (ExpressionEvaluationData)data);
            Driver jdbcDriver = DriverManager.getDriver(wh.getURL());
            Properties info = new Properties();
            info.setProperty("user", wh.getUser());
            info.setProperty("password", wh.getPassword());
            DriverPropertyInfo[] infos = jdbcDriver.getPropertyInfo(world.getUrl(), info);
            for (int i = 0; i < infos.length; ++i) {
                DriverPropertyInfo dpf = infos[i];
                String name = dpf.name;
                if (name.equals("user") || name.equals("password")) continue;
                BeanWorldDriverProperty property = worldDriverPropertyMap.get(name);
                if (property == null) {
                    property = new BeanWorldDriverProperty();
                    property.setName(name);
                    property.setValue(dpf.value);
                }
                property.setDescription(infos[i].description);
                property.setChoices(infos[i].choices);
                boolean req = dpf.required;
                property.setRequired(req);
                if (req) {
                    property.setUsed(req);
                }
                list.add(property);
            }
            response.setDriverPropertyList(list);
        }
        catch (Exception e) {
            log.error((Object)e);
        }
    }

    private List<String> getList(String list) {
        ArrayList<String> newList = new ArrayList<String>();
        if (list != null) {
            StringTokenizer st = new StringTokenizer(list, ",");
            while (st.hasMoreTokens()) {
                newList.add(st.nextToken());
            }
        }
        return newList;
    }

    private BeanWorldDefinition getWorld(DaoFactory daoFactory, DatabaseRequest request) {
        if (request.getWorldName() == null && request.getWorld() == null) {
            throw new DashboardRuntimeException(ErrorCode.MISSING_ERROR, "A world is needed");
        }
        if (request.getWorld() == null) {
            WorldDao worldDao = daoFactory.getWorldDao();
            BeanWorldDefinition world = (BeanWorldDefinition)worldDao.getDefinition(request.getWorldName());
            return world;
        }
        return request.getWorld();
    }

    private Connection getConnection(DaoFactory daoFactory, DatabaseRequest request, ExpressionEvaluationData data) throws DashboardException {
        WorldHelper worldHelper = this.getWorldHelper(daoFactory, request, data);
        return ConnectionHelper.getInstance((WorldHelper)worldHelper).getConnection();
    }

    private WorldHelper getWorldHelper(DaoFactory daoFactory, DatabaseRequest request, ExpressionEvaluationData data) throws DashboardException {
        BeanWorldDefinition world = this.getWorld(daoFactory, request);
        JdbcDriverHelper driverHelper = JdbcDriverHelper.getInstance(daoFactory);
        BeanJDBCDriverDefinition driver = driverHelper.getDefinition(world.getDriverName());
        return WorldHelper.getInstance((BeanWorldDefinition)world, (DriverCharacteristics)driver, (ExpressionEvaluationData)data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map<String, String> getMap(DaoFactory daoFactory, DatabaseRequest request) throws DashboardException {
        try {
            int level = 2;
            if (request.getLevel() != null) {
                level = request.getLevel();
            }
            BeanWorldDefinition world = this.getWorld(daoFactory, request);
            ExpressionEvaluationData data = this.getData(daoFactory, request);
            WorldHelper worldHelper = WorldHelper.getInstance((DaoFactory)daoFactory, (BeanWorldDefinition)world, (ExpressionEvaluationData)data);
            IPoolDBInfo poolDbInfo = worldHelper.getPoolDbInfo();
            IDBInfo dbInfo = poolDbInfo.getDBInfo();
            try (Connection con = ConnectionHelper.getConnection((IPoolDBInfo)poolDbInfo);){
                DatabaseMetaData dmd = con.getMetaData();
                String catalog = request.getData()[2];
                if (world.getLimitToCatalogSchema()) {
                    catalog = dbInfo.getCatalog();
                }
                String schema = request.getData()[3];
                if (world.getLimitToCatalogSchema()) {
                    schema = dbInfo.getSchema();
                }
                switch (level) {
                    case 2: {
                        if (world.getLimitToCatalogSchema()) {
                            HashMap<String, String> map = new HashMap<String, String>();
                            if (!"".equals(catalog) && catalog != null) {
                                map.put(catalog, catalog);
                            }
                            HashMap<String, String> hashMap = map;
                            return hashMap;
                        }
                        try (ResultSet rs = dmd.getCatalogs();){
                            Map<String, String> map = this.getMap(rs);
                            return map;
                        }
                    }
                    case 3: {
                        if (world.getLimitToCatalogSchema()) {
                            HashMap<String, String> map = new HashMap<String, String>();
                            if (!"".equals(schema) && schema != null) {
                                map.put(schema, schema);
                            }
                            HashMap<String, String> hashMap = map;
                            return hashMap;
                        }
                        try (ResultSet rs = dmd.getSchemas();){
                            Map<String, String> map = this.getMap(rs);
                            return map;
                        }
                    }
                    case 1: {
                        try (ResultSet rs = dmd.getTableTypes();){
                            Map<String, String> map = this.getMap(rs);
                            return map;
                        }
                    }
                    case 4: {
                        String[] types = null;
                        String tmp = request.getData()[1];
                        if (tmp != null) {
                            types = new String[]{tmp};
                        }
                        Map<String, String> map = this.getTableMap(dmd, catalog, schema, types);
                        return map;
                    }
                    case 5: {
                        Map<String, String> map = this.getFieldMap(dmd, catalog, schema, request.getData()[4]);
                        return map;
                    }
                }
                Map<String, String> map = null;
                return map;
            }
        }
        catch (SQLException e) {
            throw new DashboardException((Throwable)e);
        }
    }

    private Map<String, String> getMapFromDataDict(DaoFactory daoFactory, DatabaseRequest request) throws DashboardException {
        ExpressionEvaluationData data = this.getData(daoFactory, request);
        String ownerEntityName = request.getOwnerEntityName();
        int level = 2;
        if (request.getLevel() != null) {
            level = request.getLevel();
        }
        switch (level) {
            case 2: {
                return new HashMap<String, String>();
            }
            case 3: {
                return new HashMap<String, String>();
            }
            case 1: {
                HashMap<String, String> map = new HashMap<String, String>();
                ResourceBundle bundle = ResourceBundle.getBundle("com.prelytis.dashboard.resources.Messages", data.getLocale());
                map.put("ALL", bundle.getString("queryAll"));
                map.put("DS", bundle.getString("queryDS"));
                map.put("SQL", bundle.getString("querySql"));
                return map;
            }
            case 4: {
                String type = request.getData()[1];
                return this.getTableMapFromDataDict(daoFactory, type, data);
            }
            case 5: {
                return this.getFieldMapFromDataDict(daoFactory, request.getData()[4], data);
            }
        }
        return null;
    }

    private Map<String, String> getFieldMapFromDataDict(DaoFactory daoFactory, String queryName, ExpressionEvaluationData data) throws DashboardException {
        QueryHelper queryHelper = QueryHelper.getInstance(daoFactory);
        IQueryDefinition query = queryHelper.getFinal(queryName);
        HashMap<String, String> map = new HashMap<String, String>();
        for (BeanQuerySQLField field : query.getBeanQuerySQLFieldList()) {
            map.put(field.getName(), (String)field.getDescriptionMap().get(data.getLocale()));
        }
        return map;
    }

    private Map<String, String> getTableMapFromDataDict(DaoFactory daoFactory, String type, ExpressionEvaluationData data) throws DashboardException {
        DbQueryFilter filter = new DbQueryFilter();
        filter.setForQuery(Boolean.TRUE);
        if ("DS".equals(type)) {
            filter.setQueryType(Integer.valueOf(2));
        } else if ("SQL".equals(type)) {
            filter.setQueryType(Integer.valueOf(1));
        }
        filter.setOwnerEntityOid(data.getEntityOid());
        filter.setSelectForDisplayType(4);
        QueryHelper queryHelper = QueryHelper.getInstance(daoFactory);
        List<Element> queryList = queryHelper.getCoreList(filter, data);
        HashMap<String, String> map = new HashMap<String, String>();
        for (Element elt : queryList) {
            BeanQuery bq = (BeanQuery)elt;
            map.put(bq.getName(), (String)bq.getDescriptionMap().get(data.getLocale()));
        }
        return map;
    }

    private Map<String, String> getMap(ResultSet rs) throws SQLException {
        HashMap<String, String> map = new HashMap<String, String>();
        if (rs != null) {
            while (rs.next()) {
                map.put(rs.getString(1), rs.getString(1));
            }
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, String> getTableMap(DatabaseMetaData dmd, String catalog, String schema, String[] types) throws SQLException {
        HashMap<String, String> map = new HashMap<String, String>();
        try (ResultSet rs = dmd.getTables(catalog, schema, null, types);){
            while (rs.next()) {
                map.put(rs.getString(3), rs.getString(5) == null || "".equals(rs.getString(5)) ? rs.getString(3) : rs.getString(5));
            }
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, String> getFieldMap(DatabaseMetaData dmd, String catalog, String schema, String table) throws SQLException {
        HashMap<String, String> map = new HashMap<String, String>();
        if (table != null) {
            try (ResultSet rs = dmd.getColumns(catalog, schema, table, null);){
                while (rs.next()) {
                    map.put(rs.getString(4), rs.getString(12) == null || "".equals(rs.getString(12)) ? rs.getString(4) : rs.getString(12));
                }
            }
        }
        return map;
    }
}

