/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.model;

import com.prelytis.dashboard.dao.DaoFactory;
import com.prelytis.dashboard.dao.EntityDao;
import com.prelytis.dashboard.dao.ExecutionContextDao;
import com.prelytis.dashboard.dao.LanguageDao;
import com.prelytis.dashboard.dao.SessionDao;
import com.prelytis.dashboard.helper.DocumentHelper;
import com.prelytis.dashboard.interfaces.SessionType;
import com.prelytis.dashboard.value.ExecutionContext;
import com.prelytis.dashboard.value.data.BeanEntity;
import com.prelytis.dashboard.value.data.BeanLanguage;
import com.prelytis.dashboard.value.data.BeanUser;
import com.prelytis.dashboard.value.data.BeanUserExecutionContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public final class ExecutionContextHelper {
    private static Logger log = LogManager.getLogger(ExecutionContextHelper.class);
    private final DaoFactory daoFactory;

    private ExecutionContextHelper(DaoFactory daoFactory) {
        this.daoFactory = daoFactory;
    }

    public static ExecutionContextHelper getInstance(DaoFactory daoFactory) {
        return new ExecutionContextHelper(daoFactory);
    }

    public ExecutionContext getExecutionContext(BeanUser user, String executionContext) {
        assert (user != null);
        if (executionContext == null) {
            return this.getExecutionContext(user);
        }
        SessionDao sessionDao = this.daoFactory.getSessionDao();
        if (log.isDebugEnabled()) {
            log.debug((Object)new StringBuilder("Looking for execution context ").append(executionContext).append(" for user ").append(user.getName()));
        }
        Locale locale = this.getLocale(this.daoFactory.getLanguageDao(), user);
        EntityDao entityDao = this.daoFactory.getEntityDao();
        for (BeanUserExecutionContext bec : user.getExecutionContextList()) {
            if (!executionContext.equals(bec.getName())) continue;
            return this.getExecutionContect(sessionDao, entityDao, user, bec, locale);
        }
        return null;
    }

    private ExecutionContext getExecutionContext(BeanUser user) {
        assert (user != null);
        SessionDao sessionDao = this.daoFactory.getSessionDao();
        if (log.isDebugEnabled()) {
            log.debug((Object)new StringBuilder("Looking for a valid execution context for user ").append(user.getName()));
        }
        Locale locale = this.getLocale(this.daoFactory.getLanguageDao(), user);
        EntityDao entityDao = this.daoFactory.getEntityDao();
        for (BeanUserExecutionContext bec : user.getExecutionContextList()) {
            ExecutionContext ec = this.getExecutionContect(sessionDao, entityDao, user, bec, locale);
            if (ec == null) continue;
            return ec;
        }
        return null;
    }

    private Locale getLocale(LanguageDao languageDao, BeanUser user) {
        BeanLanguage language = (BeanLanguage)languageDao.getCore(user.getLanguageOID());
        return new Locale(language.getLanguage());
    }

    public List<ExecutionContext> getExecutionContextList(BeanUser user) {
        SessionDao sessionDao = this.daoFactory.getSessionDao();
        EntityDao entityDao = this.daoFactory.getEntityDao();
        Locale locale = this.getLocale(this.daoFactory.getLanguageDao(), user);
        ArrayList<ExecutionContext> list = new ArrayList<ExecutionContext>();
        for (BeanUserExecutionContext bec : user.getExecutionContextList()) {
            ExecutionContext ec = this.getExecutionContect(sessionDao, entityDao, user, bec, locale);
            if (ec == null) continue;
            list.add(ec);
        }
        return list;
    }

    private ExecutionContext getExecutionContect(SessionDao sessionDao, EntityDao entityDao, BeanUser user, BeanUserExecutionContext bec, Locale locale) {
        BeanEntity entity = (BeanEntity)entityDao.getCore(bec.getEntityOid());
        if (!entity.isActive()) {
            return null;
        }
        ExecutionContext ec = new ExecutionContext();
        ec.setObjectID(bec.getObjectID());
        ec.setName(bec.getName());
        ec.setDescription((String)bec.getDescriptionMap().get(locale));
        ec.setDescriptionKey(bec.getDescriptionKey());
        ec.getDescriptionMap().putAll(bec.getDescriptionMap());
        ec.setProfile(bec.getProfile());
        ec.setEntityName(bec.getEntityName());
        ec.setWorkspaceName(bec.getWorkspaceName());
        if (bec.getDashBoardOid() == null) {
            ec.setDefaultName(null);
            ec.setDefaultSessionType(null);
        } else {
            try {
                ec.setDefaultName(bec.getDashboardName());
                ec.setDefaultSessionType(SessionType.DASHBOARD);
                DocumentHelper documentHelper = DocumentHelper.getInstance(this.daoFactory);
                Integer accessLevel = documentHelper.getDocumentAccessLevelForEC(bec.getObjectID(), SessionType.DASHBOARD, bec.getDashboardName(), false);
                if (accessLevel == null || accessLevel == 0) {
                    ec.setDefaultName(null);
                    ec.setDefaultSessionType(null);
                    log.warn((Object)("User " + user.getName() + " do not have access to home dashboard"));
                }
            }
            catch (Exception e) {
                log.error((Object)e);
            }
        }
        return ec;
    }

    public boolean isAllowed(String currentExecutionContextName, String destExecutionContextName) {
        ExecutionContextDao dao = this.daoFactory.getExecutionContextDao();
        return dao.isAllowed(currentExecutionContextName, destExecutionContextName);
    }
}

