/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.model;

import com.prelytis.dashboard.dao.BeanKey;
import com.prelytis.dashboard.dao.Dao;
import com.prelytis.dashboard.dao.DaoFactory;
import com.prelytis.dashboard.dao.SessionDao;
import com.prelytis.dashboard.dao.db.DbTableList;
import com.prelytis.dashboard.dao.filter.DbDefaultFilter;
import com.prelytis.dashboard.dao.filter.DbDefaultVersionFilter;
import com.prelytis.dashboard.dao.filter.DbSessionFilter;
import com.prelytis.dashboard.helper.PDFExportHelper;
import com.prelytis.dashboard.helper.SQLExportHelper;
import com.prelytis.dashboard.interfaces.DashboardException;
import com.prelytis.dashboard.interfaces.DashboardRuntimeException;
import com.prelytis.dashboard.interfaces.Element;
import com.prelytis.dashboard.interfaces.ErrorCode;
import com.prelytis.dashboard.interfaces.SessionParameterType;
import com.prelytis.dashboard.interfaces.SessionType;
import com.prelytis.dashboard.interfaces.Versionable;
import com.prelytis.dashboard.model.ResponseFactory;
import com.prelytis.dashboard.model.helper.ColorListHelper;
import com.prelytis.dashboard.model.helper.ControlGroupHelper;
import com.prelytis.dashboard.model.helper.ControlHelper;
import com.prelytis.dashboard.model.helper.DashBoardHelper;
import com.prelytis.dashboard.model.helper.EntityHelper;
import com.prelytis.dashboard.model.helper.ExecutionContextHelper;
import com.prelytis.dashboard.model.helper.ExtSessionHelper;
import com.prelytis.dashboard.model.helper.FieldGroupHelper;
import com.prelytis.dashboard.model.helper.FolderHelper;
import com.prelytis.dashboard.model.helper.FormHelper;
import com.prelytis.dashboard.model.helper.ImportHelper;
import com.prelytis.dashboard.model.helper.JdbcDriverHelper;
import com.prelytis.dashboard.model.helper.LanguageHelper;
import com.prelytis.dashboard.model.helper.LengthUnitHelper;
import com.prelytis.dashboard.model.helper.LinkHelper;
import com.prelytis.dashboard.model.helper.MaintenancePeriodHelper;
import com.prelytis.dashboard.model.helper.MessageProviderHelper;
import com.prelytis.dashboard.model.helper.MessageTypeHelper;
import com.prelytis.dashboard.model.helper.MetricHelper;
import com.prelytis.dashboard.model.helper.PageHelper;
import com.prelytis.dashboard.model.helper.PageLayoutHelper;
import com.prelytis.dashboard.model.helper.ParameterHelper;
import com.prelytis.dashboard.model.helper.PersFieldHelper;
import com.prelytis.dashboard.model.helper.PerspectiveHelper;
import com.prelytis.dashboard.model.helper.PrelytisInfoHelper;
import com.prelytis.dashboard.model.helper.QueryHelper;
import com.prelytis.dashboard.model.helper.References;
import com.prelytis.dashboard.model.helper.ReportHelper;
import com.prelytis.dashboard.model.helper.SessionGroupHelper;
import com.prelytis.dashboard.model.helper.SessionHelper;
import com.prelytis.dashboard.model.helper.SqlFunctionGroupHelper;
import com.prelytis.dashboard.model.helper.SqlFunctionHelper;
import com.prelytis.dashboard.model.helper.SqlFunctionImplHelper;
import com.prelytis.dashboard.model.helper.SqlStyleHelper;
import com.prelytis.dashboard.model.helper.StrategicObjectiveHelper;
import com.prelytis.dashboard.model.helper.StrokeTypeHelper;
import com.prelytis.dashboard.model.helper.StyleHelper;
import com.prelytis.dashboard.model.helper.TaskGroupHelper;
import com.prelytis.dashboard.model.helper.TaskHelper;
import com.prelytis.dashboard.model.helper.TextHelper;
import com.prelytis.dashboard.model.helper.ThemeHelper;
import com.prelytis.dashboard.model.helper.ThresholdTypeHelper;
import com.prelytis.dashboard.model.helper.TimeUnitHelper;
import com.prelytis.dashboard.model.helper.UserHelper;
import com.prelytis.dashboard.model.helper.WorkspaceHelper;
import com.prelytis.dashboard.model.helper.WorldHelper;
import com.prelytis.dashboard.persistence.Configuration;
import com.prelytis.dashboard.value.ExportParamRequest;
import com.prelytis.dashboard.value.ExportParamResponse;
import com.prelytis.dashboard.value.Request;
import com.prelytis.dashboard.value.Response;
import com.prelytis.dashboard.value.data.Bean;
import com.prelytis.dashboard.value.data.BeanPRPInfo;
import com.prelytis.dashboard.value.data.BeanQuery;
import com.prelytis.dashboard.value.data.BeanSession;
import com.prelytis.dashboard.value.data.BeanTask;
import com.prelytis.dashboard.value.data.BeanUserDefinition;
import com.prelytis.dashboard.value.data.ExportBean;
import com.prelytis.dashboard.value.data.filter.DefaultFilter;
import com.prelytis.dashboard.value.data.filter.DefaultVersionFilter;
import com.prelytis.dashboard.value.util.ExecutionMessageStd;
import com.prelytis.dashboard.value.util.ExpressionEvaluationData;
import com.prelytis.dashboard.xml.stax.XmlHelper;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.TransformerException;
import org.xml.sax.SAXException;

class ExportParamResponseFactory
extends ResponseFactory {
    private static final String ORDER = "export.xml";
    private static final String DATA = "data.xml";

    ExportParamResponseFactory() {
    }

    @Override
    public Response create(Request value, ExpressionEvaluationData data, DaoFactory daoFactory) throws DashboardException {
        ExportParamRequest request = (ExportParamRequest)value;
        ExportParamRequest.Action action = request.getAction();
        switch (action) {
            case EXPORT_PDF_DOC: {
                return this.getExportPdf(daoFactory, request, data);
            }
            case LIST_SESSION: {
                return this.getSessionList(daoFactory, request, data);
            }
            case XML_LIST_BEAN_WILDCARDS: {
                return this.getExportBeanListWildcards(daoFactory, request, data);
            }
            case XML_LIST_BEAN: {
                return this.getExportBeanList(daoFactory, request, data);
            }
            case COMMAND_FILE: {
                return this.getCommandFile(daoFactory, request, data);
            }
            case LOAD_FILE: {
                return this.getExportLoadFile(daoFactory, request, data);
            }
            case CREATE_ZIP: {
                return this.getZipFile(daoFactory, request, data);
            }
            case XML_DEPENDENCIES: {
                return this.getExportBeanDependencies(daoFactory, request, data);
            }
            case XML_SORT_LIST: {
                return this.getSortedList(daoFactory, request, data);
            }
        }
        throw new DashboardRuntimeException(ErrorCode.INSIGHT_UNKNOWN, "Unknown request");
    }

    private Response getSessionList(DaoFactory daoFactory, ExportParamRequest request, ExpressionEvaluationData data) throws DashboardException {
        ExportParamResponse response = new ExportParamResponse();
        response.setList(this.getSessionList(daoFactory, data));
        return response;
    }

    private List<Element> getSessionList(DaoFactory daoFactory, ExpressionEvaluationData data) throws DashboardException {
        try {
            SessionDao sessionDao = daoFactory.getSessionDao();
            DbSessionFilter sessionFilter = new DbSessionFilter();
            sessionFilter.setType(SessionType.SYSTEM);
            List list = sessionDao.listAllAccessible(data.getWorkspaceOid().intValue(), (DbDefaultFilter)sessionFilter);
            ArrayList<Element> finalList = new ArrayList<Element>();
            for (Element e : list) {
                SessionParameterType type = SessionParameterType.valueOf((int)e.getObjectID());
                if (type == null) continue;
                switch (type) {
                    case COLOR_LIST: 
                    case CONTROL_GROUP: 
                    case CONTROL: 
                    case DASHBOARD: 
                    case ENTITY: 
                    case EXTERN_SESSION: 
                    case EXECUTION_CONTEXT: 
                    case FIELD_GROUP: 
                    case FOLDER: 
                    case FORM: 
                    case IMPORT_TASK: 
                    case JDBC_DRIVER: 
                    case LANGUAGE: 
                    case LENGTH_UNIT: 
                    case LINK: 
                    case MAINTENANCE_PERIOD: 
                    case MESSAGE_PROVIDER: 
                    case MESSAGE_TYPE: 
                    case METRIC: 
                    case PAGE: 
                    case PAGE_LAYOUT: 
                    case PERS_FIELD: 
                    case PERSPECTIVE: 
                    case SETTINGS: 
                    case QUERY: 
                    case REPORT: 
                    case SESSION_GROUP: 
                    case SQL_FUNCTION: 
                    case SQL_FUNCTION_GROUP: 
                    case SQL_FUNCTION_IMPL: 
                    case STRATEGIC_OBJECTIVE: 
                    case STROKE_TYPE: 
                    case STYLE: 
                    case TASK: 
                    case TASK_GROUP: 
                    case TEXT: 
                    case THEME: 
                    case THRESHOLD_TYPE: 
                    case TIME_UNIT: 
                    case USER: 
                    case WORKSPACE: 
                    case WORLD: {
                        finalList.add(e);
                        break;
                    }
                }
            }
            return finalList;
        }
        catch (Exception e) {
            throw this.getDashboardException(e);
        }
    }

    private DashboardException getDashboardException(Exception e) {
        SAXException se;
        TransformerException te;
        Throwable t;
        if (e instanceof TransformerException && (t = (te = (TransformerException)e).getException()) != null && t != te && t instanceof Exception) {
            return this.getDashboardException((Exception)t);
        }
        if (e instanceof SAXException && (t = (se = (SAXException)e).getException()) != null && t != se) {
            return this.getDashboardException((Exception)t);
        }
        if (e instanceof DashboardException) {
            return (DashboardException)((Object)e);
        }
        return new DashboardException((Throwable)e);
    }

    private ExportParamResponse getExportBeanDependencies(DaoFactory daoFactory, ExportParamRequest request, ExpressionEvaluationData data) throws DashboardException {
        ExportParamResponse response = new ExportParamResponse();
        List<Element> list = this.getDependencyList(daoFactory, request, data);
        response.setList(this.getExportBeanList(list, data));
        return response;
    }

    private List<Element> getDependencyList(DaoFactory daoFactory, ExportParamRequest request, ExpressionEvaluationData data) throws DashboardException {
        ArrayList<Element> list = new ArrayList<Element>();
        HashSet<BeanKey<SessionParameterType>> set = new HashSet<BeanKey<SessionParameterType>>();
        List exportList = request.getExportList();
        for (ExportBean bean : exportList) {
            Dao dao = daoFactory.getDao(bean.getSessionParameterType());
            DbDefaultVersionFilter filter = new DbDefaultVersionFilter();
            filter.setName(bean.getName());
            if (dao == null) continue;
            List newList = dao.listAll((DbDefaultFilter)filter, 1);
            this.fillList(daoFactory, list, set, newList, request.isDependencies(), request.getLeveldep(), data);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ExportParamResponse getZipFile(DaoFactory daoFactory, ExportParamRequest request, ExpressionEvaluationData data) throws DashboardException {
        ExportParamResponse response = new ExportParamResponse();
        ArrayList<Element> beanList = new ArrayList<Element>();
        List exportList = request.getExportList();
        for (ExportBean bean : exportList) {
            BeanPRPInfo elt;
            if (!bean.isActionAdd()) continue;
            String name = bean.getName();
            switch (bean.getSessionParameterType()) {
                case COLOR_LIST: {
                    ColorListHelper colorListHelper = ColorListHelper.getInstance(daoFactory);
                    elt = colorListHelper.getDefinition(name);
                    break;
                }
                case CONTROL_GROUP: {
                    ControlGroupHelper controlGroupHelper = ControlGroupHelper.getInstance(daoFactory);
                    elt = controlGroupHelper.getDefinition(name);
                    break;
                }
                case CONTROL: {
                    ControlHelper controlHelper = ControlHelper.getInstance(daoFactory);
                    elt = controlHelper.getDefinition(name);
                    break;
                }
                case DASHBOARD: {
                    DashBoardHelper dashBoardHelper = DashBoardHelper.getInstance(daoFactory);
                    elt = dashBoardHelper.getDefinition(name);
                    break;
                }
                case ENTITY: {
                    EntityHelper entityHelper = EntityHelper.getInstance(daoFactory);
                    elt = entityHelper.getDefinition(name);
                    break;
                }
                case EXECUTION_CONTEXT: {
                    ExecutionContextHelper executionContextHelper = ExecutionContextHelper.getInstance(daoFactory);
                    elt = executionContextHelper.getDefinition(name);
                    break;
                }
                case EXTERN_SESSION: {
                    ExtSessionHelper extSessionHelper = ExtSessionHelper.getInstance(daoFactory);
                    elt = extSessionHelper.getDefinition(name);
                    break;
                }
                case FIELD_GROUP: {
                    FieldGroupHelper fieldGroupHelper = FieldGroupHelper.getInstance(daoFactory);
                    elt = fieldGroupHelper.getDefinition(name);
                    break;
                }
                case FOLDER: {
                    FolderHelper folderHelper = FolderHelper.getInstance(daoFactory);
                    elt = folderHelper.getDefinition(name);
                    break;
                }
                case FORM: {
                    FormHelper formHelper = FormHelper.getInstance(daoFactory);
                    elt = formHelper.getDefinition(name);
                    break;
                }
                case IMPORT_TASK: {
                    ImportHelper importHelper = ImportHelper.getInstance(daoFactory);
                    elt = importHelper.getDefinition(name);
                    break;
                }
                case JDBC_DRIVER: {
                    JdbcDriverHelper jdbcDriverHelper = JdbcDriverHelper.getInstance(daoFactory);
                    elt = jdbcDriverHelper.getDefinition(name);
                    break;
                }
                case LANGUAGE: {
                    LanguageHelper languageHelper = LanguageHelper.getInstance(daoFactory);
                    elt = languageHelper.getDefinition(name);
                    break;
                }
                case LENGTH_UNIT: {
                    LengthUnitHelper lengthUnitHelper = LengthUnitHelper.getInstance(daoFactory);
                    elt = lengthUnitHelper.getDefinition(name);
                    break;
                }
                case LINK: {
                    LinkHelper linkHelper = LinkHelper.getInstance(daoFactory);
                    elt = linkHelper.getDefinition(name);
                    break;
                }
                case MAINTENANCE_PERIOD: {
                    MaintenancePeriodHelper maintenancePeriodHelper = MaintenancePeriodHelper.getInstance(daoFactory);
                    elt = maintenancePeriodHelper.getDefinition(name);
                    break;
                }
                case MESSAGE_PROVIDER: {
                    MessageProviderHelper messageProviderHelper = MessageProviderHelper.getInstance(daoFactory);
                    elt = messageProviderHelper.getDefinition(name);
                    break;
                }
                case MESSAGE_TYPE: {
                    MessageTypeHelper messageTypeHelper = MessageTypeHelper.getInstance(daoFactory);
                    elt = messageTypeHelper.getDefinition(name);
                    break;
                }
                case METRIC: {
                    MetricHelper metricHelper = MetricHelper.getInstance(daoFactory);
                    elt = metricHelper.getDefinition(name);
                    break;
                }
                case PAGE: {
                    PageHelper pageHelper = PageHelper.getInstance(daoFactory);
                    elt = pageHelper.getDefinition(name);
                    break;
                }
                case PAGE_LAYOUT: {
                    PageLayoutHelper pageLayoutHelper = PageLayoutHelper.getInstance(daoFactory);
                    elt = pageLayoutHelper.getDefinition(name);
                    break;
                }
                case PERS_FIELD: {
                    PersFieldHelper persFieldHelper = PersFieldHelper.getInstance(daoFactory);
                    elt = persFieldHelper.getDefinition(name);
                    break;
                }
                case PERSPECTIVE: {
                    PerspectiveHelper perspectiveHelper = PerspectiveHelper.getInstance(daoFactory);
                    elt = perspectiveHelper.getDefinition(name);
                    break;
                }
                case SETTINGS: {
                    PrelytisInfoHelper prelytisInfoHelper = PrelytisInfoHelper.getInstance(daoFactory);
                    elt = prelytisInfoHelper.getPrelytisInfo();
                    break;
                }
                case QUERY: {
                    QueryHelper queryHelper = QueryHelper.getInstance(daoFactory);
                    elt = queryHelper.getDefinition(name);
                    break;
                }
                case REPORT: {
                    ReportHelper reportHelper = ReportHelper.getInstance(daoFactory);
                    DefaultFilter filter = new DefaultFilter();
                    filter.setName(name);
                    reportHelper.list(filter, 2, null, null, null);
                    elt = reportHelper.getDefinition(name);
                    break;
                }
                case SESSION: {
                    SessionHelper sessionHelper = SessionHelper.getInstance(daoFactory);
                    elt = sessionHelper.getDefinition(name);
                    break;
                }
                case SESSION_GROUP: {
                    SessionGroupHelper sessionGroupHelper = SessionGroupHelper.getInstance(daoFactory);
                    elt = sessionGroupHelper.getDefinition(name);
                    break;
                }
                case SQL_FUNCTION: {
                    SqlFunctionHelper sqlFunctionHelper = SqlFunctionHelper.getInstance(daoFactory);
                    elt = sqlFunctionHelper.getDefinition(name);
                    break;
                }
                case SQL_FUNCTION_GROUP: {
                    SqlFunctionGroupHelper sqlFunctionGroupHelper = SqlFunctionGroupHelper.getInstance(daoFactory);
                    elt = sqlFunctionGroupHelper.getDefinition(name);
                    break;
                }
                case SQL_FUNCTION_IMPL: {
                    SqlFunctionImplHelper sqlFunctionImplHelper = SqlFunctionImplHelper.getInstance(daoFactory);
                    elt = sqlFunctionImplHelper.getDefinition(name);
                    break;
                }
                case SQL_STYLE: {
                    SqlStyleHelper sqlStyleHelper = SqlStyleHelper.getInstance(daoFactory);
                    elt = sqlStyleHelper.getDefinition(name);
                    break;
                }
                case STRATEGIC_OBJECTIVE: {
                    StrategicObjectiveHelper strategicObjectiveHelper = StrategicObjectiveHelper.getInstance(daoFactory);
                    elt = strategicObjectiveHelper.getDefinition(name);
                    break;
                }
                case STROKE_TYPE: {
                    StrokeTypeHelper strokeTypeHelper = StrokeTypeHelper.getInstance(daoFactory);
                    elt = strokeTypeHelper.getDefinition(name);
                    break;
                }
                case STYLE: {
                    StyleHelper styleHelper = StyleHelper.getInstance(daoFactory);
                    elt = styleHelper.getDefinition(name);
                    break;
                }
                case TASK: {
                    TaskHelper taskHelper = TaskHelper.getInstance(daoFactory);
                    elt = taskHelper.getDefinition(name);
                    break;
                }
                case TASK_GROUP: {
                    TaskGroupHelper taskGroupHelper = TaskGroupHelper.getInstance(daoFactory);
                    elt = taskGroupHelper.getDefinition(name);
                    break;
                }
                case TEXT: {
                    TextHelper textHelper = TextHelper.getInstance(daoFactory);
                    elt = textHelper.getDefinition(name);
                    break;
                }
                case THEME: {
                    ThemeHelper themeHelper = ThemeHelper.getInstance(daoFactory);
                    elt = themeHelper.getDefinition(name);
                    break;
                }
                case THRESHOLD_TYPE: {
                    ThresholdTypeHelper thresholdTypeHelper = ThresholdTypeHelper.getInstance(daoFactory);
                    elt = thresholdTypeHelper.getDefinition(name);
                    break;
                }
                case TIME_UNIT: {
                    TimeUnitHelper timeUnitHelper = TimeUnitHelper.getInstance(daoFactory);
                    elt = timeUnitHelper.getDefinition(name);
                    break;
                }
                case USER: {
                    UserHelper userHelper = UserHelper.getInstance(daoFactory);
                    BeanUserDefinition user = userHelper.getDefinition(name);
                    userHelper.loadBookmarks(user);
                    elt = user;
                    break;
                }
                case WORKSPACE: {
                    WorkspaceHelper workspaceHelper = WorkspaceHelper.getInstance(daoFactory);
                    elt = workspaceHelper.getDefinition(name);
                    break;
                }
                case WORLD: {
                    WorldHelper worldHelper = WorldHelper.getInstance(daoFactory);
                    elt = worldHelper.getDefinition(name);
                    break;
                }
                default: {
                    throw new DashboardException();
                }
            }
            beanList.add((Element)elt);
            bean.setName(elt.getName());
            if (!(elt instanceof Versionable)) continue;
            Versionable v = (Versionable)elt;
            bean.setVersion(v.getVersion());
        }
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try (ZipOutputStream zos = new ZipOutputStream(baos);){
                ZipEntry exportEntry = new ZipEntry(ORDER);
                zos.putNextEntry(exportEntry);
                this.writeCommand(zos, request.getExportList());
                zos.closeEntry();
                ZipEntry dataEntry = new ZipEntry(DATA);
                zos.putNextEntry(dataEntry);
                this.writeData(zos, beanList);
                zos.closeEntry();
            }
            response.setData(baos.toByteArray());
        }
        catch (IOException ioe) {
            throw this.getDashboardException(ioe);
        }
        return response;
    }

    private void writeData(OutputStream os, List<Element> list) {
        try {
            XmlHelper helper = XmlHelper.getInstance();
            helper.write(os, list);
        }
        catch (XMLStreamException e) {
            throw new DashboardRuntimeException((Throwable)e);
        }
    }

    private void writeCommand(OutputStream os, List<ExportBean> list) {
        try {
            XmlHelper helper = XmlHelper.getInstance();
            helper.writeCommand(os, list);
        }
        catch (XMLStreamException e) {
            throw new DashboardRuntimeException((Throwable)e);
        }
    }

    private ExportParamResponse getExportLoadFile(DaoFactory daoFactory, ExportParamRequest request, ExpressionEvaluationData data) throws DashboardException {
        return null;
    }

    private ExportParamResponse getCommandFile(DaoFactory daoFactory, ExportParamRequest request, ExpressionEvaluationData data) throws DashboardException {
        OutputStream fos = null;
        try {
            Configuration configuration = Configuration.getInstance();
            File dir = new File(configuration.getBaseDir(), "var/import-export");
            if (!dir.isDirectory()) {
                dir.mkdir();
            }
            File file = new File(dir, new StringBuffer().append("cmd-").append(data.getUserOid()).append(".xml").toString());
            fos = new BufferedOutputStream(new FileOutputStream(file));
            this.writeCommand(fos, request.getExportList());
        }
        catch (Exception e) {
            throw this.getDashboardException(e);
        }
        finally {
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (Exception e) {
                log.warn((Object)e);
            }
        }
        ExportParamResponse response = new ExportParamResponse();
        return response;
    }

    private ExportParamResponse getExportBeanList(DaoFactory daoFactory, ExportParamRequest request, ExpressionEvaluationData data) throws DashboardException {
        ExportParamResponse response = new ExportParamResponse();
        List<Element> list = this.getEltList(daoFactory, request, data);
        response.setList(this.getExportBeanList(list, data));
        return response;
    }

    private ExportParamResponse getExportBeanListWildcards(DaoFactory daoFactory, ExportParamRequest request, ExpressionEvaluationData data) throws DashboardException {
        ExportParamResponse response = new ExportParamResponse();
        List exportList = request.getExportList();
        ArrayList<Element> finalList = new ArrayList<Element>();
        block46: for (ExportBean exportBean : exportList) {
            DefaultFilter filter = new DefaultFilter();
            filter.setName(exportBean.getName());
            switch (exportBean.getSessionParameterType()) {
                case COLOR_LIST: {
                    ColorListHelper colorListHelper = ColorListHelper.getInstance(daoFactory);
                    finalList.addAll(colorListHelper.list(filter, 2, null, null, null));
                    break;
                }
                case CONTROL_GROUP: {
                    ControlGroupHelper controlGroupHelper = ControlGroupHelper.getInstance(daoFactory);
                    finalList.addAll(controlGroupHelper.list(filter, 2, null, null, null));
                    break;
                }
                case CONTROL: {
                    ControlHelper controlHelper = ControlHelper.getInstance(daoFactory);
                    finalList.addAll(controlHelper.list(filter, 2, null, null, null));
                    break;
                }
                case DASHBOARD: {
                    DashBoardHelper dashBoardHelper = DashBoardHelper.getInstance(daoFactory);
                    finalList.addAll(dashBoardHelper.list(filter, 2, null, null, null));
                    break;
                }
                case ENTITY: {
                    EntityHelper entityHelper = EntityHelper.getInstance(daoFactory);
                    finalList.addAll(entityHelper.list(filter, 2, null, null, null));
                    break;
                }
                case EXECUTION_CONTEXT: {
                    ExecutionContextHelper executionContextHelper = ExecutionContextHelper.getInstance(daoFactory);
                    finalList.addAll(executionContextHelper.list(filter, 2, null, null, null));
                    break;
                }
                case EXTERN_SESSION: {
                    ExtSessionHelper extSessionHelper = ExtSessionHelper.getInstance(daoFactory);
                    finalList.addAll(extSessionHelper.list(filter, 2, null, null, null));
                    break;
                }
                case FIELD_GROUP: {
                    FieldGroupHelper fieldGroupHelper = FieldGroupHelper.getInstance(daoFactory);
                    finalList.addAll(fieldGroupHelper.list(filter, 2, null, null, null));
                    break;
                }
                case FOLDER: {
                    FolderHelper folderHelper = FolderHelper.getInstance(daoFactory);
                    finalList.addAll(folderHelper.list(filter, 2, null, null, null));
                    break;
                }
                case FORM: {
                    FormHelper formHelper = FormHelper.getInstance(daoFactory);
                    finalList.addAll(formHelper.list(filter, 2, null, null, null));
                    break;
                }
                case IMPORT_TASK: {
                    ImportHelper importHelper = ImportHelper.getInstance(daoFactory);
                    finalList.addAll(importHelper.list(filter, 2, null, null, null));
                    break;
                }
                case JDBC_DRIVER: {
                    JdbcDriverHelper jdbcDriverHelper = JdbcDriverHelper.getInstance(daoFactory);
                    finalList.addAll(jdbcDriverHelper.list(filter, 2, null, null, null));
                    break;
                }
                case LANGUAGE: {
                    LanguageHelper languageHelper = LanguageHelper.getInstance(daoFactory);
                    finalList.addAll(languageHelper.list(filter, 2, null, null, null));
                    break;
                }
                case LENGTH_UNIT: {
                    LengthUnitHelper lengthUnitHelper = LengthUnitHelper.getInstance(daoFactory);
                    finalList.addAll(lengthUnitHelper.list(filter, 2, null, null, null));
                    break;
                }
                case LINK: {
                    LinkHelper linkHelper = LinkHelper.getInstance(daoFactory);
                    finalList.addAll(linkHelper.list(filter, 2, null, null, null));
                    break;
                }
                case MAINTENANCE_PERIOD: {
                    MaintenancePeriodHelper maintenancePeriodHelper = MaintenancePeriodHelper.getInstance(daoFactory);
                    finalList.addAll(maintenancePeriodHelper.list(filter, 2, null, null, null));
                    break;
                }
                case MESSAGE_PROVIDER: {
                    MessageProviderHelper messageProviderHelper = MessageProviderHelper.getInstance(daoFactory);
                    finalList.addAll(messageProviderHelper.list(filter, 2, null, null, null));
                    break;
                }
                case MESSAGE_TYPE: {
                    MessageTypeHelper messageTypeHelper = MessageTypeHelper.getInstance(daoFactory);
                    finalList.addAll(messageTypeHelper.list(filter, 2, null, null, null));
                    break;
                }
                case METRIC: {
                    MetricHelper metricHelper = MetricHelper.getInstance(daoFactory);
                    finalList.addAll(metricHelper.list(filter, 2, null, null, null));
                    break;
                }
                case PAGE: {
                    PageHelper pageHelper = PageHelper.getInstance(daoFactory);
                    finalList.addAll(pageHelper.list(filter, 2, null, null, null));
                    break;
                }
                case PAGE_LAYOUT: {
                    PageLayoutHelper pageLayoutHelper = PageLayoutHelper.getInstance(daoFactory);
                    finalList.addAll(pageLayoutHelper.list(filter, 2, null, null, null));
                    break;
                }
                case PERS_FIELD: {
                    PersFieldHelper persFieldHelper = PersFieldHelper.getInstance(daoFactory);
                    finalList.addAll(persFieldHelper.list(filter, 2, null, null, null));
                    break;
                }
                case PERSPECTIVE: {
                    PerspectiveHelper perspectiveHelper = PerspectiveHelper.getInstance(daoFactory);
                    finalList.addAll(perspectiveHelper.list(filter, 2, null, null, null));
                    break;
                }
                case SETTINGS: {
                    PrelytisInfoHelper prelytisInfoHelper = PrelytisInfoHelper.getInstance(daoFactory);
                    List<Element> prelytisInfoList = prelytisInfoHelper.list(filter, 2, null, null, null);
                    if (!"*".equals(filter.getName())) continue block46;
                    finalList.addAll(prelytisInfoList);
                    break;
                }
                case QUERY: {
                    QueryHelper queryHelper = QueryHelper.getInstance(daoFactory);
                    finalList.addAll(queryHelper.list(filter, 2, null, null, null));
                    break;
                }
                case REPORT: {
                    ReportHelper reportHelper = ReportHelper.getInstance(daoFactory);
                    finalList.addAll(reportHelper.list(filter, 2, null, null, null));
                    break;
                }
                case SESSION: {
                    SessionHelper sessionHelper = SessionHelper.getInstance(daoFactory);
                    finalList.addAll(sessionHelper.list(filter, 2, null, null, null));
                    break;
                }
                case SESSION_GROUP: {
                    SessionGroupHelper sessionGroupHelper = SessionGroupHelper.getInstance(daoFactory);
                    finalList.addAll(sessionGroupHelper.list(filter, 2, null, null, null));
                    break;
                }
                case SQL_FUNCTION: {
                    SqlFunctionHelper sqlFunctionHelper = SqlFunctionHelper.getInstance(daoFactory);
                    finalList.addAll(sqlFunctionHelper.list(filter, 2, null, null, null));
                    break;
                }
                case SQL_FUNCTION_GROUP: {
                    SqlFunctionGroupHelper sqlFunctionGroupHelper = SqlFunctionGroupHelper.getInstance(daoFactory);
                    finalList.addAll(sqlFunctionGroupHelper.list(filter, 2, null, null, null));
                    break;
                }
                case SQL_FUNCTION_IMPL: {
                    SqlFunctionImplHelper sqlFunctionImplHelper = SqlFunctionImplHelper.getInstance(daoFactory);
                    finalList.addAll(sqlFunctionImplHelper.list(filter, 2, null, null, null));
                    break;
                }
                case SQL_STYLE: {
                    SqlStyleHelper sqlStyleHelper = SqlStyleHelper.getInstance(daoFactory);
                    finalList.addAll(sqlStyleHelper.list(filter, 2, null, null, null));
                    break;
                }
                case STRATEGIC_OBJECTIVE: {
                    StrategicObjectiveHelper strategicObjectiveHelper = StrategicObjectiveHelper.getInstance(daoFactory);
                    finalList.addAll(strategicObjectiveHelper.list(filter, 2, null, null, null));
                    break;
                }
                case STROKE_TYPE: {
                    StrokeTypeHelper strokeTypeHelper = StrokeTypeHelper.getInstance(daoFactory);
                    finalList.addAll(strokeTypeHelper.list(filter, 2, null, null, null));
                    break;
                }
                case STYLE: {
                    StyleHelper styleHelper = StyleHelper.getInstance(daoFactory);
                    finalList.addAll(styleHelper.list(filter, 2, null, null, null));
                    break;
                }
                case TASK: {
                    TaskHelper taskHelper = TaskHelper.getInstance(daoFactory);
                    finalList.addAll(taskHelper.list(filter, 2, null, null, null));
                    break;
                }
                case TASK_GROUP: {
                    TaskGroupHelper taskGroupHelper = TaskGroupHelper.getInstance(daoFactory);
                    finalList.addAll(taskGroupHelper.list(filter, 2, null, null, null));
                    break;
                }
                case TEXT: {
                    TextHelper textHelper = TextHelper.getInstance(daoFactory);
                    finalList.addAll(textHelper.list(filter, 2, null, null, null));
                    break;
                }
                case THEME: {
                    ThemeHelper themeHelper = ThemeHelper.getInstance(daoFactory);
                    finalList.addAll(themeHelper.list(filter, 2, null, null, null));
                    break;
                }
                case THRESHOLD_TYPE: {
                    ThresholdTypeHelper thresholdTypeHelper = ThresholdTypeHelper.getInstance(daoFactory);
                    finalList.addAll(thresholdTypeHelper.list(filter, 2, null, null, null));
                    break;
                }
                case TIME_UNIT: {
                    TimeUnitHelper timeUnitHelper = TimeUnitHelper.getInstance(daoFactory);
                    finalList.addAll(timeUnitHelper.list(filter, 2, null, null, null));
                    break;
                }
                case USER: {
                    UserHelper userHelper = UserHelper.getInstance(daoFactory);
                    finalList.addAll(userHelper.list(filter, 2, null, null, null));
                    break;
                }
                case WORKSPACE: {
                    WorkspaceHelper workspaceHelper = WorkspaceHelper.getInstance(daoFactory);
                    List<Element> workspaceList = workspaceHelper.list(filter, 2, null, null, null);
                    for (Element elementWorkspace : workspaceList) {
                        if (elementWorkspace.getName().startsWith("AUTO_9876")) continue;
                        finalList.add(elementWorkspace);
                    }
                    continue block46;
                }
                case WORLD: {
                    WorldHelper worldHelper = WorldHelper.getInstance(daoFactory);
                    finalList.addAll(worldHelper.list(filter, 2, null, null, null));
                    break;
                }
                default: {
                    throw new DashboardException();
                }
            }
        }
        response.setList(this.getExportBeanList(finalList, data));
        return response;
    }

    private List<ExportBean> getExportBeanList(List<Element> list, ExpressionEvaluationData data) {
        TreeMap<ExportBeanKey, ExportBean> map = new TreeMap<ExportBeanKey, ExportBean>(new ExportBeanKeyComparator());
        for (Element element : list) {
            ExportBean expBean = new ExportBean();
            this.setVersion(expBean, element);
            expBean.setObjectID(element.getObjectID());
            expBean.setName(element.getName());
            SessionParameterType sessionParameterType = null;
            if (element instanceof Bean) {
                Bean bean = (Bean)element;
                expBean.setDescriptionKey(bean.getDescriptionKey());
                expBean.getDescriptionMap().putAll(bean.getDescriptionMap());
                expBean.setDescription((String)bean.getDescriptionMap().get(data.getLocale()));
                sessionParameterType = bean.getSessionParameterType();
                expBean.setExportSortOrder(this.getExportSortOrder(bean));
            }
            expBean.setSessionParameterType(sessionParameterType);
            expBean.setActionAdd(true);
            expBean.setActionDelete(false);
            if (element.getObjectID() < 100) {
                expBean.setCheck(false);
            } else {
                expBean.setCheck(true);
            }
            map.put(new ExportBeanKey(expBean), expBean);
        }
        return new ArrayList<ExportBean>(map.values());
    }

    private void setVersion(ExportBean expBean, Element element) {
        if (element instanceof Versionable) {
            Versionable versionable = (Versionable)element;
            String version = versionable.getVersion();
            if (version != null) {
                expBean.setVersion(version);
            } else {
                expBean.setVersion("");
            }
        } else {
            expBean.setVersion("");
        }
    }

    private List<Element> getEltList(DaoFactory daoFactory, ExportParamRequest request, ExpressionEvaluationData data) throws DashboardException {
        ArrayList<Element> list = new ArrayList<Element>();
        HashSet<BeanKey<SessionParameterType>> set = new HashSet<BeanKey<SessionParameterType>>();
        for (SessionParameterType type : request.getSessionList()) {
            ParameterHelper parameterHelper = ParameterHelper.getInstance(daoFactory, type);
            if (parameterHelper == null) continue;
            DefaultVersionFilter filter = new DefaultVersionFilter();
            filter.setVersion(request.getVersion());
            filter.setVersionOperator(request.getVersionOp());
            filter.setDateModification(request.getDateModification());
            filter.setDateOperator(request.getDateOp());
            filter.setOwnerEntityName(data.getEntityName());
            filter.setSelectForDisplayType(5);
            List<Element> newList = parameterHelper.list((DefaultFilter)filter, 1, null, null, data);
            this.fillList(daoFactory, list, set, newList, request.isDependencies(), request.getLeveldep(), data);
        }
        return list;
    }

    private void fillList(DaoFactory daoFactory, List<Element> finalList, Set<BeanKey<SessionParameterType>> finalSet, List<Element> list, boolean dependencies, int level, ExpressionEvaluationData data) throws DashboardException {
        if (list == null || list.isEmpty()) {
            return;
        }
        if (dependencies && level > 0) {
            for (Element elt : list) {
                BeanKey key;
                Bean bean = (Bean)elt;
                if (elt instanceof BeanSession || finalSet.contains(key = new BeanKey((Enum)bean.getSessionParameterType(), bean.getObjectID()))) continue;
                finalSet.add((BeanKey<SessionParameterType>)key);
                finalList.add((Element)bean);
                ParameterHelper parameterHelper = ParameterHelper.getInstance(daoFactory, bean.getSessionParameterType());
                if (!(parameterHelper instanceof References)) continue;
                References dependency = (References)((Object)parameterHelper);
                List<Element> newList = dependency.getReferences(bean.getObjectID(), data);
                this.fillList(daoFactory, finalList, finalSet, newList, dependencies, level - 1, data);
            }
        } else {
            for (Element elt : list) {
                Bean bean = (Bean)elt;
                BeanKey key = new BeanKey((Enum)bean.getSessionParameterType(), bean.getObjectID());
                if (finalSet.contains(key)) continue;
                finalSet.add((BeanKey<SessionParameterType>)key);
                finalList.add((Element)bean);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ExportParamResponse getExportPdf(DaoFactory daoFactory, ExportParamRequest request, ExpressionEvaluationData data) {
        ExportParamResponse response = new ExportParamResponse();
        ArrayList<ExecutionMessageStd> msgList = null;
        try {
            PDFExportHelper helper = new PDFExportHelper();
            Configuration configuration = Configuration.getInstance();
            File xslFile = new File(configuration.getBaseDir(), "var/xsl/prp2fo.xsl");
            helper.setXslUrl(xslFile);
            try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
                helper.go(os);
                response.setData(os.toByteArray());
            }
        }
        catch (Exception e) {
            if (msgList == null) {
                msgList = new ArrayList<ExecutionMessageStd>();
            }
            msgList.add(new ExecutionMessageStd(e.getMessage()));
        }
        response.setMessageList(msgList);
        return response;
    }

    private ExportParamResponse getSortedList(DaoFactory daoFactory, ExportParamRequest request, ExpressionEvaluationData data) {
        List list = request.getExportList();
        ExportParamResponse response = new ExportParamResponse();
        TreeMap<ExportBeanKey, ExportBean> map = new TreeMap<ExportBeanKey, ExportBean>(new ExportBeanKeyComparator());
        for (ExportBean b : list) {
            map.put(new ExportBeanKey(b), b);
        }
        response.setList(new ArrayList(map.values()));
        return response;
    }

    private int getExportSortOrder(Bean bean) {
        switch (bean.getSessionParameterType()) {
            case SETTINGS: {
                return 1;
            }
            case THRESHOLD_TYPE: {
                return 2;
            }
            case LANGUAGE: {
                return 3;
            }
            case LENGTH_UNIT: {
                return 4;
            }
            case TIME_UNIT: {
                return 5;
            }
            case PERS_FIELD: {
                return 6;
            }
            case ENTITY: {
                return 7;
            }
            case FIELD_GROUP: {
                return 8;
            }
            case COLOR_LIST: {
                return 9;
            }
            case THEME: {
                return 10;
            }
            case STYLE: {
                return 11;
            }
            case STROKE_TYPE: {
                return 12;
            }
            case PAGE: {
                return 13;
            }
            case PAGE_LAYOUT: {
                return 14;
            }
            case SQL_FUNCTION_GROUP: {
                return 15;
            }
            case SQL_FUNCTION: {
                return 16;
            }
            case SQL_FUNCTION_IMPL: {
                return 17;
            }
            case JDBC_DRIVER: {
                return 18;
            }
            case WORLD: {
                return 19;
            }
            case QUERY: {
                BeanQuery query = (BeanQuery)bean;
                if (query.getQueryType() != 3) {
                    return 20;
                }
                return 21;
            }
            case REPORT: {
                return 22;
            }
            case CONTROL_GROUP: {
                return 23;
            }
            case PERSPECTIVE: {
                return 24;
            }
            case STRATEGIC_OBJECTIVE: {
                return 25;
            }
            case TASK_GROUP: {
                return 26;
            }
            case CONTROL: 
            case METRIC: {
                return 27;
            }
            case EXTERN_SESSION: {
                return 28;
            }
            case TEXT: {
                return 29;
            }
            case FORM: {
                return 30;
            }
            case DASHBOARD: {
                return 31;
            }
            case MESSAGE_TYPE: {
                return 32;
            }
            case MESSAGE_PROVIDER: {
                return 33;
            }
            case LINK: {
                return 34;
            }
            case SESSION_GROUP: {
                return 35;
            }
            case FOLDER: {
                return 36;
            }
            case IMPORT_TASK: {
                return 37;
            }
            case MAINTENANCE_PERIOD: {
                return 39;
            }
            case WORKSPACE: {
                return 40;
            }
            case EXECUTION_CONTEXT: {
                return 41;
            }
            case USER: {
                return 42;
            }
            case TASK: {
                BeanTask task = (BeanTask)bean;
                switch (task.getTaskType()) {
                    case TASK_TYPE_CONTROL: 
                    case TASK_TYPE_METRIC: {
                        throw new DashboardRuntimeException(ErrorCode.SHOULD_NEVER_OCCUR);
                    }
                }
                return 43;
            }
        }
        return 100;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addFile(ZipOutputStream zos, String fileName) throws IOException {
        try (InputStream is = SQLExportHelper.class.getResourceAsStream("/com/prelytis/dashboard/resources/sql/" + fileName);){
            zos.putNextEntry(new ZipEntry(fileName));
            int size = 1024;
            byte[] data = new byte[size];
            while (size == 1024) {
                size = is.read(data);
                zos.write(data, 0, size);
            }
        }
    }

    private String getKey(String key, String entry) {
        if (entry == null) {
            return key;
        }
        return new StringBuffer().append(key).append("[").append(entry).append("]").toString();
    }

    private String[] getTableList() {
        return DbTableList.TABLE_LIST;
    }

    private static String[] getAsList(String value) {
        if (value == null || "".equals(value)) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(value, ",");
        int nb = st.countTokens();
        String[] resu = new String[nb];
        for (int i = 0; i < nb; ++i) {
            resu[i] = st.nextToken();
        }
        return resu;
    }

    private static class ExportBeanKeyComparator
    implements Comparator<ExportBeanKey> {
        private ExportBeanKeyComparator() {
        }

        @Override
        public int compare(ExportBeanKey b1, ExportBeanKey b2) {
            if (b1.getExportSortOrder() != b2.getExportSortOrder()) {
                return b1.getExportSortOrder() - b2.getExportSortOrder();
            }
            if (b1.getSessionParameterType() != null) {
                if (b2.getSessionParameterType() == null) {
                    return -1;
                }
                if (b1.getSessionParameterType() != b2.getSessionParameterType()) {
                    return b1.getSessionParameterType().getId() - b2.getSessionParameterType().getId();
                }
                return b1.getObjectID() - b2.getObjectID();
            }
            return 1;
        }
    }

    private static class ExportBeanKey {
        private final SessionParameterType sessionParameterType;
        private final int objectId;
        private final int exportSortOrder;

        private ExportBeanKey(ExportBean b) {
            this.sessionParameterType = b.getSessionParameterType();
            this.objectId = b.getObjectID();
            this.exportSortOrder = b.getExportSortOrder();
        }

        public int getObjectID() {
            return this.objectId;
        }

        public int getExportSortOrder() {
            return this.exportSortOrder;
        }

        public boolean equals(Object obj) {
            if (obj instanceof ExportBeanKey) {
                ExportBeanKey key = (ExportBeanKey)obj;
                return this.sessionParameterType == key.sessionParameterType && this.objectId == key.objectId && this.exportSortOrder == key.exportSortOrder;
            }
            return false;
        }

        public int hashCode() {
            return this.sessionParameterType.getId() * 100 + this.objectId;
        }

        public SessionParameterType getSessionParameterType() {
            return this.sessionParameterType;
        }
    }
}

