/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.model;

import com.prelytis.dashboard.dao.DaoFactory;
import com.prelytis.dashboard.dao.FolderDao;
import com.prelytis.dashboard.dao.FolderValueDao;
import com.prelytis.dashboard.dao.WorkspaceDao;
import com.prelytis.dashboard.helper.ExceptionHelper;
import com.prelytis.dashboard.helper.FileHelper;
import com.prelytis.dashboard.interfaces.DashboardException;
import com.prelytis.dashboard.interfaces.I18nElement;
import com.prelytis.dashboard.interfaces.SessionType;
import com.prelytis.dashboard.model.ResponseFactory;
import com.prelytis.dashboard.value.FolderValueRequest;
import com.prelytis.dashboard.value.FolderValueResponse;
import com.prelytis.dashboard.value.Request;
import com.prelytis.dashboard.value.Response;
import com.prelytis.dashboard.value.data.BeanFile;
import com.prelytis.dashboard.value.data.FolderValue;
import com.prelytis.dashboard.value.data.SecurityAdapter;
import com.prelytis.dashboard.value.util.ExpressionEvaluationData;
import java.io.File;
import java.io.IOException;

class FolderValueResponseFactory
extends ResponseFactory {
    public static final String DIRECTORY_ERROR = "error.directory";

    FolderValueResponseFactory() {
    }

    @Override
    public Response create(Request request, ExpressionEvaluationData data, DaoFactory daoFactory) throws DashboardException {
        FolderValueRequest value = (FolderValueRequest)request;
        try {
            FolderDao folderDao;
            BeanFile beanFile;
            FileHelper fileHelper;
            File f;
            FolderValueRequest.Action action = value.getAction();
            if (action == null) {
                action = FolderValueRequest.Action.FILL_CONTENT;
            }
            if (!(f = (fileHelper = FileHelper.getInstance(beanFile = (BeanFile)(folderDao = daoFactory.getFolderDao()).getDefinition(value.getFolderName()))).getFile(data)).isDirectory()) {
                throw ExceptionHelper.getInstance(data.getLocale()).createDashboardException("notADirectory", new String[]{f.getName()}, null);
            }
            WorkspaceDao workspaceDao = daoFactory.getWorkspaceDao();
            WorkspaceDao.SessionAccessLevel folderAccessLevel = workspaceDao.getAccessLevelForEC(data.getExecutionContextOid().intValue(), SessionType.FILE, beanFile.getName());
            FolderValueDao folderValueDao = daoFactory.getFolderValueDao();
            FolderValue folderValue = new FolderValue();
            folderValue.setObjectID(beanFile.getObjectID());
            folderValue.setName(beanFile.getName());
            folderValue.setDescriptionKey(beanFile.getDescriptionKey());
            folderValue.getDescriptionMap().putAll(beanFile.getDescriptionMap());
            folderValue.setDescription((String)beanFile.getDescriptionMap().get(data.getLocale()));
            if (folderValue.getDescription() == null || folderValue.getDescription().isEmpty()) {
                folderValue.setDescription(beanFile.getName());
            }
            try {
                folderValue.setPhysicalRootFolder(f.getCanonicalPath());
            }
            catch (IOException e) {
                throw new DashboardException((Throwable)e);
            }
            FolderValueResponse response = new FolderValueResponse();
            switch (action) {
                case FILL_CONTENT: {
                    if (value.getFolderName() == null) {
                        throw new IllegalArgumentException("Missing folderName or path on FolderValueRequest");
                    }
                    response.setFolderContent(folderValueDao.read(folderValue, value.getPath(), folderAccessLevel.getAccessLevel()));
                    break;
                }
                case RENAME: {
                    if (value.getPath() == null || value.getNewName() == null) {
                        throw new IllegalArgumentException("Missing path or newName on FolderValueRequest");
                    }
                    folderValueDao.rename(folderValue, value.getPath(), value.getNewName());
                    break;
                }
                case DELETE: {
                    if (value.getPath() == null) {
                        throw new IllegalArgumentException("Missing path on FolderValueRequest");
                    }
                    folderValueDao.delete(folderValue, value.getPath());
                    break;
                }
                case UPLOAD: {
                    if (value.getFile() == null || value.getPath() == null) {
                        throw new IllegalArgumentException("Missing file or path on FolderValueRequest");
                    }
                    folderValueDao.writeBytes(folderValue, value.getPath(), value.getFile(), false);
                    break;
                }
                case FORCE_UPLOAD: {
                    if (value.getFile() == null || value.getPath() == null) {
                        throw new IllegalArgumentException("Missing file or path on FolderValueRequest");
                    }
                    folderValueDao.writeBytes(folderValue, value.getPath(), value.getFile(), true);
                    break;
                }
                case DOWNLOAD: {
                    String[] path = value.getPath();
                    byte[] bytes = folderValueDao.readBytes(folderValue, path);
                    response.setBytes(bytes);
                    if (path.length <= 0) break;
                    response.setFileName(path[path.length - 1]);
                    break;
                }
                default: {
                    throw new DashboardException();
                }
            }
            SecurityAdapter sa = new SecurityAdapter((I18nElement)folderValue);
            switch (folderAccessLevel.getAccessLevel()) {
                case 2: {
                    sa.setRead(true);
                    sa.setUpdate(true);
                    sa.setDelete(true);
                    break;
                }
                case 1: {
                    sa.setRead(true);
                    sa.setUpdate(false);
                    sa.setDelete(false);
                    break;
                }
                default: {
                    throw new SecurityException();
                }
            }
            response.setAdapter(sa);
            return response;
        }
        catch (Exception e) {
            throw this.getException(e);
        }
    }
}

