/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.model;

import com.prelytis.dashboard.dao.DaoFactory;
import com.prelytis.dashboard.interfaces.DashboardException;
import com.prelytis.dashboard.model.ResponseFactory;
import com.prelytis.dashboard.value.HierachicalFilterParameterRequest;
import com.prelytis.dashboard.value.HierachicalFilterParameterResponse;
import com.prelytis.dashboard.value.Request;
import com.prelytis.dashboard.value.Response;
import com.prelytis.dashboard.value.data.AbstractBeanReport;
import com.prelytis.dashboard.value.data.AbstractBeanReportAvlField;
import com.prelytis.dashboard.value.data.BeanQueryDataStructureTable;
import com.prelytis.dashboard.value.data.BeanQueryDataStructureTableField;
import com.prelytis.dashboard.value.data.BeanQuerySQLFieldDataStructure;
import com.prelytis.dashboard.value.data.BeanReportAvlCalcField;
import com.prelytis.dashboard.value.data.BeanReportAvlField;
import com.prelytis.dashboard.value.data.BeanReportAvlGroup;
import com.prelytis.dashboard.value.query.CalcFunctionOperand;
import com.prelytis.dashboard.value.query.CalculatedOperand;
import com.prelytis.dashboard.value.query.FieldOperand;
import com.prelytis.dashboard.value.query.ICalculatedOperand;
import com.prelytis.dashboard.value.query.IOperandGroup;
import com.prelytis.dashboard.value.query.IOperandGroupElement;
import com.prelytis.dashboard.value.query.Operand;
import com.prelytis.dashboard.value.util.ExpressionEvaluationData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class HierarchicalFilterParameterResponseFactory
extends ResponseFactory {
    HierarchicalFilterParameterResponseFactory() {
    }

    @Override
    public Response create(Request request, ExpressionEvaluationData data, DaoFactory daoFactory) throws DashboardException {
        HierachicalFilterParameterRequest parameterRequest = (HierachicalFilterParameterRequest)request;
        HierachicalFilterParameterResponse parameterResponse = new HierachicalFilterParameterResponse();
        List fieldNames = parameterRequest.getFieldNames();
        AbstractBeanReport report = parameterRequest.getReport();
        if (fieldNames == null || fieldNames.isEmpty()) {
            ArrayList<AbstractBeanReportAvlField> fieldList = new ArrayList<AbstractBeanReportAvlField>();
            for (BeanReportAvlGroup group : report.getAvlGroupList()) {
                for (AbstractBeanReportAvlField field : group.getFields()) {
                    fieldList.add(field);
                }
            }
            parameterResponse.setFieldNameList(fieldList);
            return parameterResponse;
        }
        ArrayList<AbstractBeanReportAvlField> avlFieldList = new ArrayList<AbstractBeanReportAvlField>();
        HashMap<String, AbstractBeanReportAvlField> avlFieldMap = new HashMap<String, AbstractBeanReportAvlField>();
        HashMap<String, List<AbstractBeanReportAvlField>> fieldListByTableName = new HashMap<String, List<AbstractBeanReportAvlField>>();
        BeanQueryDataStructureTable table = null;
        for (BeanReportAvlGroup group : report.getAvlGroupList()) {
            for (AbstractBeanReportAvlField fld : group.getFields()) {
                avlFieldMap.put(fld.getName(), fld);
            }
        }
        for (BeanReportAvlGroup group : report.getAvlGroupList()) {
            for (AbstractBeanReportAvlField fld : group.getFields()) {
                BeanQueryDataStructureTable t = this.getTable(report.getName(), avlFieldMap, fld);
                if (t == null) continue;
                ArrayList<AbstractBeanReportAvlField> list = (ArrayList<AbstractBeanReportAvlField>)fieldListByTableName.get(t.getName());
                if (list == null) {
                    list = new ArrayList<AbstractBeanReportAvlField>();
                    fieldListByTableName.put(t.getName(), list);
                }
                list.add(fld);
                if (!fld.getName().equals(fieldNames.get(0))) continue;
                table = t;
            }
        }
        if (table != null) {
            this.createFieldNameList(table, avlFieldList, fieldListByTableName, parameterRequest.getFieldNames());
        }
        parameterResponse.setFieldNameList(avlFieldList);
        return parameterResponse;
    }

    private BeanQueryDataStructureTable getTable(String reportName, Map<String, AbstractBeanReportAvlField> avlFieldMap, AbstractBeanReportAvlField avlField) {
        if (avlField instanceof BeanReportAvlField) {
            BeanReportAvlField f = (BeanReportAvlField)avlField;
            return this.getTable(f);
        }
        if (avlField instanceof BeanReportAvlCalcField) {
            BeanReportAvlCalcField f = (BeanReportAvlCalcField)avlField;
            return this.getTable(reportName, avlFieldMap, f.getOperand());
        }
        log.warn((Object)("Report '" + reportName + "' contains unsupported field '" + avlField.getName() + "'"));
        return null;
    }

    private BeanQueryDataStructureTable getTable(String reportName, Map<String, AbstractBeanReportAvlField> avlFieldMap, ICalculatedOperand operand) {
        BeanQueryDataStructureTable table = null;
        if (operand instanceof CalculatedOperand) {
            CalculatedOperand aco = (CalculatedOperand)operand;
            Operand o = aco.getOperand();
            if (o instanceof FieldOperand) {
                FieldOperand fo = (FieldOperand)o;
                AbstractBeanReportAvlField f = avlFieldMap.get(fo.getField());
                table = this.getTable(reportName, avlFieldMap, f);
            } else if (o instanceof CalcFunctionOperand) {
                CalcFunctionOperand cfo = (CalcFunctionOperand)o;
                for (IOperandGroup g : cfo.getOperandGroups()) {
                    for (IOperandGroupElement e : g.getElementList()) {
                        for (ICalculatedOperand co : e.getOperands()) {
                            table = this.getTable(table, this.getTable(reportName, avlFieldMap, co));
                        }
                    }
                }
            }
        }
        return table;
    }

    private BeanQueryDataStructureTable getTable(BeanReportAvlField avlField) {
        if (avlField.getField() instanceof BeanQuerySQLFieldDataStructure) {
            BeanQuerySQLFieldDataStructure fieldDS = (BeanQuerySQLFieldDataStructure)avlField.getField();
            BeanQueryDataStructureTableField tableField = fieldDS.getBeanQueryDataStructureTableField();
            return tableField.getBeanQueryDataStructureTable();
        }
        return null;
    }

    private BeanQueryDataStructureTable getTable(BeanQueryDataStructureTable table1, BeanQueryDataStructureTable table2) {
        if (table1 == null) {
            return table2;
        }
        if (table2 == null) {
            return table1;
        }
        if (table1.getId() == table2.getId()) {
            return table1;
        }
        if (table1.getId() > table2.getId()) {
            return table1;
        }
        return table2;
    }

    private void createFieldNameList(BeanQueryDataStructureTable table, List<AbstractBeanReportAvlField> fieldNameList, Map<String, List<AbstractBeanReportAvlField>> fieldListByTableName, List<String> fieldNames) {
        List<AbstractBeanReportAvlField> list = fieldListByTableName.get(table.getName());
        if (list != null) {
            for (AbstractBeanReportAvlField fld : list) {
                if (fieldNames != null && fieldNames.contains(fld.getName())) continue;
                fieldNameList.add(fld);
            }
        }
        if (table.getTableChildList() != null) {
            for (BeanQueryDataStructureTable child : table.getTableChildList()) {
                this.createFieldNameList(child, fieldNameList, fieldListByTableName, null);
            }
        }
    }
}

