/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.model;

import com.prelytis.dashboard.dao.DaoFactory;
import com.prelytis.dashboard.helper.ValueListHelper;
import com.prelytis.dashboard.interfaces.DashboardException;
import com.prelytis.dashboard.interfaces.IQueryDefinition;
import com.prelytis.dashboard.model.ResponseFactory;
import com.prelytis.dashboard.model.helper.QueryHelper;
import com.prelytis.dashboard.model.helper.ReportHelper;
import com.prelytis.dashboard.value.HierarchicalFilterRequest;
import com.prelytis.dashboard.value.HierarchicalFilterResponse;
import com.prelytis.dashboard.value.Request;
import com.prelytis.dashboard.value.Response;
import com.prelytis.dashboard.value.data.AbstractBeanReport;
import com.prelytis.dashboard.value.data.ValueListElt;
import com.prelytis.dashboard.value.query.ComparisonExpression;
import com.prelytis.dashboard.value.query.Expression;
import com.prelytis.dashboard.value.query.FieldOperand;
import com.prelytis.dashboard.value.query.InteractiveOperand;
import com.prelytis.dashboard.value.query.LogicalExpression;
import com.prelytis.dashboard.value.query.Operand;
import com.prelytis.dashboard.value.query.PromptOperand;
import com.prelytis.dashboard.value.structure.ReportDocument;
import com.prelytis.dashboard.value.util.ExpressionEvaluationData;
import java.util.ArrayList;
import java.util.List;

class HierarchicalFilterResponseFactory
extends ResponseFactory {
    HierarchicalFilterResponseFactory() {
    }

    @Override
    public Response create(Request request, ExpressionEvaluationData data, DaoFactory daoFactory) throws DashboardException {
        boolean completeList;
        String fieldName;
        String reportName;
        HierarchicalFilterRequest filterRequest = (HierarchicalFilterRequest)request;
        HierarchicalFilterResponse filterResponse = new HierarchicalFilterResponse();
        if (filterRequest.getDocument() instanceof ReportDocument) {
            reportName = filterRequest.getDocument().getName();
        } else if (filterRequest.getReportName() != null) {
            reportName = filterRequest.getReportName();
        } else {
            throw new DashboardException((Throwable)new NullPointerException("Missing reportOID"));
        }
        ReportHelper reportHelper = ReportHelper.getInstance(daoFactory);
        AbstractBeanReport report = reportHelper.getDefinition(reportName);
        QueryHelper queryHelper = QueryHelper.getInstance(daoFactory);
        IQueryDefinition query = queryHelper.getFinal(report.getQueryName());
        ValueListHelper valueListHelper = ValueListHelper.getInstance(daoFactory, data, query, report);
        if (filterRequest.getReportFilterName() != null) {
            ComparisonExpression ce = this.findExpression(report.getTopExpression(), filterRequest.getReportFilterName());
            FieldOperand fo = (FieldOperand)ce.getLeftOperand();
            fieldName = fo.getField();
            PromptOperand po = (PromptOperand)ce.getRightOperand();
            completeList = po.isCompleteList();
        } else {
            fieldName = filterRequest.getCurrentFieldName();
            completeList = filterRequest.getCompleteList() == null ? true : filterRequest.getCompleteList();
        }
        List<ValueListElt> valueList = valueListHelper.getHierarchicalValueList(fieldName, filterRequest.getPrecedFieldName(), filterRequest.getPrecedDataType(), filterRequest.getPrecedSelectValueList() == null ? null : filterRequest.getPrecedSelectValueList().toArray(), filterRequest.getFormat(), filterRequest.getSortOrder(), !completeList);
        ArrayList<String> values = new ArrayList<String>();
        for (ValueListElt elt : valueList) {
            values.add(String.valueOf(elt.getValue()));
        }
        filterResponse.setAvailableValueList(values);
        return filterResponse;
    }

    private ComparisonExpression findExpression(Expression expression, String promptName) {
        block3: {
            block2: {
                if (!(expression instanceof ComparisonExpression)) break block2;
                ComparisonExpression comparison = (ComparisonExpression)expression;
                for (Operand operand : comparison.getOperands()) {
                    InteractiveOperand interactiveOperand;
                    if (!(operand instanceof InteractiveOperand) || !(interactiveOperand = (InteractiveOperand)operand).getName().equals(promptName)) continue;
                    return comparison;
                }
                break block3;
            }
            if (!(expression instanceof LogicalExpression)) break block3;
            LogicalExpression logical = (LogicalExpression)expression;
            for (Expression e : logical.getExpressionList()) {
                ComparisonExpression ce = this.findExpression(e, promptName);
                if (ce == null) continue;
                return ce;
            }
        }
        return null;
    }
}

