/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.model;

import com.prelytis.dashboard.dao.DaoFactory;
import com.prelytis.dashboard.helper.ConnectionInformationHelper;
import com.prelytis.dashboard.interfaces.DashboardException;
import com.prelytis.dashboard.model.ResponseFactory;
import com.prelytis.dashboard.security.DashboardManager;
import com.prelytis.dashboard.value.LogoutRequest;
import com.prelytis.dashboard.value.LogoutResponse;
import com.prelytis.dashboard.value.Request;
import com.prelytis.dashboard.value.Response;
import com.prelytis.dashboard.value.util.ExpressionEvaluationData;
import com.prelytis.dashboard.value.util.HostnameUtil;
import javax.naming.ServiceUnavailableException;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

class LogoutResponseFactory
extends ResponseFactory {
    private static final Logger LOG = LogManager.getLogger(LogoutResponseFactory.class);

    LogoutResponseFactory() {
    }

    @Override
    public Response create(Request request, ExpressionEvaluationData data, DaoFactory daoFactory) throws DashboardException {
        LogoutRequest value = (LogoutRequest)request;
        try {
            String guid = value.getUserGuidToDeconnect() == null ? value.getUserSessionGuid() : value.getUserGuidToDeconnect();
            ConnectionInformationHelper helper = ConnectionInformationHelper.getInstance(daoFactory);
            helper.disconnect(guid);
            if (!value.isSkipLogoutAudit()) {
                this.auditLogoutAction(value);
            }
        }
        catch (Exception e) {
            throw this.getException(e);
        }
        return new LogoutResponse();
    }

    private void auditLogoutAction(LogoutRequest value) {
        String host = HostnameUtil.resolveAddressToHostname((String)value.getUserHost());
        try {
            DashboardManager.getInstance().auditWebDashboardLogoutAction(value.getUserLoginName(), value.getUserSessionAuditId(), host, true);
        }
        catch (ServiceUnavailableException e) {
            LOG.error((Object)"Failed to contact Sentinel audit service", (Throwable)e);
        }
    }
}

