/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.model;

import com.prelytis.dashboard.dao.DaoFactory;
import com.prelytis.dashboard.interfaces.DashboardException;
import com.prelytis.dashboard.model.ResponseFactory;
import com.prelytis.dashboard.model.helper.ParameterHelper;
import com.prelytis.dashboard.value.ParameterRequest;
import com.prelytis.dashboard.value.ParameterResponse;
import com.prelytis.dashboard.value.Request;
import com.prelytis.dashboard.value.Response;
import com.prelytis.dashboard.value.util.ExpressionEvaluationData;

class ParameterResponseFactory
extends ResponseFactory {
    ParameterResponseFactory() {
    }

    @Override
    public Response create(Request request, ExpressionEvaluationData data, DaoFactory daoFactory) throws DashboardException {
        ParameterResponse response;
        ParameterRequest value = (ParameterRequest)request;
        ParameterHelper parameterHelper = ParameterHelper.getInstance(daoFactory, value.getSessionParameterType());
        boolean success = true;
        try {
            response = parameterHelper.getResponse(value, data);
        }
        catch (DashboardException e) {
            success = false;
            throw e;
        }
        finally {
            this.audit(value, success);
        }
        return response;
    }

    private void audit(ParameterRequest value, boolean success) {
        int actionType = value.getAction().getId();
        int objectType = value.getSessionParameterType().getId();
        String userName = value.getUserLoginName();
        String auditSessionId = value.getAuditSessionId();
        String objectName = value.getElement() == null ? value.getName() : value.getElement().getName();
        this.audit(userName, auditSessionId, actionType, objectType, objectName, success, null);
    }
}

