/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.model;

import com.axway.sentinel.dashboard.audit.AuditDetailsBean;
import com.axway.sentinel.dashboard.audit.AuditDetailsHelper;
import com.prelytis.dashboard.dao.DaoFactory;
import com.prelytis.dashboard.interfaces.DashboardException;
import com.prelytis.dashboard.interfaces.DashboardRuntimeException;
import com.prelytis.dashboard.interfaces.ErrorCode;
import com.prelytis.dashboard.model.BatchFileResponseFactory;
import com.prelytis.dashboard.model.CalcFieldResponseFactory;
import com.prelytis.dashboard.model.CustomizationResponseFactory;
import com.prelytis.dashboard.model.DashBoardCommentResponseFactory;
import com.prelytis.dashboard.model.DataStructureResponseFactory;
import com.prelytis.dashboard.model.DatabaseResponseFactory;
import com.prelytis.dashboard.model.DependencyResponseFactory;
import com.prelytis.dashboard.model.DisplayPropertiesResponseFactory;
import com.prelytis.dashboard.model.DocumentQueryResponseFactory;
import com.prelytis.dashboard.model.DocumentResponseFactory;
import com.prelytis.dashboard.model.ExportParamResponseFactory;
import com.prelytis.dashboard.model.FolderValueResponseFactory;
import com.prelytis.dashboard.model.HierarchicalFilterParameterResponseFactory;
import com.prelytis.dashboard.model.HierarchicalFilterResponseFactory;
import com.prelytis.dashboard.model.ImportParamResponseFactory;
import com.prelytis.dashboard.model.ImportResponseFactory;
import com.prelytis.dashboard.model.LifeCycleResponseFactory;
import com.prelytis.dashboard.model.LoginResponseFactory;
import com.prelytis.dashboard.model.LogoutResponseFactory;
import com.prelytis.dashboard.model.ParameterResponseFactory;
import com.prelytis.dashboard.model.ParametersListResponseFactory;
import com.prelytis.dashboard.model.PostItResponseFactory;
import com.prelytis.dashboard.model.RestResponseFactory;
import com.prelytis.dashboard.model.SystemResponseFactory;
import com.prelytis.dashboard.model.TaskResponseFactory;
import com.prelytis.dashboard.model.UserResponseFactory;
import com.prelytis.dashboard.model.WorkspaceResponseFactory;
import com.prelytis.dashboard.model.XmlResponseFactory;
import com.prelytis.dashboard.security.DashboardManager;
import com.prelytis.dashboard.security.IDashboardManager;
import com.prelytis.dashboard.value.Request;
import com.prelytis.dashboard.value.Response;
import com.prelytis.dashboard.value.util.ExpressionEvaluationData;
import javax.naming.ServiceUnavailableException;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public abstract class ResponseFactory {
    protected static final Logger log = LogManager.getLogger(ResponseFactory.class);

    public abstract Response create(Request var1, ExpressionEvaluationData var2, DaoFactory var3) throws DashboardException;

    protected DashboardException getException(Exception e) {
        if (e instanceof DashboardException) {
            return (DashboardException)((Object)e);
        }
        return new DashboardException((Throwable)e);
    }

    public static ResponseFactory getResponseBuilder(Request value) throws DashboardException {
        switch (value.getType()) {
            case 18: {
                return new CalcFieldResponseFactory();
            }
            case 38: {
                return new CustomizationResponseFactory();
            }
            case 12: {
                return new DataStructureResponseFactory();
            }
            case 8: {
                return new DatabaseResponseFactory();
            }
            case 9: {
                return new DependencyResponseFactory();
            }
            case 7: {
                return new DocumentResponseFactory();
            }
            case 21: {
                return new DocumentQueryResponseFactory();
            }
            case 19: {
                return new ExportParamResponseFactory();
            }
            case 40: {
                return new FolderValueResponseFactory();
            }
            case 23: {
                return new ImportParamResponseFactory();
            }
            case 3: {
                return new LoginResponseFactory();
            }
            case 4: {
                return new LogoutResponseFactory();
            }
            case 25: {
                return new LifeCycleResponseFactory();
            }
            case 2: {
                return new ParameterResponseFactory();
            }
            case 1: {
                return new ParametersListResponseFactory();
            }
            case 22: {
                return new RestResponseFactory();
            }
            case 13: {
                return new SystemResponseFactory();
            }
            case 17: {
                return new TaskResponseFactory();
            }
            case 20: {
                return new UserResponseFactory();
            }
            case 30: {
                return new BatchFileResponseFactory();
            }
            case 31: {
                return new DisplayPropertiesResponseFactory();
            }
            case 34: {
                return new DashBoardCommentResponseFactory();
            }
            case 36: {
                return new HierarchicalFilterResponseFactory();
            }
            case 35: {
                return new HierarchicalFilterParameterResponseFactory();
            }
            case 37: {
                return new WorkspaceResponseFactory();
            }
            case 39: {
                return new ImportResponseFactory();
            }
            case 41: {
                return new PostItResponseFactory();
            }
            case 42: {
                return new XmlResponseFactory();
            }
        }
        throw new DashboardRuntimeException(ErrorCode.INSIGHT_UNKNOWN, "Unknown request: " + value.toString());
    }

    protected void audit(String userName, String auditSessionId, int actionType, int objectType, String objectName, boolean success, String moreInfo) {
        AuditDetailsBean auditDetails = AuditDetailsHelper.createAuditDetailsForObjectActions((String)userName, (String)auditSessionId, (int)actionType, (int)objectType, (String)objectName, (boolean)success, (String)moreInfo);
        if (auditDetails == null) {
            return;
        }
        try {
            IDashboardManager dashboardManager = DashboardManager.getInstance();
            dashboardManager.auditWebDashboardActions(auditDetails);
        }
        catch (ServiceUnavailableException e) {
            log.warn((Object)"Failed attempt to contact server for audit:");
            log.warn((Object)e.getLocalizedMessage());
            log.debug((Object)e);
        }
    }
}

