/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.model;

import com.prelytis.dashboard.dao.DaoFactory;
import com.prelytis.dashboard.helper.XMLExportHelper;
import com.prelytis.dashboard.helper.XMLImportHelper;
import com.prelytis.dashboard.interfaces.DashboardException;
import com.prelytis.dashboard.interfaces.DashboardRuntimeException;
import com.prelytis.dashboard.model.ResponseFactory;
import com.prelytis.dashboard.model.SystemResponseFactory;
import com.prelytis.dashboard.model.reader.DataSourceEventProducer;
import com.prelytis.dashboard.model.reader.MessageListEventProducer;
import com.prelytis.dashboard.model.reader.SystemResponseEventProducer;
import com.prelytis.dashboard.persistence.Configuration;
import com.prelytis.dashboard.value.Request;
import com.prelytis.dashboard.value.Response;
import com.prelytis.dashboard.value.RestRequest;
import com.prelytis.dashboard.value.RestResponse;
import com.prelytis.dashboard.value.SystemRequest;
import com.prelytis.dashboard.value.SystemResponse;
import com.prelytis.dashboard.value.util.ExecutionMessage;
import com.prelytis.dashboard.value.util.ExecutionMessageStd;
import com.prelytis.dashboard.value.util.ExpressionEvaluationData;
import com.prelytis.dashboard.xml.stax.XMLEventProducer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;

class RestResponseFactory
extends ResponseFactory {
    private final SystemResponseFactory systemResponseFactory = new SystemResponseFactory();

    RestResponseFactory() {
    }

    @Override
    public Response create(Request value, ExpressionEvaluationData data, DaoFactory daoFactory) throws DashboardException {
        RestRequest request = (RestRequest)value;
        RestResponse response = new RestResponse();
        String pathInfo = request.getPathInfo();
        ArrayList<ExecutionMessage> messageList = new ArrayList<ExecutionMessageStd>();
        Configuration configuration = Configuration.getInstance();
        try {
            switch (request.getMethod()) {
                case 1: {
                    if ("/status.xml".equals(pathInfo)) {
                        SystemRequest systemRequest = new SystemRequest();
                        systemRequest.setAction(SystemRequest.Action.CHECK_INSTALL);
                        SystemResponse systemResponse = this.systemResponseFactory.create((Request)systemRequest, data, daoFactory);
                        response.setData(this.getResult(new SystemResponseEventProducer(systemResponse)));
                        break;
                    }
                    if ("/reload.xml".equals(pathInfo) || !"/datasources.xml".equals(pathInfo)) break;
                    response.setData(this.getResult(new DataSourceEventProducer(configuration.getDataSourceConfiguration().getDataSources().iterator())));
                    break;
                }
                case 2: {
                    if ("/xml-export/execute.xml".equals(pathInfo)) {
                        byte[] resu = null;
                        String[] file = (String[])request.getParameter().get("command");
                        if (file == null || file.length == 0) {
                            messageList.add((ExecutionMessage)new ExecutionMessageStd("No file found"));
                            resu = this.getXMLExecution(-2, messageList);
                        } else {
                            try {
                                resu = this.exportData(file[0]);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        response.setData(resu);
                        break;
                    }
                    if (!"/xml-import/execute.xml".equals(pathInfo)) break;
                    byte[] resu = null;
                    String[] file = (String[])request.getParameter().get("command");
                    if (file == null || file.length == 0) {
                        messageList.add((ExecutionMessage)new ExecutionMessageStd("No file found"));
                        resu = this.getXMLExecution(-2, messageList);
                    } else {
                        try {
                            resu = this.importData(file[0]);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    response.setData(resu);
                    break;
                }
                case 4: {
                    if (!"/create-db.xml".equals(pathInfo)) break;
                    SystemRequest systemRequest = new SystemRequest();
                    systemRequest.setAction(SystemRequest.Action.CREATE_DATABASE);
                    SystemResponse systemResponse = this.systemResponseFactory.create((Request)systemRequest, data, daoFactory);
                    messageList = systemResponse.getMessageList();
                    response.setData(this.getXMLExecution(0, messageList));
                    break;
                }
                case 3: {
                    if (!"/delete-db.xml".equals(pathInfo)) break;
                    SystemRequest systemRequest = new SystemRequest();
                    systemRequest.setAction(SystemRequest.Action.DROP_DATABASE);
                    SystemResponse systemResponse = this.systemResponseFactory.create((Request)systemRequest, data, daoFactory);
                    messageList = systemResponse.getMessageList();
                    response.setData(this.getXMLExecution(0, messageList));
                }
            }
        }
        catch (Exception e) {
            throw this.getException(e);
        }
        return response;
    }

    private byte[] getXMLExecution(int status, List<ExecutionMessage> list) {
        return this.getResult(new MessageListEventProducer(status, list.iterator()));
    }

    private byte[] exportData(String file) throws DashboardException {
        XMLExportHelper exportHelper = new XMLExportHelper();
        ByteArrayInputStream is = null;
        ByteArrayOutputStream os = null;
        try {
            is = new ByteArrayInputStream(file.getBytes());
            os = new ByteArrayOutputStream();
            exportHelper.go(is, os);
            byte[] byArray = os.toByteArray();
            return byArray;
        }
        catch (Exception e) {
            throw this.getException(e);
        }
        finally {
            try {
                if (os != null) {
                    os.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (is != null) {
                    ((InputStream)is).close();
                }
            }
            catch (Exception exception) {}
        }
    }

    private byte[] importData(String file) throws DashboardException {
        ArrayList<ExecutionMessage> msgList = new ArrayList();
        byte[] st = null;
        XMLImportHelper importHelper = new XMLImportHelper();
        try {
            msgList = importHelper.go();
            st = this.getXMLExecution(1, msgList);
        }
        catch (Exception e) {
            throw this.getException(e);
        }
        return st;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] getResult(XMLEventProducer producer) {
        try {
            XMLOutputFactory outputFactory = XMLOutputFactory.newInstance();
            try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
                XMLEventWriter writer = outputFactory.createXMLEventWriter(baos);
                while (producer.hasMore()) {
                    producer.produce(writer);
                }
            }
            return baos.toByteArray();
        }
        catch (XMLStreamException e) {
            throw new DashboardRuntimeException((Throwable)e);
        }
        catch (IOException e) {
            throw new DashboardRuntimeException((Throwable)e);
        }
    }
}

