/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.model;

import com.prelytis.dashboard.dao.DaoFactory;
import com.prelytis.dashboard.dao.EntityDao;
import com.prelytis.dashboard.dao.LanguageDao;
import com.prelytis.dashboard.dao.LockDao;
import com.prelytis.dashboard.dao.SessionDao;
import com.prelytis.dashboard.dao.db.DefaultDaoFactory;
import com.prelytis.dashboard.helper.ExceptionHelper;
import com.prelytis.dashboard.helper.SQLImportHelper;
import com.prelytis.dashboard.helper.SystemHelper;
import com.prelytis.dashboard.interfaces.DashboardException;
import com.prelytis.dashboard.interfaces.DashboardRuntimeException;
import com.prelytis.dashboard.model.InfoExpressionEvaluationData;
import com.prelytis.dashboard.model.ResponseFactory;
import com.prelytis.dashboard.model.helper.PrelytisInfoHelper;
import com.prelytis.dashboard.model.helper.QueryHelper;
import com.prelytis.dashboard.persistence.Configuration;
import com.prelytis.dashboard.persistence.DataSourceConfiguration;
import com.prelytis.dashboard.util.GuidFactory;
import com.prelytis.dashboard.util.SerializationUtil;
import com.prelytis.dashboard.value.Request;
import com.prelytis.dashboard.value.SystemRequest;
import com.prelytis.dashboard.value.SystemResponse;
import com.prelytis.dashboard.value.data.BeanPRPInfo;
import com.prelytis.dashboard.value.data.BeanPRPInfoModule;
import com.prelytis.dashboard.value.util.ExpressionEvaluationData;
import com.prelytis.dashboard.xml.stax.XMLEventReaderWrapper;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

class SystemResponseFactory
extends ResponseFactory {
    private static final String FIXI18N = "FixI18n";
    private static final String SYSTEM = "System";
    private static final String FIX = "Fix";
    private SystemHelper helper = SystemHelper.getInstance();

    SystemResponseFactory() {
    }

    public synchronized SystemResponse create(Request request, ExpressionEvaluationData data, DaoFactory daoFactory) throws DashboardException {
        SystemRequest value = (SystemRequest)request;
        SystemResponse response = new SystemResponse();
        String baseDir = Configuration.getInstance().getBaseDir();
        try {
            SystemRequest.Action action = value.getAction();
            if (action == null) {
                action = SystemRequest.Action.CHECK_VERSION;
            }
            switch (action) {
                case CREATE_DATABASE: {
                    response = this.getCreateDatabaseResponse();
                    break;
                }
                case DROP_DATABASE: {
                    response = this.getDropDatabaseResponse();
                    break;
                }
                case CHECK_INSTALL: {
                    response = this.getCheckInstallResponse();
                    break;
                }
                case FIX_DATABASE: {
                    response = this.getFixDatabase();
                    break;
                }
                case FIX_DICTIONNARIES: {
                    response = this.getFixDictionnaries();
                    break;
                }
                case FIX_I18N: {
                    this.fixI18n(value.getOverwrite());
                    response = new SystemResponse();
                    break;
                }
                case CHECK_VERSION: {
                    response = this.getVersions();
                    break;
                }
                case FIX_ENTITIES_PARENT_LIST: {
                    response = this.getFixEntitiesParentList();
                    break;
                }
                case RUN_SQL_SCRIPTS: {
                    response = this.getRunScriptsResponse(value);
                    break;
                }
            }
        }
        catch (Exception e) {
            throw this.getException(e);
        }
        return response;
    }

    private SystemResponse getVersions() throws DashboardException {
        Configuration configuration = Configuration.getInstance();
        DataSourceConfiguration dsc = configuration.getDataSourceConfiguration();
        if (dsc.getDataSource() == null) {
            throw ExceptionHelper.getInstance(Locale.ENGLISH).createDashboardException("invalidConfigurationFile", null, null);
        }
        SystemResponse response = new SystemResponse();
        String databaseVersion = this.helper.getDatabaseVersion(dsc.getDataSource());
        response.setExecutableVersion("4.2.0");
        response.setExpectedDatabaseVersion("4.2.0");
        response.setDatabaseVersion(databaseVersion);
        return response;
    }

    private SystemResponse getCreateDatabaseResponse() throws DashboardException {
        Configuration configuration = Configuration.getInstance();
        String baseDir = configuration.getBaseDir();
        DataSourceConfiguration dsc = configuration.getDataSourceConfiguration();
        SQLImportHelper sqlImportHelper = SQLImportHelper.getInstance(dsc.getDataSource());
        if (dsc.getDataSource() == null) {
            throw ExceptionHelper.getInstance(Locale.ENGLISH).createDashboardException("invalidConfigurationFile", null, null);
        }
        sqlImportHelper.execute(this.helper.getFileList(dsc.getDataSource()));
        List<String> filelist = this.helper.getLanguageFileList();
        sqlImportHelper.importData(filelist, Boolean.FALSE);
        File etcDir = new File(baseDir, "etc");
        if (etcDir.isDirectory()) {
            DaoFactory daoFactory = DefaultDaoFactory.getInstance();
            PrelytisInfoHelper infoHelper = PrelytisInfoHelper.getInstance(daoFactory);
            BeanPRPInfo info = infoHelper.getPrelytisInfo();
            ArrayList<BeanPRPInfoModule> modules = new ArrayList<BeanPRPInfoModule>();
            File xmlFile = new File(etcDir, "prelytis.xml");
            File propFile = new File(etcDir, "prelytis.properties");
            if (propFile.exists()) {
                if (xmlFile.exists()) {
                    this.updateInfoFromXml(xmlFile, info, modules);
                    xmlFile.renameTo(new File(etcDir, "prelytis.xml." + GuidFactory.getInstance().generateGUID((Object)propFile)));
                }
                propFile.renameTo(new File(etcDir, "prelytis.properties." + GuidFactory.getInstance().generateGUID((Object)propFile)));
            } else if (xmlFile.exists()) {
                this.updateInfoFromXml(xmlFile, info, modules);
                xmlFile.renameTo(new File(etcDir, "prelytis.xml." + GuidFactory.getInstance().generateGUID((Object)propFile)));
            }
            infoHelper.saveModules(modules);
            infoHelper.save(info, new InfoExpressionEvaluationData());
        }
        SystemResponse response = new SystemResponse();
        response.setMessageList(sqlImportHelper.getMsgList());
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateInfoFromXml(File xmlFile, BeanPRPInfo info, List<BeanPRPInfoModule> modules) {
        try {
            XMLInputFactory inputFactory = XMLInputFactory.newInstance();
            try (FileInputStream fis = new FileInputStream(xmlFile);){
                XMLEventReaderWrapper reader = new XMLEventReaderWrapper(inputFactory.createXMLEventReader(fis));
                while (reader.hasNext()) {
                    XMLEvent event = reader.peek();
                    if (event.isStartElement()) {
                        StartElement se = event.asStartElement();
                        String localName = se.getName().getLocalPart();
                        if ("server".equals(localName)) {
                            this.readServerPart((XMLEventReader)reader, info);
                        } else if ("module".equals(localName)) {
                            this.readModule((XMLEventReader)reader, modules);
                        }
                    }
                    reader.nextEvent();
                }
            }
        }
        catch (XMLStreamException e) {
            throw new DashboardRuntimeException((Throwable)e);
        }
        catch (IOException e) {
            throw new DashboardRuntimeException((Throwable)e);
        }
    }

    private void readModule(XMLEventReader reader, List<BeanPRPInfoModule> modules) throws XMLStreamException {
        reader.nextEvent();
        BeanPRPInfoModule module = new BeanPRPInfoModule();
        while (reader.hasNext()) {
            XMLEvent event = reader.peek();
            if (event.isEndElement()) {
                EndElement ee = event.asEndElement();
                if ("module".equals(ee.getName().getLocalPart())) {
                    modules.add(module);
                    return;
                }
            } else if (event.isStartElement()) {
                StartElement se = event.asStartElement();
                String localName = se.getName().getLocalPart();
                if ("className".equals(localName)) {
                    module.setClassName(reader.getElementText());
                } else if ("param".equals(localName)) {
                    this.readModuleParam(reader, module);
                }
            }
            reader.nextEvent();
        }
    }

    private void readModuleParam(XMLEventReader reader, BeanPRPInfoModule module) throws XMLStreamException {
        String name = null;
        ArrayList<String> values = new ArrayList<String>();
        while (reader.hasNext()) {
            XMLEvent event = reader.peek();
            if (event.isEndElement()) {
                EndElement ee = event.asEndElement();
                if ("param".equals(ee.getName().getLocalPart())) {
                    if (name != null) {
                        String value = this.computeValue(values);
                        module.getParams().put(name, value);
                    }
                    return;
                }
            } else if (event.isStartElement()) {
                StartElement se = event.asStartElement();
                String localName = se.getName().getLocalPart();
                if ("name".equals(localName)) {
                    name = reader.getElementText();
                } else if ("value".equals(localName)) {
                    values.add(reader.getElementText());
                }
            }
            reader.nextEvent();
        }
    }

    private String computeValue(List<String> values) {
        String value = null;
        switch (values.size()) {
            case 0: {
                value = "";
                break;
            }
            case 1: {
                value = values.get(0);
                break;
            }
            default: {
                StringBuilder sb = new StringBuilder();
                boolean first = true;
                for (String v : values) {
                    if (first) {
                        first = false;
                    } else {
                        sb.append(",");
                    }
                    sb.append(v);
                }
                value = sb.toString();
            }
        }
        return value;
    }

    private void readServerPart(XMLEventReader reader, BeanPRPInfo info) throws XMLStreamException {
        reader.nextEvent();
        while (reader.hasNext()) {
            XMLEvent event = reader.peek();
            if (event.isEndElement()) {
                EndElement ee = event.asEndElement();
                if ("server".equals(ee.getName().getLocalPart())) {
                    return;
                }
            } else if (event.isStartElement()) {
                StartElement se = event.asStartElement();
                String localName = se.getName().getLocalPart();
                if ("startTaskMgr".equals(localName)) {
                    info.setStartTaskMgr(this.getBooleanValue(reader));
                } else if ("topMenuShowHelp".equals(localName)) {
                    info.setShowHelp(this.getBooleanValue(reader));
                } else if ("topMenuShowChangePassword".equals(localName)) {
                    info.setChangePasswordEnabled(this.getBooleanValue(reader));
                } else if ("linkPreviewWidth".equals(localName)) {
                    info.setLinkPreviewWidth(this.getIntValue(reader));
                } else if ("linkPreviewHeight".equals(localName)) {
                    info.setLinkPreviewHeight(this.getIntValue(reader));
                } else if ("linkPreviewScale".equals(localName)) {
                    info.setLinkPreviewScale(this.getDoubleValue(reader));
                } else if ("uploadMaxSize".equals(localName)) {
                    info.setUploadMaxSize(this.getIntValue(reader));
                } else if ("uploadThreshold".equals(localName)) {
                    info.setUploadThreshold(this.getIntValue(reader));
                } else if ("uploadRepository".equals(localName)) {
                    info.setUploadRepository(reader.getElementText());
                } else if ("fixDatabaseOnStartup".equals(localName)) {
                    info.setFixDatabaseOnStartup(this.getBooleanValue(reader));
                } else if ("fixDictionnariesOnStartup".equals(localName)) {
                    info.setFixDictionnariesOnStartup(this.getBooleanValue(reader));
                } else if ("fixI18nOnStartup".equals(localName)) {
                    info.setFixI18nOnStartup(this.getBooleanValue(reader));
                } else if ("overwriteI18n".equals(localName)) {
                    info.setOverwriteI18n(this.getBooleanValue(reader));
                } else if ("passwordRegex".equals(localName)) {
                    info.setPasswordRegex(reader.getElementText());
                } else if ("chromeFrameEnabled".equals(localName)) {
                    info.setChromeFrameEnabled(this.getBooleanValue(reader));
                } else if ("htmlAllowedInReports".equals(localName)) {
                    info.setHtmlAllowedInReports(this.getBooleanValue(reader));
                }
            }
            reader.nextEvent();
        }
    }

    private double getDoubleValue(XMLEventReader reader) throws NumberFormatException, XMLStreamException {
        return Double.parseDouble(reader.getElementText());
    }

    private int getIntValue(XMLEventReader reader) throws NumberFormatException, XMLStreamException {
        return Integer.parseInt(reader.getElementText().trim());
    }

    private boolean getBooleanValue(XMLEventReader reader) throws XMLStreamException {
        return "true".equalsIgnoreCase(reader.getElementText());
    }

    private SystemResponse getRunScriptsResponse(SystemRequest value) throws DashboardException {
        DataSourceConfiguration dsc = Configuration.getInstance().getDataSourceConfiguration();
        SQLImportHelper sqlHelper = SQLImportHelper.getInstance(dsc.getDataSource());
        if (dsc.getDataSource() == null) {
            throw ExceptionHelper.getInstance(Locale.ENGLISH).createDashboardException("invalidConfigurationFile", null, null);
        }
        if (value.getData() != null) {
            try {
                Object data = SerializationUtil.deserialize((byte[])value.getData());
                if (data instanceof List) {
                    for (String file : (List)data) {
                        sqlHelper.execute(file);
                    }
                }
            }
            catch (IOException ex) {
                throw new DashboardRuntimeException((Throwable)ex);
            }
            catch (ClassNotFoundException ex) {
                throw new DashboardRuntimeException((Throwable)ex);
            }
        }
        SystemResponse response = new SystemResponse();
        response.setMessageList(sqlHelper.getMsgList());
        return response;
    }

    private SystemResponse getDropDatabaseResponse() throws DashboardException {
        DataSourceConfiguration dsc = Configuration.getInstance().getDataSourceConfiguration();
        SQLImportHelper sqlImportHelper = SQLImportHelper.getInstance(dsc.getDataSource());
        if (dsc.getDataSource() == null) {
            throw ExceptionHelper.getInstance(Locale.ENGLISH).createDashboardException("invalidConfigurationFile", null, null);
        }
        sqlImportHelper.execute("droptable.sql");
        SystemResponse response = new SystemResponse();
        response.setMessageList(sqlImportHelper.getMsgList());
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SystemResponse getCheckInstallResponse() throws DashboardException {
        Configuration configuration = Configuration.getInstance();
        String baseDir = configuration.getBaseDir();
        DataSourceConfiguration dsc = configuration.getDataSourceConfiguration();
        SystemResponse response = new SystemResponse();
        response.setBaseUrl(baseDir);
        response.setExecutableVersion("4.2.0");
        response.setExpectedDatabaseVersion("4.2.0");
        if (dsc == null || dsc.getDataSource() == null) {
            response.setDatabaseFound(Boolean.FALSE);
        } else {
            response.setDatabaseVersion(this.helper.getDatabaseVersion(dsc.getDataSource()));
            response.setDatabaseFound(Boolean.TRUE);
            Connection con = null;
            try {
                try {
                    con = dsc.getDataSource().getConnection();
                }
                finally {
                    if (con != null) {
                        con.close();
                    }
                }
            }
            catch (Exception e) {
                response.setDatabaseFound(Boolean.FALSE);
            }
        }
        if (response.getDatabaseFound().booleanValue()) {
            response.setStatus("RUNNING");
        } else {
            response.setStatus("STOPPED");
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SystemResponse getFixDatabase() throws DashboardException {
        DaoFactory daoFactory = DefaultDaoFactory.getInstance();
        SessionDao sessionDao = daoFactory.getSessionDao();
        LockDao lockDao = daoFactory.getLockDao();
        if (lockDao.lock(SYSTEM, FIX)) {
            try {
                sessionDao.fix();
            }
            finally {
                lockDao.unlock(SYSTEM, FIX);
            }
        } else {
            log.warn((Object)"Cannot fix database (lock)");
        }
        return new SystemResponse();
    }

    private SystemResponse getFixDictionnaries() throws DashboardException {
        DaoFactory daoFactory = DefaultDaoFactory.getInstance();
        QueryHelper queryHelper = QueryHelper.getInstance(daoFactory);
        queryHelper.fix();
        return new SystemResponse();
    }

    private SystemResponse getFixEntitiesParentList() throws DashboardException {
        DaoFactory daoFactory = DefaultDaoFactory.getInstance();
        EntityDao entityDao = daoFactory.getEntityDao();
        entityDao.fixEntitiesParentList();
        return new SystemResponse();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fixI18n(Boolean overwrite) throws DashboardException {
        block11: {
            try {
                DaoFactory daoFactory = DefaultDaoFactory.getInstance();
                Configuration configuration = Configuration.getInstance();
                String baseDir = configuration.getBaseDir();
                LockDao lockDao = daoFactory.getLockDao();
                if (lockDao.lock(SYSTEM, FIXI18N)) {
                    try {
                        LanguageDao languageDao = daoFactory.getLanguageDao();
                        Set keys = languageDao.getUsedKeys();
                        File backupDir = new File(baseDir, "backup");
                        if (!backupDir.exists()) {
                            backupDir.mkdir();
                        }
                        List localeList = languageDao.getLocaleList();
                        HashSet<String> keySet = new HashSet<String>();
                        for (Locale l : localeList) {
                            String language = l.getLanguage();
                            Map l10nMap = languageDao.getData(l);
                            File file = new File(backupDir, new StringBuffer().append("lang_").append(language).append(".properties").toString());
                            this.cleanLocaleData(l10nMap, file, language, keySet, keys);
                        }
                        languageDao.deleteData(keySet);
                        DataSourceConfiguration dsc = Configuration.getInstance().getDataSourceConfiguration();
                        SQLImportHelper sqlImportHelper = SQLImportHelper.getInstance(dsc.getDataSource());
                        SystemResponse response = new SystemResponse();
                        response.setBaseUrl(baseDir);
                        if (dsc.getDataSource() == null) {
                            throw ExceptionHelper.getInstance(Locale.ENGLISH).createDashboardException("error.invalidPropertyFile", null, null);
                        }
                        try {
                            List<String> filelist = this.helper.getLanguageFileList();
                            sqlImportHelper.importData(filelist, overwrite);
                            break block11;
                        }
                        catch (Exception e) {
                            throw this.getException(e);
                        }
                    }
                    finally {
                        lockDao.unlock(SYSTEM, FIXI18N);
                    }
                }
                log.warn((Object)"Cannot fix I18n (lock)");
            }
            catch (Exception e) {
                throw this.getException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanLocaleData(Map<String, String> l10nMap, File file, String language, Set<String> keySet, Set<String> keys) throws IOException {
        l10nMap.keySet().removeAll(keys);
        if (!l10nMap.isEmpty()) {
            Properties prop = new Properties();
            if (file.exists()) {
                try (FileInputStream fis = null;){
                    fis = new FileInputStream(file);
                    prop.load(fis);
                }
            }
            prop.putAll(l10nMap);
            try (FileOutputStream fos = null;){
                fos = new FileOutputStream(file);
                prop.store(fos, null);
            }
            log.info((Object)new StringBuffer().append(l10nMap.size()).append(" entries to delete for language ").append(language).toString());
            keySet.addAll(l10nMap.keySet());
        }
    }
}

