/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.model;

import com.prelytis.dashboard.dao.DaoFactory;
import com.prelytis.dashboard.dao.LockDao;
import com.prelytis.dashboard.dao.SessionDao;
import com.prelytis.dashboard.dao.TaskDao;
import com.prelytis.dashboard.dao.TaskExecutionDao;
import com.prelytis.dashboard.dao.TaskGroupDao;
import com.prelytis.dashboard.dao.TimeUnitDao;
import com.prelytis.dashboard.dao.filter.DbDefaultFilter;
import com.prelytis.dashboard.dao.filter.DbTaskFilter;
import com.prelytis.dashboard.dao.filter.DbTaskGroupFilter;
import com.prelytis.dashboard.helper.ExecutionMessageHelper;
import com.prelytis.dashboard.interfaces.DashboardException;
import com.prelytis.dashboard.interfaces.I18nElement;
import com.prelytis.dashboard.model.ResponseFactory;
import com.prelytis.dashboard.persistence.helper.ListHelper;
import com.prelytis.dashboard.task.AbstractTaskExecution;
import com.prelytis.dashboard.task.TaskExecutionDatabaseListener;
import com.prelytis.dashboard.task.TaskExecutionException;
import com.prelytis.dashboard.task.TaskExecutionLogListener;
import com.prelytis.dashboard.task.TaskLogger;
import com.prelytis.dashboard.value.Request;
import com.prelytis.dashboard.value.Response;
import com.prelytis.dashboard.value.TaskRequest;
import com.prelytis.dashboard.value.TaskResponse;
import com.prelytis.dashboard.value.data.BeanSession;
import com.prelytis.dashboard.value.data.BeanTaskDefinition;
import com.prelytis.dashboard.value.data.BeanTaskGroup;
import com.prelytis.dashboard.value.data.BeanTimeUnit;
import com.prelytis.dashboard.value.structure.Task;
import com.prelytis.dashboard.value.tree.DefaultMutableTreeNode;
import com.prelytis.dashboard.value.tree.TreeNode;
import com.prelytis.dashboard.value.util.ExecutionMessage;
import com.prelytis.dashboard.value.util.ExecutionMessageI18n;
import com.prelytis.dashboard.value.util.ExecutionMessageStd;
import com.prelytis.dashboard.value.util.ExpressionEvaluationData;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;

class TaskResponseFactory
extends ResponseFactory {
    private static final String TASK = "Task";

    TaskResponseFactory() {
    }

    @Override
    public Response create(Request request, ExpressionEvaluationData data, DaoFactory daoFactory) throws DashboardException {
        TaskRequest value = (TaskRequest)request;
        TaskRequest.Action action = value.getAction();
        if (action == null) {
            action = TaskRequest.Action.LIST;
        }
        switch (action) {
            case EXECUTE: {
                return this.execute(daoFactory, value);
            }
            case LIST: {
                return this.list(daoFactory, data.getLocale());
            }
            case MESSAGES: {
                return this.messages(daoFactory, value.getTaskName(), data);
            }
        }
        throw new DashboardException();
    }

    private TaskResponse messages(DaoFactory daoFactory, String taskName, ExpressionEvaluationData data) {
        TaskExecutionDao dao = daoFactory.getTaskExecutionDao();
        List messages = dao.getMessages(taskName);
        ExecutionMessageHelper messageHelper = new ExecutionMessageHelper(data.getLocale());
        TaskResponse response = new TaskResponse();
        response.setMessages(messageHelper.getLocalizedMessages(messages));
        return response;
    }

    private TaskResponse list(DaoFactory daoFactory, Locale locale) throws DashboardException {
        TaskResponse response = new TaskResponse();
        response.setTaskTreeNode(this.getTaskTreeNode(daoFactory, locale));
        return response;
    }

    private TaskResponse execute(DaoFactory daoFactory, TaskRequest request) {
        TaskDao taskDao = daoFactory.getTaskDao();
        LockDao lockDao = daoFactory.getLockDao();
        TreeNode<Task> task = request.getTask();
        if (task == null) {
            Map<Integer, BeanTimeUnit> tuDescMap = this.getTimeUnitMap(daoFactory.getTimeUnitDao(), Locale.ENGLISH);
            BeanTaskDefinition t = (BeanTaskDefinition)taskDao.getDefinition(request.getTaskName());
            task = this.newTask(t, tuDescMap, Locale.ENGLISH);
        }
        this.execute(daoFactory, taskDao, lockDao, task, request.getScheduledDate());
        TaskResponse response = new TaskResponse();
        response.setTaskTreeNode((TreeNode)task);
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private void execute(DaoFactory daoFactory, TaskDao taskDao, LockDao lockDao, TreeNode<Task> node, Date scheduledDate) {
        status = -3;
        task = (Task)node.getUserObject();
        if (lockDao.lock("Task", task.getName())) {
            try {
                taskLogger = new TaskLogger(daoFactory.getTaskExecutionDao(), task.getObjectID());
                traceTaskExecutionDuration = true;
                listener /* !! */  = traceTaskExecutionDuration != false ? new TaskExecutionDatabaseListener(daoFactory.getTaskExecutionDao()) : new TaskExecutionLogListener();
                try {
                    taskLogger.log((ExecutionMessage)new ExecutionMessageI18n(1, "taskMsg.startExec", task.getName()));
                    task.setPlannedDate(scheduledDate);
                    taskExecution = AbstractTaskExecution.getInstance(taskLogger, listener /* !! */ , task.getTaskType());
                    status = taskExecution.execute(daoFactory, task);
                    switch (status) {
                        case 0: {
                            taskLogger.log((ExecutionMessage)new ExecutionMessageI18n(1, "taskMsg.execOk", task.getName()));
                            ** break;
lbl17:
                            // 1 sources

                            break;
                        }
                        case -1: {
                            taskLogger.log((ExecutionMessage)new ExecutionMessageI18n(2, "taskMsg.execWarning", task.getName()));
                            ** break;
lbl21:
                            // 1 sources

                            break;
                        }
                        case -2: {
                            taskLogger.log((ExecutionMessage)new ExecutionMessageI18n(3, "taskMsg.errorExec", task.getName()));
                            ** break;
lbl25:
                            // 1 sources

                            break;
                        }
                        default: {
                            taskLogger.log((ExecutionMessage)new ExecutionMessageI18n(3, "taskMsg.unknownStatus"));
                            break;
                        }
                    }
                }
                catch (TaskExecutionException e) {
                    status = -2;
                    taskLogger.log((ExecutionMessage)new ExecutionMessageStd(3, e.getMessage()));
                    taskLogger.log((ExecutionMessage)new ExecutionMessageI18n(3, "taskMsg.errorExec", task.getName()));
                }
                finally {
                    task.setStatus(status);
                    task.setCalculationDate(new Date());
                    this.update(taskDao, task);
                }
                try {
                    this.execute(daoFactory, taskDao, lockDao, node.getChildren(), task.getStatus(), scheduledDate);
                }
                catch (Exception e) {
                    if (TaskResponseFactory.log.isDebugEnabled()) {
                        TaskResponseFactory.log.error((Object)e, (Throwable)e);
                    }
                    TaskResponseFactory.log.error((Object)e);
                }
            }
            finally {
                lockDao.unlock("Task", task.getName());
            }
        } else {
            TaskResponseFactory.log.warn((Object)("Unable to lock task " + task.getName()));
        }
    }

    private void update(TaskDao taskDao, Task task) {
        try {
            taskDao.update(task);
        }
        catch (Exception e) {
            log.error((Object)e);
        }
    }

    private void execute(DaoFactory daoFactory, TaskDao taskDao, LockDao lockDao, List<TreeNode<Task>> childList, int status, Date scheduledDate) {
        if (childList == null) {
            return;
        }
        for (TreeNode<Task> node : childList) {
            Task task = (Task)node.getUserObject();
            if (this.getExecuteChild(task, status)) {
                this.execute(daoFactory, taskDao, lockDao, node, scheduledDate);
                continue;
            }
            task.setStatus(1);
            task.setCalculationDate(new Date());
            this.update(taskDao, task);
        }
    }

    private boolean getExecuteChild(Task task, int status) {
        int executionType = task.getExecutionType();
        switch (status) {
            case 0: {
                return executionType == 1 || executionType == 5 || executionType == 7;
            }
            case -1: {
                return executionType == 5 || executionType == 7 || executionType == 4 || executionType == 6;
            }
            case -2: {
                return executionType == 2 || executionType == 7 || executionType == 6;
            }
        }
        return false;
    }

    private TreeNode<Task> getTaskTreeNode(DaoFactory daoFactory, Locale locale) throws DashboardException {
        try {
            SessionDao sessionDao = daoFactory.getSessionDao();
            BeanSession session = (BeanSession)sessionDao.getCore(20);
            DefaultMutableTreeNode treeNode = new DefaultMutableTreeNode();
            Task tm = new Task();
            tm.setObjectID(session.getObjectID());
            tm.setName(session.getName());
            tm.setDescription((String)session.getDescriptionMap().get(locale));
            tm.getDescriptionMap().putAll(session.getDescriptionMap());
            treeNode.setUserObject((Object)tm);
            TaskGroupDao taskGroupDao = daoFactory.getTaskGroupDao();
            DbTaskGroupFilter taskGroupFilter = new DbTaskGroupFilter();
            taskGroupFilter.setActive(Boolean.TRUE);
            List taskGroupList = taskGroupDao.listAll((DbDefaultFilter)taskGroupFilter, 1);
            if (!taskGroupList.isEmpty()) {
                TaskDao taskDao = daoFactory.getTaskDao();
                Map<Integer, BeanTimeUnit> tuDescMap = this.getTimeUnitMap(daoFactory.getTimeUnitDao(), locale);
                ArrayList<DefaultMutableTreeNode> list = new ArrayList<DefaultMutableTreeNode>();
                treeNode.setChildren(list);
                for (int i = 0; i < taskGroupList.size(); ++i) {
                    BeanTaskGroup group = (BeanTaskGroup)taskGroupList.get(i);
                    DefaultMutableTreeNode groupTreeNode = new DefaultMutableTreeNode();
                    Task tg = new Task((I18nElement)group);
                    tg.setDescription((String)group.getDescriptionMap().get(locale));
                    groupTreeNode.setUserObject((Object)tg);
                    DbTaskFilter filter = new DbTaskFilter();
                    filter.setParentTaskOid(new Integer[]{null});
                    filter.setTaskGrpOid(new Integer[]{group.getObjectID()});
                    this.load(taskDao, filter, (TreeNode<Task>)groupTreeNode, tuDescMap, locale);
                    if (groupTreeNode.isLeaf()) continue;
                    groupTreeNode.setParent((TreeNode)treeNode);
                    list.add(groupTreeNode);
                }
            }
            return treeNode;
        }
        catch (Exception e) {
            throw this.getException(e);
        }
    }

    private Map<Integer, BeanTimeUnit> getTimeUnitMap(TimeUnitDao timeUnitDao, Locale locale) {
        List timeUnitList = timeUnitDao.listAll(null, 1);
        return ListHelper.getInstance().getMapById(timeUnitList, BeanTimeUnit.class);
    }

    private void load(TaskDao taskDao, DbTaskFilter filter, TreeNode<Task> treeNode, Map<Integer, BeanTimeUnit> tuMap, Locale locale) throws DashboardException {
        try {
            List taskList = taskDao.listAll((DbDefaultFilter)filter, 2);
            if (!taskList.isEmpty()) {
                ArrayList<TreeNode<Task>> childList = new ArrayList<TreeNode<Task>>();
                treeNode.setChildren(childList);
                for (int i = 0; i < taskList.size(); ++i) {
                    BeanTaskDefinition task = (BeanTaskDefinition)taskList.get(i);
                    log.debug((Object)("TaskMgr.refresh " + task.getName()));
                    TreeNode<Task> taskTreeNode = this.newTask(task, tuMap, locale);
                    taskTreeNode.setParent(treeNode);
                    childList.add(taskTreeNode);
                    DbTaskFilter taskFilter = new DbTaskFilter();
                    taskFilter.setParentTaskOid(new Integer[]{task.getObjectID()});
                    this.load(taskDao, taskFilter, taskTreeNode, tuMap, locale);
                }
            }
        }
        catch (Exception e) {
            throw this.getException(e);
        }
    }

    private TreeNode<Task> newTask(BeanTaskDefinition task, Map<Integer, BeanTimeUnit> tuMap, Locale locale) {
        DefaultMutableTreeNode taskTreeNode = new DefaultMutableTreeNode();
        Task tn = new Task((I18nElement)task);
        tn.setDescription((String)task.getDescriptionMap().get(locale));
        tn.setCalculationDate(task.getCalcDate());
        tn.setCronExpression(task.getCronExpression());
        tn.setEndDate(task.getEndDate());
        tn.setFreq(task.getFreq());
        tn.setPeriod(task.getFreq());
        tn.setExecutionType(task.getExecutionType());
        BeanTimeUnit tu = tuMap.get(task.getFreqUnitOID());
        if (tu != null) {
            tn.setPeriodUnitDescription((String)tu.getDescriptionMap().get(locale));
            tn.setFreqConvFactor(tu.getConvFactor());
            tn.setFreqConvField(tu.getConvField());
        }
        tn.setPlannedDate(task.getPlannedDate());
        tn.setStartDate(task.getStartDate());
        tn.setStatus(task.getCalcStatus());
        tn.setTaskType(task.getTaskType());
        tn.setTimeZone(task.getTimeZone());
        taskTreeNode.setUserObject((Object)tn);
        return taskTreeNode;
    }
}

