/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.model;

import com.prelytis.dashboard.dao.DaoFactory;
import com.prelytis.dashboard.dao.PrelytisInfoDao;
import com.prelytis.dashboard.interfaces.DashboardException;
import com.prelytis.dashboard.interfaces.SessionType;
import com.prelytis.dashboard.model.ResponseFactory;
import com.prelytis.dashboard.model.helper.DashBoardHelper;
import com.prelytis.dashboard.value.Request;
import com.prelytis.dashboard.value.Response;
import com.prelytis.dashboard.value.WorkspaceRequest;
import com.prelytis.dashboard.value.WorkspaceResponse;
import com.prelytis.dashboard.value.data.BeanDashBoardBlock;
import com.prelytis.dashboard.value.data.BeanDashBoardBlockControlPanel;
import com.prelytis.dashboard.value.data.BeanDashBoardBlockExternSession;
import com.prelytis.dashboard.value.data.BeanDashBoardBlockForm;
import com.prelytis.dashboard.value.data.BeanDashBoardBlockMetricPanel;
import com.prelytis.dashboard.value.data.BeanDashBoardBlockReport;
import com.prelytis.dashboard.value.data.BeanDashBoardBlockStrategyMap;
import com.prelytis.dashboard.value.data.BeanDashBoardDefinition;
import com.prelytis.dashboard.value.data.BeanDashBoardTemplate;
import com.prelytis.dashboard.value.data.BeanPRPInfo;
import com.prelytis.dashboard.value.data.BeanWorkspaceSession;
import com.prelytis.dashboard.value.util.ExpressionEvaluationData;
import java.util.ArrayList;
import java.util.List;

class WorkspaceResponseFactory
extends ResponseFactory {
    WorkspaceResponseFactory() {
    }

    @Override
    public Response create(Request request, ExpressionEvaluationData data, DaoFactory daoFactory) throws DashboardException {
        WorkspaceRequest value = (WorkspaceRequest)request;
        WorkspaceResponse response = new WorkspaceResponse();
        ArrayList<BeanWorkspaceSession> res = new ArrayList<BeanWorkspaceSession>();
        PrelytisInfoDao infoDao = daoFactory.getPrelytisInfoDao();
        BeanPRPInfo info = infoDao.getPrelytisInfo();
        List sessionList = value.getMoreList();
        if (info.isAddDashBoardDepDoc() && sessionList != null) {
            DashBoardHelper dashboardHelper = DashBoardHelper.getInstance(daoFactory);
            BeanDashBoardDefinition dashboard = dashboardHelper.getDefinition(value.getDashboardName());
            for (BeanDashBoardTemplate template : dashboard.getTemplateList()) {
                for (BeanDashBoardBlock block : template.getBlockList()) {
                    if (block instanceof BeanDashBoardBlockReport) {
                        String reportName = ((BeanDashBoardBlockReport)block).getReportName();
                        for (BeanWorkspaceSession session : sessionList) {
                            if (session.getType() != SessionType.DOCUMENT || !session.getName().equals(reportName)) continue;
                            session.setAccessLevel(Integer.valueOf(2));
                            res.add(session);
                        }
                        continue;
                    }
                    if (block instanceof BeanDashBoardBlockExternSession) {
                        String extSessionName = ((BeanDashBoardBlockExternSession)block).getExternSessionName();
                        for (BeanWorkspaceSession session : sessionList) {
                            if (session.getType() != SessionType.EXTERN || !session.getName().equals(extSessionName)) continue;
                            session.setAccessLevel(Integer.valueOf(2));
                            res.add(session);
                        }
                        continue;
                    }
                    if (block instanceof BeanDashBoardBlockForm) {
                        String formName = ((BeanDashBoardBlockForm)block).getFormName();
                        for (BeanWorkspaceSession session : sessionList) {
                            if (session.getType() != SessionType.FORM || !session.getName().equals(formName)) continue;
                            session.setAccessLevel(Integer.valueOf(2));
                            res.add(session);
                        }
                        continue;
                    }
                    if (block instanceof BeanDashBoardBlockControlPanel) {
                        for (BeanWorkspaceSession session : sessionList) {
                            if (session.getType() != SessionType.CONTROL_PANEL) continue;
                            session.setAccessLevel(Integer.valueOf(2));
                            res.add(session);
                        }
                        continue;
                    }
                    if (block instanceof BeanDashBoardBlockStrategyMap) {
                        for (BeanWorkspaceSession session : sessionList) {
                            if (session.getType() != SessionType.STRATEGY_MAP) continue;
                            session.setAccessLevel(Integer.valueOf(2));
                            res.add(session);
                        }
                        continue;
                    }
                    if (!(block instanceof BeanDashBoardBlockMetricPanel)) continue;
                    for (BeanWorkspaceSession session : sessionList) {
                        if (session.getType() != SessionType.METRIC_PANEL) continue;
                        session.setAccessLevel(Integer.valueOf(2));
                        res.add(session);
                    }
                }
            }
        }
        response.setSessionList(res);
        return response;
    }
}

