/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.model;

import com.axway.sentinel.dashboard.audit.AuditActionType;
import com.prelytis.dashboard.dao.DaoFactory;
import com.prelytis.dashboard.dao.WorkspaceDao;
import com.prelytis.dashboard.helper.ConnectionInformationHelper;
import com.prelytis.dashboard.helper.ExceptionHelper;
import com.prelytis.dashboard.helper.ExpressionEvaluationDataHelper;
import com.prelytis.dashboard.interfaces.DashboardException;
import com.prelytis.dashboard.interfaces.DashboardRuntimeException;
import com.prelytis.dashboard.interfaces.Element;
import com.prelytis.dashboard.interfaces.ErrorCode;
import com.prelytis.dashboard.interfaces.SessionType;
import com.prelytis.dashboard.model.ExecutionContextHelper;
import com.prelytis.dashboard.model.ResponseFactory;
import com.prelytis.dashboard.model.helper.ParameterHelper;
import com.prelytis.dashboard.model.helper.UserHelper;
import com.prelytis.dashboard.model.reader.XmlResponseEventProducer;
import com.prelytis.dashboard.security.DashboardManager;
import com.prelytis.dashboard.util.GuidFactory;
import com.prelytis.dashboard.util.sql.ConnectionInformation;
import com.prelytis.dashboard.value.ExecutionContext;
import com.prelytis.dashboard.value.Request;
import com.prelytis.dashboard.value.Response;
import com.prelytis.dashboard.value.XMLRequest;
import com.prelytis.dashboard.value.XMLResponse;
import com.prelytis.dashboard.value.data.Bean;
import com.prelytis.dashboard.value.data.BeanUser;
import com.prelytis.dashboard.value.data.BeanUserDefinition;
import com.prelytis.dashboard.value.data.ImportKey;
import com.prelytis.dashboard.value.data.filter.DefaultFilter;
import com.prelytis.dashboard.value.util.ExpressionEvaluationData;
import com.prelytis.dashboard.value.util.HostnameUtil;
import com.prelytis.dashboard.xml.stax.XMLEventProducer;
import com.prelytis.dashboard.xml.stax.XmlHelper;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.naming.ServiceUnavailableException;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;

class XmlResponseFactory
extends ResponseFactory {
    XmlResponseFactory() {
    }

    @Override
    public Response create(Request request, ExpressionEvaluationData data, DaoFactory daoFactory) throws DashboardException {
        XMLRequest value = (XMLRequest)request;
        try {
            switch (value.getAction()) {
                case AUTHENTICATE: {
                    return this.authenticate(value, daoFactory);
                }
            }
            return this.createResponse(value, daoFactory);
        }
        catch (DashboardRuntimeException dre) {
            return this.getXmlError(new DashboardException(dre.getCode(), (Throwable)dre, dre.getMessage()));
        }
        catch (DashboardException de) {
            return this.getXmlError(de);
        }
        catch (Exception e) {
            return this.getXmlError(new DashboardException(ErrorCode.INSIGHT_UNKNOWN, (Throwable)e, e.getMessage()));
        }
    }

    public Response createResponse(XMLRequest value, DaoFactory daoFactory) throws DashboardException {
        ExpressionEvaluationData data = this.getExpressionEvaluationData(value, daoFactory);
        switch (value.getAction()) {
            case DELETE: {
                return this.delete(value, data, daoFactory);
            }
            case POST: {
                return this.post(value, data, daoFactory);
            }
            case PREPARE: {
                return this.prepare(value, data, daoFactory);
            }
            case PUT: {
                return this.put(value, data, daoFactory);
            }
            case GET: {
                return this.get(value, data, daoFactory);
            }
            case LOGOUT: {
                return this.logout(value, daoFactory);
            }
        }
        throw new DashboardException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Response put(XMLRequest value, ExpressionEvaluationData data, DaoFactory daoFactory) throws DashboardException {
        block17: {
            int n;
            boolean success;
            ParameterHelper helper;
            Bean elt;
            block18: {
                block16: {
                    Map map;
                    if (value.getSessionType() != SessionType.SYSTEM) break block17;
                    if (value.getName() == null) {
                        throw new DashboardException(ErrorCode.INSIGHT_MISSING_NAME, null, "Missing name");
                    }
                    try (ByteArrayInputStream is = new ByteArrayInputStream(value.getPayload());){
                        map = XmlHelper.getInstance().read((InputStream)is);
                    }
                    catch (XMLStreamException e) {
                        throw new DashboardException((Throwable)e);
                    }
                    catch (IOException e) {
                        throw new DashboardException((Throwable)e);
                    }
                    ImportKey key = new ImportKey(value.getSessionParameterType(), value.getName());
                    elt = (Bean)map.get(key);
                    if (elt == null || map.size() != 1) break block17;
                    WorkspaceDao workspaceDao = daoFactory.getWorkspaceDao();
                    int accessLevel = workspaceDao.getAccessLevelForEC(data.getExecutionContextOid().intValue(), value.getSessionParameterType()).getAccessLevel();
                    if (accessLevel < 2) {
                        throw ExceptionHelper.getInstance(Locale.ENGLISH).createDashboardException(ErrorCode.INSIGHT_ACCESS_DENIED, "security", null, null);
                    }
                    helper = ParameterHelper.getInstance(daoFactory, value.getSessionParameterType());
                    DefaultFilter filter = new DefaultFilter();
                    filter.setName(value.getName());
                    List<Element> l = helper.list(filter, 1, null, 2, data);
                    if (!l.isEmpty()) {
                        Bean dbElt = (Bean)l.get(0);
                        elt.setObjectID(dbElt.getObjectID());
                        elt.setOwner(dbElt.getOwner());
                        elt.setCreationDate(dbElt.getCreationDate());
                        elt.setLastModifier(dbElt.getLastModifier());
                        elt.setLastModificationDate(dbElt.getLastModificationDate());
                    }
                    success = true;
                    try {
                        ParameterHelper.save(daoFactory, elt, data, l.size() == 0);
                        if (l.size() != 0) break block16;
                    }
                    catch (DashboardException de) {
                        try {
                            success = false;
                            throw de;
                            catch (DashboardRuntimeException dre) {
                                success = false;
                                throw new DashboardException(ErrorCode.INSIGHT_UNKNOWN, (Throwable)dre, dre.getMessage());
                            }
                        }
                        catch (Throwable throwable) {
                            this.audit(value, l.size() == 0 ? AuditActionType.ADD.getId() : AuditActionType.EDIT.getId(), success);
                            throw throwable;
                        }
                    }
                    n = AuditActionType.ADD.getId();
                    break block18;
                }
                n = AuditActionType.EDIT.getId();
            }
            this.audit(value, n, success);
            if (helper instanceof UserHelper) {
                UserHelper userHelper = (UserHelper)helper;
                userHelper.saveBookmarks((BeanUserDefinition)elt, data);
            }
            return this.get(value, data, daoFactory);
        }
        throw new DashboardException(ErrorCode.NOT_IMPLEMENTED, null, "Not implemented");
    }

    private void audit(XMLRequest req, int action, boolean success) {
        this.audit(req.getUserLoginName(), req.getAuditSessionId(), action, req.getSessionParameterType().getId(), req.getName(), success, "(REST)");
    }

    private Response delete(XMLRequest value, ExpressionEvaluationData data, DaoFactory daoFactory) throws DashboardException {
        if (value.getSessionType() == SessionType.SYSTEM) {
            WorkspaceDao workspaceDao = daoFactory.getWorkspaceDao();
            int accessLevel = workspaceDao.getAccessLevelForEC(data.getExecutionContextOid().intValue(), value.getSessionParameterType()).getAccessLevel();
            if (accessLevel < 2) {
                throw ExceptionHelper.getInstance(Locale.ENGLISH).createDashboardException(ErrorCode.INSIGHT_ACCESS_DENIED, "security", null, null);
            }
            ParameterHelper helper = ParameterHelper.getInstance(daoFactory, value.getSessionParameterType());
            if (value.getName() != null) {
                boolean success = true;
                try {
                    helper.delete(value.getName(), data);
                }
                catch (DashboardException e) {
                    success = false;
                    throw e;
                }
                finally {
                    this.audit(value, AuditActionType.REMOVE.getId(), success);
                }
                return new XMLResponse();
            }
        }
        this.audit(value, AuditActionType.REMOVE.getId(), false);
        throw new DashboardException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Response get(XMLRequest value, ExpressionEvaluationData data, DaoFactory daoFactory) throws DashboardException {
        if (value.getSessionType() == SessionType.SYSTEM) {
            WorkspaceDao workspaceDao = daoFactory.getWorkspaceDao();
            int accessLevel = workspaceDao.getAccessLevelForEC(data.getExecutionContextOid().intValue(), value.getSessionParameterType()).getAccessLevel();
            if (accessLevel < 1) {
                throw ExceptionHelper.getInstance(Locale.ENGLISH).createDashboardException(ErrorCode.INSIGHT_ACCESS_DENIED, "security", null, null);
            }
            ParameterHelper helper = ParameterHelper.getInstance(daoFactory, value.getSessionParameterType());
            if (value.getName() != null) {
                DefaultFilter defaultFilter = new DefaultFilter();
                defaultFilter.setName(value.getName());
                List<Element> list = helper.list(defaultFilter, 2, null, 2, data);
                if (list.size() == 1) {
                    if (helper instanceof UserHelper) {
                        UserHelper userHelper = (UserHelper)helper;
                        userHelper.loadBookmarks((BeanUserDefinition)list.get(0));
                    }
                    return this.getXmlResponse(list);
                }
            } else {
                XMLResponse xMLResponse;
                List<Element> list = helper.list(null, 1, null, null, data);
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                try {
                    XmlHelper.getInstance().writeList(os, list);
                    XMLResponse response = new XMLResponse();
                    response.setResponse(os.toByteArray());
                    xMLResponse = response;
                }
                catch (Throwable throwable) {
                    try {
                        os.close();
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new DashboardException((Throwable)e);
                    }
                    catch (XMLStreamException e) {
                        throw new DashboardException((Throwable)e);
                    }
                }
                os.close();
                return xMLResponse;
            }
        }
        throw new DashboardException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private XMLResponse getXmlResponse(List<Element> list) throws DashboardException {
        XMLResponse xMLResponse;
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            XmlHelper.getInstance().write((OutputStream)os, list);
            XMLResponse response = new XMLResponse();
            response.setResponse(os.toByteArray());
            xMLResponse = response;
        }
        catch (Throwable throwable) {
            try {
                os.close();
                throw throwable;
            }
            catch (IOException e) {
                throw new DashboardException((Throwable)e);
            }
            catch (XMLStreamException e) {
                throw new DashboardException((Throwable)e);
            }
        }
        os.close();
        return xMLResponse;
    }

    private Response prepare(XMLRequest value, ExpressionEvaluationData data, DaoFactory daoFactory) throws DashboardException {
        if (value.getSessionType() == SessionType.SYSTEM) {
            WorkspaceDao workspaceDao = daoFactory.getWorkspaceDao();
            int accessLevel = workspaceDao.getAccessLevelForEC(data.getExecutionContextOid().intValue(), value.getSessionParameterType()).getAccessLevel();
            if (accessLevel < 2) {
                throw ExceptionHelper.getInstance(Locale.ENGLISH).createDashboardException(ErrorCode.INSIGHT_ACCESS_DENIED, "security", null, null);
            }
            ParameterHelper helper = ParameterHelper.getInstance(daoFactory, value.getSessionParameterType());
            Bean newElt = helper.create(data);
            return this.getXmlResponse(Arrays.asList(newElt));
        }
        throw new DashboardException();
    }

    private Response post(XMLRequest value, ExpressionEvaluationData data, DaoFactory daoFactory) throws DashboardException {
        throw new DashboardException();
    }

    private Response logout(XMLRequest value, DaoFactory daoFactory) throws DashboardException {
        XMLResponse response;
        String host = "unresolved host";
        boolean success = true;
        try {
            ConnectionInformationHelper helper = ConnectionInformationHelper.getInstance(daoFactory);
            ConnectionInformation ci = helper.getConnectedUser(value.getUserSessionGuid());
            if (ci == null || ci.getConnectionType() != 5) {
                throw ExceptionHelper.getInstance(Locale.ENGLISH).createInvalidSessionGUIDException();
            }
            host = ci.getIpAddress();
            helper.disconnect(ci.getSessionGUID());
            response = new XMLResponse();
        }
        catch (DashboardException e) {
            success = false;
            throw e;
        }
        finally {
            this.auditLogout(value, host, success);
        }
        return response;
    }

    private void auditLogout(XMLRequest value, String host, boolean success) {
        String hostname = HostnameUtil.resolveAddressToHostname((String)host);
        try {
            DashboardManager.getInstance().auditWebDashboardLogoutAction(value.getUserLoginName(), value.getAuditSessionId(), hostname, success);
        }
        catch (ServiceUnavailableException e) {
            log.error((Object)"Failed to contact Sentinel audit service");
            log.debug((Object)e);
        }
    }

    private XMLResponse authenticate(XMLRequest request, DaoFactory daoFactory) throws DashboardException {
        BeanUserDefinition user;
        String login = request.getName();
        UserHelper userHelper = UserHelper.getInstance(daoFactory);
        try {
            user = userHelper.findUserUsingLogin(login);
        }
        catch (DashboardException de) {
            if (de.getCode() == ErrorCode.NOT_FOUND_ERROR) {
                throw ExceptionHelper.getInstance(Locale.ENGLISH).createLoginException(ErrorCode.INSIGHT_INVALID_CREDENTIALS, "invalidUser");
            }
            throw de;
        }
        ExecutionContextHelper helper = ExecutionContextHelper.getInstance(daoFactory);
        ExecutionContext ec = helper.getExecutionContext((BeanUser)user, request.getExecutionContext());
        GuidFactory guidFactory = GuidFactory.getInstance();
        ConnectionInformation ci = new ConnectionInformation(guidFactory.generateGUID((Object)user), user.getObjectID(), user.getName(), ec.getObjectID(), ec.getName(), ec.getProfile(), ec.getEntityName(), ec.getWorkspaceName(), new Date(), 5, "ws", "ws");
        ConnectionInformationHelper.getInstance(daoFactory).connectUser(ci, true);
        XMLResponse response = new XMLResponse();
        response.setResponse(this.getResult(new XmlResponseEventProducer(ci.getSessionGUID(), ci.getExecutionContextName(), null)));
        return response;
    }

    private XMLResponse getXmlError(DashboardException de) {
        XMLResponse response = new XMLResponse();
        response.setErrorCode(de.getCode());
        response.setResponse(this.getResult(new XmlResponseEventProducer(de)));
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] getResult(XMLEventProducer producer) {
        try {
            XMLOutputFactory outputFactory = XMLOutputFactory.newInstance();
            try (ByteArrayOutputStream baos = new ByteArrayOutputStream();
                 XMLEventWriter writer = outputFactory.createXMLEventWriter(baos, "UTF-8");){
                while (producer.hasMore()) {
                    producer.produce(writer);
                }
            }
            return baos.toByteArray();
        }
        catch (XMLStreamException e) {
            throw new DashboardRuntimeException((Throwable)e);
        }
        catch (IOException e) {
            throw new DashboardRuntimeException((Throwable)e);
        }
    }

    private ExpressionEvaluationData getExpressionEvaluationData(XMLRequest value, DaoFactory daoFactory) throws DashboardException {
        if (value.getUserSessionGuid() == null) {
            throw ExceptionHelper.getInstance(Locale.ENGLISH).createInvalidSessionGUIDException();
        }
        ExpressionEvaluationDataHelper eedh = ExpressionEvaluationDataHelper.getInstance(daoFactory);
        ExpressionEvaluationData data = eedh.getExpressionEvaluationData(value.getUserSessionGuid(), value.getExecutionContext());
        return data;
    }
}

