/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.model.helper;

import com.prelytis.dashboard.dao.Dao;
import com.prelytis.dashboard.dao.DaoFactory;
import com.prelytis.dashboard.dao.EntityDao;
import com.prelytis.dashboard.dao.ExecutionContextDao;
import com.prelytis.dashboard.dao.WorkspaceDao;
import com.prelytis.dashboard.dao.filter.DbDefaultFilter;
import com.prelytis.dashboard.dao.filter.DbEntityFilter;
import com.prelytis.dashboard.dao.filter.DbExecutionContextFilter;
import com.prelytis.dashboard.dao.filter.DbUserFilter;
import com.prelytis.dashboard.dao.filter.DbWorkspaceFilter;
import com.prelytis.dashboard.helper.ExceptionHelper;
import com.prelytis.dashboard.interfaces.DashboardException;
import com.prelytis.dashboard.interfaces.Element;
import com.prelytis.dashboard.interfaces.I18nElement;
import com.prelytis.dashboard.interfaces.SecurityException;
import com.prelytis.dashboard.interfaces.SessionParameterType;
import com.prelytis.dashboard.model.helper.Dependency;
import com.prelytis.dashboard.model.helper.DependencyDefinition;
import com.prelytis.dashboard.model.helper.EntityHelper;
import com.prelytis.dashboard.model.helper.ParameterHelper;
import com.prelytis.dashboard.model.helper.References;
import com.prelytis.dashboard.value.DependencyGroup;
import com.prelytis.dashboard.value.DependencyRequest;
import com.prelytis.dashboard.value.DependencyResponse;
import com.prelytis.dashboard.value.ParameterRequest;
import com.prelytis.dashboard.value.ParameterResponse;
import com.prelytis.dashboard.value.ParametersListRequest;
import com.prelytis.dashboard.value.ParametersListResponse;
import com.prelytis.dashboard.value.data.Bean;
import com.prelytis.dashboard.value.data.BeanExecutionContext;
import com.prelytis.dashboard.value.data.filter.DefaultFilter;
import com.prelytis.dashboard.value.util.ExpressionEvaluationData;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public final class ExecutionContextHelper
extends ParameterHelper
implements Dependency,
References {
    private final EntityHelper entityHelper;
    private final ExecutionContextDao dao;

    ExecutionContextHelper(DaoFactory daoFactory) {
        super(daoFactory);
        this.dao = this.daoFactory.getExecutionContextDao();
        this.entityHelper = new EntityHelper(daoFactory);
    }

    @Override
    public ParameterResponse getResponse(ParameterRequest value, ExpressionEvaluationData data) throws DashboardException {
        Integer instanceType = value.getInstanceType();
        ParameterRequest.Action action = value.getAction() == null ? ParameterRequest.Action.OPEN : value.getAction();
        switch (action) {
            case OPEN: 
            case OPEN_AS_SUPER_USER: {
                return this.get(instanceType, value.getName(), data);
            }
            case COPY: {
                return this.getCopy(value.getName(), data);
            }
            case DELETE: {
                return this.getDelete(value.getName(), (Bean)((BeanExecutionContext)value.getElement()), data);
            }
            case SAVE_AS_NEW: {
                return this.getSaveAsNew((BeanExecutionContext)value.getElement(), data);
            }
            case SAVE: {
                return this.getSave((BeanExecutionContext)value.getElement(), data);
            }
            case NEW: {
                return this.getNew(data);
            }
        }
        throw new DashboardException();
    }

    private ParameterResponse getNew(ExpressionEvaluationData data) throws DashboardException {
        return this.helper.getResponse((I18nElement)this.create(data), data, SessionParameterType.EXECUTION_CONTEXT);
    }

    public BeanExecutionContext create(ExpressionEvaluationData data) throws DashboardException {
        BeanExecutionContext elt = new BeanExecutionContext();
        this.helper.updateDescKey((Bean)elt, false);
        elt.setEntityOid(data.getEntityOid().intValue());
        elt.setEntityName(data.getEntityName());
        elt.setWorkspaceOid(data.getWorkspaceOid().intValue());
        elt.setWorkspaceName(data.getWorkspaceName());
        elt.setProfile(data.getProfile().intValue());
        elt.setCreationDate(new Date());
        elt.setOwner(data.getUserName());
        elt.setLastModificationDate(new Date());
        elt.setLastModifier(data.getUserName());
        return elt;
    }

    private ParameterResponse getSaveAsNew(BeanExecutionContext elt, ExpressionEvaluationData data) throws DashboardException {
        this.save(elt, data, true);
        return this.helper.getResponse((I18nElement)elt, data, SessionParameterType.EXECUTION_CONTEXT);
    }

    private ParameterResponse getSave(BeanExecutionContext elt, ExpressionEvaluationData data) throws DashboardException {
        this.save(elt, data, false);
        return this.helper.getResponse((I18nElement)elt, data, SessionParameterType.EXECUTION_CONTEXT);
    }

    public void save(BeanExecutionContext elt, ExpressionEvaluationData data, boolean isNew) throws DashboardException {
        this.save(elt, data, isNew, false);
    }

    public void save(BeanExecutionContext elt, ExpressionEvaluationData data, boolean isNew, boolean isImport) throws DashboardException {
        this.helper.checkDescriptionMap(elt.getDescriptionMap(), data.getLocale());
        if (isNew) {
            this.helper.checkForSaveAsNew((Dao)this.dao, data, (Element)elt);
            elt.setObjectID(0);
            elt.setOwner(data.getUserName());
            elt.setCreationDate(new Date());
        } else {
            BeanExecutionContext prev = (BeanExecutionContext)this.dao.getCore(elt.getName());
            this.checkOwnerEntity(data, prev);
            this.helper.checkSaveConcurrency(data, (Bean)elt, isImport, (Bean)prev);
        }
        this.checkOwnerEntity(data, elt);
        this.updateOids(elt);
        this.helper.updateDescKey((Bean)elt, false);
        this.helper.updateDescriptionMap((Bean)elt, data.getLocale());
        elt.setLastModificationDate(new Date());
        elt.setLastModifier(data.getUserName());
        String execCtxName = this.dao.getExecutionContextName(elt.getEntityOid(), elt.getWorkspaceOid(), elt.getProfile());
        if (execCtxName != null && !execCtxName.equals(elt.getName())) {
            throw ExceptionHelper.getInstance(data.getLocale()).createDashboardException("unicityExecutionContext", new String[]{execCtxName}, null);
        }
        this.helper.checkForSave(data, (Element)elt);
        this.dao.save((Element)elt);
    }

    @Override
    public void delete(String name, ExpressionEvaluationData data) throws DashboardException {
        BeanExecutionContext elt = this.helper.get((Dao)this.dao, name, 1, BeanExecutionContext.class);
        this.checkOwnerEntity(data, elt);
        if (data.getExecutionContextOid().intValue() == elt.getObjectID()) {
            throw new SecurityException();
        }
        if (elt.getSystem()) {
            throw ExceptionHelper.getInstance(data.getLocale()).createDashboardException("cannotDeleteSystemObject", null, null);
        }
        this.helper.checkForDelete(this.getDependencyDefinitionList((Bean)elt), data, (Element)elt);
        this.dao.delete((Element)elt);
    }

    private ParameterResponse get(Integer instanceType, String name, ExpressionEvaluationData data) throws DashboardException {
        BeanExecutionContext elt = this.helper.get((Dao)this.dao, name, instanceType, BeanExecutionContext.class);
        this.updateNames(elt);
        return this.helper.getResponse((I18nElement)elt, data, SessionParameterType.EXECUTION_CONTEXT);
    }

    private void updateNames(BeanExecutionContext bean) throws DashboardException {
        bean.setEntityName(this.getName(SessionParameterType.ENTITY, bean.getEntityOid()));
        bean.setWorkspaceName(this.getName(SessionParameterType.WORKSPACE, bean.getWorkspaceOid()));
    }

    private void updateOids(BeanExecutionContext bean) throws DashboardException {
        bean.setEntityOid(this.getOid(SessionParameterType.ENTITY, bean.getEntityName()));
        bean.setWorkspaceOid(this.getOid(SessionParameterType.WORKSPACE, bean.getWorkspaceName()));
    }

    private void checkOwnerEntity(ExpressionEvaluationData data, BeanExecutionContext elt) throws DashboardException {
        if (!this.entityHelper.isChild(data.getEntityOid(), elt.getEntityOid())) {
            throw new SecurityException();
        }
    }

    private ParameterResponse getCopy(String name, ExpressionEvaluationData data) throws DashboardException {
        if (name == null) {
            throw new DashboardException();
        }
        BeanExecutionContext elt = (BeanExecutionContext)this.dao.getDefinition(name);
        this.helper.updateForCopy((Bean)elt);
        this.helper.updateDescKey((Bean)elt, true);
        elt.setEntityOid(data.getEntityOid().intValue());
        elt.setProfile(data.getProfile().intValue());
        elt.setCreationDate(new Date());
        elt.setOwner(data.getUserName());
        elt.setLastModificationDate(new Date());
        elt.setLastModifier(data.getUserName());
        return this.helper.getResponse((I18nElement)elt, data, SessionParameterType.EXECUTION_CONTEXT);
    }

    @Override
    public ParametersListResponse getResponse(ParametersListRequest value, ExpressionEvaluationData data) throws DashboardException {
        WorkspaceDao workspaceDao = this.daoFactory.getWorkspaceDao();
        try {
            int accessLevel = workspaceDao.getAccessLevelForEC(data.getExecutionContextOid().intValue(), SessionParameterType.EXECUTION_CONTEXT).getAccessLevel();
            if (accessLevel == 0) {
                boolean limitedAccess = workspaceDao.getLimitedAccessForUser(data.getUserOid().intValue(), data.getExecutionContextOid().intValue(), SessionParameterType.EXECUTION_CONTEXT);
                if (!limitedAccess) {
                    throw new SecurityException();
                }
                accessLevel = 1;
            }
            int instanceType = value.getBeanType() == null ? 1 : value.getBeanType();
            List<Element> eltList = this.list(value.getFilter(), instanceType, value.getSortedField(), value.getMaxSize(), data);
            return this.helper.list(eltList, value.getMaxSize(), false, SessionParameterType.EXECUTION_CONTEXT, accessLevel, data);
        }
        catch (Exception e) {
            throw this.getException(e);
        }
    }

    @Override
    public DependencyResponse getResponse(DependencyRequest value, ExpressionEvaluationData data) throws DashboardException {
        BeanExecutionContext elt = this.helper.get((Dao)this.dao, value.getName(), 1, BeanExecutionContext.class);
        List<DependencyGroup> dependencies = this.getDependencies((Bean)elt, data);
        return this.helper.getResponse((Bean)elt, dependencies, data, SessionParameterType.EXECUTION_CONTEXT);
    }

    @Override
    public List<Element> list(DefaultFilter defaultFilter, int instanceType, ParametersListRequest.SortedField sort, Integer maxSize, ExpressionEvaluationData data) throws DashboardException {
        DbExecutionContextFilter filter = this.helper.getFilter(defaultFilter, data, DbExecutionContextFilter.class);
        List eltList = this.dao.listAll((DbDefaultFilter)filter, instanceType, sort, maxSize);
        for (Element elt : eltList) {
            this.updateNames((BeanExecutionContext)elt);
        }
        return eltList;
    }

    @Override
    public List<DependencyGroup> getDependencies(Bean elt, ExpressionEvaluationData data) throws DashboardException {
        return this.helper.getDependencies(this.getDependencyDefinitionList(elt), data);
    }

    private List<DependencyDefinition> getDependencyDefinitionList(Bean elt) {
        Integer objectID = elt.getObjectID();
        ArrayList<DependencyDefinition> list = new ArrayList<DependencyDefinition>();
        DbUserFilter userFilter = new DbUserFilter();
        userFilter.setExecutionContextOid(objectID);
        list.add(new DependencyDefinition((DbDefaultFilter)userFilter, SessionParameterType.USER));
        return list;
    }

    public static ExecutionContextHelper getInstance(DaoFactory daoFactory) {
        return new ExecutionContextHelper(daoFactory);
    }

    public BeanExecutionContext getDefinition(String name) throws DashboardException {
        BeanExecutionContext bean = this.helper.get((Dao)this.dao, name, 2, BeanExecutionContext.class);
        this.updateNames(bean);
        return bean;
    }

    @Override
    public List<Element> getReferences(int objectID, ExpressionEvaluationData data) {
        ArrayList<Element> l = new ArrayList<Element>();
        Integer oid = objectID;
        DbEntityFilter entityFilter = new DbEntityFilter();
        entityFilter.setOwnerEntityOid(data.getEntityOid());
        entityFilter.setSelectForDisplayType(5);
        entityFilter.setUsedByExecutionContext(oid);
        EntityDao entityDao = this.daoFactory.getEntityDao();
        l.addAll(entityDao.listAll((DbDefaultFilter)entityFilter, 1));
        DbWorkspaceFilter workspaceFilter = new DbWorkspaceFilter();
        workspaceFilter.setOwnerEntityOid(data.getEntityOid());
        workspaceFilter.setSelectForDisplayType(5);
        workspaceFilter.setUsedByExecutionContext(oid);
        WorkspaceDao workspaceDao = this.daoFactory.getWorkspaceDao();
        l.addAll(workspaceDao.listAll((DbDefaultFilter)workspaceFilter, 1));
        return l;
    }
}

