/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.model.helper;

import com.prelytis.dashboard.dao.Dao;
import com.prelytis.dashboard.dao.DaoFactory;
import com.prelytis.dashboard.dao.ExternSessionDao;
import com.prelytis.dashboard.dao.QueryDao;
import com.prelytis.dashboard.dao.WorkspaceDao;
import com.prelytis.dashboard.dao.filter.DbDashboardFilter;
import com.prelytis.dashboard.dao.filter.DbDefaultFilter;
import com.prelytis.dashboard.dao.filter.DbExternSessionFilter;
import com.prelytis.dashboard.dao.filter.DbLinkFilter;
import com.prelytis.dashboard.dao.filter.DbQueryFilter;
import com.prelytis.dashboard.data.helper.EngineHelper;
import com.prelytis.dashboard.data.transformation.DataTransformer;
import com.prelytis.dashboard.data.transformation.ResultsetDataReader;
import com.prelytis.dashboard.data.transformation.ValueListDataHandler;
import com.prelytis.dashboard.db.sql.Result;
import com.prelytis.dashboard.interfaces.DashboardException;
import com.prelytis.dashboard.interfaces.Element;
import com.prelytis.dashboard.interfaces.I18nElement;
import com.prelytis.dashboard.interfaces.SecurityException;
import com.prelytis.dashboard.interfaces.SessionParameterType;
import com.prelytis.dashboard.interfaces.SessionType;
import com.prelytis.dashboard.model.helper.Dependency;
import com.prelytis.dashboard.model.helper.DependencyDefinition;
import com.prelytis.dashboard.model.helper.ParameterHelper;
import com.prelytis.dashboard.model.helper.References;
import com.prelytis.dashboard.model.helper.SystemSessionGroup;
import com.prelytis.dashboard.model.helper.WorkspaceHelper;
import com.prelytis.dashboard.util.ExpressionEvaluationHelper;
import com.prelytis.dashboard.value.DependencyGroup;
import com.prelytis.dashboard.value.DependencyRequest;
import com.prelytis.dashboard.value.DependencyResponse;
import com.prelytis.dashboard.value.ParameterRequest;
import com.prelytis.dashboard.value.ParameterResponse;
import com.prelytis.dashboard.value.ParametersListRequest;
import com.prelytis.dashboard.value.ParametersListResponse;
import com.prelytis.dashboard.value.data.Bean;
import com.prelytis.dashboard.value.data.BeanExtSession;
import com.prelytis.dashboard.value.data.BeanExtSessionDefinition;
import com.prelytis.dashboard.value.data.BeanExtSessionParameter;
import com.prelytis.dashboard.value.data.BeanQuerySQL;
import com.prelytis.dashboard.value.data.ReportFilter;
import com.prelytis.dashboard.value.data.ValueListElt;
import com.prelytis.dashboard.value.data.filter.DefaultFilter;
import com.prelytis.dashboard.value.util.Expression;
import com.prelytis.dashboard.value.util.ExpressionEvaluationData;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;

public final class ExtSessionHelper
extends ParameterHelper
implements Dependency,
References {
    private final ExternSessionDao dao;

    ExtSessionHelper(DaoFactory daoFactory) {
        super(daoFactory);
        this.dao = this.daoFactory.getExternSessionDao();
    }

    public static ExtSessionHelper getInstance(DaoFactory daoFactory) {
        return new ExtSessionHelper(daoFactory);
    }

    @Override
    public ParameterResponse getResponse(ParameterRequest value, ExpressionEvaluationData data) throws DashboardException {
        Integer instanceType = value.getInstanceType();
        ParameterRequest.Action action = value.getAction() == null ? ParameterRequest.Action.OPEN : value.getAction();
        switch (action) {
            case OPEN: 
            case OPEN_AS_SUPER_USER: {
                return this.get(instanceType, value.getName(), data);
            }
            case COPY: {
                return this.getCopy(value.getName(), data);
            }
            case DELETE: {
                return this.getDelete(value.getName(), (Bean)((BeanExtSession)value.getElement()), data);
            }
            case SAVE_AS_NEW: {
                return this.getSaveAsNew((BeanExtSessionDefinition)value.getElement(), data);
            }
            case SAVE: {
                return this.getSave((BeanExtSessionDefinition)value.getElement(), data);
            }
            case NEW: {
                return this.getNew(data);
            }
        }
        throw new DashboardException();
    }

    @Override
    public void delete(String name, ExpressionEvaluationData data) throws DashboardException {
        BeanExtSession elt = this.helper.get((Dao)this.dao, name, 1, BeanExtSession.class);
        this.helper.checkForDelete(this.getDependencyDefinitionList((Bean)elt), data, (Element)elt);
        this.dao.delete((Element)elt);
    }

    private ParameterResponse getNew(ExpressionEvaluationData data) throws DashboardException {
        return this.helper.getResponse((I18nElement)this.create(data), data, SessionParameterType.EXTERN_SESSION);
    }

    public BeanExtSessionDefinition create(ExpressionEvaluationData data) throws DashboardException {
        BeanExtSessionDefinition elt = new BeanExtSessionDefinition();
        this.updateDescKeys(elt, false);
        elt.setCreationDate(new Date());
        elt.setOwner(data.getUserName());
        elt.setLastModificationDate(new Date());
        elt.setLastModifier(data.getUserName());
        return elt;
    }

    private ParameterResponse get(Integer instanceType, String name, ExpressionEvaluationData data) throws DashboardException {
        BeanExtSession elt = this.helper.get((Dao)this.dao, name, instanceType, BeanExtSession.class);
        this.updateNames(elt);
        return this.helper.getResponse((I18nElement)elt, data, SessionParameterType.EXTERN_SESSION);
    }

    private ParameterResponse getSaveAsNew(BeanExtSessionDefinition elt, ExpressionEvaluationData data) throws DashboardException {
        this.save(elt, data, true);
        return this.helper.getResponse((I18nElement)elt, data, SessionParameterType.EXTERN_SESSION);
    }

    private ParameterResponse getSave(BeanExtSessionDefinition elt, ExpressionEvaluationData data) throws DashboardException {
        this.save(elt, data, false);
        return this.helper.getResponse((I18nElement)elt, data, SessionParameterType.EXTERN_SESSION);
    }

    public void save(BeanExtSessionDefinition elt, ExpressionEvaluationData data, boolean isNew) throws DashboardException {
        this.save(elt, data, isNew, false);
    }

    public void save(BeanExtSessionDefinition elt, ExpressionEvaluationData data, boolean isNew, boolean isImport) throws DashboardException {
        this.helper.checkForSave((Dao)this.dao, data, (Bean)elt, isNew, isImport);
        this.updateOids((BeanExtSession)elt);
        this.updateDescKeys(elt, false);
        this.updateDescriptionMap(elt, this.helper.getLocales(), data.getLocale());
        elt.setLastModificationDate(new Date());
        elt.setLastModifier(data.getUserName());
        this.helper.checkForSave(data, (Element)elt);
        this.dao.save((Element)elt);
        this.saveExtCompInHiddenNode(elt, data);
    }

    private void saveExtCompInHiddenNode(BeanExtSessionDefinition elt, ExpressionEvaluationData data) throws DashboardException {
        WorkspaceHelper workspaceHelper = new WorkspaceHelper(this.daoFactory);
        workspaceHelper.addSession(data.getWorkspaceOid(), SessionType.EXTERN, elt.getObjectID(), SystemSessionGroup.HIDDEN.getOid(), true, data.getLocale());
    }

    private void updateDescriptionMap(BeanExtSessionDefinition elt, List<Locale> locales, Locale defaultLocale) {
        this.helper.updateDescriptionMap((Bean)elt, locales, defaultLocale);
        for (BeanExtSessionParameter param : elt.getParameterList()) {
            this.helper.updateDescriptionMap(param.getDescriptionMap(), locales, defaultLocale);
        }
    }

    private ParameterResponse getCopy(String name, ExpressionEvaluationData data) throws DashboardException {
        if (name == null) {
            throw new DashboardException();
        }
        BeanExtSessionDefinition elt = (BeanExtSessionDefinition)this.dao.getDefinition(name);
        this.helper.updateForCopy((Bean)elt);
        this.helper.updateDescKey((Bean)elt, true);
        elt.setCreationDate(new Date());
        elt.setOwner(data.getUserName());
        elt.setLastModificationDate(new Date());
        elt.setLastModifier(data.getUserName());
        for (BeanExtSessionParameter param : elt.getParameterList()) {
            param.setDescriptionKey(this.guidFactory.generateGUID((Object)param));
        }
        return this.helper.getResponse((I18nElement)elt, data, SessionParameterType.EXTERN_SESSION);
    }

    private void updateNames(BeanExtSession bean) throws DashboardException {
        if (!(bean instanceof BeanExtSessionDefinition)) {
            return;
        }
        BeanExtSessionDefinition elt = (BeanExtSessionDefinition)bean;
        for (BeanExtSessionParameter param : elt.getParameterList()) {
            if (param.getValueListOID() == 0) continue;
            param.setValueListName(this.getName(SessionParameterType.QUERY, param.getValueListOID()));
        }
    }

    private void updateDescKeys(BeanExtSessionDefinition elt, boolean replace) {
        this.helper.updateDescKey((Bean)elt, replace);
        for (BeanExtSessionParameter param : elt.getParameterList()) {
            if (!replace && !this.helper.isInvalidDescKey(param.getDescriptionKey())) continue;
            param.setDescriptionKey(this.guidFactory.generateGUID((Object)param));
        }
    }

    private void updateOids(BeanExtSession bean) throws DashboardException {
        if (!(bean instanceof BeanExtSessionDefinition)) {
            return;
        }
        BeanExtSessionDefinition elt = (BeanExtSessionDefinition)bean;
        Iterator iterator = elt.getParameterList().iterator();
        while (iterator.hasNext()) {
            BeanExtSessionParameter param;
            Integer valueListOid = this.optOid(SessionParameterType.QUERY, (param = (BeanExtSessionParameter)iterator.next()).getValueListName());
            param.setValueListOID(valueListOid == null ? 0 : valueListOid);
        }
    }

    @Override
    public ParametersListResponse getResponse(ParametersListRequest value, ExpressionEvaluationData data) throws DashboardException {
        WorkspaceDao workspaceDao = this.daoFactory.getWorkspaceDao();
        try {
            int accessLevel = workspaceDao.getAccessLevelForEC(data.getExecutionContextOid().intValue(), SessionParameterType.EXTERN_SESSION).getAccessLevel();
            if (accessLevel == 0) {
                boolean limitedAccess = workspaceDao.getLimitedAccessForUser(data.getUserOid().intValue(), data.getExecutionContextOid().intValue(), SessionParameterType.EXTERN_SESSION);
                if (!limitedAccess) {
                    throw new SecurityException();
                }
                accessLevel = 1;
            }
            int instanceType = value.getBeanType() == null ? 1 : value.getBeanType();
            List<Element> eltList = this.list(value.getFilter(), instanceType, value.getSortedField(), value.getMaxSize(), data);
            return this.helper.list(eltList, value.getMaxSize(), false, SessionParameterType.EXTERN_SESSION, accessLevel, data);
        }
        catch (Exception e) {
            throw this.getException(e);
        }
    }

    @Override
    public DependencyResponse getResponse(DependencyRequest value, ExpressionEvaluationData data) throws DashboardException {
        BeanExtSession elt = this.helper.get((Dao)this.dao, value.getName(), 1, BeanExtSession.class);
        List<DependencyGroup> dependencies = this.getDependencies((Bean)elt, data);
        return this.helper.getResponse((Bean)elt, dependencies, data, SessionParameterType.EXTERN_SESSION);
    }

    public BeanExtSessionDefinition getDefinition(String name) throws DashboardException {
        BeanExtSessionDefinition elt = this.helper.get((Dao)this.dao, name, 2, BeanExtSessionDefinition.class);
        this.updateNames((BeanExtSession)elt);
        return elt;
    }

    public List<ReportFilter> getLinkableFilterList(List<BeanExtSessionParameter> parameterList, List<? extends ReportFilter> filterList, ExpressionEvaluationData data) throws DashboardException {
        return this.getFilterList(parameterList, filterList, true, data);
    }

    public List<ReportFilter> getVisibleFilterList(List<BeanExtSessionParameter> parameterList, List<? extends ReportFilter> filterList, ExpressionEvaluationData data) throws DashboardException {
        return this.getFilterList(parameterList, filterList, false, data);
    }

    private List<ReportFilter> getFilterList(List<BeanExtSessionParameter> parameterList, List<? extends ReportFilter> filterList, boolean linkable, ExpressionEvaluationData data) throws DashboardException {
        ExpressionEvaluationHelper helper = ExpressionEvaluationHelper.getInstance();
        HashMap<String, ReportFilter> map = new HashMap<String, ReportFilter>();
        if (filterList != null) {
            for (ReportFilter reportFilter : filterList) {
                map.put(reportFilter.getName(), reportFilter);
            }
        }
        ArrayList<ReportFilter> newFilterList = new ArrayList<ReportFilter>();
        for (BeanExtSessionParameter parameter : parameterList) {
            int queryOid;
            boolean add = linkable ? parameter.getLinkable() : parameter.getParameter() == '2';
            if (!add) continue;
            ReportFilter filter = new ReportFilter();
            filter.setName(parameter.getName());
            filter.setDescription((String)parameter.getDescriptionMap().get(data.getLocale()));
            filter.setDatatype(parameter.getDataType());
            filter.setLinkable(parameter.getLinkable());
            filter.setUseFilter(parameter.isUseFilter());
            filter.setValue(this.getValue(parameter.getDefaultValue(), helper, data));
            filter.setVisible(true);
            if (parameter.getValueListOID() != 0) {
                filter.setPromptType(2);
            } else {
                filter.setPromptType(1);
            }
            ReportFilter flt = (ReportFilter)map.get(filter.getName());
            if (flt != null) {
                filter.setValues(this.getValues(flt.getValues(), helper, data));
                filter.setUseFilter(flt.getUseFilter());
            }
            if ((queryOid = parameter.getValueListOID()) != 0) {
                List<ValueListElt> list = this.initValueList(filter, queryOid, data);
                filter.setValueList(list);
            }
            newFilterList.add(filter);
        }
        return newFilterList;
    }

    private Object[] getValues(Object[] values, ExpressionEvaluationHelper helper, ExpressionEvaluationData data) throws DashboardException {
        if (values == null) {
            return null;
        }
        Object[] resu = new Object[values.length];
        for (int i = 0; i < values.length; ++i) {
            resu[i] = this.getValue(values[i], helper, data);
        }
        return resu;
    }

    private Object getValue(Object value, ExpressionEvaluationHelper helper, ExpressionEvaluationData data) throws DashboardException {
        return value instanceof Expression ? helper.evaluateExpression((Expression)value, data) : value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ValueListElt> initValueList(ReportFilter filter, int queryOid, ExpressionEvaluationData data) throws DashboardException {
        List<ValueListElt> list;
        if (filter == null) {
            return null;
        }
        QueryDao queryDao = this.daoFactory.getQueryDao();
        BeanQuerySQL sqlQuery = (BeanQuerySQL)queryDao.getDefinition(queryOid);
        EngineHelper eh = EngineHelper.getInstance(this.daoFactory);
        Result result = eh.getResult(sqlQuery, data, null);
        try {
            ResultsetDataReader dataReader = new ResultsetDataReader(result);
            ValueListDataHandler dataHandler = new ValueListDataHandler("{0}", data.getLocale(), data.getTimeZone());
            DataTransformer transformer = new DataTransformer();
            transformer.transform(dataReader, dataHandler);
            list = dataHandler.getValueList();
        }
        catch (Throwable throwable) {
            try {
                result.close();
                throw throwable;
            }
            catch (Exception e) {
                throw this.getException(e);
            }
        }
        result.close();
        return list;
    }

    public BeanExtSession getCore(String name, ExpressionEvaluationData data) throws DashboardException {
        BeanExtSession elt = this.helper.get((Dao)this.dao, name, 1, BeanExtSession.class);
        return elt;
    }

    @Override
    public List<Element> list(DefaultFilter defaultFilter, int instanceType, ParametersListRequest.SortedField sort, Integer maxSize, ExpressionEvaluationData data) throws DashboardException {
        DbExternSessionFilter filter = this.helper.getFilter(defaultFilter, data, DbExternSessionFilter.class);
        List eltList = this.dao.listAll((DbDefaultFilter)filter, instanceType, sort, maxSize);
        for (Element elt : eltList) {
            this.updateNames((BeanExtSession)elt);
        }
        return eltList;
    }

    @Override
    public List<DependencyGroup> getDependencies(Bean elt, ExpressionEvaluationData data) throws DashboardException {
        return this.helper.getDependencies(this.getDependencyDefinitionList(elt), data);
    }

    private List<DependencyDefinition> getDependencyDefinitionList(Bean elt) {
        Integer objectID = elt.getObjectID();
        ArrayList<DependencyDefinition> list = new ArrayList<DependencyDefinition>();
        DbDashboardFilter dashboardFilter = new DbDashboardFilter();
        dashboardFilter.setExternSessionOid(objectID);
        list.add(new DependencyDefinition((DbDefaultFilter)dashboardFilter, SessionParameterType.DASHBOARD));
        DbLinkFilter linkFilter = new DbLinkFilter();
        linkFilter.setDstExternalSession(objectID);
        list.add(new DependencyDefinition((DbDefaultFilter)linkFilter, SessionParameterType.LINK));
        return list;
    }

    @Override
    public List<Element> getReferences(int objectID, ExpressionEvaluationData data) {
        ArrayList<Element> l = new ArrayList<Element>();
        Integer oid = objectID;
        DbQueryFilter queryFilter = new DbQueryFilter();
        queryFilter.setOwnerEntityOid(data.getEntityOid());
        queryFilter.setSelectForDisplayType(5);
        queryFilter.setUsedByExternSession(oid);
        QueryDao queryDao = this.daoFactory.getQueryDao();
        l.addAll(queryDao.listAll((DbDefaultFilter)queryFilter, 1));
        return l;
    }

    public BeanExtSession getCore(String name) throws DashboardException {
        BeanExtSession bean = this.helper.get((Dao)this.dao, name, 1, BeanExtSession.class);
        this.updateNames(bean);
        return bean;
    }
}

