/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.model.helper;

import com.prelytis.dashboard.dao.Dao;
import com.prelytis.dashboard.dao.DaoFactory;
import com.prelytis.dashboard.dao.EntityDao;
import com.prelytis.dashboard.dao.FolderDao;
import com.prelytis.dashboard.dao.ImportDao;
import com.prelytis.dashboard.dao.PrelytisInfoDao;
import com.prelytis.dashboard.dao.QueryDao;
import com.prelytis.dashboard.dao.WorkspaceDao;
import com.prelytis.dashboard.dao.WorldDao;
import com.prelytis.dashboard.dao.filter.DbDefaultFilter;
import com.prelytis.dashboard.dao.filter.DbEntityFilter;
import com.prelytis.dashboard.dao.filter.DbFolderFilter;
import com.prelytis.dashboard.dao.filter.DbImportFilter;
import com.prelytis.dashboard.dao.filter.DbQueryFilter;
import com.prelytis.dashboard.dao.filter.DbWorldFilter;
import com.prelytis.dashboard.interfaces.DashboardException;
import com.prelytis.dashboard.interfaces.Element;
import com.prelytis.dashboard.interfaces.I18nElement;
import com.prelytis.dashboard.interfaces.SecurityException;
import com.prelytis.dashboard.interfaces.SessionParameterType;
import com.prelytis.dashboard.model.helper.EntityHelper;
import com.prelytis.dashboard.model.helper.ParameterHelper;
import com.prelytis.dashboard.model.helper.References;
import com.prelytis.dashboard.value.ParameterRequest;
import com.prelytis.dashboard.value.ParameterResponse;
import com.prelytis.dashboard.value.ParametersListRequest;
import com.prelytis.dashboard.value.ParametersListResponse;
import com.prelytis.dashboard.value.data.Bean;
import com.prelytis.dashboard.value.data.BeanImport;
import com.prelytis.dashboard.value.data.BeanImportDefinition;
import com.prelytis.dashboard.value.data.OwnerEntity;
import com.prelytis.dashboard.value.data.filter.DefaultFilter;
import com.prelytis.dashboard.value.data.filter.ImportFilter;
import com.prelytis.dashboard.value.util.ExpressionEvaluationData;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public final class ImportHelper
extends ParameterHelper
implements References {
    private final EntityHelper entityHelper;
    private final boolean autoNameGeneration;
    private final ImportDao dao;

    ImportHelper(DaoFactory daoFactory) {
        super(daoFactory);
        this.dao = this.daoFactory.getImportDao();
        this.entityHelper = new EntityHelper(daoFactory);
        PrelytisInfoDao prelytisInfoDao = daoFactory.getPrelytisInfoDao();
        this.autoNameGeneration = prelytisInfoDao.isAutoNameGeneration();
    }

    @Override
    public ParameterResponse getResponse(ParameterRequest value, ExpressionEvaluationData data) throws DashboardException {
        Integer instanceType = value.getInstanceType();
        ParameterRequest.Action action = value.getAction() == null ? ParameterRequest.Action.OPEN : value.getAction();
        switch (action) {
            case OPEN: 
            case OPEN_AS_SUPER_USER: {
                return this.get(instanceType, value.getName(), data);
            }
            case COPY: {
                return this.getCopy(value.getName(), data);
            }
            case DELETE: {
                return this.getDelete(value.getName(), (Bean)((BeanImport)value.getElement()), data);
            }
            case SAVE_AS_NEW: {
                return this.getSaveAsNew((BeanImportDefinition)value.getElement(), data);
            }
            case SAVE: {
                return this.getSave((BeanImportDefinition)value.getElement(), data);
            }
            case NEW: {
                return this.getNew(data);
            }
        }
        throw new DashboardException();
    }

    @Override
    public void delete(String name, ExpressionEvaluationData data) throws DashboardException {
        BeanImport elt = this.helper.get((Dao)this.dao, name, 1, BeanImport.class);
        this.helper.checkOwnerEntity(this.entityHelper, data, (OwnerEntity)elt);
        this.helper.checkForDelete(null, data, (Element)elt);
        this.dao.delete((Element)elt);
    }

    private ParameterResponse getNew(ExpressionEvaluationData data) throws DashboardException {
        return this.helper.getResponse((I18nElement)this.create(data), data, SessionParameterType.IMPORT_TASK);
    }

    public BeanImportDefinition create(ExpressionEvaluationData data) throws DashboardException {
        BeanImportDefinition elt = new BeanImportDefinition();
        if (this.autoNameGeneration) {
            elt.setName(this.guidFactory.generateGUID((Object)elt));
        }
        this.helper.updateDescKey((Bean)elt, false);
        elt.setOwnerEntOID(data.getEntityOid().intValue());
        elt.setOwnerEntityName(data.getEntityName());
        elt.setCreationDate(new Date());
        elt.setOwner(data.getUserName());
        elt.setLastModificationDate(new Date());
        elt.setLastModifier(data.getUserName());
        return elt;
    }

    private ParameterResponse get(Integer instanceType, String name, ExpressionEvaluationData data) throws DashboardException {
        BeanImport elt = this.helper.get((Dao)this.dao, name, instanceType, BeanImport.class);
        this.updateNames(elt);
        return this.helper.getResponse((I18nElement)elt, data, SessionParameterType.IMPORT_TASK);
    }

    private ParameterResponse getSaveAsNew(BeanImportDefinition elt, ExpressionEvaluationData data) throws DashboardException {
        this.save(elt, data, true);
        return this.helper.getResponse((I18nElement)elt, data, SessionParameterType.IMPORT_TASK);
    }

    private ParameterResponse getSave(BeanImportDefinition elt, ExpressionEvaluationData data) throws DashboardException {
        this.save(elt, data, false);
        return this.helper.getResponse((I18nElement)elt, data, SessionParameterType.IMPORT_TASK);
    }

    public void save(BeanImportDefinition elt, ExpressionEvaluationData data, boolean isNew) throws DashboardException {
        this.save(elt, data, isNew, false);
    }

    public void save(BeanImportDefinition elt, ExpressionEvaluationData data, boolean isNew, boolean isImport) throws DashboardException {
        this.helper.checkDescriptionMap(elt.getDescriptionMap(), data.getLocale());
        this.helper.checkForSave((Dao)this.dao, data, (Bean)elt, isNew, isImport);
        this.updateOids((BeanImport)elt);
        this.helper.updateDescKey((Bean)elt, false);
        this.helper.updateDescriptionMap((Bean)elt, data.getLocale());
        elt.setLastModificationDate(new Date());
        elt.setLastModifier(data.getUserName());
        this.helper.checkOwnerEntity(this.entityHelper, data, (OwnerEntity)elt);
        this.helper.checkForSave(data, (Element)elt);
        this.dao.save((Element)elt);
    }

    private void updateNames(BeanImport bean) throws DashboardException {
        bean.setOwnerEntityName(this.getName(SessionParameterType.ENTITY, bean.getOwnerEntOID()));
        if (bean instanceof BeanImportDefinition) {
            BeanImportDefinition elt = (BeanImportDefinition)bean;
            elt.setWorldName(this.optName(SessionParameterType.WORLD, elt.getWorld()));
            elt.setQueryName(this.optName(SessionParameterType.QUERY, elt.getQueryOid()));
            elt.setFolderName(this.optName(SessionParameterType.FOLDER, elt.getFolderOid()));
        }
    }

    private void updateOids(BeanImport bean) throws DashboardException {
        bean.setOwnerEntOID(this.getOid(SessionParameterType.ENTITY, bean.getOwnerEntityName()));
        if (bean instanceof BeanImportDefinition) {
            BeanImportDefinition elt = (BeanImportDefinition)bean;
            if (elt.getWorldName() != null) {
                elt.setWorld(Integer.valueOf(this.getOid(SessionParameterType.WORLD, elt.getWorldName())));
            }
            if (elt.getQueryName() != null) {
                elt.setQueryOid(Integer.valueOf(this.getOid(SessionParameterType.QUERY, elt.getQueryName())));
            }
            if (elt.getFolderName() != null) {
                elt.setFolderOid(Integer.valueOf(this.getOid(SessionParameterType.FOLDER, elt.getFolderName())));
            }
        }
    }

    private ParameterResponse getCopy(String name, ExpressionEvaluationData data) throws DashboardException {
        if (name == null) {
            throw new DashboardException();
        }
        BeanImportDefinition elt = (BeanImportDefinition)this.dao.getDefinition(name);
        this.helper.updateForCopy((Bean)elt, this.autoNameGeneration);
        this.helper.updateDescKey((Bean)elt, true);
        elt.setOwnerEntOID(data.getEntityOid().intValue());
        elt.setOwnerEntityName(data.getEntityName());
        elt.setCreationDate(new Date());
        elt.setOwner(data.getUserName());
        elt.setLastModificationDate(new Date());
        elt.setLastModifier(data.getUserName());
        this.updateNames((BeanImport)elt);
        return this.helper.getResponse((I18nElement)elt, data, SessionParameterType.IMPORT_TASK);
    }

    @Override
    public ParametersListResponse getResponse(ParametersListRequest value, ExpressionEvaluationData data) throws DashboardException {
        WorkspaceDao workspaceDao = this.daoFactory.getWorkspaceDao();
        try {
            int accessLevel = workspaceDao.getAccessLevelForEC(data.getExecutionContextOid().intValue(), SessionParameterType.IMPORT_TASK).getAccessLevel();
            if (accessLevel == 0) {
                boolean limitedAccess = workspaceDao.getLimitedAccessForUser(data.getUserOid().intValue(), data.getExecutionContextOid().intValue(), SessionParameterType.IMPORT_TASK);
                if (!limitedAccess) {
                    throw new SecurityException();
                }
                accessLevel = 1;
            }
            int instanceType = value.getBeanType() == null ? 1 : value.getBeanType();
            List<Element> eltList = this.list(value.getFilter(), instanceType, value.getSortedField(), value.getMaxSize(), data);
            return this.helper.list(eltList, value.getMaxSize(), false, SessionParameterType.IMPORT_TASK, accessLevel, data);
        }
        catch (Exception e) {
            throw this.getException(e);
        }
    }

    @Override
    public List<Element> list(DefaultFilter defaultFilter, int instanceType, ParametersListRequest.SortedField sort, Integer maxSize, ExpressionEvaluationData data) throws DashboardException {
        DbImportFilter filter = this.helper.getFilter(defaultFilter, data, DbImportFilter.class);
        if (defaultFilter instanceof ImportFilter) {
            ImportFilter src = (ImportFilter)defaultFilter;
            filter.setQueryOid(this.optOid(SessionParameterType.QUERY, src.getQueryName()));
            filter.setWorldOid(this.optOid(SessionParameterType.WORLD, src.getWorldName()));
            filter.setFolderOid(this.optOid(SessionParameterType.FOLDER, src.getFolderName()));
        }
        List eltList = this.dao.listAll((DbDefaultFilter)filter, instanceType, sort, maxSize);
        if (instanceType != 1) {
            for (Element elt : eltList) {
                this.updateNames((BeanImport)elt);
            }
        }
        return eltList;
    }

    public static ImportHelper getInstance(DaoFactory daoFactory) {
        return new ImportHelper(daoFactory);
    }

    public BeanImportDefinition getDefinition(String name) throws DashboardException {
        BeanImportDefinition bean = this.helper.get((Dao)this.dao, name, 2, BeanImportDefinition.class);
        this.updateNames((BeanImport)bean);
        return bean;
    }

    @Override
    public List<Element> getReferences(int objectID, ExpressionEvaluationData data) {
        ArrayList<Element> l = new ArrayList<Element>();
        Integer oid = objectID;
        DbQueryFilter queryFilter = new DbQueryFilter();
        queryFilter.setOwnerEntityOid(data.getEntityOid());
        queryFilter.setSelectForDisplayType(5);
        queryFilter.setUsedByImport(oid);
        QueryDao queryDao = this.daoFactory.getQueryDao();
        l.addAll(queryDao.listAll((DbDefaultFilter)queryFilter, 1));
        DbFolderFilter folderFilter = new DbFolderFilter();
        folderFilter.setUsedByImport(oid);
        FolderDao folderDao = this.daoFactory.getFolderDao();
        l.addAll(folderDao.listAll((DbDefaultFilter)folderFilter, 1));
        DbWorldFilter worldFilter = new DbWorldFilter();
        worldFilter.setUsedByImport(oid);
        WorldDao worldDao = this.daoFactory.getWorldDao();
        l.addAll(worldDao.listAll((DbDefaultFilter)worldFilter, 1));
        DbEntityFilter entityFilter = new DbEntityFilter();
        entityFilter.setOwnerEntityOid(data.getEntityOid());
        entityFilter.setSelectForDisplayType(5);
        entityFilter.setUsedByForm(oid);
        EntityDao entityDao = this.daoFactory.getEntityDao();
        l.addAll(entityDao.listAll((DbDefaultFilter)entityFilter, 1));
        return l;
    }
}

