/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.model.helper;

import com.prelytis.dashboard.dao.Dao;
import com.prelytis.dashboard.dao.DaoFactory;
import com.prelytis.dashboard.dao.JdbcDriverDao;
import com.prelytis.dashboard.dao.SessionDao;
import com.prelytis.dashboard.dao.SqlFunctionDao;
import com.prelytis.dashboard.dao.SqlFunctionGroupDao;
import com.prelytis.dashboard.dao.SqlFunctionImplDao;
import com.prelytis.dashboard.dao.WorkspaceDao;
import com.prelytis.dashboard.dao.filter.DbDefaultFilter;
import com.prelytis.dashboard.dao.filter.DbJdbcDriverFilter;
import com.prelytis.dashboard.dao.filter.DbWorldFilter;
import com.prelytis.dashboard.interfaces.DashboardException;
import com.prelytis.dashboard.interfaces.Element;
import com.prelytis.dashboard.interfaces.I18nElement;
import com.prelytis.dashboard.interfaces.SecurityException;
import com.prelytis.dashboard.interfaces.SessionParameterType;
import com.prelytis.dashboard.model.helper.Dependency;
import com.prelytis.dashboard.model.helper.DependencyDefinition;
import com.prelytis.dashboard.model.helper.ParameterHelper;
import com.prelytis.dashboard.model.helper.SecurityHelper;
import com.prelytis.dashboard.value.DependencyGroup;
import com.prelytis.dashboard.value.DependencyRequest;
import com.prelytis.dashboard.value.DependencyResponse;
import com.prelytis.dashboard.value.ParameterRequest;
import com.prelytis.dashboard.value.ParameterResponse;
import com.prelytis.dashboard.value.ParametersListRequest;
import com.prelytis.dashboard.value.ParametersListResponse;
import com.prelytis.dashboard.value.data.Bean;
import com.prelytis.dashboard.value.data.BeanJDBCDriver;
import com.prelytis.dashboard.value.data.BeanJDBCDriverDefinition;
import com.prelytis.dashboard.value.data.BeanJDBCDriverSQLFunction;
import com.prelytis.dashboard.value.data.BeanJDBCDriverSQLFunctionGroup;
import com.prelytis.dashboard.value.data.BeanSQLFctImpl;
import com.prelytis.dashboard.value.data.BeanSQLFunction;
import com.prelytis.dashboard.value.data.BeanSQLFunctionGroup;
import com.prelytis.dashboard.value.data.BeanSession;
import com.prelytis.dashboard.value.data.SecurityAdapter;
import com.prelytis.dashboard.value.data.filter.DefaultFilter;
import com.prelytis.dashboard.value.data.filter.JdbcDriverFilter;
import com.prelytis.dashboard.value.util.ExpressionEvaluationData;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

public final class JdbcDriverHelper
extends ParameterHelper
implements Dependency {
    private final JdbcDriverDao dao;

    JdbcDriverHelper(DaoFactory daoFactory) {
        super(daoFactory);
        this.dao = this.daoFactory.getJdbcDriverDao();
    }

    @Override
    public ParameterResponse getResponse(ParameterRequest value, ExpressionEvaluationData data) throws DashboardException {
        ParameterRequest.Action action = value.getAction() == null ? ParameterRequest.Action.OPEN : value.getAction();
        switch (action) {
            case OPEN: 
            case OPEN_AS_SUPER_USER: {
                return this.get(value.getInstanceType(), value.getName(), data);
            }
            case COPY: {
                return this.getCopy(value.getName(), data);
            }
            case DELETE: {
                return this.getDelete(value.getName(), (Bean)((BeanJDBCDriver)value.getElement()), data);
            }
            case SAVE_AS_NEW: {
                return this.getSaveAsNew((BeanJDBCDriverDefinition)value.getElement(), data);
            }
            case SAVE: {
                return this.getSave((BeanJDBCDriverDefinition)value.getElement(), data);
            }
            case NEW: {
                return this.getNew(data);
            }
        }
        throw new DashboardException();
    }

    private ParameterResponse getNew(ExpressionEvaluationData data) throws DashboardException {
        return this.helper.getResponse((I18nElement)this.create(data), data, SessionParameterType.JDBC_DRIVER);
    }

    public BeanJDBCDriverDefinition create(ExpressionEvaluationData data) throws DashboardException {
        BeanJDBCDriverDefinition elt = new BeanJDBCDriverDefinition();
        this.helper.updateDescKey((Bean)elt, false);
        elt.setSqlStyleOID(1);
        elt.setCreationDate(new Date());
        elt.setOwner(data.getUserName());
        elt.setLastModificationDate(new Date());
        elt.setLastModifier(data.getUserName());
        this.updateNames((BeanJDBCDriver)elt);
        return elt;
    }

    private ParameterResponse getSaveAsNew(BeanJDBCDriverDefinition elt, ExpressionEvaluationData data) throws DashboardException {
        this.save(elt, data, true);
        return this.helper.getResponse((I18nElement)elt, data, SessionParameterType.JDBC_DRIVER);
    }

    private ParameterResponse getSave(BeanJDBCDriverDefinition elt, ExpressionEvaluationData data) throws DashboardException {
        this.save(elt, data, false);
        return this.helper.getResponse((I18nElement)elt, data, SessionParameterType.JDBC_DRIVER);
    }

    public void save(BeanJDBCDriverDefinition elt, ExpressionEvaluationData data, boolean isNew) throws DashboardException {
        this.save(elt, data, isNew, false);
    }

    public void save(BeanJDBCDriverDefinition elt, ExpressionEvaluationData data, boolean isNew, boolean isImport) throws DashboardException {
        this.helper.checkDescriptionMap(elt.getDescriptionMap(), data.getLocale());
        this.helper.checkForSave((Dao)this.dao, data, (Bean)elt, isNew, isImport);
        elt.setLastModificationDate(new Date());
        elt.setLastModifier(data.getUserName());
        this.updateOids((BeanJDBCDriver)elt);
        this.helper.updateDescKey((Bean)elt, false);
        this.helper.updateDescriptionMap((Bean)elt, data.getLocale());
        this.helper.checkForSave(data, (Element)elt);
        this.dao.save((Element)elt);
    }

    @Override
    public void delete(String name, ExpressionEvaluationData data) throws DashboardException {
        BeanJDBCDriver elt = this.helper.get((Dao)this.dao, name, 1, BeanJDBCDriver.class);
        this.helper.checkForDelete(this.getDependencyDefinitionList((Bean)elt), data, (Element)elt);
        this.dao.delete((Element)elt);
    }

    private ParameterResponse get(Integer instanceType, String name, ExpressionEvaluationData data) throws DashboardException {
        BeanJDBCDriver elt = this.helper.get((Dao)this.dao, name, instanceType, BeanJDBCDriver.class);
        try {
            elt.setExist(null != DriverManager.getDriver(elt.getUrl()));
        }
        catch (SQLException e) {
            elt.setExist(false);
        }
        this.updateNames(elt);
        return this.helper.getResponse((I18nElement)elt, data, SessionParameterType.JDBC_DRIVER);
    }

    private void updateNames(BeanJDBCDriver elt) throws DashboardException {
        if (elt instanceof BeanJDBCDriverDefinition) {
            BeanJDBCDriverDefinition bean = (BeanJDBCDriverDefinition)elt;
            bean.setSqlStyleName(this.getName(SessionParameterType.SQL_STYLE, bean.getSqlStyleOID()));
            this.remapUsingOids(bean);
        }
    }

    private void updateOids(BeanJDBCDriver elt) throws DashboardException {
        if (elt instanceof BeanJDBCDriverDefinition) {
            BeanJDBCDriverDefinition bean = (BeanJDBCDriverDefinition)elt;
            bean.setSqlStyleOID(this.getOid(SessionParameterType.SQL_STYLE, bean.getSqlStyleName()));
            this.remapUsingNames(bean);
        }
    }

    private void remapUsingOids(BeanJDBCDriverDefinition elt) {
        HashMap<Integer, BeanJDBCDriverSQLFunction> functionMap = new HashMap<Integer, BeanJDBCDriverSQLFunction>();
        for (BeanJDBCDriverSQLFunctionGroup group : elt.getSqlFunctionGroupList()) {
            for (BeanJDBCDriverSQLFunction f : group.getSQLFunctionList()) {
                functionMap.put(f.getSqlFunctionOid(), f);
            }
        }
        List<BeanJDBCDriverSQLFunctionGroup> groups = this.getGroups();
        for (BeanJDBCDriverSQLFunctionGroup group : groups) {
            block3: for (BeanJDBCDriverSQLFunction f : group.getSQLFunctionList()) {
                BeanJDBCDriverSQLFunction initial = (BeanJDBCDriverSQLFunction)functionMap.get(f.getSqlFunctionOid());
                if (initial == null) continue;
                for (BeanSQLFctImpl impl : f.getChoiceList()) {
                    if (!impl.getName().equals(initial.getSqlFunctionImplName())) continue;
                    f.setSqlFunctionImplName(impl.getName());
                    f.setSqlFunctionImplOid(Integer.valueOf(impl.getObjectID()));
                    continue block3;
                }
            }
        }
        elt.getSqlFunctionGroupList().clear();
        elt.getSqlFunctionGroupList().addAll(groups);
    }

    private void remapUsingNames(BeanJDBCDriverDefinition elt) {
        HashMap<String, BeanJDBCDriverSQLFunction> functionMap = new HashMap<String, BeanJDBCDriverSQLFunction>();
        for (BeanJDBCDriverSQLFunctionGroup group : elt.getSqlFunctionGroupList()) {
            for (BeanJDBCDriverSQLFunction f : group.getSQLFunctionList()) {
                functionMap.put(f.getSqlFunctionName(), f);
            }
        }
        List<BeanJDBCDriverSQLFunctionGroup> groups = this.getGroups();
        for (BeanJDBCDriverSQLFunctionGroup group : groups) {
            block3: for (BeanJDBCDriverSQLFunction f : group.getSQLFunctionList()) {
                BeanJDBCDriverSQLFunction initial = (BeanJDBCDriverSQLFunction)functionMap.get(f.getSqlFunctionName());
                if (initial == null) continue;
                for (BeanSQLFctImpl impl : f.getChoiceList()) {
                    if (!impl.getName().equals(initial.getSqlFunctionImplName())) continue;
                    f.setSqlFunctionImplName(impl.getName());
                    f.setSqlFunctionImplOid(Integer.valueOf(impl.getObjectID()));
                    continue block3;
                }
            }
        }
        elt.getSqlFunctionGroupList().clear();
        elt.getSqlFunctionGroupList().addAll(groups);
    }

    private List<BeanJDBCDriverSQLFunctionGroup> getGroups() {
        SqlFunctionGroupDao groupDao = this.daoFactory.getSqlFunctionGroupDao();
        List<BeanSQLFunctionGroup> groups = this.asList(groupDao.listAll(null, 1), BeanSQLFunctionGroup.class);
        HashMap<Integer, BeanJDBCDriverSQLFunctionGroup> groupMap = new HashMap<Integer, BeanJDBCDriverSQLFunctionGroup>();
        for (BeanSQLFunctionGroup group : groups) {
            BeanJDBCDriverSQLFunctionGroup grp = new BeanJDBCDriverSQLFunctionGroup((Element)group);
            groupMap.put(group.getObjectID(), grp);
        }
        SqlFunctionImplDao implDao = this.daoFactory.getSqlFunctionImplDao();
        List<BeanSQLFctImpl> implList = this.asList(implDao.listAll(null, 1), BeanSQLFctImpl.class);
        HashMap<Object, ArrayList<BeanSQLFctImpl>> implMap = new HashMap<Object, ArrayList<BeanSQLFctImpl>>();
        for (BeanSQLFctImpl impl : implList) {
            Integer sqlFunctionOid = impl.getSqlFunctionOID();
            ArrayList<BeanSQLFctImpl> list = (ArrayList<BeanSQLFctImpl>)implMap.get(sqlFunctionOid);
            if (list == null) {
                list = new ArrayList<BeanSQLFctImpl>();
                implMap.put(sqlFunctionOid, list);
            }
            list.add(impl);
        }
        SqlFunctionDao functionDao = this.daoFactory.getSqlFunctionDao();
        List<BeanSQLFunction> functions = this.asList(functionDao.listAll(null, 1), BeanSQLFunction.class);
        for (BeanSQLFunction function : functions) {
            BeanJDBCDriverSQLFunctionGroup group = (BeanJDBCDriverSQLFunctionGroup)groupMap.get(function.getSQLFunctionGroupOID());
            if (group == null) continue;
            function.setSqlFunctionGroupName(group.getName());
            List list = (List)implMap.get(function.getObjectID());
            if (list == null) continue;
            BeanJDBCDriverSQLFunction fct = new BeanJDBCDriverSQLFunction();
            fct.setSqlFunctionOid(function.getObjectID());
            fct.setSqlFunctionName(function.getName());
            fct.getDescriptionMap().putAll(function.getDescriptionMap());
            fct.getChoiceList().addAll(list);
            group.getSQLFunctionList().add(fct);
        }
        ArrayList<BeanJDBCDriverSQLFunctionGroup> finalGroups = new ArrayList<BeanJDBCDriverSQLFunctionGroup>();
        for (BeanJDBCDriverSQLFunctionGroup group : groupMap.values()) {
            if (group.getSQLFunctionList().isEmpty()) continue;
            finalGroups.add(group);
        }
        return finalGroups;
    }

    private ParameterResponse getCopy(String name, ExpressionEvaluationData data) throws DashboardException {
        if (name == null) {
            throw new DashboardException();
        }
        BeanJDBCDriverDefinition elt = (BeanJDBCDriverDefinition)this.dao.getDefinition(name);
        this.helper.updateForCopy((Bean)elt);
        this.helper.updateDescKey((Bean)elt, true);
        this.updateNames((BeanJDBCDriver)elt);
        elt.setCreationDate(new Date());
        elt.setOwner(data.getUserName());
        elt.setLastModificationDate(new Date());
        elt.setLastModifier(data.getUserName());
        return this.helper.getResponse((I18nElement)elt, data, SessionParameterType.JDBC_DRIVER);
    }

    @Override
    public ParametersListResponse getResponse(ParametersListRequest value, ExpressionEvaluationData data) throws DashboardException {
        SessionParameterType sessionParameterType = value.getSessionParameterType();
        WorkspaceDao workspaceDao = this.daoFactory.getWorkspaceDao();
        try {
            int accessLevel = workspaceDao.getAccessLevelForEC(data.getExecutionContextOid().intValue(), sessionParameterType).getAccessLevel();
            if (accessLevel == 0) {
                boolean limitedAccess = workspaceDao.getLimitedAccessForUser(data.getUserOid().intValue(), data.getExecutionContextOid().intValue(), sessionParameterType);
                if (!limitedAccess) {
                    throw new SecurityException();
                }
                accessLevel = 1;
            }
            ArrayList<SecurityAdapter> list = null;
            SecurityHelper securityHelper = SecurityHelper.getInstance(this.daoFactory);
            int instanceType = value.getBeanType() == null ? 1 : value.getBeanType();
            List<Element> elementList = this.list(value.getFilter(), instanceType, value.getSortedField(), value.getMaxSize(), data);
            ParametersListResponse response = new ParametersListResponse();
            if (elementList != null) {
                int m;
                if (value.getMaxSize() != null && (m = value.getMaxSize().intValue()) > 0 && elementList.size() > m) {
                    elementList.subList(m, elementList.size()).clear();
                    response.setTruncatedData(true);
                }
                list = new ArrayList<SecurityAdapter>();
                for (int i = elementList.size() - 1; i >= 0; --i) {
                    SecurityAdapter sa;
                    Bean elt = (Bean)elementList.get(i);
                    if (elt instanceof BeanJDBCDriver) {
                        BeanJDBCDriver d = (BeanJDBCDriver)elt;
                        try {
                            Class.forName(d.getDriverClassName());
                            d.setExist(null != DriverManager.getDriver(d.getUrl()));
                        }
                        catch (Exception e) {
                            d.setExist(false);
                        }
                    }
                    if (!(sa = securityHelper.create((I18nElement)elt, data, accessLevel)).isRead()) continue;
                    list.add(sa);
                }
            }
            SessionDao sessionDao = this.daoFactory.getSessionDao();
            BeanSession session = sessionDao.getSession(sessionParameterType);
            response.setDescription((String)session.getDescriptionMap().get(data.getLocale()));
            response.setList(list);
            response.setAccessLevel(Integer.valueOf(accessLevel));
            return response;
        }
        catch (Exception e) {
            throw this.getException(e);
        }
    }

    @Override
    public DependencyResponse getResponse(DependencyRequest value, ExpressionEvaluationData data) throws DashboardException {
        BeanJDBCDriver elt = this.helper.get((Dao)this.daoFactory.getJdbcDriverDao(), value.getName(), 1, BeanJDBCDriver.class);
        List<DependencyGroup> dependencies = this.getDependencies((Bean)elt, data);
        return this.helper.getResponse((Bean)elt, dependencies, data, SessionParameterType.JDBC_DRIVER);
    }

    @Override
    public List<Element> list(DefaultFilter defaultFilter, int instanceType, ParametersListRequest.SortedField sort, Integer maxSize, ExpressionEvaluationData data) throws DashboardException {
        DbJdbcDriverFilter filter = this.helper.getFilter(defaultFilter, data, DbJdbcDriverFilter.class);
        if (defaultFilter instanceof JdbcDriverFilter) {
            JdbcDriverFilter src = (JdbcDriverFilter)defaultFilter;
            filter.setSqlFunctionImplOid(this.optOid(SessionParameterType.SQL_FUNCTION_IMPL, src.getSqlFunctionImplName()));
            filter.setSqlFunctionOid(this.optOid(SessionParameterType.SQL_FUNCTION, src.getSqlFunctionImplName()));
        }
        List eltList = this.dao.listAll((DbDefaultFilter)filter, instanceType, sort, maxSize);
        return eltList;
    }

    @Override
    public List<DependencyGroup> getDependencies(Bean elt, ExpressionEvaluationData data) throws DashboardException {
        return this.helper.getDependencies(this.getDependencyDefinitionList(elt), data);
    }

    private List<DependencyDefinition> getDependencyDefinitionList(Bean elt) {
        Integer objectID = elt.getObjectID();
        ArrayList<DependencyDefinition> list = new ArrayList<DependencyDefinition>();
        DbWorldFilter worldFilter = new DbWorldFilter();
        worldFilter.setDriverOid(objectID);
        list.add(new DependencyDefinition((DbDefaultFilter)worldFilter, SessionParameterType.WORLD));
        return list;
    }

    public static JdbcDriverHelper getInstance(DaoFactory daoFactory) {
        return new JdbcDriverHelper(daoFactory);
    }

    public BeanJDBCDriverDefinition getDefinition(String name) throws DashboardException {
        BeanJDBCDriverDefinition bean = this.helper.get((Dao)this.dao, name, 2, BeanJDBCDriverDefinition.class);
        this.updateNames((BeanJDBCDriver)bean);
        return bean;
    }
}

