/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.model.helper;

import com.prelytis.dashboard.dao.Dao;
import com.prelytis.dashboard.dao.DaoFactory;
import com.prelytis.dashboard.dao.DashboardDao;
import com.prelytis.dashboard.dao.ExternSessionDao;
import com.prelytis.dashboard.dao.FormDao;
import com.prelytis.dashboard.dao.LinkDao;
import com.prelytis.dashboard.dao.PrelytisInfoDao;
import com.prelytis.dashboard.dao.ReportDao;
import com.prelytis.dashboard.dao.WorkspaceDao;
import com.prelytis.dashboard.dao.filter.DbDashboardFilter;
import com.prelytis.dashboard.dao.filter.DbDefaultFilter;
import com.prelytis.dashboard.dao.filter.DbExternSessionFilter;
import com.prelytis.dashboard.dao.filter.DbFormFilter;
import com.prelytis.dashboard.dao.filter.DbLinkFilter;
import com.prelytis.dashboard.dao.filter.DbReportFilter;
import com.prelytis.dashboard.helper.ExceptionHelper;
import com.prelytis.dashboard.interfaces.DashboardException;
import com.prelytis.dashboard.interfaces.Element;
import com.prelytis.dashboard.interfaces.ErrorCode;
import com.prelytis.dashboard.interfaces.I18nElement;
import com.prelytis.dashboard.interfaces.SecurityException;
import com.prelytis.dashboard.interfaces.SessionParameterType;
import com.prelytis.dashboard.model.helper.EntityHelper;
import com.prelytis.dashboard.model.helper.ParameterHelper;
import com.prelytis.dashboard.model.helper.References;
import com.prelytis.dashboard.model.helper.ReportHelper;
import com.prelytis.dashboard.value.ParameterRequest;
import com.prelytis.dashboard.value.ParameterResponse;
import com.prelytis.dashboard.value.ParametersListRequest;
import com.prelytis.dashboard.value.ParametersListResponse;
import com.prelytis.dashboard.value.data.AbstractBeanReport;
import com.prelytis.dashboard.value.data.Bean;
import com.prelytis.dashboard.value.data.BeanLink;
import com.prelytis.dashboard.value.data.BeanLinkDefinition;
import com.prelytis.dashboard.value.data.BeanReportCrossTable;
import com.prelytis.dashboard.value.data.BeanReportDataUsedField;
import com.prelytis.dashboard.value.data.BeanReportStd;
import com.prelytis.dashboard.value.data.BeanReportStdUsedField;
import com.prelytis.dashboard.value.data.OwnerEntity;
import com.prelytis.dashboard.value.data.filter.DefaultFilter;
import com.prelytis.dashboard.value.data.filter.LinkFilter;
import com.prelytis.dashboard.value.data.filter.ReportFilter;
import com.prelytis.dashboard.value.util.ExpressionEvaluationData;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public final class LinkHelper
extends ParameterHelper
implements References {
    private final EntityHelper entityHelper;
    private final boolean autoNameGeneration;
    private final LinkDao dao;

    LinkHelper(DaoFactory daoFactory) {
        super(daoFactory);
        this.dao = this.daoFactory.getLinkDao();
        this.entityHelper = new EntityHelper(daoFactory);
        PrelytisInfoDao prelytisInfoDao = daoFactory.getPrelytisInfoDao();
        this.autoNameGeneration = prelytisInfoDao.isAutoNameGeneration();
    }

    public static LinkHelper getInstance(DaoFactory daoFactory) {
        return new LinkHelper(daoFactory);
    }

    @Override
    public ParameterResponse getResponse(ParameterRequest value, ExpressionEvaluationData data) throws DashboardException {
        Integer instanceType = value.getInstanceType();
        ParameterRequest.Action action = value.getAction() == null ? ParameterRequest.Action.OPEN : value.getAction();
        switch (action) {
            case OPEN: 
            case OPEN_AS_SUPER_USER: {
                return this.get(instanceType, value.getName(), data);
            }
            case COPY: {
                return this.getCopy(value.getName(), data);
            }
            case DELETE: {
                return this.getDelete(value.getName(), (Bean)((BeanLink)value.getElement()), data);
            }
            case SAVE_AS_NEW: {
                return this.getSaveAsNew((BeanLinkDefinition)value.getElement(), data);
            }
            case SAVE: {
                return this.getSave((BeanLinkDefinition)value.getElement(), data);
            }
            case NEW: {
                return this.getNew(data);
            }
        }
        throw new DashboardException();
    }

    @Override
    public void delete(String name, ExpressionEvaluationData data) throws DashboardException {
        BeanLink elt = this.helper.get((Dao)this.dao, name, 1, BeanLink.class);
        this.helper.checkOwnerEntity(this.entityHelper, data, (OwnerEntity)elt);
        this.helper.checkForDelete(null, data, (Element)elt);
        this.dao.delete((Element)elt);
    }

    private ParameterResponse getNew(ExpressionEvaluationData data) throws DashboardException {
        return this.helper.getResponse((I18nElement)this.create(data), data, SessionParameterType.LINK);
    }

    public BeanLinkDefinition create(ExpressionEvaluationData data) throws DashboardException {
        BeanLinkDefinition elt = new BeanLinkDefinition();
        if (this.autoNameGeneration) {
            elt.setName(this.guidFactory.generateGUID((Object)elt));
        }
        this.helper.updateDescKey((Bean)elt, false);
        ReportHelper reportHelper = ReportHelper.getInstance(this.daoFactory);
        ReportFilter reportFilter = new ReportFilter();
        reportFilter.setOwnerEntityName(data.getEntityName());
        reportFilter.setSelectForDisplayType(7);
        List<Element> list = reportHelper.list((DefaultFilter)reportFilter, 2, null, 1, data);
        if (list.isEmpty()) {
            throw ExceptionHelper.getInstance(data.getLocale()).createDashboardException(ErrorCode.INSIGHT_LINK_NO_REPORT_FOUND, null, null, null);
        }
        AbstractBeanReport report = (AbstractBeanReport)list.get(0);
        elt.setSrcReportOID(report.getObjectID());
        elt.setSrcReportName(report.getName());
        elt.setDstReportOID(Integer.valueOf(report.getObjectID()));
        elt.setDstReportName(report.getName());
        if (report instanceof BeanReportStd) {
            BeanReportStd std = (BeanReportStd)report;
            if (!std.getFieldList().isEmpty()) {
                elt.setLinkedFieldName(((BeanReportStdUsedField)std.getFieldList().get(0)).getName());
            }
        } else {
            BeanReportCrossTable ct = (BeanReportCrossTable)report;
            if (!ct.getDataFieldList().isEmpty()) {
                elt.setLinkedFieldName(((BeanReportDataUsedField)ct.getDataFieldList().get(0)).getName());
            }
        }
        elt.setOwnerEntOID(data.getEntityOid().intValue());
        elt.setOwnerEntityName(data.getEntityName());
        elt.setCreationDate(new Date());
        elt.setOwner(data.getUserName());
        elt.setLastModificationDate(new Date());
        elt.setLastModifier(data.getUserName());
        return elt;
    }

    private ParameterResponse get(Integer instanceType, String name, ExpressionEvaluationData data) throws DashboardException {
        BeanLink elt = this.helper.get((Dao)this.dao, name, instanceType, BeanLink.class);
        this.updateNames(elt);
        return this.helper.getResponse((I18nElement)elt, data, SessionParameterType.LINK);
    }

    private ParameterResponse getSaveAsNew(BeanLinkDefinition elt, ExpressionEvaluationData data) throws DashboardException {
        this.save(elt, data, true);
        return this.helper.getResponse((I18nElement)elt, data, SessionParameterType.LINK);
    }

    private ParameterResponse getSave(BeanLinkDefinition elt, ExpressionEvaluationData data) throws DashboardException {
        this.save(elt, data, false);
        return this.helper.getResponse((I18nElement)elt, data, SessionParameterType.LINK);
    }

    public void save(BeanLinkDefinition elt, ExpressionEvaluationData data, boolean isNew) throws DashboardException {
        this.save(elt, data, isNew, false);
    }

    public void save(BeanLinkDefinition elt, ExpressionEvaluationData data, boolean isNew, boolean isImport) throws DashboardException {
        this.helper.checkDescriptionMap(elt.getDescriptionMap(), data.getLocale());
        this.helper.checkForSave((Dao)this.dao, data, (Bean)elt, isNew, isImport);
        this.updateOids((BeanLink)elt);
        this.helper.updateDescKey((Bean)elt, false);
        this.helper.updateDescriptionMap((Bean)elt, data.getLocale());
        elt.setLastModificationDate(new Date());
        elt.setLastModifier(data.getUserName());
        this.helper.checkOwnerEntity(this.entityHelper, data, (OwnerEntity)elt);
        this.helper.checkForSave(data, (Element)elt);
        this.dao.save((Element)elt);
    }

    private void updateNames(BeanLink bean) throws DashboardException {
        bean.setOwnerEntityName(this.getName(SessionParameterType.ENTITY, bean.getOwnerEntOID()));
        if (bean instanceof BeanLinkDefinition) {
            BeanLinkDefinition elt = (BeanLinkDefinition)bean;
            elt.setDstDashBoardName(this.optName(SessionParameterType.DASHBOARD, elt.getDstDashBoardOID()));
            elt.setDstExtSessionName(this.optName(SessionParameterType.EXTERN_SESSION, elt.getDstExtSessionOID()));
            elt.setDstFormName(this.optName(SessionParameterType.FORM, elt.getDstFormOID()));
            elt.setDstReportName(this.optName(SessionParameterType.REPORT, elt.getDstReportOID()));
            elt.setSrcReportName(this.getName(SessionParameterType.REPORT, elt.getSrcReportOID()));
        }
    }

    private void updateOids(BeanLink bean) throws DashboardException {
        bean.setOwnerEntOID(this.getOid(SessionParameterType.ENTITY, bean.getOwnerEntityName()));
        if (bean instanceof BeanLinkDefinition) {
            BeanLinkDefinition elt = (BeanLinkDefinition)bean;
            elt.setDstDashBoardOID(this.optOid(SessionParameterType.DASHBOARD, elt.getDstDashBoardName()));
            elt.setDstExtSessionOID(this.optOid(SessionParameterType.EXTERN_SESSION, elt.getDstExtSessionName()));
            elt.setDstFormOID(this.optOid(SessionParameterType.FORM, elt.getDstFormName()));
            elt.setDstReportOID(this.optOid(SessionParameterType.REPORT, elt.getDstReportName()));
            elt.setSrcReportOID(this.getOid(SessionParameterType.REPORT, elt.getSrcReportName()));
        }
    }

    private ParameterResponse getCopy(String name, ExpressionEvaluationData data) throws DashboardException {
        if (name == null) {
            throw new DashboardException();
        }
        BeanLinkDefinition elt = (BeanLinkDefinition)this.dao.getDefinition(name);
        this.helper.updateForCopy((Bean)elt, this.autoNameGeneration);
        this.helper.updateDescKey((Bean)elt, true);
        elt.setOwnerEntOID(data.getEntityOid().intValue());
        this.updateNames((BeanLink)elt);
        elt.setCreationDate(new Date());
        elt.setOwner(data.getUserName());
        elt.setLastModificationDate(new Date());
        elt.setLastModifier(data.getUserName());
        return this.helper.getResponse((I18nElement)elt, data, SessionParameterType.LINK);
    }

    @Override
    public ParametersListResponse getResponse(ParametersListRequest value, ExpressionEvaluationData data) throws DashboardException {
        WorkspaceDao workspaceDao = this.daoFactory.getWorkspaceDao();
        try {
            int accessLevel = workspaceDao.getAccessLevelForEC(data.getExecutionContextOid().intValue(), SessionParameterType.LINK).getAccessLevel();
            if (accessLevel == 0) {
                boolean limitedAccess = workspaceDao.getLimitedAccessForUser(data.getUserOid().intValue(), data.getExecutionContextOid().intValue(), SessionParameterType.LINK);
                if (!limitedAccess) {
                    throw new SecurityException();
                }
                accessLevel = 1;
            }
            int instanceType = value.getBeanType() == null ? 1 : value.getBeanType();
            List<Element> eltList = this.list(value.getFilter(), instanceType, value.getSortedField(), value.getMaxSize(), data);
            return this.helper.list(eltList, value.getMaxSize(), false, SessionParameterType.LINK, accessLevel, data);
        }
        catch (Exception e) {
            throw this.getException(e);
        }
    }

    @Override
    public List<Element> list(DefaultFilter defaultFilter, int instanceType, ParametersListRequest.SortedField sort, Integer maxSize, ExpressionEvaluationData data) throws DashboardException {
        DbLinkFilter filter = this.helper.getFilter(defaultFilter, data, DbLinkFilter.class);
        if (defaultFilter instanceof LinkFilter) {
            LinkFilter src = (LinkFilter)defaultFilter;
            if (src.getDstDashboard() != null && !src.getDstDashboard().isEmpty()) {
                filter.setDstDashboard(Integer.valueOf(this.getOid(SessionParameterType.DASHBOARD, src.getDstDashboard())));
            }
            if (src.getDstExternalSession() != null && !src.getDstExternalSession().isEmpty()) {
                filter.setDstExternalSession(Integer.valueOf(this.getOid(SessionParameterType.EXTERN_SESSION, src.getDstExternalSession())));
            }
            if (src.getDstForm() != null && !src.getDstForm().isEmpty()) {
                filter.setDstForm(Integer.valueOf(this.getOid(SessionParameterType.FORM, src.getDstForm())));
            }
            if (src.getDstReport() != null && !src.getDstReport().isEmpty()) {
                filter.setDstReport(Integer.valueOf(this.getOid(SessionParameterType.REPORT, src.getDstReport())));
            }
            if (src.getReportName() != null && !src.getReportName().isEmpty()) {
                filter.setReportOid(Integer.valueOf(this.getOid(SessionParameterType.REPORT, src.getReportName())));
            }
        }
        return this.list(filter, instanceType, sort, maxSize, data);
    }

    public List<Element> list(DbLinkFilter filter, int instanceType, ParametersListRequest.SortedField sort, Integer maxSize, ExpressionEvaluationData data) throws DashboardException {
        List eltList = this.dao.listAll((DbDefaultFilter)filter, instanceType, sort, maxSize);
        if (instanceType != 1) {
            for (Element elt : eltList) {
                this.updateNames((BeanLink)elt);
            }
        }
        return eltList;
    }

    public BeanLinkDefinition getDefinition(String name) throws DashboardException {
        BeanLinkDefinition bean = this.helper.get((Dao)this.dao, name, 2, BeanLinkDefinition.class);
        this.updateNames((BeanLink)bean);
        return bean;
    }

    @Override
    public List<Element> getReferences(int objectID, ExpressionEvaluationData data) {
        ArrayList<Element> l = new ArrayList<Element>();
        Integer oid = objectID;
        DbReportFilter reportFilter = new DbReportFilter();
        reportFilter.setOwnerEntityOid(data.getEntityOid());
        reportFilter.setSelectForDisplayType(5);
        reportFilter.setUsedByLink(oid);
        ReportDao reportDao = this.daoFactory.getReportDao();
        l.addAll(reportDao.listAll((DbDefaultFilter)reportFilter, 1));
        DbDashboardFilter dashboardFilter = new DbDashboardFilter();
        dashboardFilter.setOwnerEntityOid(data.getEntityOid());
        dashboardFilter.setSelectForDisplayType(5);
        dashboardFilter.setUsedByLink(oid);
        DashboardDao dashboardDao = this.daoFactory.getDashboardDao();
        l.addAll(dashboardDao.listAll((DbDefaultFilter)dashboardFilter, 1));
        DbExternSessionFilter externSessionFilter = new DbExternSessionFilter();
        externSessionFilter.setUsedByLink(oid);
        ExternSessionDao externSessionDao = this.daoFactory.getExternSessionDao();
        l.addAll(externSessionDao.listAll((DbDefaultFilter)externSessionFilter, 1));
        DbFormFilter formFilter = new DbFormFilter();
        formFilter.setOwnerEntityOid(data.getEntityOid());
        formFilter.setSelectForDisplayType(5);
        formFilter.setUsedByLink(oid);
        FormDao FormDao2 = this.daoFactory.getFormDao();
        l.addAll(FormDao2.listAll((DbDefaultFilter)formFilter, 1));
        return l;
    }
}

