/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.model.helper;

import com.prelytis.dashboard.dao.Dao;
import com.prelytis.dashboard.dao.DaoFactory;
import com.prelytis.dashboard.dao.MaintenancePeriodDao;
import com.prelytis.dashboard.dao.WorkspaceDao;
import com.prelytis.dashboard.dao.filter.DbDefaultFilter;
import com.prelytis.dashboard.dao.filter.DbMaintenancePeriodFilter;
import com.prelytis.dashboard.helper.ExceptionHelper;
import com.prelytis.dashboard.interfaces.DashboardException;
import com.prelytis.dashboard.interfaces.Element;
import com.prelytis.dashboard.interfaces.I18nElement;
import com.prelytis.dashboard.interfaces.SecurityException;
import com.prelytis.dashboard.interfaces.SessionParameterType;
import com.prelytis.dashboard.model.helper.ParameterHelper;
import com.prelytis.dashboard.value.ParameterRequest;
import com.prelytis.dashboard.value.ParameterResponse;
import com.prelytis.dashboard.value.ParametersListRequest;
import com.prelytis.dashboard.value.ParametersListResponse;
import com.prelytis.dashboard.value.data.Bean;
import com.prelytis.dashboard.value.data.BeanMaintenancePeriod;
import com.prelytis.dashboard.value.data.filter.DefaultFilter;
import com.prelytis.dashboard.value.data.filter.MaintenancePeriodFilter;
import com.prelytis.dashboard.value.util.ExpressionEvaluationData;
import java.util.Date;
import java.util.List;

public final class MaintenancePeriodHelper
extends ParameterHelper {
    private final MaintenancePeriodDao dao;

    MaintenancePeriodHelper(DaoFactory daoFactory) {
        super(daoFactory);
        this.dao = this.daoFactory.getMaintenancePeriodDao();
    }

    @Override
    public ParameterResponse getResponse(ParameterRequest value, ExpressionEvaluationData data) throws DashboardException {
        ParameterRequest.Action action = value.getAction() == null ? ParameterRequest.Action.OPEN : value.getAction();
        switch (action) {
            case OPEN: 
            case OPEN_AS_SUPER_USER: {
                return this.get(value.getInstanceType(), value.getName(), data);
            }
            case COPY: {
                return this.getCopy(value.getName(), data);
            }
            case DELETE: {
                return this.getDelete(value.getName(), (Bean)((BeanMaintenancePeriod)value.getElement()), data);
            }
            case SAVE_AS_NEW: {
                return this.getSaveAsNew((BeanMaintenancePeriod)value.getElement(), data);
            }
            case SAVE: {
                return this.getSave((BeanMaintenancePeriod)value.getElement(), data);
            }
            case NEW: {
                return this.getNew(data);
            }
        }
        throw new DashboardException();
    }

    private ParameterResponse getNew(ExpressionEvaluationData data) throws DashboardException {
        return this.helper.getResponse((I18nElement)this.create(data), data, SessionParameterType.MAINTENANCE_PERIOD);
    }

    public BeanMaintenancePeriod create(ExpressionEvaluationData data) throws DashboardException {
        BeanMaintenancePeriod elt = new BeanMaintenancePeriod();
        this.helper.updateDescKey((Bean)elt, false);
        elt.setCreationDate(new Date());
        elt.setOwner(data.getUserName());
        elt.setLastModificationDate(new Date());
        elt.setLastModifier(data.getUserName());
        return elt;
    }

    private ParameterResponse getSaveAsNew(BeanMaintenancePeriod elt, ExpressionEvaluationData data) throws DashboardException {
        this.save(elt, data, true);
        return this.helper.getResponse((I18nElement)elt, data, SessionParameterType.MAINTENANCE_PERIOD);
    }

    private ParameterResponse getSave(BeanMaintenancePeriod elt, ExpressionEvaluationData data) throws DashboardException {
        this.save(elt, data, false);
        return this.helper.getResponse((I18nElement)elt, data, SessionParameterType.MAINTENANCE_PERIOD);
    }

    public void save(BeanMaintenancePeriod elt, ExpressionEvaluationData data, boolean isNew) throws DashboardException {
        this.save(elt, data, isNew, false);
    }

    public void save(BeanMaintenancePeriod elt, ExpressionEvaluationData data, boolean isNew, boolean isImport) throws DashboardException {
        this.helper.checkDescriptionMap(elt.getDescriptionMap(), data.getLocale());
        this.helper.checkForSave((Dao)this.dao, data, (Bean)elt, isNew, isImport);
        this.helper.updateDescKey((Bean)elt, false);
        this.helper.updateDescriptionMap((Bean)elt, data.getLocale());
        elt.setLastModificationDate(new Date());
        elt.setLastModifier(data.getUserName());
        if (elt.getStartDate() != null && elt.getEndDate() != null && elt.getStartDate().after(elt.getEndDate())) {
            throw ExceptionHelper.getInstance(data.getLocale()).createDashboardException("startEndDateOrder", null, null);
        }
        this.helper.checkForSave(data, (Element)elt);
        this.dao.save((Element)elt);
    }

    @Override
    public void delete(String name, ExpressionEvaluationData data) throws DashboardException {
        BeanMaintenancePeriod elt = this.helper.get((Dao)this.dao, name, 1, BeanMaintenancePeriod.class);
        this.helper.checkForDelete(null, data, (Element)elt);
        this.dao.delete((Element)elt);
    }

    private ParameterResponse get(Integer instanceType, String name, ExpressionEvaluationData data) throws DashboardException {
        BeanMaintenancePeriod elt = this.helper.get((Dao)this.dao, name, instanceType, BeanMaintenancePeriod.class);
        return this.helper.getResponse((I18nElement)elt, data, SessionParameterType.MAINTENANCE_PERIOD);
    }

    private ParameterResponse getCopy(String name, ExpressionEvaluationData data) throws DashboardException {
        BeanMaintenancePeriod elt = this.helper.get((Dao)this.dao, name, 2, BeanMaintenancePeriod.class);
        this.helper.updateForCopy((Bean)elt);
        this.helper.updateDescKey((Bean)elt, true);
        elt.setCreationDate(new Date());
        elt.setOwner(data.getUserName());
        elt.setLastModificationDate(new Date());
        elt.setLastModifier(data.getUserName());
        return this.helper.getResponse((I18nElement)elt, data, SessionParameterType.MAINTENANCE_PERIOD);
    }

    @Override
    public ParametersListResponse getResponse(ParametersListRequest value, ExpressionEvaluationData data) throws DashboardException {
        WorkspaceDao workspaceDao = this.daoFactory.getWorkspaceDao();
        try {
            int accessLevel = workspaceDao.getAccessLevelForEC(data.getExecutionContextOid().intValue(), SessionParameterType.MAINTENANCE_PERIOD).getAccessLevel();
            if (accessLevel == 0) {
                boolean limitedAccess = workspaceDao.getLimitedAccessForUser(data.getUserOid().intValue(), data.getExecutionContextOid().intValue(), SessionParameterType.MAINTENANCE_PERIOD);
                if (!limitedAccess) {
                    throw new SecurityException();
                }
                accessLevel = 1;
            }
            int instanceType = value.getBeanType() == null ? 1 : value.getBeanType();
            List<Element> eltList = this.list(value.getFilter(), instanceType, value.getSortedField(), value.getMaxSize(), data);
            return this.helper.list(eltList, value.getMaxSize(), false, SessionParameterType.MAINTENANCE_PERIOD, accessLevel, data);
        }
        catch (Exception e) {
            throw this.getException(e);
        }
    }

    @Override
    public List<Element> list(DefaultFilter defaultFilter, int instanceType, ParametersListRequest.SortedField sort, Integer maxSize, ExpressionEvaluationData data) {
        DbMaintenancePeriodFilter filter = this.helper.getFilter(defaultFilter, data, DbMaintenancePeriodFilter.class);
        if (defaultFilter instanceof MaintenancePeriodFilter) {
            MaintenancePeriodFilter src = (MaintenancePeriodFilter)defaultFilter;
            filter.setActive(src.getActive());
        }
        List eltList = this.dao.listAll((DbDefaultFilter)filter, instanceType, sort, maxSize);
        return eltList;
    }

    public static MaintenancePeriodHelper getInstance(DaoFactory daoFactory) {
        return new MaintenancePeriodHelper(daoFactory);
    }

    public BeanMaintenancePeriod getDefinition(String name) throws DashboardException {
        BeanMaintenancePeriod bean = this.helper.get((Dao)this.dao, name, 2, BeanMaintenancePeriod.class);
        return bean;
    }
}

