/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.model.helper;

import com.prelytis.dashboard.dao.Dao;
import com.prelytis.dashboard.dao.DaoFactory;
import com.prelytis.dashboard.dao.MessageProviderDao;
import com.prelytis.dashboard.dao.WorkspaceDao;
import com.prelytis.dashboard.dao.filter.DbDefaultFilter;
import com.prelytis.dashboard.dao.filter.DbMessageProviderFilter;
import com.prelytis.dashboard.interfaces.DashboardException;
import com.prelytis.dashboard.interfaces.Element;
import com.prelytis.dashboard.interfaces.I18nElement;
import com.prelytis.dashboard.interfaces.SecurityException;
import com.prelytis.dashboard.interfaces.SessionParameterType;
import com.prelytis.dashboard.model.helper.ParameterHelper;
import com.prelytis.dashboard.value.ParameterRequest;
import com.prelytis.dashboard.value.ParameterResponse;
import com.prelytis.dashboard.value.ParametersListRequest;
import com.prelytis.dashboard.value.ParametersListResponse;
import com.prelytis.dashboard.value.data.Bean;
import com.prelytis.dashboard.value.data.BeanMessageProv;
import com.prelytis.dashboard.value.data.BeanMessageProvDefinition;
import com.prelytis.dashboard.value.data.BeanMessageProvParam;
import com.prelytis.dashboard.value.data.filter.DefaultFilter;
import com.prelytis.dashboard.value.util.ExpressionEvaluationData;
import java.util.Date;
import java.util.List;
import java.util.Locale;

public final class MessageProviderHelper
extends ParameterHelper {
    private final MessageProviderDao dao;

    MessageProviderHelper(DaoFactory daoFactory) {
        super(daoFactory);
        this.dao = this.daoFactory.getMessageProviderDao();
    }

    @Override
    public ParameterResponse getResponse(ParameterRequest value, ExpressionEvaluationData data) throws DashboardException {
        ParameterRequest.Action action = value.getAction() == null ? ParameterRequest.Action.OPEN : value.getAction();
        switch (action) {
            case OPEN: 
            case OPEN_AS_SUPER_USER: {
                return this.get(value.getInstanceType(), value.getName(), data);
            }
            case COPY: {
                return this.getCopy(value.getName(), data);
            }
            case DELETE: {
                return this.getDelete(value.getName(), (Bean)((BeanMessageProv)value.getElement()), data);
            }
            case SAVE_AS_NEW: {
                return this.getSaveAsNew((BeanMessageProvDefinition)value.getElement(), data);
            }
            case SAVE: {
                return this.getSave((BeanMessageProvDefinition)value.getElement(), data);
            }
            case NEW: {
                return this.getNew(data);
            }
        }
        throw new DashboardException();
    }

    private ParameterResponse getNew(ExpressionEvaluationData data) throws DashboardException {
        return this.helper.getResponse((I18nElement)this.create(data), data, SessionParameterType.MESSAGE_PROVIDER);
    }

    public BeanMessageProvDefinition create(ExpressionEvaluationData data) throws DashboardException {
        BeanMessageProvDefinition elt = new BeanMessageProvDefinition();
        this.updateDescKeys(elt, false);
        elt.setCreationDate(new Date());
        elt.setOwner(data.getUserName());
        elt.setLastModificationDate(new Date());
        elt.setLastModifier(data.getUserName());
        return elt;
    }

    private ParameterResponse getSaveAsNew(BeanMessageProvDefinition elt, ExpressionEvaluationData data) throws DashboardException {
        this.save(elt, data, true);
        return this.helper.getResponse((I18nElement)elt, data, SessionParameterType.MESSAGE_PROVIDER);
    }

    private ParameterResponse getSave(BeanMessageProvDefinition elt, ExpressionEvaluationData data) throws DashboardException {
        this.save(elt, data, false);
        return this.helper.getResponse((I18nElement)elt, data, SessionParameterType.MESSAGE_PROVIDER);
    }

    public void save(BeanMessageProvDefinition elt, ExpressionEvaluationData data, boolean isNew) throws DashboardException {
        this.save(elt, data, isNew, false);
    }

    public void save(BeanMessageProvDefinition elt, ExpressionEvaluationData data, boolean isNew, boolean isImport) throws DashboardException {
        this.helper.checkForSave((Dao)this.dao, data, (Bean)elt, isNew, isImport);
        elt.setLastModificationDate(new Date());
        elt.setLastModifier(data.getUserName());
        this.updateDescKeys(elt, false);
        this.updateDescriptionMap(elt, this.helper.getLocales(), data.getLocale());
        this.helper.checkForSave(data, (Element)elt);
        this.dao.save((Element)elt);
    }

    private void updateDescriptionMap(BeanMessageProvDefinition elt, List<Locale> locales, Locale defaultLocale) {
        this.helper.updateDescriptionMap((Bean)elt, locales, defaultLocale);
        for (BeanMessageProvParam param : elt.getBeanMessageProvParamList()) {
            this.helper.updateDescriptionMap(param.getDescriptionMap(), locales, defaultLocale);
        }
    }

    @Override
    public void delete(String name, ExpressionEvaluationData data) throws DashboardException {
        BeanMessageProv elt = this.helper.get((Dao)this.dao, name, 1, BeanMessageProv.class);
        this.helper.checkForDelete(null, data, (Element)elt);
        this.dao.delete((Element)elt);
    }

    private ParameterResponse get(Integer instanceType, String name, ExpressionEvaluationData data) throws DashboardException {
        BeanMessageProv elt = this.helper.get((Dao)this.dao, name, instanceType, BeanMessageProv.class);
        return this.helper.getResponse((I18nElement)elt, data, SessionParameterType.MESSAGE_PROVIDER);
    }

    private ParameterResponse getCopy(String name, ExpressionEvaluationData data) throws DashboardException {
        BeanMessageProvDefinition elt = this.helper.get((Dao)this.dao, name, 2, BeanMessageProvDefinition.class);
        this.helper.updateForCopy((Bean)elt);
        this.updateDescKeys(elt, true);
        elt.setCreationDate(new Date());
        elt.setOwner(data.getUserName());
        elt.setLastModificationDate(new Date());
        elt.setLastModifier(data.getUserName());
        return this.helper.getResponse((I18nElement)elt, data, SessionParameterType.MESSAGE_PROVIDER);
    }

    private void updateDescKeys(BeanMessageProvDefinition elt, boolean replace) {
        this.helper.updateDescKey((Bean)elt, replace);
        for (BeanMessageProvParam param : elt.getBeanMessageProvParamList()) {
            if (!replace && !this.helper.isInvalidDescKey(param.getDescriptionKey())) continue;
            param.setDescriptionKey(this.guidFactory.generateGUID((Object)param));
        }
    }

    @Override
    public ParametersListResponse getResponse(ParametersListRequest value, ExpressionEvaluationData data) throws DashboardException {
        WorkspaceDao workspaceDao = this.daoFactory.getWorkspaceDao();
        try {
            int accessLevel = workspaceDao.getAccessLevelForEC(data.getExecutionContextOid().intValue(), SessionParameterType.MESSAGE_PROVIDER).getAccessLevel();
            if (accessLevel == 0) {
                boolean limitedAccess = workspaceDao.getLimitedAccessForUser(data.getUserOid().intValue(), data.getExecutionContextOid().intValue(), SessionParameterType.MESSAGE_PROVIDER);
                if (!limitedAccess) {
                    throw new SecurityException();
                }
                accessLevel = 1;
            }
            int instanceType = value.getBeanType() == null ? 1 : value.getBeanType();
            List<Element> eltList = this.list(value.getFilter(), instanceType, value.getSortedField(), value.getMaxSize(), data);
            return this.helper.list(eltList, value.getMaxSize(), false, SessionParameterType.MESSAGE_PROVIDER, accessLevel, data);
        }
        catch (Exception e) {
            throw this.getException(e);
        }
    }

    @Override
    public List<Element> list(DefaultFilter defaultFilter, int instanceType, ParametersListRequest.SortedField sort, Integer maxSize, ExpressionEvaluationData data) {
        DbMessageProviderFilter filter = this.helper.getFilter(defaultFilter, data, DbMessageProviderFilter.class);
        List eltList = this.dao.listAll((DbDefaultFilter)filter, instanceType, sort, maxSize);
        return eltList;
    }

    public static MessageProviderHelper getInstance(DaoFactory daoFactory) {
        return new MessageProviderHelper(daoFactory);
    }

    public BeanMessageProvDefinition getDefinition(String name) throws DashboardException {
        BeanMessageProvDefinition bean = this.helper.get((Dao)this.dao, name, 2, BeanMessageProvDefinition.class);
        return bean;
    }
}

