/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.model.helper;

import com.prelytis.dashboard.dao.Dao;
import com.prelytis.dashboard.dao.DaoFactory;
import com.prelytis.dashboard.dao.EntityDao;
import com.prelytis.dashboard.dao.LengthUnitDao;
import com.prelytis.dashboard.dao.PageDao;
import com.prelytis.dashboard.dao.PageLayoutDao;
import com.prelytis.dashboard.dao.WorkspaceDao;
import com.prelytis.dashboard.dao.filter.DbDashboardFilter;
import com.prelytis.dashboard.dao.filter.DbDefaultFilter;
import com.prelytis.dashboard.dao.filter.DbEntityFilter;
import com.prelytis.dashboard.dao.filter.DbLengthUnitFilter;
import com.prelytis.dashboard.dao.filter.DbPageFilter;
import com.prelytis.dashboard.dao.filter.DbPageLayoutFilter;
import com.prelytis.dashboard.dao.filter.DbReportFilter;
import com.prelytis.dashboard.interfaces.DashboardException;
import com.prelytis.dashboard.interfaces.Element;
import com.prelytis.dashboard.interfaces.I18nElement;
import com.prelytis.dashboard.interfaces.SecurityException;
import com.prelytis.dashboard.interfaces.SessionParameterType;
import com.prelytis.dashboard.model.helper.Dependency;
import com.prelytis.dashboard.model.helper.DependencyDefinition;
import com.prelytis.dashboard.model.helper.ParameterHelper;
import com.prelytis.dashboard.model.helper.References;
import com.prelytis.dashboard.value.DependencyGroup;
import com.prelytis.dashboard.value.DependencyRequest;
import com.prelytis.dashboard.value.DependencyResponse;
import com.prelytis.dashboard.value.ParameterRequest;
import com.prelytis.dashboard.value.ParameterResponse;
import com.prelytis.dashboard.value.ParametersListRequest;
import com.prelytis.dashboard.value.ParametersListResponse;
import com.prelytis.dashboard.value.data.Bean;
import com.prelytis.dashboard.value.data.BeanPageLayout;
import com.prelytis.dashboard.value.data.filter.DefaultFilter;
import com.prelytis.dashboard.value.data.filter.PageLayoutFilter;
import com.prelytis.dashboard.value.util.ExpressionEvaluationData;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public final class PageLayoutHelper
extends ParameterHelper
implements Dependency,
References {
    private final PageLayoutDao dao;

    PageLayoutHelper(DaoFactory daoFactory) {
        super(daoFactory);
        this.dao = this.daoFactory.getPageLayoutDao();
    }

    @Override
    public ParameterResponse getResponse(ParameterRequest value, ExpressionEvaluationData data) throws DashboardException {
        ParameterRequest.Action action = value.getAction() == null ? ParameterRequest.Action.OPEN : value.getAction();
        switch (action) {
            case OPEN: 
            case OPEN_AS_SUPER_USER: {
                return this.get(value.getInstanceType(), value.getName(), data);
            }
            case COPY: {
                return this.getCopy(value.getName(), data);
            }
            case DELETE: {
                return this.getDelete(value.getName(), (Bean)((BeanPageLayout)value.getElement()), data);
            }
            case SAVE_AS_NEW: {
                return this.getSaveAsNew((BeanPageLayout)value.getElement(), data);
            }
            case SAVE: {
                return this.getSave((BeanPageLayout)value.getElement(), data);
            }
            case NEW: {
                return this.getNew(data);
            }
        }
        throw new DashboardException();
    }

    private ParameterResponse getNew(ExpressionEvaluationData data) throws DashboardException {
        return this.helper.getResponse((I18nElement)this.create(data), data, SessionParameterType.PAGE_LAYOUT);
    }

    public BeanPageLayout create(ExpressionEvaluationData data) throws DashboardException {
        BeanPageLayout elt = new BeanPageLayout();
        this.helper.updateDescKey((Bean)elt, false);
        elt.setCreationDate(new Date());
        elt.setOwner(data.getUserName());
        elt.setOwnerEntOID(data.getEntityOid().intValue());
        elt.setOwnerEntityName(data.getEntityName());
        elt.setLastModificationDate(new Date());
        elt.setLastModifier(data.getUserName());
        return elt;
    }

    private ParameterResponse getSaveAsNew(BeanPageLayout elt, ExpressionEvaluationData data) throws DashboardException {
        this.save(elt, data, true);
        return this.helper.getResponse((I18nElement)elt, data, SessionParameterType.PAGE_LAYOUT);
    }

    private ParameterResponse getSave(BeanPageLayout elt, ExpressionEvaluationData data) throws DashboardException {
        this.save(elt, data, false);
        return this.helper.getResponse((I18nElement)elt, data, SessionParameterType.PAGE_LAYOUT);
    }

    public void save(BeanPageLayout elt, ExpressionEvaluationData data, boolean isNew) throws DashboardException {
        this.save(elt, data, isNew, false);
    }

    public void save(BeanPageLayout elt, ExpressionEvaluationData data, boolean isNew, boolean isImport) throws DashboardException {
        this.helper.checkForSave((Dao)this.dao, data, (Bean)elt, isNew, isImport);
        this.updateOids(elt);
        this.helper.updateDescKey((Bean)elt, false);
        this.helper.updateDescriptionMap((Bean)elt, data.getLocale());
        elt.setLastModificationDate(new Date());
        elt.setLastModifier(data.getUserName());
        this.helper.checkForSave(data, (Element)elt);
        this.dao.save((Element)elt);
    }

    @Override
    public void delete(String name, ExpressionEvaluationData data) throws DashboardException {
        BeanPageLayout elt = this.helper.get((Dao)this.dao, name, 1, BeanPageLayout.class);
        this.helper.checkForDelete(this.getDependencyDefinitionList((Bean)elt), data, (Element)elt);
        this.dao.delete((Element)elt);
    }

    private ParameterResponse get(Integer instanceType, String name, ExpressionEvaluationData data) throws DashboardException {
        BeanPageLayout elt = this.helper.get((Dao)this.dao, name, instanceType, BeanPageLayout.class);
        this.updateNames(elt);
        return this.helper.getResponse((I18nElement)elt, data, SessionParameterType.PAGE_LAYOUT);
    }

    private void updateNames(BeanPageLayout bean) throws DashboardException {
        bean.setOwnerEntityName(this.getName(SessionParameterType.ENTITY, bean.getOwnerEntOID()));
        bean.setPageName(this.optName(SessionParameterType.PAGE, bean.getPageOID()));
        bean.setLengthUnitName(this.getName(SessionParameterType.LENGTH_UNIT, bean.getLengthUnitOID()));
    }

    private void updateOids(BeanPageLayout bean) throws DashboardException {
        bean.setOwnerEntOID(this.getOid(SessionParameterType.ENTITY, bean.getOwnerEntityName()));
        bean.setPageOID(this.optOid(SessionParameterType.PAGE, bean.getPageName()));
        bean.setLengthUnitOID(this.getOid(SessionParameterType.LENGTH_UNIT, bean.getLengthUnitName()));
    }

    private ParameterResponse getCopy(String name, ExpressionEvaluationData data) throws DashboardException {
        BeanPageLayout elt = this.helper.get((Dao)this.dao, name, 2, BeanPageLayout.class);
        this.helper.updateForCopy((Bean)elt);
        this.helper.updateDescKey((Bean)elt, true);
        elt.setOwnerEntOID(data.getEntityOid().intValue());
        elt.setOwnerEntityName(data.getEntityName());
        elt.setCreationDate(new Date());
        elt.setOwner(data.getUserName());
        elt.setLastModificationDate(new Date());
        elt.setLastModifier(data.getUserName());
        return this.helper.getResponse((I18nElement)elt, data, SessionParameterType.PAGE_LAYOUT);
    }

    @Override
    public ParametersListResponse getResponse(ParametersListRequest value, ExpressionEvaluationData data) throws DashboardException {
        WorkspaceDao workspaceDao = this.daoFactory.getWorkspaceDao();
        try {
            int accessLevel = workspaceDao.getAccessLevelForEC(data.getExecutionContextOid().intValue(), SessionParameterType.PAGE_LAYOUT).getAccessLevel();
            if (accessLevel == 0) {
                boolean limitedAccess = workspaceDao.getLimitedAccessForUser(data.getUserOid().intValue(), data.getExecutionContextOid().intValue(), SessionParameterType.PAGE_LAYOUT);
                if (!limitedAccess) {
                    throw new SecurityException();
                }
                accessLevel = 1;
            }
            int instanceType = value.getBeanType() == null ? 1 : value.getBeanType();
            List<Element> eltList = this.list(value.getFilter(), instanceType, value.getSortedField(), value.getMaxSize(), data);
            return this.helper.list(eltList, value.getMaxSize(), false, SessionParameterType.PAGE_LAYOUT, accessLevel, data);
        }
        catch (Exception e) {
            throw this.getException(e);
        }
    }

    @Override
    public DependencyResponse getResponse(DependencyRequest value, ExpressionEvaluationData data) throws DashboardException {
        BeanPageLayout elt = this.helper.get((Dao)this.dao, value.getName(), 1, BeanPageLayout.class);
        List<DependencyGroup> dependencies = this.getDependencies((Bean)elt, data);
        return this.helper.getResponse((Bean)elt, dependencies, data, SessionParameterType.PAGE_LAYOUT);
    }

    @Override
    public List<Element> list(DefaultFilter defaultFilter, int instanceType, ParametersListRequest.SortedField sort, Integer maxSize, ExpressionEvaluationData data) throws DashboardException {
        DbPageLayoutFilter filter = this.helper.getFilter(defaultFilter, data, DbPageLayoutFilter.class);
        if (defaultFilter instanceof PageLayoutFilter) {
            PageLayoutFilter src = (PageLayoutFilter)defaultFilter;
            filter.setPageOid(this.optOid(SessionParameterType.PAGE, src.getPageName()));
        }
        List eltList = this.dao.listAll((DbDefaultFilter)filter, instanceType, sort, maxSize);
        for (Element elt : eltList) {
            this.updateNames((BeanPageLayout)elt);
        }
        return eltList;
    }

    @Override
    public List<DependencyGroup> getDependencies(Bean elt, ExpressionEvaluationData data) throws DashboardException {
        return this.helper.getDependencies(this.getDependencyDefinitionList(elt), data);
    }

    private List<DependencyDefinition> getDependencyDefinitionList(Bean elt) {
        Integer objectID = elt.getObjectID();
        ArrayList<DependencyDefinition> list = new ArrayList<DependencyDefinition>();
        DbReportFilter reportFilter = new DbReportFilter();
        reportFilter.setPageLayoutOid(objectID);
        list.add(new DependencyDefinition((DbDefaultFilter)reportFilter, SessionParameterType.REPORT));
        DbDashboardFilter dashboardFilter = new DbDashboardFilter();
        dashboardFilter.setPageLayoutOid(objectID);
        list.add(new DependencyDefinition((DbDefaultFilter)dashboardFilter, SessionParameterType.DASHBOARD));
        return list;
    }

    public static PageLayoutHelper getInstance(DaoFactory daoFactory) {
        return new PageLayoutHelper(daoFactory);
    }

    public BeanPageLayout getDefinition(String name) throws DashboardException {
        BeanPageLayout bean = this.helper.get((Dao)this.dao, name, 2, BeanPageLayout.class);
        this.updateNames(bean);
        return bean;
    }

    @Override
    public List<Element> getReferences(int objectID, ExpressionEvaluationData data) {
        ArrayList<Element> l = new ArrayList<Element>();
        Integer oid = objectID;
        DbLengthUnitFilter lengthUnitFilter = new DbLengthUnitFilter();
        lengthUnitFilter.setUsedByPageLayout(oid);
        LengthUnitDao lengthUnitDao = this.daoFactory.getLengthUnitDao();
        l.addAll(lengthUnitDao.listAll((DbDefaultFilter)lengthUnitFilter, 1));
        DbPageFilter pageFilter = new DbPageFilter();
        pageFilter.setUsedByPageLayout(oid);
        PageDao pageDao = this.daoFactory.getPageDao();
        l.addAll(pageDao.listAll((DbDefaultFilter)pageFilter, 1));
        DbEntityFilter entityFilter = new DbEntityFilter();
        entityFilter.setUsedByPageLayout(oid);
        EntityDao entityDao = this.daoFactory.getEntityDao();
        l.addAll(entityDao.listAll((DbDefaultFilter)entityFilter, 1));
        return l;
    }
}

