/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.model.helper;

import com.prelytis.dashboard.dao.Dao;
import com.prelytis.dashboard.dao.DaoFactory;
import com.prelytis.dashboard.dao.SessionGroupDao;
import com.prelytis.dashboard.dao.WorkspaceDao;
import com.prelytis.dashboard.dao.filter.DbDefaultFilter;
import com.prelytis.dashboard.dao.filter.DbSessionGroupFilter;
import com.prelytis.dashboard.dao.filter.DbWorkspaceFilter;
import com.prelytis.dashboard.interfaces.DashboardException;
import com.prelytis.dashboard.interfaces.Element;
import com.prelytis.dashboard.interfaces.I18nElement;
import com.prelytis.dashboard.interfaces.SecurityException;
import com.prelytis.dashboard.interfaces.SessionParameterType;
import com.prelytis.dashboard.model.helper.Dependency;
import com.prelytis.dashboard.model.helper.DependencyDefinition;
import com.prelytis.dashboard.model.helper.ParameterHelper;
import com.prelytis.dashboard.model.helper.References;
import com.prelytis.dashboard.value.DependencyGroup;
import com.prelytis.dashboard.value.DependencyRequest;
import com.prelytis.dashboard.value.DependencyResponse;
import com.prelytis.dashboard.value.ParameterRequest;
import com.prelytis.dashboard.value.ParameterResponse;
import com.prelytis.dashboard.value.ParametersListRequest;
import com.prelytis.dashboard.value.ParametersListResponse;
import com.prelytis.dashboard.value.data.Bean;
import com.prelytis.dashboard.value.data.BeanSessionGroup;
import com.prelytis.dashboard.value.data.filter.DefaultFilter;
import com.prelytis.dashboard.value.data.filter.SessionGroupFilter;
import com.prelytis.dashboard.value.util.ExpressionEvaluationData;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public final class SessionGroupHelper
extends ParameterHelper
implements Dependency,
References {
    private final SessionGroupDao dao;

    SessionGroupHelper(DaoFactory daoFactory) {
        super(daoFactory);
        this.dao = this.daoFactory.getSessionGroupDao();
    }

    @Override
    public ParameterResponse getResponse(ParameterRequest value, ExpressionEvaluationData data) throws DashboardException {
        Integer instanceType = value.getInstanceType();
        ParameterRequest.Action action = value.getAction() == null ? ParameterRequest.Action.OPEN : value.getAction();
        switch (action) {
            case OPEN: 
            case OPEN_AS_SUPER_USER: {
                return this.get(instanceType, value.getName(), data);
            }
            case COPY: {
                return this.getCopy(value.getName(), data);
            }
            case DELETE: {
                return this.getDelete(value.getName(), (Bean)((BeanSessionGroup)value.getElement()), data);
            }
            case SAVE_AS_NEW: {
                return this.getSaveAsNew((BeanSessionGroup)value.getElement(), data);
            }
            case SAVE: {
                return this.getSave((BeanSessionGroup)value.getElement(), data);
            }
            case NEW: {
                return this.getNew(data);
            }
        }
        throw new DashboardException();
    }

    @Override
    public void delete(String name, ExpressionEvaluationData data) throws DashboardException {
        BeanSessionGroup elt = this.helper.get((Dao)this.dao, name, 1, BeanSessionGroup.class);
        this.helper.checkForDelete(this.getDependencyDefinitionList((Bean)elt), data, (Element)elt);
        this.dao.delete((Element)elt);
    }

    private ParameterResponse getNew(ExpressionEvaluationData data) throws DashboardException {
        return this.helper.getResponse((I18nElement)this.create(data), data, SessionParameterType.SESSION_GROUP);
    }

    public BeanSessionGroup create(ExpressionEvaluationData data) throws DashboardException {
        BeanSessionGroup elt = new BeanSessionGroup();
        this.helper.updateDescKey((Bean)elt, false);
        elt.setCreationDate(new Date());
        elt.setOwner(data.getUserName());
        elt.setLastModificationDate(new Date());
        elt.setLastModifier(data.getUserName());
        return elt;
    }

    private ParameterResponse get(Integer instanceType, String name, ExpressionEvaluationData data) throws DashboardException {
        BeanSessionGroup elt = this.helper.get((Dao)this.dao, name, instanceType, BeanSessionGroup.class);
        this.updateNames(elt);
        return this.helper.getResponse((I18nElement)elt, data, SessionParameterType.SESSION_GROUP);
    }

    private void updateNames(BeanSessionGroup elt) throws DashboardException {
        elt.setParentName(this.optName(SessionParameterType.SESSION_GROUP, elt.getParentSessionGroupOid()));
    }

    private ParameterResponse getSaveAsNew(BeanSessionGroup elt, ExpressionEvaluationData data) throws DashboardException {
        this.save(elt, data, true);
        return this.helper.getResponse((I18nElement)elt, data, SessionParameterType.SESSION_GROUP);
    }

    private ParameterResponse getSave(BeanSessionGroup elt, ExpressionEvaluationData data) throws DashboardException {
        this.save(elt, data, false);
        return this.helper.getResponse((I18nElement)elt, data, SessionParameterType.SESSION_GROUP);
    }

    public void save(BeanSessionGroup elt, ExpressionEvaluationData data, boolean isNew) throws DashboardException {
        this.save(elt, data, isNew, false);
    }

    public void save(BeanSessionGroup elt, ExpressionEvaluationData data, boolean isNew, boolean isImport) throws DashboardException {
        this.helper.checkDescriptionMap(elt.getDescriptionMap(), data.getLocale());
        this.helper.checkForSave((Dao)this.dao, data, (Bean)elt, isNew, isImport);
        elt.setLastModificationDate(new Date());
        elt.setLastModifier(data.getUserName());
        this.updateOids(elt);
        this.helper.updateDescKey((Bean)elt, false);
        this.helper.updateDescriptionMap((Bean)elt, data.getLocale());
        this.helper.checkForSave(data, (Element)elt);
        this.dao.save((Element)elt);
    }

    private void updateOids(BeanSessionGroup elt) throws DashboardException {
        elt.setParentSessionGroupOid(this.optOid(SessionParameterType.SESSION_GROUP, elt.getParentName()));
    }

    private ParameterResponse getCopy(String name, ExpressionEvaluationData data) throws DashboardException {
        if (name == null) {
            throw new DashboardException();
        }
        BeanSessionGroup elt = (BeanSessionGroup)this.dao.getDefinition(name);
        this.helper.updateForCopy((Bean)elt);
        this.helper.updateDescKey((Bean)elt, true);
        this.updateNames(elt);
        elt.setCreationDate(new Date());
        elt.setOwner(data.getUserName());
        elt.setLastModificationDate(new Date());
        elt.setLastModifier(data.getUserName());
        return this.helper.getResponse((I18nElement)elt, data, SessionParameterType.SESSION_GROUP);
    }

    @Override
    public ParametersListResponse getResponse(ParametersListRequest value, ExpressionEvaluationData data) throws DashboardException {
        WorkspaceDao workspaceDao = this.daoFactory.getWorkspaceDao();
        try {
            int accessLevel = workspaceDao.getAccessLevelForEC(data.getExecutionContextOid().intValue(), SessionParameterType.SESSION_GROUP).getAccessLevel();
            if (accessLevel == 0) {
                boolean limitedAccess = workspaceDao.getLimitedAccessForUser(data.getUserOid().intValue(), data.getExecutionContextOid().intValue(), SessionParameterType.SESSION_GROUP);
                if (!limitedAccess) {
                    throw new SecurityException();
                }
                accessLevel = 1;
            }
            int instanceType = value.getBeanType() == null ? 1 : value.getBeanType();
            List<Element> eltList = this.list(value.getFilter(), instanceType, value.getSortedField(), value.getMaxSize(), data);
            return this.helper.list(eltList, value.getMaxSize(), false, SessionParameterType.SESSION_GROUP, accessLevel, data);
        }
        catch (Exception e) {
            throw this.getException(e);
        }
    }

    @Override
    public DependencyResponse getResponse(DependencyRequest value, ExpressionEvaluationData data) throws DashboardException {
        BeanSessionGroup elt = this.helper.get((Dao)this.dao, value.getName(), 1, BeanSessionGroup.class);
        List<DependencyGroup> dependencies = this.getDependencies((Bean)elt, data);
        return this.helper.getResponse((Bean)elt, dependencies, data, SessionParameterType.SESSION_GROUP);
    }

    @Override
    public List<Element> list(DefaultFilter defaultFilter, int instanceType, ParametersListRequest.SortedField sort, Integer maxSize, ExpressionEvaluationData data) throws DashboardException {
        DbSessionGroupFilter filter = this.helper.getFilter(defaultFilter, data, DbSessionGroupFilter.class);
        if (defaultFilter instanceof SessionGroupFilter) {
            SessionGroupFilter src = (SessionGroupFilter)defaultFilter;
            filter.setActive(src.getActive());
            filter.setParentSessionGroupOid(this.optOid(SessionParameterType.SESSION_GROUP, src.getParentSessionGroupName()));
        }
        List eltList = this.dao.listAll((DbDefaultFilter)filter, instanceType, sort, maxSize);
        for (Element e : eltList) {
            this.updateNames((BeanSessionGroup)e);
        }
        return eltList;
    }

    @Override
    public List<DependencyGroup> getDependencies(Bean elt, ExpressionEvaluationData data) throws DashboardException {
        return this.helper.getDependencies(this.getDependencyDefinitionList(elt), data);
    }

    private List<DependencyDefinition> getDependencyDefinitionList(Bean elt) {
        Integer objectID = elt.getObjectID();
        ArrayList<DependencyDefinition> list = new ArrayList<DependencyDefinition>();
        DbWorkspaceFilter workspaceFilter = new DbWorkspaceFilter();
        workspaceFilter.setSessionGroupOid(objectID);
        list.add(new DependencyDefinition((DbDefaultFilter)workspaceFilter, SessionParameterType.WORKSPACE));
        DbSessionGroupFilter sessionGroupFilter = new DbSessionGroupFilter();
        sessionGroupFilter.setParentSessionGroupOid(objectID);
        list.add(new DependencyDefinition((DbDefaultFilter)sessionGroupFilter, SessionParameterType.SESSION_GROUP));
        return list;
    }

    public static SessionGroupHelper getInstance(DaoFactory daoFactory) {
        return new SessionGroupHelper(daoFactory);
    }

    public BeanSessionGroup getDefinition(String name) throws DashboardException {
        BeanSessionGroup bean = this.helper.get((Dao)this.dao, name, 2, BeanSessionGroup.class);
        this.updateNames(bean);
        return bean;
    }

    @Override
    public List<Element> getReferences(int objectID, ExpressionEvaluationData data) {
        ArrayList<Element> l = new ArrayList<Element>();
        Integer oid = objectID;
        DbSessionGroupFilter sessionGroupFilter = new DbSessionGroupFilter();
        sessionGroupFilter.setUsedBySessionGroup(oid);
        SessionGroupDao sessionGroupDao = this.daoFactory.getSessionGroupDao();
        l.addAll(sessionGroupDao.listAll((DbDefaultFilter)sessionGroupFilter, 1));
        return l;
    }
}

