/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.model.helper;

import com.prelytis.dashboard.dao.Dao;
import com.prelytis.dashboard.dao.DaoFactory;
import com.prelytis.dashboard.dao.SessionDao;
import com.prelytis.dashboard.dao.WorkspaceDao;
import com.prelytis.dashboard.dao.filter.DbDefaultFilter;
import com.prelytis.dashboard.dao.filter.DbSessionFilter;
import com.prelytis.dashboard.interfaces.DashboardException;
import com.prelytis.dashboard.interfaces.Element;
import com.prelytis.dashboard.interfaces.I18nElement;
import com.prelytis.dashboard.interfaces.SecurityException;
import com.prelytis.dashboard.interfaces.SessionParameterType;
import com.prelytis.dashboard.interfaces.SessionType;
import com.prelytis.dashboard.model.helper.ParameterHelper;
import com.prelytis.dashboard.value.ParameterRequest;
import com.prelytis.dashboard.value.ParameterResponse;
import com.prelytis.dashboard.value.ParametersListRequest;
import com.prelytis.dashboard.value.ParametersListResponse;
import com.prelytis.dashboard.value.data.Bean;
import com.prelytis.dashboard.value.data.BeanSession;
import com.prelytis.dashboard.value.data.filter.DefaultFilter;
import com.prelytis.dashboard.value.util.ExpressionEvaluationData;
import java.util.Date;
import java.util.List;

public final class SessionHelper
extends ParameterHelper {
    private final SessionDao dao;

    SessionHelper(DaoFactory daoFactory) {
        super(daoFactory);
        this.dao = this.daoFactory.getSessionDao();
    }

    public static SessionHelper getInstance(DaoFactory daoFactory) {
        return new SessionHelper(daoFactory);
    }

    @Override
    public ParameterResponse getResponse(ParameterRequest value, ExpressionEvaluationData data) throws DashboardException {
        Integer instanceType = value.getInstanceType();
        ParameterRequest.Action action = value.getAction() == null ? ParameterRequest.Action.OPEN : value.getAction();
        switch (action) {
            case OPEN: 
            case OPEN_AS_SUPER_USER: {
                return this.get(instanceType, value.getName(), data);
            }
            case COPY: {
                return this.getCopy(value.getName(), data);
            }
            case DELETE: {
                return this.getDelete(value.getName(), (Bean)((BeanSession)value.getElement()), data);
            }
            case SAVE_AS_NEW: {
                return this.getSaveAsNew((BeanSession)value.getElement(), data);
            }
            case SAVE: {
                return this.getSave((BeanSession)value.getElement(), data);
            }
            case NEW: {
                return this.getNew(data);
            }
        }
        throw new DashboardException();
    }

    @Override
    public void delete(String name, ExpressionEvaluationData data) throws DashboardException {
        BeanSession elt = this.helper.get((Dao)this.dao, name, 1, BeanSession.class);
        this.helper.checkForDelete(null, data, (Element)elt);
        this.dao.delete((Element)elt);
    }

    private ParameterResponse getNew(ExpressionEvaluationData data) throws DashboardException {
        return this.helper.getResponse((I18nElement)this.create(data), data, SessionParameterType.SESSION);
    }

    public BeanSession create(ExpressionEvaluationData data) throws DashboardException {
        BeanSession elt = new BeanSession();
        this.helper.updateDescKey((Bean)elt, false);
        elt.setCreationDate(new Date());
        elt.setOwner(data.getUserName());
        elt.setLastModificationDate(new Date());
        elt.setLastModifier(data.getUserName());
        return elt;
    }

    private ParameterResponse get(Integer instanceType, String name, ExpressionEvaluationData data) throws DashboardException {
        BeanSession elt = this.helper.get((Dao)this.dao, name, instanceType, BeanSession.class);
        return this.helper.getResponse((I18nElement)elt, data, SessionParameterType.SESSION);
    }

    private ParameterResponse getSaveAsNew(BeanSession elt, ExpressionEvaluationData data) throws DashboardException {
        this.save(elt, data, true);
        return this.helper.getResponse((I18nElement)elt, data, SessionParameterType.SESSION);
    }

    private ParameterResponse getSave(BeanSession elt, ExpressionEvaluationData data) throws DashboardException {
        this.save(elt, data, false);
        return this.helper.getResponse((I18nElement)elt, data, SessionParameterType.SESSION);
    }

    public void save(BeanSession elt, ExpressionEvaluationData data, boolean isNew) throws DashboardException {
        this.save(elt, data, isNew, false);
    }

    public void save(BeanSession elt, ExpressionEvaluationData data, boolean isNew, boolean isImport) throws DashboardException {
        this.helper.checkForSave((Dao)this.dao, data, (Bean)elt, isNew, isImport);
        this.helper.updateDescKey((Bean)elt, false);
        this.helper.updateDescriptionMap((Bean)elt, data.getLocale());
        elt.setLastModificationDate(new Date());
        elt.setLastModifier(data.getUserName());
        this.helper.checkForSave(data, (Element)elt);
        this.dao.save((Element)elt);
    }

    private ParameterResponse getCopy(String name, ExpressionEvaluationData data) throws DashboardException {
        if (name == null) {
            throw new DashboardException();
        }
        BeanSession elt = (BeanSession)this.dao.getDefinition(name);
        this.helper.updateForCopy((Bean)elt);
        this.helper.updateDescKey((Bean)elt, true);
        elt.setCreationDate(new Date());
        elt.setOwner(data.getUserName());
        elt.setLastModificationDate(new Date());
        elt.setLastModifier(data.getUserName());
        return this.helper.getResponse((I18nElement)elt, data, SessionParameterType.SESSION);
    }

    @Override
    public ParametersListResponse getResponse(ParametersListRequest value, ExpressionEvaluationData data) throws DashboardException {
        WorkspaceDao workspaceDao = this.daoFactory.getWorkspaceDao();
        try {
            int accessLevel = workspaceDao.getAccessLevelForEC(data.getExecutionContextOid().intValue(), SessionParameterType.SESSION).getAccessLevel();
            if (accessLevel == 0) {
                boolean limitedAccess = workspaceDao.getLimitedAccessForUser(data.getUserOid().intValue(), data.getExecutionContextOid().intValue(), SessionParameterType.SESSION);
                if (!limitedAccess) {
                    throw new SecurityException();
                }
                accessLevel = 1;
            }
            int instanceType = value.getBeanType() == null ? 1 : value.getBeanType();
            List<Element> eltList = this.list(value.getFilter(), instanceType, value.getSortedField(), value.getMaxSize(), data);
            return this.helper.list(eltList, value.getMaxSize(), false, SessionParameterType.SESSION, accessLevel, data);
        }
        catch (Exception e) {
            throw this.getException(e);
        }
    }

    public BeanSession getDefinition(SessionType sessionType, String name, ExpressionEvaluationData data) {
        BeanSession session = this.dao.getSession(sessionType, name);
        return session;
    }

    @Override
    public List<Element> list(DefaultFilter defaultFilter, int instanceType, ParametersListRequest.SortedField sort, Integer maxSize, ExpressionEvaluationData data) {
        DbSessionFilter filter = this.helper.getFilter(defaultFilter, data, DbSessionFilter.class);
        List eltList = this.dao.listAll((DbDefaultFilter)filter, instanceType, sort, maxSize);
        return eltList;
    }

    public BeanSession getDefinition(String name) throws DashboardException {
        BeanSession bean = this.helper.get((Dao)this.dao, name, 2, BeanSession.class);
        return bean;
    }
}

