/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.model.helper;

import com.prelytis.dashboard.dao.Dao;
import com.prelytis.dashboard.dao.DaoFactory;
import com.prelytis.dashboard.dao.SqlFunctionDao;
import com.prelytis.dashboard.dao.SqlFunctionImplDao;
import com.prelytis.dashboard.dao.WorkspaceDao;
import com.prelytis.dashboard.dao.filter.DbDefaultFilter;
import com.prelytis.dashboard.dao.filter.DbJdbcDriverFilter;
import com.prelytis.dashboard.dao.filter.DbSqlFunctionFilter;
import com.prelytis.dashboard.dao.filter.DbSqlFunctionImplFilter;
import com.prelytis.dashboard.helper.ExceptionHelper;
import com.prelytis.dashboard.interfaces.DashboardException;
import com.prelytis.dashboard.interfaces.Element;
import com.prelytis.dashboard.interfaces.I18nElement;
import com.prelytis.dashboard.interfaces.SecurityException;
import com.prelytis.dashboard.interfaces.SessionParameterType;
import com.prelytis.dashboard.model.helper.Dependency;
import com.prelytis.dashboard.model.helper.DependencyDefinition;
import com.prelytis.dashboard.model.helper.ParameterHelper;
import com.prelytis.dashboard.model.helper.References;
import com.prelytis.dashboard.value.DependencyGroup;
import com.prelytis.dashboard.value.DependencyRequest;
import com.prelytis.dashboard.value.DependencyResponse;
import com.prelytis.dashboard.value.ParameterRequest;
import com.prelytis.dashboard.value.ParameterResponse;
import com.prelytis.dashboard.value.ParametersListRequest;
import com.prelytis.dashboard.value.ParametersListResponse;
import com.prelytis.dashboard.value.data.Bean;
import com.prelytis.dashboard.value.data.BeanSQLFctImpl;
import com.prelytis.dashboard.value.data.BeanSQLFctImplDefinition;
import com.prelytis.dashboard.value.data.BeanSQLFctImplParam;
import com.prelytis.dashboard.value.data.BeanSQLFctImplParamGroup;
import com.prelytis.dashboard.value.data.BeanSQLFunctionDefinition;
import com.prelytis.dashboard.value.data.BeanSQLFunctionParam;
import com.prelytis.dashboard.value.data.BeanSQLFunctionParamGroup;
import com.prelytis.dashboard.value.data.filter.DefaultFilter;
import com.prelytis.dashboard.value.data.filter.SqlFunctionImplFilter;
import com.prelytis.dashboard.value.util.ExpressionEvaluationData;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public final class SqlFunctionImplHelper
extends ParameterHelper
implements Dependency,
References {
    private final SqlFunctionImplDao dao;

    SqlFunctionImplHelper(DaoFactory daoFactory) {
        super(daoFactory);
        this.dao = this.daoFactory.getSqlFunctionImplDao();
    }

    @Override
    public ParameterResponse getResponse(ParameterRequest value, ExpressionEvaluationData data) throws DashboardException {
        ParameterRequest.Action action = value.getAction() == null ? ParameterRequest.Action.OPEN : value.getAction();
        switch (action) {
            case OPEN: 
            case OPEN_AS_SUPER_USER: {
                return this.get(value.getInstanceType(), value.getName(), data);
            }
            case COPY: {
                return this.getCopy(value.getName(), data);
            }
            case DELETE: {
                return this.getDelete(value.getName(), (Bean)((BeanSQLFctImpl)value.getElement()), data);
            }
            case SAVE_AS_NEW: {
                return this.getSaveAsNew((BeanSQLFctImplDefinition)value.getElement(), data);
            }
            case SAVE: {
                return this.getSave((BeanSQLFctImplDefinition)value.getElement(), data);
            }
            case NEW: {
                return this.getNew(data);
            }
            case REFRESH: {
                if (!(value.getElement() instanceof BeanSQLFctImplDefinition)) {
                    throw ExceptionHelper.getInstance(data.getLocale()).createDashboardException("nothingToRefresh", null, null);
                }
                return this.getRefresh((BeanSQLFctImplDefinition)value.getElement(), data);
            }
        }
        throw new DashboardException();
    }

    private ParameterResponse getRefresh(BeanSQLFctImplDefinition elt, ExpressionEvaluationData data) throws DashboardException {
        this.refresh(elt);
        return this.helper.getResponse((I18nElement)elt, data, SessionParameterType.SQL_FUNCTION_IMPL);
    }

    private ParameterResponse getNew(ExpressionEvaluationData data) throws DashboardException {
        return this.helper.getResponse((I18nElement)this.create(data), data, SessionParameterType.SQL_FUNCTION_IMPL);
    }

    public BeanSQLFctImplDefinition create(ExpressionEvaluationData data) throws DashboardException {
        BeanSQLFctImplDefinition elt = new BeanSQLFctImplDefinition();
        this.helper.updateDescKey((Bean)elt, false);
        elt.setCreationDate(new Date());
        elt.setOwner(data.getUserName());
        elt.setLastModificationDate(new Date());
        elt.setLastModifier(data.getUserName());
        return elt;
    }

    private ParameterResponse getSaveAsNew(BeanSQLFctImplDefinition elt, ExpressionEvaluationData data) throws DashboardException {
        this.save(elt, data, true);
        return this.helper.getResponse((I18nElement)elt, data, SessionParameterType.SQL_FUNCTION_IMPL);
    }

    private ParameterResponse getSave(BeanSQLFctImplDefinition elt, ExpressionEvaluationData data) throws DashboardException {
        this.save(elt, data, false);
        return this.helper.getResponse((I18nElement)elt, data, SessionParameterType.SQL_FUNCTION_IMPL);
    }

    public void save(BeanSQLFctImplDefinition elt, ExpressionEvaluationData data, boolean isNew) throws DashboardException {
        this.save(elt, data, isNew, false);
    }

    public void save(BeanSQLFctImplDefinition elt, ExpressionEvaluationData data, boolean isNew, boolean isImport) throws DashboardException {
        this.helper.checkForSave((Dao)this.dao, data, (Bean)elt, isNew, isImport);
        this.updateOids((BeanSQLFctImpl)elt);
        this.helper.updateDescKey((Bean)elt, false);
        this.helper.updateDescriptionMap((Bean)elt, data.getLocale());
        elt.setLastModificationDate(new Date());
        elt.setLastModifier(data.getUserName());
        this.helper.checkForSave(data, (Element)elt);
        this.dao.save((Element)elt);
    }

    @Override
    public void delete(String name, ExpressionEvaluationData data) throws DashboardException {
        BeanSQLFctImpl elt = this.helper.get((Dao)this.dao, name, 1, BeanSQLFctImpl.class);
        this.helper.checkForDelete(this.getDependencyDefinitionList((Bean)elt), data, (Element)elt);
        this.dao.delete((Element)elt);
    }

    private ParameterResponse get(Integer instanceType, String name, ExpressionEvaluationData data) throws DashboardException {
        BeanSQLFctImpl elt = this.helper.get((Dao)this.dao, name, instanceType, BeanSQLFctImpl.class);
        this.updateNames(elt);
        return this.helper.getResponse((I18nElement)elt, data, SessionParameterType.SQL_FUNCTION_IMPL);
    }

    private void refresh(BeanSQLFctImplDefinition bean) throws DashboardException {
        int i;
        SqlFunctionDao sqlFunctionDao = this.daoFactory.getSqlFunctionDao();
        BeanSQLFunctionDefinition sqlFunction = (BeanSQLFunctionDefinition)sqlFunctionDao.getDefinition(bean.getSqlFunctionName());
        List listRef = sqlFunction.getParamGroupList();
        List groupList = bean.getParamGroupList();
        for (i = groupList.size(); i < listRef.size(); ++i) {
            BeanSQLFunctionParamGroup groupRef = (BeanSQLFunctionParamGroup)listRef.get(i);
            BeanSQLFctImplParamGroup group = new BeanSQLFctImplParamGroup();
            group.setGroupNum(groupRef.getGroupNum());
            group.setLeftString("");
            group.setRightString("");
            group.setPreviousGroupPosition(1);
            groupList.add(group);
        }
        for (i = listRef.size(); i < groupList.size(); ++i) {
            groupList.remove(listRef.size());
        }
        for (i = 0; i < groupList.size(); ++i) {
            this.refresh((BeanSQLFctImplParamGroup)groupList.get(i), (BeanSQLFunctionParamGroup)listRef.get(i));
        }
    }

    private void refresh(BeanSQLFctImplParamGroup paramGroup, BeanSQLFunctionParamGroup paramGroupRef) {
        List paramList = paramGroup.getParamList();
        List paramRefList = paramGroupRef.getParamList();
        for (BeanSQLFunctionParam ref : paramRefList) {
            BeanSQLFctImplParam param = new BeanSQLFctImplParam();
            param.init(ref.getParamNum(), "", "", "", 1);
            paramList.add(param);
        }
        for (int i = paramRefList.size(); i < paramGroup.getNbParam(); ++i) {
            paramList.remove(paramRefList.size());
        }
    }

    private void updateNames(BeanSQLFctImpl bean) throws DashboardException {
        bean.setSqlFunctionName(this.getName(SessionParameterType.SQL_FUNCTION, bean.getSqlFunctionOID()));
    }

    private void updateOids(BeanSQLFctImpl bean) throws DashboardException {
        bean.setSqlFunctionOID(this.getOid(SessionParameterType.SQL_FUNCTION, bean.getSqlFunctionName()));
    }

    private ParameterResponse getCopy(String name, ExpressionEvaluationData data) throws DashboardException {
        BeanSQLFctImplDefinition elt = this.helper.get((Dao)this.dao, name, 2, BeanSQLFctImplDefinition.class);
        this.helper.updateForCopy((Bean)elt);
        this.helper.updateDescKey((Bean)elt, true);
        this.updateNames((BeanSQLFctImpl)elt);
        elt.setCreationDate(new Date());
        elt.setOwner(data.getUserName());
        elt.setLastModificationDate(new Date());
        elt.setLastModifier(data.getUserName());
        return this.helper.getResponse((I18nElement)elt, data, SessionParameterType.SQL_FUNCTION_IMPL);
    }

    @Override
    public ParametersListResponse getResponse(ParametersListRequest value, ExpressionEvaluationData data) throws DashboardException {
        WorkspaceDao workspaceDao = this.daoFactory.getWorkspaceDao();
        try {
            int accessLevel = workspaceDao.getAccessLevelForEC(data.getExecutionContextOid().intValue(), SessionParameterType.SQL_FUNCTION_IMPL).getAccessLevel();
            if (accessLevel == 0) {
                boolean limitedAccess = workspaceDao.getLimitedAccessForUser(data.getUserOid().intValue(), data.getExecutionContextOid().intValue(), SessionParameterType.SQL_FUNCTION_IMPL);
                if (!limitedAccess) {
                    throw new SecurityException();
                }
                accessLevel = 1;
            }
            int instanceType = value.getBeanType() == null ? 1 : value.getBeanType();
            List<Element> eltList = this.list(value.getFilter(), instanceType, value.getSortedField(), value.getMaxSize(), data);
            return this.helper.list(eltList, value.getMaxSize(), false, SessionParameterType.SQL_FUNCTION_IMPL, accessLevel, data);
        }
        catch (Exception e) {
            throw this.getException(e);
        }
    }

    @Override
    public DependencyResponse getResponse(DependencyRequest value, ExpressionEvaluationData data) throws DashboardException {
        BeanSQLFctImpl elt = this.helper.get((Dao)this.dao, value.getName(), 1, BeanSQLFctImpl.class);
        List<DependencyGroup> dependencies = this.getDependencies((Bean)elt, data);
        return this.helper.getResponse((Bean)elt, dependencies, data, SessionParameterType.SQL_FUNCTION_IMPL);
    }

    @Override
    public List<Element> list(DefaultFilter defaultFilter, int instanceType, ParametersListRequest.SortedField sort, Integer maxSize, ExpressionEvaluationData data) throws DashboardException {
        DbSqlFunctionImplFilter filter = this.helper.getFilter(defaultFilter, data, DbSqlFunctionImplFilter.class);
        if (defaultFilter instanceof SqlFunctionImplFilter) {
            SqlFunctionImplFilter src = (SqlFunctionImplFilter)defaultFilter;
            filter.setSqlFunctionOid(this.optOid(SessionParameterType.SQL_FUNCTION_IMPL, src.getSqlFunctionName()));
        }
        List eltList = this.dao.listAll((DbDefaultFilter)filter, instanceType, sort, maxSize);
        for (Element elt : eltList) {
            this.updateNames((BeanSQLFctImpl)elt);
        }
        return eltList;
    }

    public static SqlFunctionImplHelper getInstance(DaoFactory daoFactory) {
        return new SqlFunctionImplHelper(daoFactory);
    }

    @Override
    public List<DependencyGroup> getDependencies(Bean elt, ExpressionEvaluationData data) throws DashboardException {
        return this.helper.getDependencies(this.getDependencyDefinitionList(elt), data);
    }

    private List<DependencyDefinition> getDependencyDefinitionList(Bean elt) {
        Integer objectID = elt.getObjectID();
        ArrayList<DependencyDefinition> list = new ArrayList<DependencyDefinition>();
        DbJdbcDriverFilter jdbcDriverFilter = new DbJdbcDriverFilter();
        jdbcDriverFilter.setSqlFunctionImplOid(objectID);
        list.add(new DependencyDefinition((DbDefaultFilter)jdbcDriverFilter, SessionParameterType.JDBC_DRIVER));
        return list;
    }

    public BeanSQLFctImplDefinition getDefinition(String name) throws DashboardException {
        BeanSQLFctImplDefinition bean = this.helper.get((Dao)this.dao, name, 2, BeanSQLFctImplDefinition.class);
        this.updateNames((BeanSQLFctImpl)bean);
        return bean;
    }

    @Override
    public List<Element> getReferences(int objectID, ExpressionEvaluationData data) {
        ArrayList<Element> l = new ArrayList<Element>();
        Integer oid = objectID;
        DbSqlFunctionFilter sqlFunctionFilter = new DbSqlFunctionFilter();
        sqlFunctionFilter.setUsedBySqlFunctionImpl(oid);
        SqlFunctionDao sqlFunctionDao = this.daoFactory.getSqlFunctionDao();
        l.addAll(sqlFunctionDao.listAll((DbDefaultFilter)sqlFunctionFilter, 1));
        return l;
    }
}

