/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.model.helper;

import com.prelytis.dashboard.dao.Dao;
import com.prelytis.dashboard.dao.DaoFactory;
import com.prelytis.dashboard.dao.PerspectiveDao;
import com.prelytis.dashboard.dao.StrategicObjectiveDao;
import com.prelytis.dashboard.dao.WorkspaceDao;
import com.prelytis.dashboard.dao.filter.DbDefaultFilter;
import com.prelytis.dashboard.dao.filter.DbMetricFilter;
import com.prelytis.dashboard.dao.filter.DbPerspectiveFilter;
import com.prelytis.dashboard.dao.filter.DbStrategicObjectiveFilter;
import com.prelytis.dashboard.helper.ExceptionHelper;
import com.prelytis.dashboard.interfaces.DashboardException;
import com.prelytis.dashboard.interfaces.Element;
import com.prelytis.dashboard.interfaces.ErrorCode;
import com.prelytis.dashboard.interfaces.I18nElement;
import com.prelytis.dashboard.interfaces.SecurityException;
import com.prelytis.dashboard.interfaces.SessionParameterType;
import com.prelytis.dashboard.model.helper.Dependency;
import com.prelytis.dashboard.model.helper.DependencyDefinition;
import com.prelytis.dashboard.model.helper.ParameterHelper;
import com.prelytis.dashboard.model.helper.References;
import com.prelytis.dashboard.value.DependencyGroup;
import com.prelytis.dashboard.value.DependencyRequest;
import com.prelytis.dashboard.value.DependencyResponse;
import com.prelytis.dashboard.value.ParameterRequest;
import com.prelytis.dashboard.value.ParameterResponse;
import com.prelytis.dashboard.value.ParametersListRequest;
import com.prelytis.dashboard.value.ParametersListResponse;
import com.prelytis.dashboard.value.data.Bean;
import com.prelytis.dashboard.value.data.BeanStrategicObjective;
import com.prelytis.dashboard.value.data.filter.DefaultFilter;
import com.prelytis.dashboard.value.data.filter.StrategicObjectiveFilter;
import com.prelytis.dashboard.value.util.ExpressionEvaluationData;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class StrategicObjectiveHelper
extends ParameterHelper
implements Dependency,
References {
    private final StrategicObjectiveDao dao;

    StrategicObjectiveHelper(DaoFactory daoFactory) {
        super(daoFactory);
        this.dao = this.daoFactory.getStrategicObjectiveDao();
    }

    @Override
    public ParameterResponse getResponse(ParameterRequest value, ExpressionEvaluationData data) throws DashboardException {
        Integer instanceType = value.getInstanceType();
        ParameterRequest.Action action = value.getAction() == null ? ParameterRequest.Action.OPEN : value.getAction();
        switch (action) {
            case OPEN: 
            case OPEN_AS_SUPER_USER: {
                return this.get(instanceType, value.getName(), data);
            }
            case COPY: {
                return this.getCopy(value.getName(), data);
            }
            case DELETE: {
                return this.getDelete(value.getName(), (Bean)((BeanStrategicObjective)value.getElement()), data);
            }
            case SAVE_AS_NEW: {
                return this.getSaveAsNew((BeanStrategicObjective)value.getElement(), data);
            }
            case SAVE: {
                return this.getSave((BeanStrategicObjective)value.getElement(), data);
            }
            case NEW: {
                return this.getNew(data);
            }
        }
        throw new DashboardException();
    }

    @Override
    public void delete(String name, ExpressionEvaluationData data) throws DashboardException {
        BeanStrategicObjective elt = this.helper.get((Dao)this.dao, name, 1, BeanStrategicObjective.class);
        this.helper.checkForDelete(this.getDependencyDefinitionList((Bean)elt), data, (Element)elt);
        this.dao.delete((Element)elt);
    }

    private ParameterResponse getNew(ExpressionEvaluationData data) throws DashboardException {
        return this.helper.getResponse((I18nElement)this.create(data), data, SessionParameterType.STRATEGIC_OBJECTIVE);
    }

    public BeanStrategicObjective create(ExpressionEvaluationData data) throws DashboardException {
        BeanStrategicObjective elt = new BeanStrategicObjective();
        this.helper.updateDescKey((Bean)elt, false);
        elt.setCommentKey(this.guidFactory.generateGUID((Object)elt));
        elt.setCreationDate(new Date());
        elt.setOwner(data.getUserName());
        elt.setLastModificationDate(new Date());
        elt.setLastModifier(data.getUserName());
        return elt;
    }

    private ParameterResponse get(Integer instanceType, String name, ExpressionEvaluationData data) throws DashboardException {
        BeanStrategicObjective elt = this.helper.get((Dao)this.dao, name, instanceType, BeanStrategicObjective.class);
        this.updateNames(elt);
        return this.helper.getResponse((I18nElement)elt, data, SessionParameterType.STRATEGIC_OBJECTIVE);
    }

    private ParameterResponse getSaveAsNew(BeanStrategicObjective elt, ExpressionEvaluationData data) throws DashboardException {
        this.save(elt, data, true);
        return this.helper.getResponse((I18nElement)elt, data, SessionParameterType.STRATEGIC_OBJECTIVE);
    }

    private ParameterResponse getSave(BeanStrategicObjective elt, ExpressionEvaluationData data) throws DashboardException {
        this.save(elt, data, false);
        return this.helper.getResponse((I18nElement)elt, data, SessionParameterType.STRATEGIC_OBJECTIVE);
    }

    public void save(BeanStrategicObjective elt, ExpressionEvaluationData data, boolean isNew) throws DashboardException {
        this.save(elt, data, isNew, false);
    }

    public void save(BeanStrategicObjective elt, ExpressionEvaluationData data, boolean isNew, boolean isImport) throws DashboardException {
        this.helper.checkForSave((Dao)this.dao, data, (Bean)elt, isNew, isImport);
        this.updateOids(elt);
        this.helper.updateDescKey((Bean)elt, false);
        this.helper.updateDescriptionMap((Bean)elt, data.getLocale());
        elt.setLastModificationDate(new Date());
        elt.setLastModifier(data.getUserName());
        if (elt.getStrategicObjectiveOID() != 0) {
            HashSet<Integer> set = new HashSet<Integer>();
            if (!isNew) {
                set.add(elt.getObjectID());
            }
            this.checkForLoop(set, elt.getStrategicObjectiveOID(), data);
        }
        this.helper.checkForSave(data, (Element)elt);
        this.dao.save((Element)elt);
    }

    private void checkForLoop(Set<Integer> set, int oid, ExpressionEvaluationData data) throws DashboardException {
        if (oid != 0) {
            if (!set.add(oid)) {
                throw ExceptionHelper.getInstance(data.getLocale()).createDashboardException(ErrorCode.INSIGHT_STRATEGIC_OBJECTIVE_LOOP, "strategicObjectiveLoop", null, null);
            }
            BeanStrategicObjective so = (BeanStrategicObjective)this.dao.getCore(oid);
            this.checkForLoop(set, so.getStrategicObjectiveOID(), data);
        }
    }

    private void updateNames(BeanStrategicObjective bean) throws DashboardException {
        bean.setParentName(this.optName(SessionParameterType.STRATEGIC_OBJECTIVE, bean.getStrategicObjectiveOID()));
        bean.setPerspectiveName(this.getName(SessionParameterType.PERSPECTIVE, bean.getPerspectiveOID()));
    }

    private void updateOids(BeanStrategicObjective bean) throws DashboardException {
        Integer oid = this.optOid(SessionParameterType.STRATEGIC_OBJECTIVE, bean.getParentName());
        bean.setStrategicObjectiveOID(oid == null ? 0 : oid);
        bean.setPerspectiveOID(this.getOid(SessionParameterType.PERSPECTIVE, bean.getPerspectiveName()));
    }

    private ParameterResponse getCopy(String name, ExpressionEvaluationData data) throws DashboardException {
        if (name == null) {
            throw new DashboardException();
        }
        BeanStrategicObjective elt = (BeanStrategicObjective)this.dao.getDefinition(name);
        this.helper.updateForCopy((Bean)elt);
        this.helper.updateDescKey((Bean)elt, true);
        this.updateNames(elt);
        elt.setCreationDate(new Date());
        elt.setOwner(data.getUserName());
        elt.setLastModificationDate(new Date());
        elt.setLastModifier(data.getUserName());
        return this.helper.getResponse((I18nElement)elt, data, SessionParameterType.STRATEGIC_OBJECTIVE);
    }

    @Override
    public ParametersListResponse getResponse(ParametersListRequest value, ExpressionEvaluationData data) throws DashboardException {
        WorkspaceDao workspaceDao = this.daoFactory.getWorkspaceDao();
        try {
            int accessLevel = workspaceDao.getAccessLevelForEC(data.getExecutionContextOid().intValue(), SessionParameterType.STRATEGIC_OBJECTIVE).getAccessLevel();
            if (accessLevel == 0) {
                boolean limitedAccess = workspaceDao.getLimitedAccessForUser(data.getUserOid().intValue(), data.getExecutionContextOid().intValue(), SessionParameterType.STRATEGIC_OBJECTIVE);
                if (!limitedAccess) {
                    throw new SecurityException();
                }
                accessLevel = 1;
            }
            int instanceType = value.getBeanType() == null ? 1 : value.getBeanType();
            List<Element> eltList = this.list(value.getFilter(), instanceType, value.getSortedField(), value.getMaxSize(), data);
            return this.helper.list(eltList, value.getMaxSize(), false, SessionParameterType.STRATEGIC_OBJECTIVE, accessLevel, data);
        }
        catch (Exception e) {
            throw this.getException(e);
        }
    }

    @Override
    public DependencyResponse getResponse(DependencyRequest value, ExpressionEvaluationData data) throws DashboardException {
        BeanStrategicObjective elt = this.helper.get((Dao)this.dao, value.getName(), 1, BeanStrategicObjective.class);
        List<DependencyGroup> dependencies = this.getDependencies((Bean)elt, data);
        return this.helper.getResponse((Bean)elt, dependencies, data, SessionParameterType.STRATEGIC_OBJECTIVE);
    }

    @Override
    public List<Element> list(DefaultFilter defaultFilter, int instanceType, ParametersListRequest.SortedField sort, Integer maxSize, ExpressionEvaluationData data) throws DashboardException {
        DbStrategicObjectiveFilter filter = this.helper.getFilter(defaultFilter, data, DbStrategicObjectiveFilter.class);
        if (defaultFilter instanceof StrategicObjectiveFilter) {
            StrategicObjectiveFilter src = (StrategicObjectiveFilter)defaultFilter;
            filter.setPerspOid(this.optOid(SessionParameterType.PERSPECTIVE, src.getPerspName()));
            filter.setParentStrategicObjective(this.optOid(SessionParameterType.STRATEGIC_OBJECTIVE, src.getParentStrategicObjective()));
        }
        List eltList = this.dao.listAll((DbDefaultFilter)filter, instanceType, sort, maxSize);
        for (Element elt : eltList) {
            this.updateNames((BeanStrategicObjective)elt);
        }
        return eltList;
    }

    @Override
    public List<DependencyGroup> getDependencies(Bean elt, ExpressionEvaluationData data) throws DashboardException {
        return this.helper.getDependencies(this.getDependencyDefinitionList(elt), data);
    }

    private List<DependencyDefinition> getDependencyDefinitionList(Bean elt) {
        Integer objectID = elt.getObjectID();
        ArrayList<DependencyDefinition> list = new ArrayList<DependencyDefinition>();
        DbMetricFilter metricFilter = new DbMetricFilter();
        metricFilter.setStrategicObjectiveOid(objectID);
        list.add(new DependencyDefinition((DbDefaultFilter)metricFilter, SessionParameterType.METRIC));
        DbStrategicObjectiveFilter strategicObjectiveFilter = new DbStrategicObjectiveFilter();
        strategicObjectiveFilter.setParentStrategicObjective(objectID);
        list.add(new DependencyDefinition((DbDefaultFilter)strategicObjectiveFilter, SessionParameterType.STRATEGIC_OBJECTIVE));
        return list;
    }

    public static StrategicObjectiveHelper getInstance(DaoFactory daoFactory) {
        return new StrategicObjectiveHelper(daoFactory);
    }

    public BeanStrategicObjective getDefinition(String name) throws DashboardException {
        BeanStrategicObjective bean = this.helper.get((Dao)this.dao, name, 2, BeanStrategicObjective.class);
        this.updateNames(bean);
        return bean;
    }

    @Override
    public List<Element> getReferences(int objectID, ExpressionEvaluationData data) {
        ArrayList<Element> l = new ArrayList<Element>();
        Integer oid = objectID;
        DbPerspectiveFilter perspectiveFilter = new DbPerspectiveFilter();
        perspectiveFilter.setUsedByStrategicObjective(oid);
        PerspectiveDao perspectiveDao = this.daoFactory.getPerspectiveDao();
        l.addAll(perspectiveDao.listAll((DbDefaultFilter)perspectiveFilter, 1));
        DbStrategicObjectiveFilter strategicObjectiveFilter = new DbStrategicObjectiveFilter();
        strategicObjectiveFilter.setUsedByStrategicObjective(oid);
        StrategicObjectiveDao strategicObjectiveDao = this.daoFactory.getStrategicObjectiveDao();
        l.addAll(strategicObjectiveDao.listAll((DbDefaultFilter)strategicObjectiveFilter, 1));
        return l;
    }
}

