/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.model.helper;

import com.prelytis.dashboard.dao.Dao;
import com.prelytis.dashboard.dao.DaoFactory;
import com.prelytis.dashboard.dao.DashboardDao;
import com.prelytis.dashboard.dao.FolderDao;
import com.prelytis.dashboard.dao.PrelytisInfoDao;
import com.prelytis.dashboard.dao.QueryDao;
import com.prelytis.dashboard.dao.ReportDao;
import com.prelytis.dashboard.dao.TaskDao;
import com.prelytis.dashboard.dao.WorkspaceDao;
import com.prelytis.dashboard.dao.WorldDao;
import com.prelytis.dashboard.dao.filter.DbDashboardFilter;
import com.prelytis.dashboard.dao.filter.DbDefaultFilter;
import com.prelytis.dashboard.dao.filter.DbFolderFilter;
import com.prelytis.dashboard.dao.filter.DbQueryFilter;
import com.prelytis.dashboard.dao.filter.DbReportFilter;
import com.prelytis.dashboard.dao.filter.DbTaskFilter;
import com.prelytis.dashboard.dao.filter.DbWorldFilter;
import com.prelytis.dashboard.helper.ExceptionHelper;
import com.prelytis.dashboard.interfaces.DashboardException;
import com.prelytis.dashboard.interfaces.Element;
import com.prelytis.dashboard.interfaces.I18nElement;
import com.prelytis.dashboard.interfaces.ITaskWithThresholds;
import com.prelytis.dashboard.interfaces.SecurityException;
import com.prelytis.dashboard.interfaces.SessionParameterType;
import com.prelytis.dashboard.model.helper.Dependency;
import com.prelytis.dashboard.model.helper.DependencyDefinition;
import com.prelytis.dashboard.model.helper.EntityHelper;
import com.prelytis.dashboard.model.helper.ParameterHelper;
import com.prelytis.dashboard.model.helper.PrelytisInfoHelper;
import com.prelytis.dashboard.model.helper.References;
import com.prelytis.dashboard.model.helper.ReportHelper;
import com.prelytis.dashboard.model.helper.ThresholdTypeHelper;
import com.prelytis.dashboard.model.helper.TimeUnitHelper;
import com.prelytis.dashboard.model.helper.UserHelper;
import com.prelytis.dashboard.util.ConversionHelper;
import com.prelytis.dashboard.value.DependencyGroup;
import com.prelytis.dashboard.value.DependencyRequest;
import com.prelytis.dashboard.value.DependencyResponse;
import com.prelytis.dashboard.value.ParameterRequest;
import com.prelytis.dashboard.value.ParameterResponse;
import com.prelytis.dashboard.value.ParametersListRequest;
import com.prelytis.dashboard.value.ParametersListResponse;
import com.prelytis.dashboard.value.data.AbstractBeanReport;
import com.prelytis.dashboard.value.data.Bean;
import com.prelytis.dashboard.value.data.BeanReportCrossTable;
import com.prelytis.dashboard.value.data.BeanReportDataUsedField;
import com.prelytis.dashboard.value.data.BeanReportStd;
import com.prelytis.dashboard.value.data.BeanReportStdUsedField;
import com.prelytis.dashboard.value.data.BeanTask;
import com.prelytis.dashboard.value.data.BeanTaskDataMart;
import com.prelytis.dashboard.value.data.BeanTaskDefinition;
import com.prelytis.dashboard.value.data.BeanTaskDocExport;
import com.prelytis.dashboard.value.data.BeanTaskDocGeneration;
import com.prelytis.dashboard.value.data.BeanTaskScript;
import com.prelytis.dashboard.value.data.BeanThresholdTypeDefinition;
import com.prelytis.dashboard.value.data.BeanTimeUnit;
import com.prelytis.dashboard.value.data.OwnerEntity;
import com.prelytis.dashboard.value.data.TaskType;
import com.prelytis.dashboard.value.data.filter.DefaultFilter;
import com.prelytis.dashboard.value.data.filter.TaskFilter;
import com.prelytis.dashboard.value.util.DataType;
import com.prelytis.dashboard.value.util.ExpressionEvaluationData;
import com.prelytis.dashboard.value.util.Threshold;
import com.prelytis.dashboard.value.util.Thresholds;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import org.quartz.CronExpression;

public final class TaskHelper
extends ParameterHelper
implements Dependency,
References {
    private final EntityHelper entityHelper;
    private final boolean autoNameGeneration;
    private final TaskDao dao;

    TaskHelper(DaoFactory daoFactory) {
        super(daoFactory);
        this.dao = this.daoFactory.getTaskDao();
        this.entityHelper = new EntityHelper(daoFactory);
        PrelytisInfoDao prelytisInfoDao = daoFactory.getPrelytisInfoDao();
        this.autoNameGeneration = prelytisInfoDao.isAutoNameGeneration();
    }

    public static TaskHelper getInstance(DaoFactory daoFactory) {
        return new TaskHelper(daoFactory);
    }

    @Override
    public ParameterResponse getResponse(ParameterRequest value, ExpressionEvaluationData data) throws DashboardException {
        ParameterRequest.Action action = value.getAction() == null ? ParameterRequest.Action.OPEN : value.getAction();
        switch (action) {
            case OPEN: 
            case OPEN_AS_SUPER_USER: {
                return this.get(value.getInstanceType(), value.getName(), data);
            }
            case COPY: {
                return this.getCopy(value.getName(), data);
            }
            case DELETE: {
                return this.getDelete(value.getName(), (Bean)((BeanTask)value.getElement()), data);
            }
            case SAVE_AS_NEW: {
                return this.getSaveAsNew((BeanTaskDefinition)value.getElement(), data);
            }
            case SAVE: {
                return this.getSave((BeanTaskDefinition)value.getElement(), data);
            }
            case NEW: {
                return this.getNew(data);
            }
            case REFRESH: {
                if (!(value.getElement() instanceof BeanTaskDefinition)) {
                    throw ExceptionHelper.getInstance(data.getLocale()).createDashboardException("nothingToRefresh", null, null);
                }
                return this.getRefresh((BeanTaskDefinition)value.getElement(), data);
            }
        }
        throw new DashboardException();
    }

    private ParameterResponse getSaveAsNew(BeanTaskDefinition elt, ExpressionEvaluationData data) throws DashboardException {
        if (elt.getTaskType() == TaskType.TASK_TYPE_METRIC || elt.getTaskType() == TaskType.TASK_TYPE_CONTROL) {
            throw new DashboardException();
        }
        this.save(elt, data, true);
        return this.helper.getResponse((I18nElement)elt, data, SessionParameterType.TASK);
    }

    private ParameterResponse getSave(BeanTaskDefinition elt, ExpressionEvaluationData data) throws DashboardException {
        if (elt.getTaskType() == TaskType.TASK_TYPE_METRIC || elt.getTaskType() == TaskType.TASK_TYPE_CONTROL) {
            throw new DashboardException();
        }
        this.save(elt, data, false);
        return this.helper.getResponse((I18nElement)elt, data, SessionParameterType.TASK);
    }

    public void save(BeanTaskDefinition elt, ExpressionEvaluationData data, boolean isNew) throws DashboardException {
        this.save(elt, data, isNew, false);
    }

    public void save(BeanTaskDefinition elt, ExpressionEvaluationData data, boolean isNew, boolean isImport) throws DashboardException {
        BeanTaskScript s;
        if (elt.getTaskType() == TaskType.TASK_TYPE_METRIC || elt.getTaskType() == TaskType.TASK_TYPE_CONTROL) {
            throw new DashboardException();
        }
        this.helper.checkForSave((Dao)this.dao, data, (Bean)elt, isNew, isImport);
        this.updateOids(elt);
        this.updateDescKeys(elt, false);
        this.updateDescriptionMap(elt, this.helper.getLocales(), data.getLocale());
        elt.setLastModificationDate(new Date());
        elt.setLastModifier(data.getUserName());
        if (elt.getCronExpression() != null && !"".equals(elt.getCronExpression())) {
            if (!CronExpression.isValidExpression((String)elt.getCronExpression())) {
                throw ExceptionHelper.getInstance(data.getLocale()).createDashboardException("taskMsg.invalidCronExp", null, null);
            }
            elt.setParentTaskName(null);
            elt.setParentTaskOID(null);
            if (elt.getTaskGroupName() == null || elt.getTaskGroupName().isEmpty()) {
                throw new DashboardException();
            }
        } else if (elt.getParentTaskName() != null && !elt.getParentTaskName().isEmpty()) {
            elt.setTaskGroupName(null);
            elt.setTaskGrpOID(null);
        }
        if (elt instanceof BeanTaskDataMart) {
            BeanTaskDataMart b = (BeanTaskDataMart)elt;
            switch (b.getSourceType()) {
                case CSV_FILE: {
                    if (b.getSourceSeparatedBy() == null) {
                        b.setSourceSeparatedBy(BeanTaskDataMart.CharSeparator.COMMA);
                    }
                    if (b.getSourceEncoding() != null && !b.getSourceEncoding().isEmpty()) break;
                    b.setSourceEncoding("UTF-8");
                    break;
                }
                case STD_LOG_FILE: {
                    if (b.getSourceEncoding() != null && !b.getSourceEncoding().isEmpty()) break;
                    b.setSourceEncoding("UTF-8");
                    break;
                }
            }
            switch (b.getTransformationType()) {
                case XSL: {
                    break;
                }
            }
            switch (b.getDestinationType()) {
                case TABLE: {
                    break;
                }
                case CSV_FILE: {
                    if (b.getDestinationSeparatedBy() == null) {
                        b.setDestinationSeparatedBy(BeanTaskDataMart.CharSeparator.COMMA);
                    }
                    if (b.getDestinationEncoding() != null && !b.getDestinationEncoding().isEmpty()) break;
                    b.setDestinationEncoding("UTF-8");
                    break;
                }
                case XML_FILE: 
                case XLS_FILE: 
                case PDF_FILE: 
                case GIF_FILE: 
                case PNG_FILE: 
                case JPG_FILE: 
                case SVG_FILE: {
                    break;
                }
            }
        } else if (elt instanceof BeanTaskDocExport) {
            BeanTaskDocExport b = (BeanTaskDocExport)elt;
        } else if (!(elt instanceof BeanTaskDocGeneration) && elt instanceof BeanTaskScript && ((s = (BeanTaskScript)elt).getFileName() == null || s.getFileName().isEmpty())) {
            throw ExceptionHelper.getInstance(data.getLocale()).createDashboardException("missingFileName", null, null);
        }
        this.helper.checkOwnerEntity(this.entityHelper, data, (OwnerEntity)elt);
        this.helper.checkForSave(data, (Element)elt);
        this.dao.save((Element)elt);
    }

    private void updateDescriptionMap(BeanTaskDefinition elt, List<Locale> locales, Locale defaultLocale) {
        this.helper.updateDescriptionMap((Bean)elt, locales, defaultLocale);
        this.helper.updateDescriptionMap(elt.getMessageBodyMap(), locales, defaultLocale);
        this.helper.updateDescriptionMap(elt.getMessageSubjectMap(), locales, defaultLocale);
    }

    @Override
    public void delete(String name, ExpressionEvaluationData data) throws DashboardException {
        BeanTask elt = this.helper.get((Dao)this.dao, name, 1, BeanTask.class);
        if (elt.getTaskType() == TaskType.TASK_TYPE_METRIC || elt.getTaskType() == TaskType.TASK_TYPE_CONTROL) {
            throw new DashboardException();
        }
        this.helper.checkOwnerEntity(this.entityHelper, data, (OwnerEntity)elt);
        this.helper.checkForDelete(this.getDependencyDefinitionList((Bean)elt), data, (Element)elt);
        this.dao.delete((Element)elt);
    }

    private ParameterResponse get(Integer instanceType, String name, ExpressionEvaluationData data) throws DashboardException {
        BeanTask elt = this.helper.get((Dao)this.dao, name, instanceType, BeanTask.class);
        if (elt.getTaskType() == TaskType.TASK_TYPE_METRIC || elt.getTaskType() == TaskType.TASK_TYPE_CONTROL) {
            throw new DashboardException();
        }
        this.updateNames(elt);
        return this.helper.getResponse((I18nElement)elt, data, SessionParameterType.TASK);
    }

    private ParameterResponse getNew(ExpressionEvaluationData data) throws DashboardException {
        return this.helper.getResponse((I18nElement)this.create(data), data, SessionParameterType.TASK);
    }

    public BeanTaskDataMart create(ExpressionEvaluationData data) throws DashboardException {
        BeanTaskDataMart elt = new BeanTaskDataMart();
        if (this.autoNameGeneration) {
            elt.setName(this.guidFactory.generateGUID((Object)elt));
        }
        this.updateDescKeys((BeanTaskDefinition)elt, false);
        elt.setOwnerEntOID(data.getEntityOid().intValue());
        elt.setOwnerEntityName(data.getEntityName());
        this.updateNames((BeanTask)elt);
        this.initCommon((BeanTask)elt);
        elt.setFreqUnitName("day");
        this.updateFreq((BeanTaskDefinition)elt);
        elt.setCreationDate(new Date());
        elt.setOwner(data.getUserName());
        elt.setLastModificationDate(new Date());
        elt.setLastModifier(data.getUserName());
        return elt;
    }

    private ParameterResponse getRefresh(BeanTaskDefinition task, ExpressionEvaluationData data) throws DashboardException {
        BeanTaskDefinition f;
        switch (task.getTaskType()) {
            case TASK_TYPE_CONTROL: 
            case TASK_TYPE_METRIC: {
                throw new DashboardException();
            }
            case TASK_TYPE_DATAMART: 
            case TASK_TYPE_XSLFO_DOC_GENERATION: 
            case TASK_TYPE_EXPORT_PARAM: 
            case TASK_TYPE_IMG_GENERATION: 
            case TASK_TYPE_IMPORT_PARAM: {
                if (task instanceof BeanTaskDataMart) {
                    f = task;
                    break;
                }
                f = new BeanTaskDataMart((BeanTask)task);
                break;
            }
            case TASK_TYPE_SCRIPT: {
                if (task instanceof BeanTaskScript) {
                    f = task;
                    break;
                }
                f = new BeanTaskScript((BeanTask)task);
                break;
            }
            case TASK_TYPE_DOC_GENERATION: {
                if (task instanceof BeanTaskDocGeneration) {
                    f = task;
                    break;
                }
                f = new BeanTaskDocGeneration((BeanTask)task);
                break;
            }
            case TASK_TYPE_DOCUMENT_EXPORT: {
                if (task instanceof BeanTaskDocExport) {
                    f = task;
                    break;
                }
                f = new BeanTaskDocExport((BeanTask)task);
                break;
            }
            default: {
                throw new DashboardException();
            }
        }
        return this.helper.getResponse((I18nElement)f, data, SessionParameterType.TASK);
    }

    private void updateNames(BeanTask bean) throws DashboardException {
        BeanTaskDefinition elt;
        bean.setFreqUnitName(this.getName(SessionParameterType.TIME_UNIT, bean.getFreqUnitOID()));
        bean.setOwnerEntityName(this.getName(SessionParameterType.ENTITY, bean.getOwnerEntOID()));
        bean.setParentTaskName(this.optName(SessionParameterType.TASK, bean.getParentTaskOID()));
        bean.setTaskGroupName(this.optName(SessionParameterType.TASK_GROUP, bean.getTaskGrpOID()));
        if (bean instanceof BeanTaskDefinition) {
            elt = (BeanTaskDefinition)bean;
            this.updateFreq(elt);
        }
        if (bean instanceof BeanTaskDataMart) {
            elt = (BeanTaskDataMart)bean;
            elt.setFieldName(this.optName(SessionParameterType.PERS_FIELD, elt.getFieldOID()));
            switch (elt.getSourceType()) {
                case CSV_FILE: 
                case STD_LOG_FILE: 
                case XLS_FILE: 
                case XML_FILE: {
                    elt.setSourceName(this.optName(SessionParameterType.FOLDER, elt.getSourceFolderOid()));
                    break;
                }
                case QUERY: {
                    elt.setSourceName(this.optName(SessionParameterType.QUERY, elt.getSourceQueryOid()));
                    break;
                }
            }
            switch (elt.getTransformationType()) {
                case XSL: {
                    elt.setTransformationName(this.optName(SessionParameterType.FOLDER, elt.getTransformationFolderOID()));
                    break;
                }
            }
            switch (elt.getDestinationType()) {
                case TABLE: {
                    elt.setDestinationName(this.optName(SessionParameterType.WORLD, elt.getDestinationWorldOid()));
                    break;
                }
                case CSV_FILE: 
                case XML_FILE: 
                case XLS_FILE: 
                case PDF_FILE: 
                case GIF_FILE: 
                case PNG_FILE: 
                case JPG_FILE: 
                case SVG_FILE: {
                    elt.setDestinationName(this.optName(SessionParameterType.FOLDER, elt.getDestinationFolderOid()));
                    break;
                }
            }
        } else if (bean instanceof BeanTaskDocExport) {
            elt = (BeanTaskDocExport)bean;
            elt.setFieldName(this.optName(SessionParameterType.PERS_FIELD, elt.getFieldOID()));
            elt.setTimeUnitName(this.optName(SessionParameterType.TIME_UNIT, elt.getTimeHistory()));
            switch (elt.getDataType()) {
                case 2: {
                    elt.setDashboardName(this.optName(SessionParameterType.DASHBOARD, elt.getDashboardOid()));
                    break;
                }
                case 1: {
                    elt.setReportName(this.optName(SessionParameterType.REPORT, elt.getReportOid()));
                }
            }
        } else if (bean instanceof BeanTaskDocGeneration) {
            elt = (BeanTaskDocGeneration)bean;
            elt.setFieldName(this.optName(SessionParameterType.PERS_FIELD, elt.getFieldOID()));
            switch (elt.getSourceType()) {
                case 2: {
                    elt.setDashboardName(this.optName(SessionParameterType.DASHBOARD, elt.getDashboardOid()));
                    break;
                }
                case 1: {
                    elt.setReportName(this.optName(SessionParameterType.REPORT, elt.getReportOid()));
                }
            }
            elt.setFolderName(this.getName(SessionParameterType.FOLDER, elt.getFolderOid()));
        } else if (bean instanceof BeanTaskScript) {
            elt = (BeanTaskScript)bean;
            elt.setFieldName(this.optName(SessionParameterType.PERS_FIELD, elt.getFieldOID()));
            elt.setFolderName(this.optName(SessionParameterType.FOLDER, elt.getFileOID()));
            elt.setWorldName(this.optName(SessionParameterType.WORLD, elt.getWorldOID()));
        }
    }

    private void updateOids(BeanTaskDefinition bean) throws DashboardException {
        if (bean.getFreqUnitName() != null && !bean.getFreqUnitName().isEmpty()) {
            bean.setFreqUnitOID(this.getOid(SessionParameterType.TIME_UNIT, bean.getFreqUnitName()));
        } else {
            bean.setFreqUnitOID(1);
        }
        bean.setOwnerEntOID(this.getOid(SessionParameterType.ENTITY, bean.getOwnerEntityName()));
        bean.setParentTaskOID(this.optOid(SessionParameterType.TASK, bean.getParentTaskName()));
        bean.setTaskGrpOID(this.optOid(SessionParameterType.TASK_GROUP, bean.getTaskGroupName()));
        if (bean instanceof BeanTaskDataMart) {
            BeanTaskDataMart elt = (BeanTaskDataMart)bean;
            switch (elt.getSourceType()) {
                case CSV_FILE: 
                case STD_LOG_FILE: 
                case XLS_FILE: 
                case XML_FILE: {
                    elt.setSourceFolderOid(this.optOid(SessionParameterType.FOLDER, elt.getSourceName()));
                    break;
                }
                case QUERY: {
                    elt.setSourceQueryOid(this.optOid(SessionParameterType.QUERY, elt.getSourceName()));
                    break;
                }
            }
            switch (elt.getTransformationType()) {
                case XSL: {
                    elt.setTransformationFolderOID(this.optOid(SessionParameterType.FOLDER, elt.getTransformationName()));
                    break;
                }
            }
            switch (elt.getDestinationType()) {
                case TABLE: {
                    elt.setDestinationWorldOid(this.optOid(SessionParameterType.WORLD, elt.getDestinationName()));
                    break;
                }
                case CSV_FILE: 
                case XML_FILE: 
                case XLS_FILE: 
                case PDF_FILE: 
                case GIF_FILE: 
                case PNG_FILE: 
                case JPG_FILE: 
                case SVG_FILE: {
                    elt.setDestinationFolderOid(this.optOid(SessionParameterType.FOLDER, elt.getDestinationName()));
                    break;
                }
            }
        } else if (bean instanceof BeanTaskDocExport) {
            BeanTaskDocExport elt;
            Integer hist = this.optOid(SessionParameterType.TIME_UNIT, (elt = (BeanTaskDocExport)bean).getTimeUnitName());
            elt.setTimeHistory(hist == null ? 0 : hist);
            switch (elt.getDataType()) {
                case 2: {
                    elt.setDashboardOid(this.optOid(SessionParameterType.DASHBOARD, elt.getDashboardName()));
                    break;
                }
                case 1: {
                    elt.setReportOid(this.optOid(SessionParameterType.REPORT, elt.getReportName()));
                }
            }
        } else if (bean instanceof BeanTaskDocGeneration) {
            BeanTaskDocGeneration elt = (BeanTaskDocGeneration)bean;
            switch (elt.getSourceType()) {
                case 2: {
                    elt.setDashboardOid(this.optOid(SessionParameterType.DASHBOARD, elt.getDashboardName()));
                    break;
                }
                case 1: {
                    elt.setReportOid(this.optOid(SessionParameterType.REPORT, elt.getReportName()));
                }
            }
            elt.setFolderOid(this.getOid(SessionParameterType.FOLDER, elt.getFolderName()));
        } else if (bean instanceof BeanTaskScript) {
            BeanTaskScript elt = (BeanTaskScript)bean;
            elt.setFileOID(this.getOid(SessionParameterType.FOLDER, elt.getFolderName()));
            elt.setWorldOID(this.getOid(SessionParameterType.WORLD, elt.getWorldName()));
        }
    }

    private ParameterResponse getCopy(String name, ExpressionEvaluationData data) throws DashboardException {
        BeanTaskDefinition elt = this.helper.get((Dao)this.dao, name, 2, BeanTaskDefinition.class);
        if (elt.getTaskType() == TaskType.TASK_TYPE_METRIC || elt.getTaskType() == TaskType.TASK_TYPE_CONTROL) {
            throw new DashboardException();
        }
        this.helper.updateForCopy((Bean)elt, this.autoNameGeneration);
        this.updateDescKeys(elt, true);
        this.updateNames((BeanTask)elt);
        elt.setOwnerEntOID(data.getEntityOid().intValue());
        elt.setOwnerEntityName(data.getEntityName());
        elt.setCreationDate(new Date());
        elt.setOwner(data.getUserName());
        elt.setLastModificationDate(new Date());
        elt.setLastModifier(data.getUserName());
        return this.helper.getResponse((I18nElement)elt, data, SessionParameterType.TASK);
    }

    @Override
    public ParametersListResponse getResponse(ParametersListRequest value, ExpressionEvaluationData data) throws DashboardException {
        WorkspaceDao workspaceDao = this.daoFactory.getWorkspaceDao();
        try {
            int accessLevel = workspaceDao.getAccessLevelForEC(data.getExecutionContextOid().intValue(), SessionParameterType.TASK).getAccessLevel();
            if (accessLevel == 0) {
                boolean limitedAccess = workspaceDao.getLimitedAccessForUser(data.getUserOid().intValue(), data.getExecutionContextOid().intValue(), SessionParameterType.TASK);
                if (!limitedAccess) {
                    throw new SecurityException();
                }
                accessLevel = 1;
            }
            int instanceType = value.getBeanType() == null ? 1 : value.getBeanType();
            List<Element> eltList = this.list(value.getFilter(), instanceType, value.getSortedField(), value.getMaxSize(), data);
            return this.helper.list(eltList, value.getMaxSize(), false, SessionParameterType.TASK, accessLevel, data);
        }
        catch (Exception e) {
            throw this.getException(e);
        }
    }

    @Override
    public DependencyResponse getResponse(DependencyRequest value, ExpressionEvaluationData data) throws DashboardException {
        BeanTask elt = this.helper.get((Dao)this.dao, value.getName(), 1, BeanTask.class);
        if (elt.getTaskType() == TaskType.TASK_TYPE_METRIC || elt.getTaskType() == TaskType.TASK_TYPE_CONTROL) {
            throw new DashboardException();
        }
        List<DependencyGroup> dependencies = this.getDependencies((Bean)elt, data);
        return this.helper.getResponse((Bean)elt, dependencies, data, SessionParameterType.TASK);
    }

    public BeanTask getCore(String name) throws DashboardException {
        BeanTask elt = this.helper.get((Dao)this.dao, name, 1, BeanTask.class);
        this.updateNames(elt);
        return elt;
    }

    public BeanTaskDefinition getDefinition(String name) throws DashboardException {
        BeanTaskDefinition elt = this.helper.get((Dao)this.dao, name, 2, BeanTaskDefinition.class);
        if (elt.getTaskType() == TaskType.TASK_TYPE_METRIC || elt.getTaskType() == TaskType.TASK_TYPE_CONTROL) {
            throw new DashboardException();
        }
        this.updateNames((BeanTask)elt);
        return elt;
    }

    @Override
    public List<Element> list(DefaultFilter defaultFilter, int instanceType, ParametersListRequest.SortedField sort, Integer maxSize, ExpressionEvaluationData data) throws DashboardException {
        DbTaskFilter filter = this.helper.getFilter(defaultFilter, data, DbTaskFilter.class);
        if (defaultFilter instanceof TaskFilter) {
            TaskFilter src = (TaskFilter)defaultFilter;
            filter.setDashboardOid(this.optOid(SessionParameterType.DASHBOARD, src.getDashboardName()));
            filter.setFolderOid(this.optOid(SessionParameterType.FOLDER, src.getFolderName()));
            filter.setParentTaskOid(this.optOids(SessionParameterType.TASK, src.getParentTaskName()));
            filter.setPersFieldOid(this.optOid(SessionParameterType.PERS_FIELD, src.getPersFieldName()));
            filter.setQueryOid(this.optOid(SessionParameterType.QUERY, src.getQueryName()));
            filter.setReportOid(this.optOid(SessionParameterType.REPORT, src.getReportName()));
            filter.setTaskGrpOid(this.optOids(SessionParameterType.TASK_GROUP, src.getTaskGroupName()));
            filter.setTaskTypeSet(src.getTaskTypeSet());
            filter.setTimeUnitOid(this.optOid(SessionParameterType.TIME_UNIT, src.getTimeUnitName()));
        }
        List eltList = this.dao.listAll((DbDefaultFilter)filter, instanceType, sort, maxSize);
        for (Element elt : eltList) {
            this.updateNames((BeanTask)elt);
        }
        return eltList;
    }

    boolean exists(DbTaskFilter filter) {
        List eltList = this.dao.listAll((DbDefaultFilter)filter, 1, null, Integer.valueOf(1));
        return !eltList.isEmpty();
    }

    @Override
    public List<DependencyGroup> getDependencies(Bean elt, ExpressionEvaluationData data) throws DashboardException {
        return this.helper.getDependencies(this.getDependencyDefinitionList(elt), data);
    }

    private List<DependencyDefinition> getDependencyDefinitionList(Bean elt) {
        Integer objectID = elt.getObjectID();
        ArrayList<DependencyDefinition> list = new ArrayList<DependencyDefinition>();
        DbTaskFilter taskFilter = new DbTaskFilter();
        taskFilter.setParentTaskOid(new Integer[]{objectID});
        list.add(new DependencyDefinition((DbDefaultFilter)taskFilter, SessionParameterType.TASK));
        return list;
    }

    protected void updateDescKeys(BeanTaskDefinition bean, boolean replace) {
        this.helper.updateDescKey((Bean)bean, replace);
        if (replace || this.helper.isInvalidDescKey(bean.getMessageBodyKey())) {
            bean.setMessageBodyKey(this.guidFactory.generateGUID((Object)bean));
        }
        if (replace || this.helper.isInvalidDescKey(bean.getMessageSubjectKey())) {
            bean.setMessageSubjectKey(this.guidFactory.generateGUID((Object)bean));
        }
    }

    @Override
    public List<Element> getReferences(int objectID, ExpressionEvaluationData data) {
        ArrayList<Element> l = new ArrayList<Element>();
        Integer oid = objectID;
        DbDashboardFilter dashboardFilter = new DbDashboardFilter();
        dashboardFilter.setUsedByTaskDocExport(oid);
        DashboardDao dashboardDao = this.daoFactory.getDashboardDao();
        l.addAll(dashboardDao.listAll((DbDefaultFilter)dashboardFilter, 1));
        dashboardFilter = new DbDashboardFilter();
        dashboardFilter.setUsedByTaskDocGeneration(oid);
        l.addAll(dashboardDao.listAll((DbDefaultFilter)dashboardFilter, 1));
        DbReportFilter reportFilter = new DbReportFilter();
        reportFilter.setUsedByTaskDocExport(oid);
        ReportDao reportDao = this.daoFactory.getReportDao();
        l.addAll(reportDao.listAll((DbDefaultFilter)reportFilter, 1));
        reportFilter = new DbReportFilter();
        reportFilter.setUsedByTaskDocGeneration(oid);
        l.addAll(reportDao.listAll((DbDefaultFilter)reportFilter, 1));
        DbFolderFilter folderFilter = new DbFolderFilter();
        folderFilter.setUsedByTaskDataMart(oid);
        FolderDao folderDao = this.daoFactory.getFolderDao();
        l.addAll(folderDao.listAll((DbDefaultFilter)folderFilter, 1));
        DbWorldFilter worldFilter = new DbWorldFilter();
        worldFilter.setUsedByTaskDataMart(oid);
        WorldDao worldDao = this.daoFactory.getWorldDao();
        l.addAll(worldDao.listAll((DbDefaultFilter)worldFilter, 1));
        DbQueryFilter queryFilter = new DbQueryFilter();
        queryFilter.setUsedByTaskDataMart(oid);
        QueryDao queryDao = this.daoFactory.getQueryDao();
        l.addAll(queryDao.listAll((DbDefaultFilter)queryFilter, 1));
        return l;
    }

    void updateFreq(BeanTaskDefinition elt) throws DashboardException {
        TimeUnitHelper timeUnitHelper = TimeUnitHelper.getInstance(this.daoFactory);
        BeanTimeUnit timeUnit = timeUnitHelper.getDefinition(elt.getFreqUnitName());
        elt.setFreqConvFactor(timeUnit.getConvFactor());
        elt.setFreqConvField(timeUnit.getConvField());
    }

    void updateMessageUserList(BeanTaskDefinition elt) throws DashboardException {
        ArrayList list = new ArrayList(elt.getMessageUserList());
        elt.getMessageUserList().clear();
        HashSet<String> names = new HashSet<String>();
        for (I18nElement e : list) {
            if (e == null || e.getName() == null) continue;
            names.add(e.getName());
        }
        if (names.isEmpty()) {
            return;
        }
        UserHelper userHelper = UserHelper.getInstance(this.daoFactory);
        for (String name : names) {
            elt.getMessageUserList().add(userHelper.getCore(name));
        }
    }

    void initThresholds(ITaskWithThresholds elt) throws DashboardException {
        ThresholdTypeHelper helper = ThresholdTypeHelper.getInstance(this.daoFactory);
        BeanThresholdTypeDefinition def = helper.getDefinition("ewwiiiiii");
        elt.setThresholdTypeName(def.getName());
        elt.setThresholdTypeOID(def.getObjectID());
        elt.setThresholds(def.getThresholds());
        elt.setThresholdIcon(def.getIcon());
    }

    void initCommon(BeanTask elt) throws DashboardException {
        PrelytisInfoHelper infoHelper = PrelytisInfoHelper.getInstance(this.daoFactory);
        elt.setTimeZone(infoHelper.getPrelytisInfo().getDefaultTimeZone());
    }

    void checkSchedule(ExpressionEvaluationData data, BeanTask elt) throws DashboardException {
        if (elt.getCronExpression() != null && !"".equals(elt.getCronExpression())) {
            if (!CronExpression.isValidExpression((String)elt.getCronExpression())) {
                throw ExceptionHelper.getInstance(data.getLocale()).createDashboardException("taskMsg.invalidCronExp", null, null);
            }
            elt.setParentTaskName(null);
            elt.setParentTaskOID(null);
            if (elt.getTaskGroupName() == null || elt.getTaskGroupName().isEmpty()) {
                throw new DashboardException();
            }
            if (elt.getTimeZone() == null || elt.getTimeZone().isEmpty()) {
                throw new DashboardException();
            }
        } else if (elt.getParentTaskName() != null && !elt.getParentTaskName().isEmpty()) {
            elt.setTaskGroupName(null);
            elt.setTaskGrpOID(null);
        }
    }

    public void updateThresholdValues(ITaskWithThresholds t, boolean str2obj) throws DashboardException {
        block4: {
            AbstractBeanReport abr;
            block3: {
                if (t.getFieldName() == null) {
                    return;
                }
                ReportHelper reportHelper = ReportHelper.getInstance(this.daoFactory);
                abr = reportHelper.getDefinition(t.getCalculationReportName());
                if (!(abr instanceof BeanReportStd)) break block3;
                BeanReportStd std = (BeanReportStd)abr;
                for (BeanReportStdUsedField usedField : std.getFieldList()) {
                    if (!t.getFieldName().equals(usedField.getName())) continue;
                    t.setDataType(ReportHelper.getDatatype(usedField));
                    this.updateThresholds(t.getThresholds(), t.getDataType(), str2obj);
                    return;
                }
                break block4;
            }
            if (!(abr instanceof BeanReportCrossTable)) break block4;
            BeanReportCrossTable ct = (BeanReportCrossTable)abr;
            for (BeanReportDataUsedField usedField : ct.getDataFieldList()) {
                if (!t.getFieldName().equals(usedField.getName())) continue;
                t.setDataType(ReportHelper.getDatatype(usedField));
                this.updateThresholds(t.getThresholds(), t.getDataType(), str2obj);
                return;
            }
        }
    }

    private void updateThresholds(Thresholds ts, DataType dt, boolean str2obj) {
        ConversionHelper conversionHelper = ConversionHelper.getDBConverter();
        for (Threshold t : ts) {
            try {
                if (str2obj) {
                    t.setValue(conversionHelper.parse(dt, (String)t.getValue()));
                    continue;
                }
                t.setValue((Object)conversionHelper.format(conversionHelper.fix(dt, t.getValue())));
            }
            catch (Exception exception) {}
        }
    }
}

