/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.model.helper;

import com.prelytis.dashboard.dao.Dao;
import com.prelytis.dashboard.dao.DaoFactory;
import com.prelytis.dashboard.dao.PrelytisInfoDao;
import com.prelytis.dashboard.dao.TextDao;
import com.prelytis.dashboard.dao.WorkspaceDao;
import com.prelytis.dashboard.dao.filter.DbDashboardFilter;
import com.prelytis.dashboard.dao.filter.DbDefaultFilter;
import com.prelytis.dashboard.dao.filter.DbTextFilter;
import com.prelytis.dashboard.helper.TextDocumentHelper;
import com.prelytis.dashboard.interfaces.DashboardException;
import com.prelytis.dashboard.interfaces.Element;
import com.prelytis.dashboard.interfaces.I18nElement;
import com.prelytis.dashboard.interfaces.SecurityException;
import com.prelytis.dashboard.interfaces.SessionParameterType;
import com.prelytis.dashboard.model.helper.Dependency;
import com.prelytis.dashboard.model.helper.DependencyDefinition;
import com.prelytis.dashboard.model.helper.EntityHelper;
import com.prelytis.dashboard.model.helper.ParameterHelper;
import com.prelytis.dashboard.value.DependencyGroup;
import com.prelytis.dashboard.value.DependencyRequest;
import com.prelytis.dashboard.value.DependencyResponse;
import com.prelytis.dashboard.value.ParameterRequest;
import com.prelytis.dashboard.value.ParameterResponse;
import com.prelytis.dashboard.value.ParametersListRequest;
import com.prelytis.dashboard.value.ParametersListResponse;
import com.prelytis.dashboard.value.data.Bean;
import com.prelytis.dashboard.value.data.BeanText;
import com.prelytis.dashboard.value.data.OwnerEntity;
import com.prelytis.dashboard.value.data.filter.DefaultFilter;
import com.prelytis.dashboard.value.util.ExpressionEvaluationData;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public final class TextHelper
extends ParameterHelper
implements Dependency {
    private final EntityHelper entityHelper;
    private final boolean autoNameGeneration;
    private final TextDao dao;

    TextHelper(DaoFactory daoFactory) {
        super(daoFactory);
        this.dao = this.daoFactory.getTextDao();
        this.entityHelper = new EntityHelper(daoFactory);
        PrelytisInfoDao prelytisInfoDao = daoFactory.getPrelytisInfoDao();
        this.autoNameGeneration = prelytisInfoDao.isAutoNameGeneration();
    }

    public static TextHelper getInstance(DaoFactory daoFactory) {
        return new TextHelper(daoFactory);
    }

    @Override
    public ParameterResponse getResponse(ParameterRequest value, ExpressionEvaluationData data) throws DashboardException {
        ParameterRequest.Action action = value.getAction() == null ? ParameterRequest.Action.OPEN : value.getAction();
        switch (action) {
            case OPEN: 
            case OPEN_AS_SUPER_USER: {
                return this.get(value.getInstanceType(), value.getName(), data);
            }
            case COPY: {
                return this.getCopy(value.getName(), data);
            }
            case DELETE: {
                return this.getDelete(value.getName(), (Bean)((BeanText)value.getElement()), data);
            }
            case SAVE_AS_NEW: {
                return this.getSaveAsNew((BeanText)value.getElement(), data);
            }
            case SAVE: {
                return this.getSave((BeanText)value.getElement(), data);
            }
            case NEW: {
                return this.getNew(data);
            }
        }
        throw new DashboardException();
    }

    private ParameterResponse getNew(ExpressionEvaluationData data) throws DashboardException {
        return this.helper.getResponse((I18nElement)this.create(data), data, SessionParameterType.TEXT);
    }

    public BeanText create(ExpressionEvaluationData data) throws DashboardException {
        BeanText elt = new BeanText();
        if (this.autoNameGeneration) {
            elt.setName(this.guidFactory.generateGUID((Object)elt));
        }
        this.updateDescKeys(elt, false);
        elt.setOwnerEntOID(data.getEntityOid().intValue());
        elt.setOwnerEntityName(data.getEntityName());
        elt.setCreationDate(new Date());
        elt.setOwner(data.getUserName());
        elt.setLastModificationDate(new Date());
        elt.setLastModifier(data.getUserName());
        return elt;
    }

    private void updateDescKeys(BeanText elt, boolean replace) {
        this.helper.updateDescKey((Bean)elt, replace);
        if (replace || this.helper.isInvalidDescKey(elt.getTextFieldKey())) {
            elt.setTextFieldKey(this.guidFactory.generateGUID((Object)elt));
        }
    }

    private ParameterResponse getSaveAsNew(BeanText elt, ExpressionEvaluationData data) throws DashboardException {
        this.save(elt, data, true);
        return this.helper.getResponse((I18nElement)elt, data, SessionParameterType.TEXT);
    }

    private ParameterResponse getSave(BeanText elt, ExpressionEvaluationData data) throws DashboardException {
        this.save(elt, data, false);
        return this.helper.getResponse((I18nElement)elt, data, SessionParameterType.TEXT);
    }

    public void save(BeanText elt, ExpressionEvaluationData data, boolean isNew) throws DashboardException {
        this.save(elt, data, isNew, false);
    }

    public void save(BeanText elt, ExpressionEvaluationData data, boolean isNew, boolean isImport) throws DashboardException {
        this.helper.checkForSave((Dao)this.dao, data, (Bean)elt, isNew, isImport);
        this.validate(elt.getTextFieldMap());
        this.updateOids(elt);
        this.updateDescKeys(elt, false);
        this.updateDescriptionMap(elt, this.helper.getLocales(), data.getLocale());
        elt.setLastModificationDate(new Date());
        elt.setLastModifier(data.getUserName());
        this.helper.checkOwnerEntity(this.entityHelper, data, (OwnerEntity)elt);
        this.helper.checkForSave(data, (Element)elt);
        this.dao.save((Element)elt);
    }

    private void updateDescriptionMap(BeanText elt, List<Locale> locales, Locale defaultLocale) {
        this.helper.updateDescriptionMap((Bean)elt, locales, defaultLocale);
        this.helper.updateDescriptionMap(elt.getTextFieldMap(), locales, defaultLocale);
    }

    private void validate(Map<Locale, String> textFieldMap) throws DashboardException {
        TextDocumentHelper helper = TextDocumentHelper.getInstance(this.dao);
        for (String text : textFieldMap.values()) {
            helper.validate(text);
        }
    }

    @Override
    public void delete(String name, ExpressionEvaluationData data) throws DashboardException {
        BeanText elt = this.helper.get((Dao)this.dao, name, 1, BeanText.class);
        this.helper.checkOwnerEntity(this.entityHelper, data, (OwnerEntity)elt);
        this.helper.checkForDelete(this.getDependencyDefinitionList((Bean)elt), data, (Element)elt);
        this.dao.delete((Element)elt);
    }

    private ParameterResponse get(Integer instanceType, String name, ExpressionEvaluationData data) throws DashboardException {
        BeanText elt = this.helper.get((Dao)this.dao, name, instanceType, BeanText.class);
        this.updateNames(elt);
        return this.helper.getResponse((I18nElement)elt, data, SessionParameterType.TEXT);
    }

    private ParameterResponse getCopy(String name, ExpressionEvaluationData data) throws DashboardException {
        BeanText elt = this.helper.get((Dao)this.dao, name, 2, BeanText.class);
        this.helper.updateForCopy((Bean)elt, this.autoNameGeneration);
        this.updateDescKeys(elt, true);
        elt.setOwnerEntOID(data.getEntityOid().intValue());
        elt.setOwnerEntityName(data.getEntityName());
        elt.setCreationDate(new Date());
        elt.setOwner(data.getUserName());
        elt.setLastModificationDate(new Date());
        elt.setLastModifier(data.getUserName());
        return this.helper.getResponse((I18nElement)elt, data, SessionParameterType.TEXT);
    }

    @Override
    public ParametersListResponse getResponse(ParametersListRequest value, ExpressionEvaluationData data) throws DashboardException {
        WorkspaceDao workspaceDao = this.daoFactory.getWorkspaceDao();
        try {
            int accessLevel = workspaceDao.getAccessLevelForEC(data.getExecutionContextOid().intValue(), SessionParameterType.TEXT).getAccessLevel();
            if (accessLevel == 0) {
                boolean limitedAccess = workspaceDao.getLimitedAccessForUser(data.getUserOid().intValue(), data.getExecutionContextOid().intValue(), SessionParameterType.TEXT);
                if (!limitedAccess) {
                    throw new SecurityException();
                }
                accessLevel = 1;
            }
            int instanceType = value.getBeanType() == null ? 1 : value.getBeanType();
            List<Element> eltList = this.list(value.getFilter(), instanceType, value.getSortedField(), value.getMaxSize(), data);
            return this.helper.list(eltList, value.getMaxSize(), false, SessionParameterType.TEXT, accessLevel, data);
        }
        catch (Exception e) {
            throw this.getException(e);
        }
    }

    @Override
    public DependencyResponse getResponse(DependencyRequest value, ExpressionEvaluationData data) throws DashboardException {
        BeanText elt = this.helper.get((Dao)this.dao, value.getName(), 1, BeanText.class);
        List<DependencyGroup> dependencies = this.getDependencies((Bean)elt, data);
        return this.helper.getResponse((Bean)elt, dependencies, data, SessionParameterType.TEXT);
    }

    public BeanText getCore(String name, ExpressionEvaluationData data) throws DashboardException {
        BeanText elt = this.helper.get((Dao)this.dao, name, 1, BeanText.class);
        return elt;
    }

    @Override
    public List<Element> list(DefaultFilter defaultFilter, int instanceType, ParametersListRequest.SortedField sort, Integer maxSize, ExpressionEvaluationData data) {
        DbTextFilter filter = this.helper.getFilter(defaultFilter, data, DbTextFilter.class);
        List eltList = this.dao.listAll((DbDefaultFilter)filter, instanceType, sort, maxSize);
        return eltList;
    }

    @Override
    public List<DependencyGroup> getDependencies(Bean elt, ExpressionEvaluationData data) throws DashboardException {
        return this.helper.getDependencies(this.getDependencyDefinitionList(elt), data);
    }

    private List<DependencyDefinition> getDependencyDefinitionList(Bean elt) {
        Integer objectID = elt.getObjectID();
        ArrayList<DependencyDefinition> list = new ArrayList<DependencyDefinition>();
        DbDashboardFilter dashboardFilter = new DbDashboardFilter();
        dashboardFilter.setTextOid(objectID);
        list.add(new DependencyDefinition((DbDefaultFilter)dashboardFilter, SessionParameterType.DASHBOARD));
        return list;
    }

    private void updateNames(BeanText bean) throws DashboardException {
        bean.setOwnerEntityName(this.getName(SessionParameterType.ENTITY, bean.getOwnerEntOID()));
    }

    private void updateOids(BeanText bean) throws DashboardException {
        bean.setOwnerEntOID(this.getOid(SessionParameterType.ENTITY, bean.getOwnerEntityName()));
    }

    public BeanText getDefinition(String name) throws DashboardException {
        BeanText bean = this.helper.get((Dao)this.dao, name, 2, BeanText.class);
        this.updateNames(bean);
        return bean;
    }
}

