/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.model.helper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;

public class TimeZoneHelper {
    private Locale locale;
    private List<String> values;
    private Map<String, String> displayValues;

    public List<String> getValues() {
        return this.values;
    }

    public Map<String, String> getDisplayValues() {
        return this.displayValues;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    private String getUTCformat(TimeZone tz) {
        int offset = tz.getRawOffset() / 3600000;
        String sOffset = offset + "";
        if (offset < 10 && offset >= 0) {
            sOffset = "0" + sOffset;
        }
        if (offset < 0 && offset > -10) {
            int mOffset = -1 * offset;
            sOffset = "-0" + mOffset;
        }
        if (offset >= 0) {
            sOffset = "+" + sOffset;
        }
        return "UTC" + sOffset + ":00";
    }

    public TimeZoneHelper(Locale locale) {
        this.locale = locale;
        String[] timezoneIds = TimeZone.getAvailableIDs();
        this.values = new ArrayList<String>(timezoneIds.length);
        this.displayValues = new HashMap<String, String>();
        for (int i = 0; i < timezoneIds.length; ++i) {
            TimeZone tz = TimeZone.getTimeZone(timezoneIds[i]);
            String utc = this.getUTCformat(tz);
            this.values.add(timezoneIds[i]);
            this.displayValues.put(timezoneIds[i], utc + " - " + timezoneIds[i] + " - " + tz.getDisplayName(locale));
        }
    }
}

