/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.model.helper;

import com.prelytis.dashboard.dao.Dao;
import com.prelytis.dashboard.dao.DaoFactory;
import com.prelytis.dashboard.dao.DashboardDao;
import com.prelytis.dashboard.dao.EntityDao;
import com.prelytis.dashboard.dao.ExecutionContextDao;
import com.prelytis.dashboard.dao.LanguageDao;
import com.prelytis.dashboard.dao.MessageProviderDao;
import com.prelytis.dashboard.dao.MessageTypeDao;
import com.prelytis.dashboard.dao.PersFieldDao;
import com.prelytis.dashboard.dao.PrelytisInfoDao;
import com.prelytis.dashboard.dao.ThemeDao;
import com.prelytis.dashboard.dao.UserDao;
import com.prelytis.dashboard.dao.WorkspaceDao;
import com.prelytis.dashboard.dao.filter.DbDashboardFilter;
import com.prelytis.dashboard.dao.filter.DbDefaultFilter;
import com.prelytis.dashboard.dao.filter.DbEntityFilter;
import com.prelytis.dashboard.dao.filter.DbExecutionContextFilter;
import com.prelytis.dashboard.dao.filter.DbLanguageFilter;
import com.prelytis.dashboard.dao.filter.DbMessageTypeFilter;
import com.prelytis.dashboard.dao.filter.DbPersFieldFilter;
import com.prelytis.dashboard.dao.filter.DbThemeFilter;
import com.prelytis.dashboard.dao.filter.DbUserFilter;
import com.prelytis.dashboard.dao.filter.DbWorkspaceFilter;
import com.prelytis.dashboard.helper.ExceptionHelper;
import com.prelytis.dashboard.interfaces.DashboardException;
import com.prelytis.dashboard.interfaces.DashboardRuntimeException;
import com.prelytis.dashboard.interfaces.Element;
import com.prelytis.dashboard.interfaces.ErrorCode;
import com.prelytis.dashboard.interfaces.I18nElement;
import com.prelytis.dashboard.interfaces.SecurityException;
import com.prelytis.dashboard.interfaces.SessionParameterType;
import com.prelytis.dashboard.interfaces.SessionType;
import com.prelytis.dashboard.model.ExecutionContextHelper;
import com.prelytis.dashboard.model.helper.EntityHelper;
import com.prelytis.dashboard.model.helper.ParameterHelper;
import com.prelytis.dashboard.model.helper.References;
import com.prelytis.dashboard.persistence.helper.ListHelper;
import com.prelytis.dashboard.util.PRP;
import com.prelytis.dashboard.value.ExecutionContext;
import com.prelytis.dashboard.value.MenuItem;
import com.prelytis.dashboard.value.ParameterRequest;
import com.prelytis.dashboard.value.ParameterResponse;
import com.prelytis.dashboard.value.ParametersListRequest;
import com.prelytis.dashboard.value.ParametersListResponse;
import com.prelytis.dashboard.value.Response;
import com.prelytis.dashboard.value.UserRequest;
import com.prelytis.dashboard.value.UserResponse;
import com.prelytis.dashboard.value.data.Bean;
import com.prelytis.dashboard.value.data.BeanExecutionContext;
import com.prelytis.dashboard.value.data.BeanMessageProvDefinition;
import com.prelytis.dashboard.value.data.BeanMessageTypeDefinition;
import com.prelytis.dashboard.value.data.BeanPRPInfo;
import com.prelytis.dashboard.value.data.BeanPersField;
import com.prelytis.dashboard.value.data.BeanPersFieldValue;
import com.prelytis.dashboard.value.data.BeanUser;
import com.prelytis.dashboard.value.data.BeanUserDefinition;
import com.prelytis.dashboard.value.data.BeanUserExecutionContext;
import com.prelytis.dashboard.value.data.BeanUserMessageType;
import com.prelytis.dashboard.value.data.filter.DefaultFilter;
import com.prelytis.dashboard.value.data.filter.UserFilter;
import com.prelytis.dashboard.value.util.ExpressionEvaluationData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class UserHelper
extends ParameterHelper
implements References {
    private final boolean autoNameGeneration;
    private final UserDao dao;
    private final EntityHelper entityHelper;

    UserHelper(DaoFactory daoFactory) {
        super(daoFactory);
        this.dao = this.daoFactory.getUserDao();
        PrelytisInfoDao prelytisInfoDao = daoFactory.getPrelytisInfoDao();
        this.autoNameGeneration = prelytisInfoDao.isAutoNameGeneration();
        this.entityHelper = new EntityHelper(daoFactory);
    }

    public static UserHelper getInstance(DaoFactory daoFactory) {
        return new UserHelper(daoFactory);
    }

    @Override
    public ParameterResponse getResponse(ParameterRequest value, ExpressionEvaluationData data) throws DashboardException {
        int instanceType = value.getInstanceType() == null ? 1 : value.getInstanceType();
        ParameterRequest.Action action = value.getAction() == null ? ParameterRequest.Action.OPEN : value.getAction();
        switch (action) {
            case OPEN: 
            case OPEN_AS_SUPER_USER: {
                return this.get(instanceType, value.getName(), data);
            }
            case COPY: {
                return this.getCopy(value.getName(), data);
            }
            case DELETE: {
                return this.getDelete(value.getName(), (Bean)((BeanUser)value.getElement()), data);
            }
            case SAVE_AS_NEW: {
                return this.getSaveAsNew((BeanUserDefinition)value.getElement(), data);
            }
            case SAVE: {
                return this.getSave((BeanUserDefinition)value.getElement(), data);
            }
            case NEW: {
                return this.getNew(data);
            }
            case REFRESH: {
                if (!(value.getElement() instanceof BeanUserDefinition)) {
                    throw ExceptionHelper.getInstance(data.getLocale()).createDashboardException("nothingToRefresh", null, null);
                }
                return this.getRefresh((BeanUserDefinition)value.getElement(), data);
            }
        }
        throw new DashboardException();
    }

    private ParameterResponse getNew(ExpressionEvaluationData data) throws DashboardException {
        return this.helper.getResponse((I18nElement)this.create(data), data, SessionParameterType.USER);
    }

    public BeanUserDefinition create(ExpressionEvaluationData data) throws DashboardException {
        BeanUserDefinition elt = this.dao.getDefault();
        if (this.autoNameGeneration) {
            elt.setName(this.guidFactory.generateGUID((Object)elt));
        }
        this.helper.updateDescKey((Bean)elt, false);
        elt.setCreationDate(new Date());
        elt.setOwner(data.getUserName());
        elt.setLastModificationDate(new Date());
        elt.setLastModifier(data.getUserName());
        BeanUserExecutionContext uec = new BeanUserExecutionContext();
        uec.setSystem(true);
        uec.setEntityOid(data.getEntityOid().intValue());
        uec.setProfile(data.getProfile().intValue());
        uec.setWorkspaceOid(data.getWorkspaceOid().intValue());
        elt.getExecutionContextList().clear();
        elt.getExecutionContextList().add(uec);
        PrelytisInfoDao prelytisInfoDao = this.daoFactory.getPrelytisInfoDao();
        BeanPRPInfo info = prelytisInfoDao.getPrelytisInfo();
        elt.setLanguageOID(info.getLanguageOID());
        elt.setTimeZone(info.getDefaultTimeZone());
        return elt;
    }

    private ParameterResponse getSaveAsNew(BeanUserDefinition elt, ExpressionEvaluationData data) throws DashboardException {
        this.save(elt, data, true);
        return this.helper.getResponse((I18nElement)elt, data, SessionParameterType.USER);
    }

    private ParameterResponse getSave(BeanUserDefinition elt, ExpressionEvaluationData data) throws DashboardException {
        this.save(elt, data, false);
        return this.helper.getResponse((I18nElement)elt, data, SessionParameterType.USER);
    }

    public void save(BeanUserDefinition elt, ExpressionEvaluationData data, boolean isNew) throws DashboardException {
        this.save(elt, data, isNew, false);
    }

    public void save(BeanUserDefinition elt, ExpressionEvaluationData data, boolean isNew, boolean isImport) throws DashboardException {
        this.helper.checkForSave((Dao)this.dao, data, (Bean)elt, isNew, isImport);
        try {
            String userName = this.dao.getUserName(elt.getLogin());
            if (!userName.equals(elt.getName())) {
                throw ExceptionHelper.getInstance(data.getLocale()).createDashboardException(ErrorCode.INSIGHT_USER_DUPLICATE_LOGIN, "userDuplicateLogin", null, null);
            }
        }
        catch (DashboardRuntimeException userName) {
            // empty catch block
        }
        this.updateOids((BeanUser)elt);
        if (!isNew) {
            EntityDao.Relation r;
            BeanUserDefinition ref = (BeanUserDefinition)this.dao.getDefinition(elt.getName());
            boolean wasEC = this.isExecutionContext(ref.getExecutionContextList());
            boolean isEC = this.isExecutionContext(elt.getExecutionContextList());
            List newList = elt.getExecutionContextList();
            ArrayList oldList = new ArrayList(newList);
            newList.clear();
            boolean addCurrent = ref.getObjectID() == data.getUserOid().intValue();
            int cpt = 0;
            Iterator iterator = oldList.iterator();
            while (iterator.hasNext()) {
                BeanUserExecutionContext uec = (BeanUserExecutionContext)iterator.next();
                r = this.entityHelper.getRelation(data.getEntityOid(), uec.getEntityOid());
                switch (r) {
                    case CHILD: 
                    case SAME: {
                        uec.setIndex(cpt++);
                        newList.add(uec);
                        if (!addCurrent || uec.getObjectID() != data.getExecutionContextOid().intValue()) break;
                        addCurrent = false;
                    }
                }
            }
            if (wasEC && isEC) {
                for (BeanUserExecutionContext uec : ref.getExecutionContextList()) {
                    r = this.entityHelper.getRelation(data.getEntityOid(), uec.getEntityOid());
                    switch (r) {
                        case NONE: 
                        case PARENT: {
                            uec.setIndex(cpt++);
                            newList.add(uec);
                            break;
                        }
                        case SAME: {
                            if (!addCurrent || uec.getObjectID() != data.getExecutionContextOid().intValue()) break;
                            uec.setIndex(cpt++);
                            newList.add(uec);
                            addCurrent = false;
                        }
                    }
                }
            }
        }
        if (elt.getStartDate() != null && elt.getEndDate() != null && elt.getStartDate().after(elt.getEndDate())) {
            throw ExceptionHelper.getInstance(data.getLocale()).createDashboardException(ErrorCode.INSIGHT_USER_INCORRECT_START_END_DATE, "startEndDateOrder", null, null);
        }
        HashSet<Integer> set = new HashSet<Integer>();
        for (BeanExecutionContext ec : elt.getExecutionContextList()) {
            if (set.add(ec.getObjectID())) continue;
            throw ExceptionHelper.getInstance(data.getLocale()).createDashboardException(ErrorCode.INSIGHT_USER_DUPLICATE_EXECUTION_CONTEXT, "duplicateExecutionContext", null, null);
        }
        this.helper.updateDescKey((Bean)elt, false);
        this.helper.updateDescriptionMap((Bean)elt, data.getLocale());
        elt.setLastModificationDate(new Date());
        elt.setLastModifier(data.getUserName());
        List persFieldList = elt.getBeanPersFieldValueList();
        Map map = this.getMap(persFieldList);
        persFieldList.clear();
        BeanUserDefinition def = this.dao.getDefault();
        for (BeanPersFieldValue value : def.getBeanPersFieldValueList()) {
            BeanPersFieldValue v = (BeanPersFieldValue)map.get(value.getName());
            if (v != null) {
                value.setValues(v.getValues());
            }
            persFieldList.add(value);
        }
        List msgList = elt.getBeanUserMessageTypeList();
        Map msgMap = this.getMap(msgList);
        msgList.clear();
        for (BeanUserMessageType msgType : def.getBeanUserMessageTypeList()) {
            BeanUserMessageType m = (BeanUserMessageType)msgMap.get(msgType.getName());
            if (m != null) {
                msgType.setActive(m.getActive());
                msgType.setIdentifier(m.getIdentifier());
            }
            msgList.add(msgType);
        }
        this.dao.save((Element)elt);
    }

    @Override
    public void delete(String name, ExpressionEvaluationData data) throws DashboardException {
        BeanUser elt = this.helper.get((Dao)this.dao, name, 1, BeanUser.class);
        if (data.getUserOid().intValue() == elt.getObjectID()) {
            throw new SecurityException();
        }
        this.helper.checkForDelete(null, data, (Element)elt);
        this.dao.delete((Element)elt);
    }

    private ParameterResponse getRefresh(BeanUserDefinition bean, ExpressionEvaluationData data) throws DashboardException {
        this.refresh(bean);
        return this.helper.getResponse((I18nElement)bean, data, SessionParameterType.USER);
    }

    private ParameterResponse get(int instanceType, String name, ExpressionEvaluationData data) throws DashboardException {
        BeanUser elt = this.helper.get((Dao)this.dao, name, instanceType, BeanUser.class);
        this.updateNames(elt);
        return this.helper.getResponse((I18nElement)elt, data, SessionParameterType.USER);
    }

    private boolean isExecutionContext(List<BeanUserExecutionContext> executionContextList) {
        if (executionContextList == null || executionContextList.isEmpty()) {
            return true;
        }
        if (executionContextList.size() == 1) {
            return !executionContextList.get(0).getSystem();
        }
        return true;
    }

    private void updateNames(BeanUser bean) throws DashboardException {
        if (!bean.getExecutionContextList().isEmpty()) {
            bean.setDefaultExecutionContextName(((BeanUserExecutionContext)bean.getExecutionContextList().get(0)).getName());
        }
        bean.setLanguageName(this.getName(SessionParameterType.LANGUAGE, bean.getLanguageOID()));
        bean.setThemeName(this.getName(SessionParameterType.THEME, bean.getThemeOID()));
        for (BeanUserExecutionContext uec : bean.getExecutionContextList()) {
            if (uec.getDashBoardOid() == null || uec.getDashBoardOid() == 0) {
                uec.setDashboardName(null);
            } else {
                uec.setDashboardName(this.getName(SessionParameterType.DASHBOARD, (int)uec.getDashBoardOid()));
            }
            uec.setEntityName(this.getName(SessionParameterType.ENTITY, uec.getEntityOid()));
            uec.setWorkspaceName(this.getName(SessionParameterType.WORKSPACE, uec.getWorkspaceOid()));
            bean.setHomeName(uec.getDashboardName());
        }
        if (bean instanceof BeanUserDefinition) {
            // empty if block
        }
    }

    private void updateOids(BeanUser bean) throws DashboardException {
        if (!bean.getExecutionContextList().isEmpty()) {
            bean.setDefaultExecutionContextOID(((BeanUserExecutionContext)bean.getExecutionContextList().get(0)).getObjectID());
        }
        if (bean.getLanguageName() != null) {
            bean.setLanguageOID(this.getOid(SessionParameterType.LANGUAGE, bean.getLanguageName()));
        }
        bean.setThemeOID(this.getOid(SessionParameterType.THEME, bean.getThemeName()));
        if (bean.getExecutionContextList().size() == 1 && ((BeanUserExecutionContext)bean.getExecutionContextList().get(0)).getSystem()) {
            BeanUserExecutionContext uec = (BeanUserExecutionContext)bean.getExecutionContextList().get(0);
            if (uec.getDashboardName() == null || uec.getDashboardName().isEmpty()) {
                uec.setDashBoardOid(null);
            } else {
                uec.setDashBoardOid(Integer.valueOf(this.getOid(SessionParameterType.DASHBOARD, uec.getDashboardName())));
            }
            uec.setEntityOid(this.getOid(SessionParameterType.ENTITY, uec.getEntityName()));
            uec.setWorkspaceOid(this.getOid(SessionParameterType.WORKSPACE, uec.getWorkspaceName()));
        } else {
            for (BeanUserExecutionContext uec : bean.getExecutionContextList()) {
                uec.setObjectID(this.getOid(SessionParameterType.EXECUTION_CONTEXT, uec.getName()));
                if (uec.getDashboardName() == null || uec.getDashboardName().isEmpty()) {
                    uec.setDashBoardOid(null);
                    continue;
                }
                uec.setDashBoardOid(Integer.valueOf(this.getOid(SessionParameterType.DASHBOARD, uec.getDashboardName())));
            }
        }
        if (bean instanceof BeanUserDefinition) {
            // empty if block
        }
    }

    private ParameterResponse getCopy(String name, ExpressionEvaluationData data) throws DashboardException {
        BeanUserDefinition elt = this.helper.get((Dao)this.dao, name, 2, BeanUserDefinition.class);
        this.helper.updateForCopy((Bean)elt, this.autoNameGeneration);
        this.updateNames((BeanUser)elt);
        this.helper.updateDescKey((Bean)elt, true);
        elt.setCreationDate(new Date());
        elt.setOwner(data.getUserName());
        elt.setLastModificationDate(new Date());
        elt.setLastModifier(data.getUserName());
        return this.helper.getResponse((I18nElement)elt, data, SessionParameterType.USER);
    }

    private void refresh(BeanUserDefinition bean) {
        List persFieldList = bean.getBeanPersFieldValueList();
        ListHelper listHelper = ListHelper.getInstance();
        Map mapPF = listHelper.getMapByName(persFieldList);
        PersFieldDao persFieldDao = this.daoFactory.getPersFieldDao();
        DbPersFieldFilter persFieldFilter = new DbPersFieldFilter();
        Integer[] list = new Integer[]{1, 3, 4};
        persFieldFilter.setTypeList(list);
        List beanPersFieldList = persFieldDao.listAll((DbDefaultFilter)persFieldFilter, 1);
        persFieldList.clear();
        for (int i = 0; i < beanPersFieldList.size(); ++i) {
            BeanPersField persField = (BeanPersField)beanPersFieldList.get(i);
            BeanPersFieldValue value = new BeanPersFieldValue();
            value.setObjectID(persField.getObjectID());
            value.setName(persField.getName());
            value.setDescriptionKey(persField.getDescriptionKey());
            value.setDataType(persField.getDataType());
            value.setType(persField.getType());
            value.setDefValues(persField.getDefValues());
            BeanPersFieldValue oldValue = (BeanPersFieldValue)mapPF.get(persField.getName());
            if (oldValue != null) {
                value.setValues(oldValue.getValues());
            } else {
                value.setValues(persField.getDefValues());
            }
            persFieldList.add(value);
        }
        List messageTypeList = bean.getBeanUserMessageTypeList();
        Map mapMT = listHelper.getMapByName(messageTypeList);
        MessageTypeDao messageTypeDao = this.daoFactory.getMessageTypeDao();
        MessageProviderDao messageProvDao = this.daoFactory.getMessageProviderDao();
        List beanMessageTypeList = messageTypeDao.listAll(null, 2);
        messageTypeList.clear();
        for (int i = 0; i < beanMessageTypeList.size(); ++i) {
            BeanMessageTypeDefinition messageType = (BeanMessageTypeDefinition)beanMessageTypeList.get(i);
            BeanMessageProvDefinition messageProv = (BeanMessageProvDefinition)messageProvDao.getDefinition(messageType.getMessageProvOID());
            BeanUserMessageType userMessageType = new BeanUserMessageType(messageType, messageProv);
            BeanUserMessageType initial = (BeanUserMessageType)mapMT.get(messageType.getName());
            if (initial != null) {
                userMessageType.setIdentifier(initial.getIdentifier());
                userMessageType.setActive(initial.getActive());
            }
            messageTypeList.add(userMessageType);
        }
    }

    @Override
    public ParametersListResponse getResponse(ParametersListRequest value, ExpressionEvaluationData data) throws DashboardException {
        WorkspaceDao workspaceDao = this.daoFactory.getWorkspaceDao();
        try {
            int accessLevel = workspaceDao.getAccessLevelForEC(data.getExecutionContextOid().intValue(), SessionParameterType.USER).getAccessLevel();
            boolean restricted = false;
            if (accessLevel == 0) {
                boolean limitedAccess = workspaceDao.getLimitedAccessForUser(data.getUserOid().intValue(), data.getExecutionContextOid().intValue(), SessionParameterType.USER);
                if (!limitedAccess) {
                    throw new SecurityException();
                }
                accessLevel = 1;
                restricted = true;
            }
            int instanceType = value.getBeanType() == null ? 1 : value.getBeanType();
            List<Element> eltList = this.list(value.getFilter(), instanceType, value.getSortedField(), value.getMaxSize(), data);
            return this.helper.list(eltList, value.getMaxSize(), restricted, SessionParameterType.USER, accessLevel, data);
        }
        catch (Exception e) {
            throw this.getException(e);
        }
    }

    public BeanUser getCore(String userName) throws DashboardException {
        BeanUser elt = this.helper.get((Dao)this.dao, userName, 1, BeanUser.class);
        this.updateNames(elt);
        return elt;
    }

    @Override
    public List<Element> list(DefaultFilter defaultFilter, int instanceType, ParametersListRequest.SortedField sort, Integer maxSize, ExpressionEvaluationData data) throws DashboardException {
        DbUserFilter filter = this.helper.getFilter(defaultFilter, data, DbUserFilter.class);
        if (data != null) {
            filter.setMinProfile(data.getProfile());
        }
        if (defaultFilter instanceof UserFilter) {
            UserFilter src = (UserFilter)defaultFilter;
            filter.setActive(src.getActive());
            filter.setAllButUserOid(this.optOid(SessionParameterType.USER, src.getAllButUserName()));
            filter.setDashboardOid(this.optOid(SessionParameterType.DASHBOARD, src.getDashboardName()));
            filter.setEntityOid(this.optOid(SessionParameterType.ENTITY, src.getEntityName()));
            filter.setExecutionContextOid(this.optOid(SessionParameterType.EXECUTION_CONTEXT, src.getExecutionContextName()));
            filter.setThemeOid(this.optOid(SessionParameterType.THEME, src.getThemeName()));
            filter.setUserLanguageOid(this.optOid(SessionParameterType.LANGUAGE, src.getUserLanguageName()));
            filter.setWorkspaceOid(this.optOid(SessionParameterType.WORKSPACE, src.getWorkspaceName()));
        }
        if (filter.getSelectForDisplayType() == null) {
            filter.setSelectForDisplayType(Integer.valueOf(5));
        }
        List eltList = this.dao.listAll((DbDefaultFilter)filter, instanceType, sort, maxSize);
        if (instanceType != 1) {
            for (Element elt : eltList) {
                this.updateNames((BeanUser)elt);
            }
        }
        return eltList;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public UserResponse getResponse(UserRequest request, ExpressionEvaluationData data) throws DashboardException {
        BeanUserDefinition user = this.helper.get((Dao)this.dao, data.getUserName(), 2, BeanUserDefinition.class);
        this.updateNames((BeanUser)user);
        if (request.getLanguageName() != null) {
            user.setLanguageName(request.getLanguageName());
        }
        if (request.getTimeZoneName() != null) {
            user.setTimeZone(request.getTimeZoneName());
        }
        if (request.getThemeName() != null) {
            user.setThemeName(request.getThemeName());
        }
        user.setHomeName(request.getHomeName());
        user.setAvatar(request.getAvatar());
        this.updateOids((BeanUser)user);
        user.setRichGraphics(request.getRichGraphics());
        user.setUseAmTimeZone(request.getUseAmTimeZone());
        user.setUseAmTheme(request.getUseAmTheme());
        user.setUseAmLang(request.getUseAmLang());
        user.setUseAmHome(request.getUseAmHome());
        user.setHeaderType(request.getHeaderType());
        PrelytisInfoDao prelytisInfoDao = this.daoFactory.getPrelytisInfoDao();
        if (prelytisInfoDao.isChangePasswordEnabled() && (request.getNewPassword() != null || request.getOldPassword() != null)) {
            try {
                if (!PRP.checkPassword((String)user.getPassword(), (String)request.getOldPassword())) throw ExceptionHelper.getInstance(data.getLocale()).createDashboardException(ErrorCode.INSIGHT_INVALID_CREDENTIALS, "invalidPassword", null, null);
                String passwordRegExp = prelytisInfoDao.getPasswordRegex();
                if (passwordRegExp != null) {
                    Pattern pattern = Pattern.compile(passwordRegExp);
                    Matcher matcher = pattern.matcher(request.getNewPassword());
                    if (!matcher.find()) throw ExceptionHelper.getInstance(data.getLocale()).createDashboardException(ErrorCode.INSIGHT_USER_WEAK_PASSWORD, "weakPassword", null, null);
                    user.setPassword(PRP.encryptPassword((String)request.getNewPassword()));
                } else {
                    user.setPassword(PRP.encryptPassword((String)request.getNewPassword()));
                }
            }
            catch (Exception e) {
                throw this.getException(e);
            }
        }
        this.dao.saveUserSettings(user);
        ExecutionContextHelper ech = ExecutionContextHelper.getInstance(this.daoFactory);
        ExecutionContext ec = ech.getExecutionContext((BeanUser)user, request.getExecContextName());
        UserResponse response = new UserResponse();
        response.setExecutionContext(ec);
        return response;
    }

    public void setNotifications(Response response, ExpressionEvaluationData data) {
        List list = this.dao.listNotifications(data.getUserOid().intValue(), data.getExecutionContextOid().intValue());
        response.getNotifications().addAll(list);
    }

    public BeanUserDefinition getDefinition(String name) throws DashboardException {
        BeanUserDefinition bean = this.helper.get((Dao)this.dao, name, 2, BeanUserDefinition.class);
        this.updateNames((BeanUser)bean);
        return bean;
    }

    public BeanUser getCore(int userOid) throws DashboardException {
        BeanUser elt = (BeanUser)this.dao.getCore(userOid);
        this.updateNames(elt);
        return elt;
    }

    @Override
    public List<Element> getReferences(int objectID, ExpressionEvaluationData data) {
        ArrayList<Element> l = new ArrayList<Element>();
        Integer oid = objectID;
        DbWorkspaceFilter workspaceFilter = new DbWorkspaceFilter();
        workspaceFilter.setOwnerEntityOid(data.getEntityOid());
        workspaceFilter.setSelectForDisplayType(5);
        workspaceFilter.setUsedByUser(oid);
        WorkspaceDao workspaceDao = this.daoFactory.getWorkspaceDao();
        l.addAll(workspaceDao.listAll((DbDefaultFilter)workspaceFilter, 1));
        DbEntityFilter entityFilter = new DbEntityFilter();
        entityFilter.setOwnerEntityOid(data.getEntityOid());
        entityFilter.setSelectForDisplayType(5);
        entityFilter.setUsedByUser(oid);
        EntityDao entityDao = this.daoFactory.getEntityDao();
        l.addAll(entityDao.listAll((DbDefaultFilter)entityFilter, 1));
        DbDashboardFilter dashboardFilter = new DbDashboardFilter();
        dashboardFilter.setOwnerEntityOid(data.getEntityOid());
        dashboardFilter.setSelectForDisplayType(5);
        dashboardFilter.setUsedByUser(oid);
        DashboardDao dashboardDao = this.daoFactory.getDashboardDao();
        l.addAll(dashboardDao.listAll((DbDefaultFilter)dashboardFilter, 1));
        DbThemeFilter themeFilter = new DbThemeFilter();
        themeFilter.setOwnerEntityOid(data.getEntityOid());
        themeFilter.setSelectForDisplayType(5);
        themeFilter.setUsedByUser(oid);
        ThemeDao themeDao = this.daoFactory.getThemeDao();
        l.addAll(themeDao.listAll((DbDefaultFilter)themeFilter, 1));
        DbLanguageFilter languageFilter = new DbLanguageFilter();
        languageFilter.setUsedByUser(oid);
        LanguageDao languageDao = this.daoFactory.getLanguageDao();
        l.addAll(languageDao.listAll((DbDefaultFilter)languageFilter, 1));
        DbPersFieldFilter persFieldFilter = new DbPersFieldFilter();
        persFieldFilter.setUsedByUser(oid);
        PersFieldDao persFieldDao = this.daoFactory.getPersFieldDao();
        l.addAll(persFieldDao.listAll((DbDefaultFilter)persFieldFilter, 1));
        DbExecutionContextFilter executionContextFilter = new DbExecutionContextFilter();
        executionContextFilter.setOwnerEntityOid(data.getEntityOid());
        executionContextFilter.setSelectForDisplayType(5);
        executionContextFilter.setUsedByUser(oid);
        ExecutionContextDao executionContextDao = this.daoFactory.getExecutionContextDao();
        l.addAll(executionContextDao.listAll((DbDefaultFilter)executionContextFilter, 1));
        DbMessageTypeFilter messageTypeFilter = new DbMessageTypeFilter();
        messageTypeFilter.setUsedByUser(oid);
        MessageTypeDao messageTypeDao = this.daoFactory.getMessageTypeDao();
        l.addAll(messageTypeDao.listAll((DbDefaultFilter)messageTypeFilter, 1));
        return l;
    }

    public boolean checkPassword(BeanUser user, String pwd) {
        assert (user != null);
        boolean pwdCheck = PRP.checkPassword((String)user.getPassword(), (String)pwd);
        if (!pwdCheck && (pwdCheck = PRP.checkOldPassword((String)user.getPassword(), (String)pwd))) {
            this.dao.changePassword(user, pwd);
        }
        return pwdCheck;
    }

    public boolean isUserActive(BeanUser user) {
        assert (user != null);
        if (!user.getActive()) {
            return false;
        }
        Date now = new Date();
        if (user.getStartDate() != null && now.before(user.getStartDate())) {
            return false;
        }
        return user.getEndDate() == null || !now.after(user.getEndDate());
    }

    public void disableUser(String userName) {
        this.dao.disable(userName);
    }

    public BeanUserDefinition findUserUsingLogin(String login) throws DashboardException {
        String userName = this.dao.getUserName(login);
        return this.getDefinition(userName);
    }

    public void loadBookmarks(BeanUserDefinition user) {
        for (BeanUserExecutionContext uec : user.getExecutionContextList()) {
            uec.setBookmarks(new ArrayList(this.dao.getBookmarks(user.getObjectID(), uec.getObjectID(), null)));
        }
    }

    public void saveBookmarks(BeanUserDefinition user, ExpressionEvaluationData data) {
        for (BeanUserExecutionContext uec : user.getExecutionContextList()) {
            if (uec.getBookmarks() == null) continue;
            this.saveBookmarks(user.getObjectID(), uec.getObjectID(), uec.getBookmarks(), data);
        }
    }

    public void saveBookmarks(Collection<MenuItem> bookmarks, ExpressionEvaluationData data) {
        this.saveBookmarks(data.getUserOid(), data.getExecutionContextOid(), bookmarks, data);
    }

    private void saveBookmarks(int userOidBookmark, int execCtxOidBookmark, Collection<MenuItem> bookmarks, ExpressionEvaluationData data) {
        WorkspaceDao workspaceDao = this.daoFactory.getWorkspaceDao();
        HashSet<MenuItem> set = new HashSet<MenuItem>();
        int execCtxOid = data.getExecutionContextOid();
        for (MenuItem menuItem : bookmarks) {
            WorkspaceDao.SessionAccessLevel accessLevel = menuItem.getSessionType() == SessionType.SYSTEM ? workspaceDao.getAccessLevelForEC(execCtxOid, menuItem.getSessionParameterType()) : workspaceDao.getAccessLevelForEC(execCtxOid, menuItem.getSessionType(), menuItem.getName());
            if (accessLevel.getAccessLevel() != 2 && accessLevel.getAccessLevel() != 1) continue;
            set.add(menuItem);
        }
        this.dao.saveBookmarks(userOidBookmark, execCtxOidBookmark, set);
    }

    public Set<MenuItem> getBookmarks(ExpressionEvaluationData data) {
        return this.dao.getBookmarks(data.getUserOid().intValue(), data.getExecutionContextOid().intValue(), data.getLocale());
    }
}

