/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.model.helper;

import com.axway.sentinel.dashboard.exception.DashboardServiceException;
import com.prelytis.dashboard.dao.Dao;
import com.prelytis.dashboard.dao.DaoFactory;
import com.prelytis.dashboard.dao.DashboardDao;
import com.prelytis.dashboard.dao.EntityDao;
import com.prelytis.dashboard.dao.ExternSessionDao;
import com.prelytis.dashboard.dao.FolderDao;
import com.prelytis.dashboard.dao.FormDao;
import com.prelytis.dashboard.dao.PersFieldDao;
import com.prelytis.dashboard.dao.PrelytisInfoDao;
import com.prelytis.dashboard.dao.ReportDao;
import com.prelytis.dashboard.dao.SessionDao;
import com.prelytis.dashboard.dao.SessionGroupDao;
import com.prelytis.dashboard.dao.TaskDao;
import com.prelytis.dashboard.dao.WorkspaceDao;
import com.prelytis.dashboard.dao.filter.DbControlFilter;
import com.prelytis.dashboard.dao.filter.DbDashboardFilter;
import com.prelytis.dashboard.dao.filter.DbDefaultFilter;
import com.prelytis.dashboard.dao.filter.DbEntityFilter;
import com.prelytis.dashboard.dao.filter.DbExternSessionFilter;
import com.prelytis.dashboard.dao.filter.DbFolderFilter;
import com.prelytis.dashboard.dao.filter.DbFormFilter;
import com.prelytis.dashboard.dao.filter.DbMetricFilter;
import com.prelytis.dashboard.dao.filter.DbPersFieldFilter;
import com.prelytis.dashboard.dao.filter.DbReportFilter;
import com.prelytis.dashboard.dao.filter.DbSessionGroupFilter;
import com.prelytis.dashboard.dao.filter.DbUserFilter;
import com.prelytis.dashboard.dao.filter.DbWorkspaceFilter;
import com.prelytis.dashboard.interfaces.DashboardException;
import com.prelytis.dashboard.interfaces.Element;
import com.prelytis.dashboard.interfaces.ErrorCode;
import com.prelytis.dashboard.interfaces.I18nElement;
import com.prelytis.dashboard.interfaces.SecurityException;
import com.prelytis.dashboard.interfaces.SessionParameterType;
import com.prelytis.dashboard.interfaces.SessionType;
import com.prelytis.dashboard.model.helper.Dependency;
import com.prelytis.dashboard.model.helper.DependencyDefinition;
import com.prelytis.dashboard.model.helper.EntityHelper;
import com.prelytis.dashboard.model.helper.ParameterHelper;
import com.prelytis.dashboard.model.helper.References;
import com.prelytis.dashboard.model.helper.SecurityHelper;
import com.prelytis.dashboard.model.helper.TreeNodeFilter;
import com.prelytis.dashboard.security.util.SettingsHelper;
import com.prelytis.dashboard.value.DependencyGroup;
import com.prelytis.dashboard.value.DependencyRequest;
import com.prelytis.dashboard.value.DependencyResponse;
import com.prelytis.dashboard.value.ParameterRequest;
import com.prelytis.dashboard.value.ParameterResponse;
import com.prelytis.dashboard.value.ParametersListRequest;
import com.prelytis.dashboard.value.ParametersListResponse;
import com.prelytis.dashboard.value.data.BasicBean;
import com.prelytis.dashboard.value.data.Bean;
import com.prelytis.dashboard.value.data.BeanPersFieldValue;
import com.prelytis.dashboard.value.data.BeanSession;
import com.prelytis.dashboard.value.data.BeanWorkspace;
import com.prelytis.dashboard.value.data.BeanWorkspaceControl;
import com.prelytis.dashboard.value.data.BeanWorkspaceControlGroup;
import com.prelytis.dashboard.value.data.BeanWorkspaceDefinition;
import com.prelytis.dashboard.value.data.BeanWorkspaceMetric;
import com.prelytis.dashboard.value.data.BeanWorkspacePerspective;
import com.prelytis.dashboard.value.data.BeanWorkspaceSession;
import com.prelytis.dashboard.value.data.BeanWorkspaceSessionGroup;
import com.prelytis.dashboard.value.data.BeanWorkspaceStrategicObjective;
import com.prelytis.dashboard.value.data.OwnerEntity;
import com.prelytis.dashboard.value.data.SecurityAdapter;
import com.prelytis.dashboard.value.data.filter.DefaultFilter;
import com.prelytis.dashboard.value.data.filter.WorkspaceFilter;
import com.prelytis.dashboard.value.tree.DefaultMutableTreeNode;
import com.prelytis.dashboard.value.tree.TreeNode;
import com.prelytis.dashboard.value.util.ExpressionEvaluationData;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class WorkspaceHelper
extends ParameterHelper
implements Dependency,
References {
    private static final Logger LOG = LogManager.getLogger(WorkspaceHelper.class);
    private final WorkspaceDao dao;
    private final EntityHelper entityHelper;
    private final boolean autoNameGeneration;

    WorkspaceHelper(DaoFactory daoFactory) {
        super(daoFactory);
        this.dao = this.daoFactory.getWorkspaceDao();
        this.entityHelper = new EntityHelper(daoFactory);
        PrelytisInfoDao prelytisInfoDao = daoFactory.getPrelytisInfoDao();
        this.autoNameGeneration = prelytisInfoDao.isAutoNameGeneration();
    }

    @Override
    public ParameterResponse getResponse(ParameterRequest value, ExpressionEvaluationData data) throws DashboardException {
        ParameterRequest.Action action = value.getAction() == null ? ParameterRequest.Action.OPEN : value.getAction();
        switch (action) {
            case OPEN: 
            case OPEN_AS_SUPER_USER: {
                return this.get(value.getInstanceType(), value.getName(), data);
            }
            case COPY: {
                return this.getCopy(value.getName(), data);
            }
            case DELETE: {
                return this.getDelete(value.getName(), (Bean)((BeanWorkspace)value.getElement()), data);
            }
            case SAVE_AS_NEW: {
                return this.getSaveAsNew((BeanWorkspaceDefinition)value.getElement(), data);
            }
            case SAVE: {
                return this.getSave((BeanWorkspaceDefinition)value.getElement(), data);
            }
            case NEW: {
                return this.getNew(data);
            }
        }
        throw new DashboardException();
    }

    private ParameterResponse getNew(ExpressionEvaluationData data) throws DashboardException {
        return this.helper.getResponse((I18nElement)this.create(data), data, SessionParameterType.WORKSPACE);
    }

    public BeanWorkspaceDefinition create(ExpressionEvaluationData data) throws DashboardException {
        BeanWorkspaceDefinition elt = this.dao.getDefault(data.getEntityOid().intValue(), data.getProfile().intValue());
        if (this.autoNameGeneration) {
            elt.setName(this.guidFactory.generateGUID((Object)elt));
        }
        this.helper.updateDescKey((Bean)elt, false);
        elt.setOwnerEntOID(data.getEntityOid().intValue());
        elt.setOwnerEntityName(data.getEntityName());
        elt.setCreationDate(new Date());
        elt.setOwner(data.getUserName());
        elt.setLastModificationDate(new Date());
        elt.setLastModifier(data.getUserName());
        return elt;
    }

    private ParameterResponse getSaveAsNew(BeanWorkspaceDefinition elt, ExpressionEvaluationData data) throws DashboardException {
        this.save(elt, data, true);
        return this.helper.getResponse((I18nElement)elt, data, SessionParameterType.WORKSPACE);
    }

    private ParameterResponse getSave(BeanWorkspaceDefinition elt, ExpressionEvaluationData data) throws DashboardException {
        this.save(elt, data, false);
        return this.helper.getResponse((I18nElement)elt, data, SessionParameterType.WORKSPACE);
    }

    public void save(BeanWorkspaceDefinition elt, ExpressionEvaluationData data, boolean isNew) throws DashboardException {
        this.save(elt, data, isNew, false);
    }

    public void save(BeanWorkspaceDefinition elt, ExpressionEvaluationData data, boolean isNew, boolean isImport) throws DashboardException {
        this.helper.checkForSave((Dao)this.dao, data, (Bean)elt, isNew, isImport);
        elt.setLastModificationDate(new Date());
        elt.setLastModifier(data.getUserName());
        this.updateOids((BeanWorkspace)elt);
        this.helper.updateDescKey((Bean)elt, false);
        this.helper.updateDescriptionMap((Bean)elt, data.getLocale());
        this.helper.checkOwnerEntity(this.entityHelper, data, (OwnerEntity)elt);
        this.helper.checkForSave(data, (Element)elt);
        List persFieldList = elt.getPersFieldValueList();
        Map map = this.getMap(elt.getPersFieldValueList());
        persFieldList.clear();
        BeanWorkspaceDefinition def = this.dao.getDefault(elt.getOwnerEntOID(), elt.getProfile());
        for (BeanPersFieldValue value : def.getPersFieldValueList()) {
            BeanPersFieldValue v = (BeanPersFieldValue)map.get(value.getName());
            if (v != null) {
                value.setValues(v.getValues());
            }
            persFieldList.add(value);
        }
        this.dao.save((Element)elt);
    }

    @Override
    public void delete(String name, ExpressionEvaluationData data) throws DashboardException {
        BeanWorkspace elt = this.helper.get((Dao)this.dao, name, 1, BeanWorkspace.class);
        this.helper.checkOwnerEntity(this.entityHelper, data, (OwnerEntity)elt);
        if (data.getWorkspaceOid().intValue() == elt.getObjectID()) {
            throw new SecurityException();
        }
        this.helper.checkForDelete(this.getDependencyDefinitionList((Bean)elt), data, (Element)elt);
        this.dao.delete((Element)elt);
    }

    private ParameterResponse get(Integer instanceType, String name, ExpressionEvaluationData data) throws DashboardException {
        BeanWorkspace elt = this.helper.get((Dao)this.dao, name, instanceType, BeanWorkspace.class);
        this.updateNames(elt);
        return this.helper.getResponse((I18nElement)elt, data, SessionParameterType.WORKSPACE);
    }

    private void updateNames(BeanWorkspace bean) throws DashboardException {
        bean.setOwnerEntityName(this.getName(SessionParameterType.ENTITY, bean.getOwnerEntOID()));
    }

    private void updateOids(BeanWorkspace bean) throws DashboardException {
        bean.setOwnerEntOID(this.getOid(SessionParameterType.ENTITY, bean.getOwnerEntityName()));
    }

    private ParameterResponse getCopy(String name, ExpressionEvaluationData data) throws DashboardException {
        BeanWorkspaceDefinition elt = this.createCopy(name, data, this.autoNameGeneration);
        return this.helper.getResponse((I18nElement)elt, data, SessionParameterType.WORKSPACE);
    }

    public BeanWorkspaceDefinition createCopy(String name, ExpressionEvaluationData data, boolean generateName) throws DashboardException {
        BeanWorkspaceDefinition elt = this.helper.get((Dao)this.dao, name, 2, BeanWorkspaceDefinition.class);
        this.helper.updateForCopy((Bean)elt, generateName);
        String eltName = elt.getName();
        if (generateName) {
            elt.setName("AUTO_9876" + eltName);
        }
        this.helper.updateDescKey((Bean)elt, true);
        elt.setOwnerEntOID(data.getEntityOid().intValue());
        elt.setOwnerEntityName(data.getEntityName());
        elt.setCreationDate(new Date());
        elt.setOwner(data.getUserName());
        elt.setLastModificationDate(new Date());
        elt.setLastModifier(data.getUserName());
        return elt;
    }

    @Override
    public ParametersListResponse getResponse(ParametersListRequest value, ExpressionEvaluationData data) throws DashboardException {
        SessionParameterType sessionParameterType = value.getSessionParameterType();
        try {
            int accessLevel = this.dao.getAccessLevelForEC(data.getExecutionContextOid().intValue(), sessionParameterType).getAccessLevel();
            boolean restricted = false;
            if (accessLevel == 0) {
                boolean limitedAccess = this.dao.getLimitedAccessForUser(data.getUserOid().intValue(), data.getExecutionContextOid().intValue(), sessionParameterType);
                if (!limitedAccess) {
                    throw new SecurityException();
                }
                accessLevel = 1;
                restricted = true;
            }
            ArrayList<SecurityAdapter> list = null;
            SecurityHelper securityHelper = SecurityHelper.getInstance(this.daoFactory);
            int instanceType = value.getBeanType() == null ? 1 : value.getBeanType();
            ParametersListResponse response = new ParametersListResponse();
            List<Element> elementList = this.list(value.getFilter(), instanceType, value.getSortedField(), value.getMaxSize(), data);
            if (elementList != null) {
                int m;
                if (restricted) {
                    ArrayList<Element> l = new ArrayList<Element>();
                    for (Element e : elementList) {
                        l.add((Element)new BasicBean((I18nElement)((Bean)e)));
                    }
                    elementList = l;
                }
                if (value.getMaxSize() != null && (m = value.getMaxSize().intValue()) > 0 && elementList.size() > m) {
                    elementList.subList(m, elementList.size()).clear();
                    response.setTruncatedData(true);
                }
                list = new ArrayList<SecurityAdapter>();
                for (int i = elementList.size() - 1; i >= 0; --i) {
                    Bean elt = (Bean)elementList.get(i);
                    SecurityAdapter sa = securityHelper.create((I18nElement)elt, data, accessLevel);
                    if (!sa.isRead()) continue;
                    list.add(sa);
                }
            }
            SessionDao sessionDao = this.daoFactory.getSessionDao();
            BeanSession session = sessionDao.getSession(sessionParameterType);
            response.setDescription((String)session.getDescriptionMap().get(data.getLocale()));
            response.setList(list);
            response.setAccessLevel(Integer.valueOf(accessLevel));
            return response;
        }
        catch (Exception e) {
            throw this.getException(e);
        }
    }

    @Override
    public DependencyResponse getResponse(DependencyRequest value, ExpressionEvaluationData data) throws DashboardException {
        BeanWorkspace elt = this.helper.get((Dao)this.dao, value.getName(), 1, BeanWorkspace.class);
        List<DependencyGroup> dependencies = this.getDependencies((Bean)elt, data);
        return this.helper.getResponse((Bean)elt, dependencies, data, SessionParameterType.WORKSPACE);
    }

    @Override
    public List<Element> list(DefaultFilter defaultFilter, int instanceType, ParametersListRequest.SortedField sort, Integer maxSize, ExpressionEvaluationData data) throws DashboardException {
        DbWorkspaceFilter filter = this.helper.getFilter(defaultFilter, data, DbWorkspaceFilter.class);
        if (defaultFilter instanceof WorkspaceFilter) {
            WorkspaceFilter src = (WorkspaceFilter)defaultFilter;
            filter.setControlGroupOid(this.optOid(SessionParameterType.CONTROL_GROUP, src.getControlGroupName()));
            filter.setDashboardOID(this.optOid(SessionParameterType.DASHBOARD, src.getDashboardName()));
            filter.setReportOID(this.optOid(SessionParameterType.REPORT, src.getReportName()));
            filter.setSessionGroupOid(this.optOid(SessionParameterType.SESSION_GROUP, src.getSessionGroupName()));
        }
        List eltList = this.dao.listAll((DbDefaultFilter)filter, instanceType, sort, maxSize);
        for (Element elt : eltList) {
            this.updateNames((BeanWorkspace)elt);
        }
        try {
            boolean usePassportAuthorization = SettingsHelper.getInstance().usesPassportAuthorization();
            if (usePassportAuthorization) {
                return this.getPPVisibleWorkspaces(eltList);
            }
        }
        catch (DashboardServiceException e) {
            throw new DashboardException((Throwable)e, e.getMessage());
        }
        return eltList;
    }

    private List<Element> getPPVisibleWorkspaces(List<Element> eltList) throws DashboardException {
        ArrayList<Element> filteredList = new ArrayList<Element>();
        String templateWorkspace = WorkspaceHelper.getTemplateWorkspaceName(this);
        for (Element elt : eltList) {
            BeanWorkspace wksp = (BeanWorkspace)elt;
            if ("public".equals(wksp.getName())) {
                wksp.getDescriptionMap().put(Locale.ENGLISH, "Public menu");
                wksp.getDescriptionMap().put(Locale.FRENCH, "Menu publique");
                filteredList.add((Element)wksp);
            }
            if (!templateWorkspace.equals(wksp.getName())) continue;
            wksp.getDescriptionMap().put(Locale.ENGLISH, "Menu");
            wksp.getDescriptionMap().put(Locale.FRENCH, "Menu");
            filteredList.add((Element)wksp);
        }
        return filteredList;
    }

    public static String getTemplateWorkspaceName(WorkspaceHelper workspaceHelper) throws DashboardException {
        SettingsHelper settingsHelper = SettingsHelper.getInstance();
        String templateWorkspace = "superadmin";
        try {
            BeanWorkspaceDefinition workspaceDef;
            String templateWorkspaceProperty = settingsHelper.getProperty("webdashboard.templateworkspace");
            if (templateWorkspaceProperty != null && (workspaceDef = workspaceHelper.getDefinition(templateWorkspaceProperty)) != null) {
                templateWorkspace = templateWorkspaceProperty;
            }
        }
        catch (DashboardException e) {
            if (e.getCode() == ErrorCode.NOT_FOUND_ERROR) {
                LOG.warn((Object)"Configured template workspace not found. Using default template workspace");
            }
            throw e;
        }
        catch (DashboardServiceException e) {
            throw new DashboardException((Throwable)e);
        }
        return templateWorkspace;
    }

    @Override
    public List<DependencyGroup> getDependencies(Bean elt, ExpressionEvaluationData data) throws DashboardException {
        return this.helper.getDependencies(this.getDependencyDefinitionList(elt), data);
    }

    private List<DependencyDefinition> getDependencyDefinitionList(Bean elt) {
        Integer objectID = elt.getObjectID();
        ArrayList<DependencyDefinition> list = new ArrayList<DependencyDefinition>();
        DbUserFilter userFilter = new DbUserFilter();
        userFilter.setWorkspaceOid(objectID);
        list.add(new DependencyDefinition((DbDefaultFilter)userFilter, SessionParameterType.USER));
        return list;
    }

    public static WorkspaceHelper getInstance(DaoFactory daoFactory) {
        return new WorkspaceHelper(daoFactory);
    }

    public BeanWorkspaceDefinition getDefinition(String name) throws DashboardException {
        BeanWorkspaceDefinition bean = this.helper.get((Dao)this.dao, name, 2, BeanWorkspaceDefinition.class);
        this.updateNames((BeanWorkspace)bean);
        return bean;
    }

    public void mergeAndSave(BeanWorkspaceDefinition elt, ExpressionEvaluationData data) throws DashboardException {
        this.mergeAndSave(elt, data, false);
    }

    public void mergeAndSave(BeanWorkspaceDefinition elt, ExpressionEvaluationData data, boolean isImport) throws DashboardException {
        List<Object> list;
        BeanWorkspaceDefinition bean;
        if (elt.getOwnerEntityName() == null || elt.getOwnerEntityName().isEmpty()) {
            LogManager.getLogger(WorkspaceHelper.class).info((Object)("No given owner entity, using " + data.getEntityName()));
            elt.setOwnerEntityName(data.getEntityName());
        }
        if (elt.getObjectID() == 0) {
            int ownerEntityOid = this.getOid(SessionParameterType.ENTITY, elt.getOwnerEntityName());
            bean = this.dao.getDefault(ownerEntityOid, elt.getProfile());
        } else {
            bean = this.helper.get((Dao)this.dao, elt.getName(), 2, BeanWorkspaceDefinition.class);
        }
        bean.setObjectID(elt.getObjectID());
        bean.setName(elt.getName());
        bean.getDescriptionMap().putAll(elt.getDescriptionMap());
        bean.setProfile(elt.getProfile());
        bean.setOwnerEntityName(elt.getOwnerEntityName());
        bean.setVersion(elt.getVersion());
        bean.setCreationDate(elt.getCreationDate());
        bean.setOwner(elt.getOwner());
        bean.setLastModificationDate(elt.getLastModificationDate());
        bean.setLastModifier(elt.getLastModifier());
        HashMap<SessionKey, SessionInfo> map = new HashMap<SessionKey, SessionInfo>();
        this.fillSessionMap(map, (TreeNode<Object>)bean.getSessionGroupNode(), null);
        for (Object s : bean.getMoreSessionList()) {
            map.put(this.getKey((BeanWorkspaceSession)s), new SessionInfo((BeanWorkspaceSession)s, ""));
        }
        bean.getMoreSessionList().clear();
        this.updateSessionMap(map, (TreeNode<Object>)elt.getSessionGroupNode(), null);
        HashMap<String, List<BeanWorkspaceSession>> groupMap = new HashMap<String, List<BeanWorkspaceSession>>();
        for (SessionInfo info : map.values()) {
            Object l = (ArrayList<BeanWorkspaceSession>)groupMap.get(info.groupName);
            if (l == null) {
                l = new ArrayList<BeanWorkspaceSession>();
                groupMap.put(info.groupName, (List<BeanWorkspaceSession>)l);
            }
            l.add(info.session);
        }
        bean.setSessionGroupNode(this.fill(null, (TreeNode<Object>)bean.getSessionGroupNode(), groupMap));
        List moreList = (List)groupMap.get("");
        if (moreList != null) {
            bean.getMoreSessionList().addAll(moreList);
        }
        HashMap<String, ControlInfo> controlMap = new HashMap<String, ControlInfo>();
        for (Object group : bean.getControlGroupList()) {
            for (BeanWorkspaceControl control : group.getBeanWorkspaceControlList()) {
                controlMap.put(control.getName(), new ControlInfo(control, group.getName()));
            }
        }
        for (BeanWorkspaceControl control : bean.getMoreControlList()) {
            controlMap.put(control.getName(), new ControlInfo(control, ""));
        }
        for (Object group : elt.getControlGroupList()) {
            for (BeanWorkspaceControl control : group.getBeanWorkspaceControlList()) {
                ControlInfo info = (ControlInfo)controlMap.get(control.getName());
                if (info == null) {
                    LogManager.getLogger(WorkspaceHelper.class).info((Object)("Control not found: " + control.getName()));
                    continue;
                }
                info.control.setAccessLevel(control.getAccessLevel());
                info.control.setSortOrder(control.getSortOrder());
                info.groupName = group.getName();
            }
        }
        HashMap<String, ArrayList<BeanWorkspaceControl>> controlGroupMap = new HashMap<String, ArrayList<BeanWorkspaceControl>>();
        for (ControlInfo info : controlMap.values()) {
            list = (ArrayList<BeanWorkspaceControl>)controlGroupMap.get(info.groupName);
            if (list == null) {
                list = new ArrayList<BeanWorkspaceControl>();
                controlGroupMap.put(info.groupName, (ArrayList<BeanWorkspaceControl>)list);
            }
            list.add(info.control);
        }
        for (BeanWorkspaceControlGroup group : bean.getControlGroupList()) {
            list = (List)controlGroupMap.remove(group.getName());
            group.getBeanWorkspaceControlList().clear();
            if (list == null) continue;
            group.getBeanWorkspaceControlList().addAll(list);
        }
        bean.getMoreControlList().clear();
        for (Iterator list2 : controlGroupMap.values()) {
            bean.getMoreControlList().addAll(list2);
        }
        HashMap<String, Integer> metricMap = new HashMap<String, Integer>();
        for (BeanWorkspacePerspective perspective : elt.getPerspectiveList()) {
            for (BeanWorkspaceStrategicObjective objective : perspective.getBeanWorkspaceStrategicObjectiveList()) {
                for (BeanWorkspaceMetric metric : objective.getBeanWorkspaceMetricList()) {
                    metricMap.put(metric.getName(), metric.getAccessLevel());
                }
            }
        }
        for (BeanWorkspacePerspective perspective : bean.getPerspectiveList()) {
            for (BeanWorkspaceStrategicObjective objective : perspective.getBeanWorkspaceStrategicObjectiveList()) {
                for (BeanWorkspaceMetric metric : objective.getBeanWorkspaceMetricList()) {
                    Integer accessLevel = (Integer)metricMap.get(metric.getName());
                    if (accessLevel == null) continue;
                    metric.setAccessLevel(accessLevel.intValue());
                }
            }
        }
        HashMap<String, Object> valueMap = new HashMap<String, Object>();
        for (BeanPersFieldValue value : elt.getPersFieldValueList()) {
            valueMap.put(value.getName(), value.getValues());
        }
        for (BeanPersFieldValue value : bean.getPersFieldValueList()) {
            Object v = valueMap.get(value.getName());
            if (v == null) continue;
            value.setValues(v);
        }
        this.save(bean, data, bean.getObjectID() == 0, isImport);
    }

    private TreeNode<Object> fill(TreeNode<Object> pn, TreeNode<Object> refNode, Map<String, List<BeanWorkspaceSession>> groupMap) {
        if (!(refNode.getUserObject() instanceof BeanWorkspaceSession)) {
            DefaultMutableTreeNode node = new DefaultMutableTreeNode();
            if (pn != null) {
                ArrayList<DefaultMutableTreeNode> l = pn.getChildren();
                if (l == null) {
                    l = new ArrayList<DefaultMutableTreeNode>();
                    pn.setChildren(l);
                }
                l.add(node);
                node.setParent(pn);
            }
            if (refNode.getUserObject() instanceof BeanWorkspaceSessionGroup) {
                BeanWorkspaceSessionGroup group = (BeanWorkspaceSessionGroup)refNode.getUserObject();
                node.setUserObject((Object)group);
                List<BeanWorkspaceSession> list = groupMap.get(group.getName());
                if (list != null) {
                    ArrayList<DefaultMutableTreeNode> cnlist = node.getChildren();
                    if (cnlist == null) {
                        cnlist = new ArrayList<DefaultMutableTreeNode>();
                        node.setChildren(cnlist);
                    }
                    for (BeanWorkspaceSession s : list) {
                        DefaultMutableTreeNode sn = new DefaultMutableTreeNode();
                        sn.setParent((TreeNode)node);
                        cnlist.add(sn);
                        sn.setUserObject((Object)s);
                    }
                }
            }
            if (refNode.getChildren() != null) {
                for (TreeNode cn : refNode.getChildren()) {
                    this.fill((TreeNode<Object>)node, (TreeNode<Object>)cn, groupMap);
                }
            }
            return node;
        }
        return null;
    }

    private void updateSessionMap(Map<SessionKey, SessionInfo> map, TreeNode<Object> node, String groupName) {
        String gn = groupName;
        if (node.getUserObject() instanceof BeanWorkspaceSessionGroup) {
            BeanWorkspaceSessionGroup group = (BeanWorkspaceSessionGroup)node.getUserObject();
            gn = group.getName();
        } else if (node.getUserObject() instanceof BeanWorkspaceSession) {
            BeanWorkspaceSession session = (BeanWorkspaceSession)node.getUserObject();
            SessionKey key = this.getKey(session);
            SessionInfo info = map.get(key);
            if (info == null) {
                LogManager.getLogger(WorkspaceHelper.class).info((Object)("Session not found: " + key.toString()));
            } else {
                info.groupName = gn;
                info.session.setAccessLevel(session.getAccessLevel());
                info.session.setSortOrder(session.getSortOrder());
            }
        }
        if (node.getChildren() != null) {
            for (TreeNode cn : node.getChildren()) {
                this.updateSessionMap(map, (TreeNode<Object>)cn, gn);
            }
        }
    }

    private void fillSessionMap(Map<SessionKey, SessionInfo> map, TreeNode<Object> node, String groupName) {
        String gn = groupName;
        if (node.getUserObject() instanceof BeanWorkspaceSessionGroup) {
            BeanWorkspaceSessionGroup group = (BeanWorkspaceSessionGroup)node.getUserObject();
            gn = group.getName();
        } else if (node.getUserObject() instanceof BeanWorkspaceSession) {
            BeanWorkspaceSession session = (BeanWorkspaceSession)node.getUserObject();
            map.put(this.getKey(session), new SessionInfo(session, gn));
        }
        if (node.getChildren() != null) {
            for (TreeNode cn : node.getChildren()) {
                this.fillSessionMap(map, (TreeNode<Object>)cn, gn);
            }
        }
    }

    private SessionKey getKey(BeanWorkspaceSession session) {
        return new SessionKey(session.getType(), session.getName());
    }

    @Override
    public List<Element> getReferences(int objectID, ExpressionEvaluationData data) {
        ArrayList<Element> l = new ArrayList<Element>();
        Integer oid = objectID;
        DbEntityFilter entityFilter = new DbEntityFilter();
        entityFilter.setOwnerEntityOid(data.getEntityOid());
        entityFilter.setSelectForDisplayType(5);
        entityFilter.setUsedByWorkspace(oid);
        EntityDao entityDao = this.daoFactory.getEntityDao();
        l.addAll(entityDao.listAll((DbDefaultFilter)entityFilter, 1));
        DbDashboardFilter dashboardFilter = new DbDashboardFilter();
        dashboardFilter.setOwnerEntityOid(data.getEntityOid());
        dashboardFilter.setSelectForDisplayType(5);
        dashboardFilter.setUsedByWorkspace(oid);
        DashboardDao dashboardDao = this.daoFactory.getDashboardDao();
        l.addAll(dashboardDao.listAll((DbDefaultFilter)dashboardFilter, 1));
        DbReportFilter reportFilter = new DbReportFilter();
        reportFilter.setOwnerEntityOid(data.getEntityOid());
        reportFilter.setSelectForDisplayType(5);
        reportFilter.setUsedByWorkspace(oid);
        ReportDao reportDao = this.daoFactory.getReportDao();
        l.addAll(reportDao.listAll((DbDefaultFilter)reportFilter, 1));
        DbExternSessionFilter extSessionFilter = new DbExternSessionFilter();
        extSessionFilter.setUsedByWorkspace(oid);
        ExternSessionDao extSessionDao = this.daoFactory.getExternSessionDao();
        l.addAll(extSessionDao.listAll((DbDefaultFilter)extSessionFilter, 1));
        DbFormFilter formFilter = new DbFormFilter();
        formFilter.setUsedByWorkspace(oid);
        FormDao formDao = this.daoFactory.getFormDao();
        l.addAll(formDao.listAll((DbDefaultFilter)formFilter, 1));
        DbFolderFilter folderFilter = new DbFolderFilter();
        folderFilter.setUsedByWorkspace(oid);
        FolderDao folderDao = this.daoFactory.getFolderDao();
        l.addAll(folderDao.listAll((DbDefaultFilter)folderFilter, 1));
        DbPersFieldFilter persFieldFilter = new DbPersFieldFilter();
        persFieldFilter.setUsedByWorkspace(oid);
        PersFieldDao persFieldDao = this.daoFactory.getPersFieldDao();
        l.addAll(persFieldDao.listAll((DbDefaultFilter)persFieldFilter, 1));
        DbControlFilter controlFilter = new DbControlFilter();
        controlFilter.setUsedByWorkspace(oid);
        TaskDao taskDao = this.daoFactory.getTaskDao();
        l.addAll(taskDao.listAll((DbDefaultFilter)controlFilter, 1));
        DbMetricFilter metricFilter = new DbMetricFilter();
        metricFilter.setUsedByWorkspace(oid);
        l.addAll(taskDao.listAll((DbDefaultFilter)metricFilter, 1));
        DbSessionGroupFilter sessionGroupFilter = new DbSessionGroupFilter();
        sessionGroupFilter.setUsedByWorkspace(oid);
        SessionGroupDao sessionGroupDao = this.daoFactory.getSessionGroupDao();
        l.addAll(sessionGroupDao.listAll((DbDefaultFilter)sessionGroupFilter, 1));
        return l;
    }

    public static List<BeanWorkspaceSession> getSessionsByFilter(TreeNode<Object> groupNode, TreeNodeFilter filter) {
        ArrayList<BeanWorkspaceSession> result = new ArrayList<BeanWorkspaceSession>();
        if (groupNode != null && groupNode.getChildren() != null) {
            WorkspaceHelper.getAllChildren(groupNode, filter, result);
        }
        return result;
    }

    private static void getAllChildren(TreeNode<Object> groupNode, TreeNodeFilter filter, List<BeanWorkspaceSession> result) {
        for (TreeNode session : groupNode.getChildren()) {
            BeanWorkspaceSession workspaceSession;
            Object userObject;
            if (session.getChildren() != null) {
                WorkspaceHelper.getAllChildren((TreeNode<Object>)session, filter, result);
            }
            if (!((userObject = session.getUserObject()) instanceof BeanWorkspaceSession) || !filter.matches(workspaceSession = (BeanWorkspaceSession)userObject)) continue;
            result.add(workspaceSession);
        }
    }

    public static TreeNode<Object> getGroupByName(TreeNode<Object> node, String groupName) {
        BeanWorkspaceSessionGroup sessionGroup;
        Object userObject = node.getUserObject();
        if (userObject instanceof BeanWorkspaceSessionGroup && groupName.equals((sessionGroup = (BeanWorkspaceSessionGroup)userObject).getName())) {
            return node;
        }
        if (node.getChildren() != null) {
            for (TreeNode child : node.getChildren()) {
                TreeNode<Object> group = WorkspaceHelper.getGroupByName((TreeNode<Object>)child, groupName);
                if (group == null) continue;
                return group;
            }
        }
        return null;
    }

    public static List<BeanWorkspaceSession> getBeanWorkspaceSessions(TreeNode<Object> treeNode, final SessionParameterType sParameterType) {
        return WorkspaceHelper.getSessionsByFilter(treeNode, new TreeNodeFilter(){

            @Override
            public boolean matches(BeanWorkspaceSession workspaceSession) {
                return sParameterType.equals((Object)workspaceSession.getParamType());
            }
        });
    }

    public int getAccessLevel(int execCtxOid, SessionParameterType sessionParameterType) {
        return this.dao.getAccessLevelForEC(execCtxOid, sessionParameterType).getAccessLevel();
    }

    private boolean addWorkspaceSession(BeanWorkspaceSession workspaceSession, BeanWorkspaceDefinition workspaceDef, int sessionGroupOid, boolean sort, Locale locale) throws DashboardException {
        TreeNode workspaceRootNode;
        TreeNode<Object> sessionGroup;
        boolean modif = false;
        if (workspaceSession != null && (sessionGroup = this.getTreeNode((TreeNode<Object>)(workspaceRootNode = workspaceDef.getSessionGroupNode()), sessionGroupOid)) != null) {
            List children = sessionGroup.getChildren();
            DefaultMutableTreeNode newNode = new DefaultMutableTreeNode();
            newNode.setUserObject((Object)workspaceSession);
            newNode.setParent(sessionGroup);
            children.add(newNode);
            if (sort) {
                this.sortNodes(children, locale);
            }
            modif = true;
        }
        return modif;
    }

    private BeanWorkspaceSession findSession(List<BeanWorkspaceSession> sessionList, SessionType beanType, int beanOid) {
        BeanWorkspaceSession workspaceSession = null;
        if (sessionList != null) {
            SessionDao sessionDao = this.daoFactory.getSessionDao();
            for (BeanWorkspaceSession session : sessionList) {
                BeanSession beanSession = (BeanSession)sessionDao.getCore(session.getObjectID());
                if (session.getType() != beanType || beanSession.getRefOid() != beanOid) continue;
                workspaceSession = session;
                workspaceSession.setAccessLevel(Integer.valueOf(2));
            }
        }
        return workspaceSession;
    }

    private void sortNodes(List<TreeNode<Object>> nodes, Locale locale) {
        Collections.sort(nodes, new NodeComparator(locale));
        int cpt = 0;
        for (TreeNode<Object> tn : nodes) {
            if (tn == null || !(tn.getUserObject() instanceof BeanWorkspaceSession)) continue;
            BeanWorkspaceSession s = (BeanWorkspaceSession)tn.getUserObject();
            s.setSortOrder(cpt);
            ++cpt;
        }
    }

    private TreeNode<Object> getTreeNode(TreeNode<Object> root, int sessionGroupOid) {
        TreeNode<Object> res = null;
        for (TreeNode tree : root.getChildren()) {
            BeanWorkspaceSessionGroup group;
            if (tree.getUserObject() != null && tree.getUserObject() instanceof BeanWorkspaceSessionGroup && (group = (BeanWorkspaceSessionGroup)tree.getUserObject()).getObjectID() == sessionGroupOid) {
                return tree;
            }
            if (tree.isLeaf() || (res = this.getTreeNode((TreeNode<Object>)tree, sessionGroupOid)) == null) continue;
            break;
        }
        return res;
    }

    public void addSession(int workspaceOid, SessionType beanType, int beanOid, int sessionGroupOid, boolean sort, Locale locale) throws DashboardException {
        WorkspaceDao workspaceDao = this.daoFactory.getWorkspaceDao();
        BeanWorkspaceDefinition workspaceDef = (BeanWorkspaceDefinition)workspaceDao.getDefinition(workspaceOid);
        List sessionList = workspaceDef.getMoreSessionList();
        BeanWorkspaceSession workspaceSession = this.findSession(sessionList, beanType, beanOid);
        boolean modif = this.addWorkspaceSession(workspaceSession, workspaceDef, sessionGroupOid, sort, locale);
        if (modif) {
            sessionList.remove(workspaceSession);
            workspaceDao.save((Element)workspaceDef);
        }
    }

    private static class NodeComparator
    implements Comparator<TreeNode<Object>> {
        Locale locale;

        NodeComparator(Locale locale) {
            this.locale = locale;
        }

        @Override
        public int compare(TreeNode<Object> o1, TreeNode<Object> o2) {
            String d2;
            Integer nullCheckResult = this.compareCheckForNull(o1, o2);
            if (nullCheckResult != null) {
                return nullCheckResult;
            }
            Object ou1 = o1.getUserObject();
            Object ou2 = o2.getUserObject();
            if (!(ou1 instanceof BeanWorkspaceSession)) {
                return 1;
            }
            if (!(ou2 instanceof BeanWorkspaceSession)) {
                return -1;
            }
            String d1 = (String)((BeanWorkspaceSession)ou1).getDescriptionMap().get(this.locale);
            nullCheckResult = this.compareCheckForNull(d1, d2 = (String)((BeanWorkspaceSession)ou2).getDescriptionMap().get(this.locale));
            if (nullCheckResult != null) {
                return nullCheckResult;
            }
            return Collator.getInstance(this.locale).compare(d1, d2);
        }

        private Integer compareCheckForNull(Object o1, Object o2) {
            if (o1 == null) {
                if (o2 == null) {
                    return 0;
                }
                return 1;
            }
            if (o2 == null) {
                return -1;
            }
            return null;
        }
    }

    private static final class ControlInfo {
        private final BeanWorkspaceControl control;
        private String groupName;

        private ControlInfo(BeanWorkspaceControl control, String groupName) {
            this.control = control;
            this.groupName = groupName;
        }
    }

    private static final class SessionInfo {
        private final BeanWorkspaceSession session;
        private String groupName;

        private SessionInfo(BeanWorkspaceSession session, String groupName) {
            this.session = session;
            this.groupName = groupName;
        }
    }

    private static class SessionKey {
        private final SessionType sessionType;
        private final String sessionName;

        SessionKey(SessionType sessionType, String sessionName) {
            this.sessionType = sessionType;
            this.sessionName = sessionName;
        }

        public boolean equals(Object obj) {
            if (obj instanceof SessionKey) {
                SessionKey k = (SessionKey)obj;
                boolean eqSessionName = this.sessionName == null ? k.sessionName == null : this.sessionName.equals(k.sessionName);
                return this.sessionType == k.sessionType && eqSessionName;
            }
            return false;
        }

        public int hashCode() {
            return this.sessionName == null ? this.sessionType.getId() : this.sessionName.hashCode();
        }

        public String toString() {
            return this.sessionType + "/" + this.sessionName;
        }
    }
}

