/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.model.helper;

import com.prelytis.dashboard.dao.Dao;
import com.prelytis.dashboard.dao.DaoFactory;
import com.prelytis.dashboard.dao.JdbcDriverDao;
import com.prelytis.dashboard.dao.WorkspaceDao;
import com.prelytis.dashboard.dao.WorldDao;
import com.prelytis.dashboard.dao.filter.DbDefaultFilter;
import com.prelytis.dashboard.dao.filter.DbImportFilter;
import com.prelytis.dashboard.dao.filter.DbJdbcDriverFilter;
import com.prelytis.dashboard.dao.filter.DbQueryFilter;
import com.prelytis.dashboard.dao.filter.DbTaskFilter;
import com.prelytis.dashboard.dao.filter.DbWorldFilter;
import com.prelytis.dashboard.helper.ExceptionHelper;
import com.prelytis.dashboard.interfaces.DashboardException;
import com.prelytis.dashboard.interfaces.Element;
import com.prelytis.dashboard.interfaces.I18nElement;
import com.prelytis.dashboard.interfaces.SecurityException;
import com.prelytis.dashboard.interfaces.SessionParameterType;
import com.prelytis.dashboard.model.helper.Dependency;
import com.prelytis.dashboard.model.helper.DependencyDefinition;
import com.prelytis.dashboard.model.helper.ParameterHelper;
import com.prelytis.dashboard.model.helper.References;
import com.prelytis.dashboard.value.DependencyGroup;
import com.prelytis.dashboard.value.DependencyRequest;
import com.prelytis.dashboard.value.DependencyResponse;
import com.prelytis.dashboard.value.ParameterRequest;
import com.prelytis.dashboard.value.ParameterResponse;
import com.prelytis.dashboard.value.ParametersListRequest;
import com.prelytis.dashboard.value.ParametersListResponse;
import com.prelytis.dashboard.value.data.Bean;
import com.prelytis.dashboard.value.data.BeanWorld;
import com.prelytis.dashboard.value.data.BeanWorldDefinition;
import com.prelytis.dashboard.value.data.TaskType;
import com.prelytis.dashboard.value.data.filter.DefaultFilter;
import com.prelytis.dashboard.value.data.filter.WorldFilter;
import com.prelytis.dashboard.value.util.ExpressionEvaluationData;
import java.util.ArrayList;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;

public final class WorldHelper
extends ParameterHelper
implements Dependency,
References {
    private final WorldDao dao;

    WorldHelper(DaoFactory daoFactory) {
        super(daoFactory);
        this.dao = this.daoFactory.getWorldDao();
    }

    @Override
    public ParameterResponse getResponse(ParameterRequest value, ExpressionEvaluationData data) throws DashboardException {
        ParameterRequest.Action action = value.getAction() == null ? ParameterRequest.Action.OPEN : value.getAction();
        switch (action) {
            case OPEN: 
            case OPEN_AS_SUPER_USER: {
                return this.get(value.getInstanceType(), value.getName(), data);
            }
            case COPY: {
                return this.getCopy(value.getName(), data);
            }
            case DELETE: {
                return this.getDelete(value.getName(), (Bean)((BeanWorld)value.getElement()), data);
            }
            case SAVE_AS_NEW: {
                return this.getSaveAsNew((BeanWorldDefinition)value.getElement(), data);
            }
            case SAVE: {
                return this.getSave((BeanWorldDefinition)value.getElement(), data);
            }
            case NEW: {
                return this.getNew(data);
            }
        }
        throw new DashboardException();
    }

    private ParameterResponse getNew(ExpressionEvaluationData data) throws DashboardException {
        return this.helper.getResponse((I18nElement)this.create(data), data, SessionParameterType.WORLD);
    }

    public BeanWorldDefinition create(ExpressionEvaluationData data) throws DashboardException {
        BeanWorldDefinition elt = new BeanWorldDefinition();
        this.helper.updateDescKey((Bean)elt, false);
        elt.setCreationDate(new Date());
        elt.setOwner(data.getUserName());
        elt.setLastModificationDate(new Date());
        elt.setLastModifier(data.getUserName());
        return elt;
    }

    private ParameterResponse getSaveAsNew(BeanWorldDefinition elt, ExpressionEvaluationData data) throws DashboardException {
        this.save(elt, data, true);
        return this.helper.getResponse((I18nElement)elt, data, SessionParameterType.WORLD);
    }

    private ParameterResponse getSave(BeanWorldDefinition elt, ExpressionEvaluationData data) throws DashboardException {
        this.save(elt, data, false);
        return this.helper.getResponse((I18nElement)elt, data, SessionParameterType.WORLD);
    }

    public void save(BeanWorldDefinition elt, ExpressionEvaluationData data, boolean isNew) throws DashboardException {
        this.save(elt, data, isNew, false);
    }

    public void save(BeanWorldDefinition elt, ExpressionEvaluationData data, boolean isNew, boolean isImport) throws DashboardException {
        this.helper.checkForSave((Dao)this.dao, data, (Bean)elt, isNew, isImport);
        this.updateOids((BeanWorld)elt);
        this.helper.updateDescKey((Bean)elt, false);
        this.helper.updateDescriptionMap((Bean)elt, data.getLocale());
        elt.setLastModificationDate(new Date());
        elt.setLastModifier(data.getUserName());
        this.helper.checkForSave(data, (Element)elt);
        this.dao.save((Element)elt);
    }

    @Override
    public void delete(String name, ExpressionEvaluationData data) throws DashboardException {
        BeanWorld elt = this.helper.get((Dao)this.dao, name, 1, BeanWorld.class);
        this.helper.checkForDelete(this.getDependencyDefinitionList((Bean)elt), data, (Element)elt);
        this.dao.delete((Element)elt);
    }

    private ParameterResponse get(Integer instanceType, String name, ExpressionEvaluationData data) throws DashboardException {
        BeanWorld elt = this.helper.get((Dao)this.dao, name, instanceType, BeanWorld.class);
        this.updateNames(elt);
        return this.helper.getResponse((I18nElement)elt, data, SessionParameterType.WORLD);
    }

    private void updateNames(BeanWorld bean) throws DashboardException {
        bean.setDriverName(this.getName(SessionParameterType.JDBC_DRIVER, bean.getDriverOID()));
    }

    private void updateOids(BeanWorld bean) throws DashboardException {
        bean.setDriverOID(this.getOid(SessionParameterType.JDBC_DRIVER, bean.getDriverName()));
    }

    private ParameterResponse getCopy(String name, ExpressionEvaluationData data) throws DashboardException {
        BeanWorldDefinition elt = this.helper.get((Dao)this.dao, name, 2, BeanWorldDefinition.class);
        this.helper.updateForCopy((Bean)elt);
        this.helper.updateDescKey((Bean)elt, true);
        this.updateNames((BeanWorld)elt);
        elt.setCreationDate(new Date());
        elt.setOwner(data.getUserName());
        elt.setLastModificationDate(new Date());
        elt.setLastModifier(data.getUserName());
        return this.helper.getResponse((I18nElement)elt, data, SessionParameterType.WORLD);
    }

    @Override
    public ParametersListResponse getResponse(ParametersListRequest value, ExpressionEvaluationData data) throws DashboardException {
        WorkspaceDao workspaceDao = this.daoFactory.getWorkspaceDao();
        try {
            int accessLevel = workspaceDao.getAccessLevelForEC(data.getExecutionContextOid().intValue(), SessionParameterType.WORLD).getAccessLevel();
            if (accessLevel == 0) {
                boolean limitedAccess = workspaceDao.getLimitedAccessForUser(data.getUserOid().intValue(), data.getExecutionContextOid().intValue(), SessionParameterType.WORLD);
                if (!limitedAccess) {
                    throw new SecurityException();
                }
                accessLevel = 1;
            }
            int instanceType = value.getBeanType() == null ? 1 : value.getBeanType();
            List<Element> eltList = this.list(value.getFilter(), instanceType, value.getSortedField(), value.getMaxSize(), data);
            return this.helper.list(eltList, value.getMaxSize(), false, SessionParameterType.WORLD, accessLevel, data);
        }
        catch (Exception e) {
            throw this.getException(e);
        }
    }

    @Override
    public DependencyResponse getResponse(DependencyRequest value, ExpressionEvaluationData data) throws DashboardException {
        BeanWorld elt = this.helper.get((Dao)this.dao, value.getName(), 1, BeanWorld.class);
        List<DependencyGroup> dependencies = this.getDependencies((Bean)elt, data);
        return this.helper.getResponse((Bean)elt, dependencies, data, SessionParameterType.WORLD);
    }

    @Override
    public List<Element> list(DefaultFilter defaultFilter, int instanceType, ParametersListRequest.SortedField sort, Integer maxSize, ExpressionEvaluationData data) throws DashboardException {
        DbWorldFilter filter = this.helper.getFilter(defaultFilter, data, DbWorldFilter.class);
        if (defaultFilter instanceof WorldFilter) {
            WorldFilter src = (WorldFilter)defaultFilter;
            filter.setReadOnly(src.getReadOnly());
            filter.setDriverOid(this.optOid(SessionParameterType.JDBC_DRIVER, src.getDriverName()));
        }
        List eltList = this.dao.listAll((DbDefaultFilter)filter, instanceType, sort, maxSize);
        for (Element elt : eltList) {
            this.updateNames((BeanWorld)elt);
        }
        return eltList;
    }

    @Override
    public List<DependencyGroup> getDependencies(Bean elt, ExpressionEvaluationData data) throws DashboardException {
        return this.helper.getDependencies(this.getDependencyDefinitionList(elt), data);
    }

    private List<DependencyDefinition> getDependencyDefinitionList(Bean elt) {
        Integer objectID = elt.getObjectID();
        ArrayList<DependencyDefinition> list = new ArrayList<DependencyDefinition>();
        DbQueryFilter queryFilter = new DbQueryFilter();
        queryFilter.setWorldOid(objectID);
        list.add(new DependencyDefinition((DbDefaultFilter)queryFilter, SessionParameterType.QUERY));
        DbImportFilter importFilter = new DbImportFilter();
        importFilter.setWorldOid(objectID);
        list.add(new DependencyDefinition((DbDefaultFilter)importFilter, SessionParameterType.IMPORT_TASK));
        DbTaskFilter taskFilter = new DbTaskFilter();
        taskFilter.setWorldOid(objectID);
        list.add(new DependencyDefinition((DbDefaultFilter)taskFilter, SessionParameterType.TASK));
        return list;
    }

    public void validateReadOnly(Bean elt, Locale locale) throws DashboardException {
        Integer objectID = elt.getObjectID();
        ArrayList<DependencyDefinition> list = new ArrayList<DependencyDefinition>();
        DbTaskFilter taskFilter = new DbTaskFilter();
        taskFilter.setWorldOid(objectID);
        taskFilter.setTaskTypeSet(EnumSet.of(TaskType.TASK_TYPE_DATAMART));
        list.add(new DependencyDefinition((DbDefaultFilter)taskFilter, SessionParameterType.TASK));
        for (DependencyDefinition def : list) {
            Dao dao = this.daoFactory.getDao(def.getSessionParameterType());
            List dep = dao.listAll(def.getFilter(), 1, null, Integer.valueOf(1));
            if (dep.isEmpty()) continue;
            throw ExceptionHelper.getInstance(locale).createDashboardException("cannotBeReadOnly", null, null);
        }
    }

    public static WorldHelper getInstance(DaoFactory daoFactory) {
        return new WorldHelper(daoFactory);
    }

    public BeanWorldDefinition getDefinition(String name) throws DashboardException {
        BeanWorldDefinition bean = this.helper.get((Dao)this.dao, name, 2, BeanWorldDefinition.class);
        this.updateNames((BeanWorld)bean);
        return bean;
    }

    @Override
    public List<Element> getReferences(int objectID, ExpressionEvaluationData data) {
        ArrayList<Element> l = new ArrayList<Element>();
        Integer oid = objectID;
        DbJdbcDriverFilter jdbcDriverFilter = new DbJdbcDriverFilter();
        jdbcDriverFilter.setUsedByWorld(oid);
        JdbcDriverDao jdbcDriverDao = this.daoFactory.getJdbcDriverDao();
        l.addAll(jdbcDriverDao.listAll((DbDefaultFilter)jdbcDriverFilter, 1));
        return l;
    }
}

