/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.sentinel.security;

import com.axway.sentinel.common.webdashboard.access.ResourceAccessTypes;
import com.axway.sentinel.common.webdashboard.access.ResourceTypes;
import com.axway.sentinel.dashboard.exception.DashboardServiceException;
import com.prelytis.dashboard.dao.DaoFactory;
import com.prelytis.dashboard.interfaces.DashboardException;
import com.prelytis.dashboard.interfaces.SessionParameterType;
import com.prelytis.dashboard.interfaces.SessionType;
import com.prelytis.dashboard.model.helper.TreeNodeFilter;
import com.prelytis.dashboard.model.helper.WorkspaceHelper;
import com.prelytis.dashboard.security.DashboardManager;
import com.prelytis.dashboard.security.IDashboardManager;
import com.prelytis.dashboard.security.util.InternalProperties;
import com.prelytis.dashboard.sentinel.security.PassPortToWDMapping;
import com.prelytis.dashboard.sentinel.security.ViewToAllAccessHandler;
import com.prelytis.dashboard.value.data.BeanWorkspaceDefinition;
import com.prelytis.dashboard.value.data.BeanWorkspaceSession;
import com.prelytis.dashboard.value.tree.DefaultMutableTreeNode;
import com.prelytis.dashboard.value.tree.TreeNode;
import com.prelytis.dashboard.value.util.ExpressionEvaluationData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.naming.ServiceUnavailableException;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public final class AuthWorkspaceHelper {
    private static final Logger LOG = LogManager.getLogger(AuthWorkspaceHelper.class);
    public static final String AUTO_PREFIX = "AUTO_9876";
    public static final String MY_DOCS_DIR = "CurDev";
    public static final String ADMIN_DIR = "Admin";
    public static final Map<ResourceTypes, SessionType> MYDOCS_DIR_OBJECT_TYPES;
    public static final List<SessionType> ADMIN_DIR_OBJECT_TYPES;
    protected static final List<PassPortToWDMapping> PASSPORT_MAPPINGS;

    private AuthWorkspaceHelper() {
    }

    public static Map<String, SessionType> getSpecificMap(String[] names, SessionType[] sessionTypes) {
        HashMap<String, SessionType> results = new HashMap<String, SessionType>();
        for (int i = 0; i < names.length; ++i) {
            SessionType sessionType = sessionTypes[i];
            results.put(names[i], sessionType);
        }
        return results;
    }

    public static Map<String, SessionType> getSpecificMap(String[] names) {
        SessionType[] sessionTypes = new SessionType[names.length];
        for (int i = 0; i < names.length; ++i) {
            sessionTypes[i] = SessionType.SYSTEM;
        }
        return AuthWorkspaceHelper.getSpecificMap(names, sessionTypes);
    }

    public static BeanWorkspaceDefinition createWorkspace(WorkspaceHelper workspaceHelper, ExpressionEvaluationData evalData) throws DashboardException {
        BeanWorkspaceDefinition newWorkspace = workspaceHelper.createCopy(WorkspaceHelper.getTemplateWorkspaceName(workspaceHelper), evalData, true);
        AuthWorkspaceHelper.updateWorkspaceDescription(newWorkspace);
        return newWorkspace;
    }

    private static void updateWorkspaceDescription(BeanWorkspaceDefinition workspace) {
        Map descMap = workspace.getDescriptionMap();
        String newDesc = AUTO_PREFIX + workspace.getName();
        for (Locale locale : descMap.keySet()) {
            descMap.put(locale, newDesc);
        }
    }

    public static void deleteWorkspaces(WorkspaceHelper workspaceHelper, ExpressionEvaluationData evalData, Set<String> workspaces) {
        for (String workspace : workspaces) {
            try {
                workspaceHelper.delete(workspace, evalData);
            }
            catch (DashboardException e) {
                LOG.debug((Object)("Could not delete workspace " + workspace + "."), (Throwable)e);
            }
        }
    }

    protected static Map<ResourceTypes, List<String>> retrieveAvailableObjects() {
        DaoFactory daoFactory = DaoFactory.getInstance();
        HashMap<ResourceTypes, List<String>> availableResources = new HashMap<ResourceTypes, List<String>>();
        availableResources.put(ResourceTypes.HTML_REPORT, daoFactory.getReportDao().getAllNames());
        availableResources.put(ResourceTypes.HTML_DASHBOARD, daoFactory.getDashboardDao().getAllNames());
        availableResources.put(ResourceTypes.HTML_FORM, daoFactory.getFormDao().getAllNames());
        availableResources.put(ResourceTypes.HTML_EXTERNAL_COMPONENT, daoFactory.getExternSessionDao().getAllNames());
        return availableResources;
    }

    public static void updateAccessLevels(BeanWorkspaceDefinition workspace, Map<ResourceTypes, Map<String, ResourceAccessTypes>> newAccessLevels) throws DashboardServiceException {
        ViewToAllAccessHandler accessHandler = new ViewToAllAccessHandler();
        for (final Map.Entry<ResourceTypes, Map<String, ResourceAccessTypes>> resourceTypeEntry : newAccessLevels.entrySet()) {
            List<BeanWorkspaceSession> sessionList = WorkspaceHelper.getSessionsByFilter((TreeNode<Object>)workspace.getSessionGroupNode(), new TreeNodeFilter(){

                @Override
                public boolean matches(BeanWorkspaceSession workspaceSession) {
                    return MYDOCS_DIR_OBJECT_TYPES.get(resourceTypeEntry.getKey()).equals((Object)workspaceSession.getType());
                }
            });
            Map<String, ResourceAccessTypes> accessLevels = resourceTypeEntry.getValue();
            for (BeanWorkspaceSession session : sessionList) {
                ResourceAccessTypes newAccessLevel = accessLevels.get(session.getName());
                if (newAccessLevel == null) continue;
                session.setAccessLevel(Integer.valueOf(accessHandler.getActualAccessLevel(newAccessLevel)));
            }
        }
    }

    public static void customizeMenus(BeanWorkspaceDefinition workspace) {
        AuthWorkspaceHelper.hideUserMenu(workspace);
        AuthWorkspaceHelper.hideUsrMgmMenu(workspace);
    }

    private static void hideUserMenu(BeanWorkspaceDefinition workspace) {
        String forceDisplayUserMenu = InternalProperties.getInstance().getProperty("force.display.users.menu");
        if (Boolean.valueOf(forceDisplayUserMenu).booleanValue()) {
            return;
        }
        List<BeanWorkspaceSession> userList = WorkspaceHelper.getBeanWorkspaceSessions((TreeNode<Object>)workspace.getSessionGroupNode(), SessionParameterType.USER);
        if (!userList.isEmpty()) {
            BeanWorkspaceSession userMenu = userList.get(0);
            userMenu.setAccessLevel(Integer.valueOf(0));
        }
    }

    private static void hideUsrMgmMenu(BeanWorkspaceDefinition workspace) {
        List<BeanWorkspaceSession> usrMgmList = WorkspaceHelper.getBeanWorkspaceSessions((TreeNode<Object>)workspace.getSessionGroupNode(), SessionParameterType.USER_MANAGEMENT);
        if (!usrMgmList.isEmpty()) {
            BeanWorkspaceSession userMenu = usrMgmList.get(0);
            userMenu.setAccessLevel(Integer.valueOf(0));
        }
    }

    public static void updateAccessLevels(BeanWorkspaceDefinition workspace, long userId) throws ServiceUnavailableException, DashboardServiceException {
        int accessLevel;
        for (PassPortToWDMapping mapping : PASSPORT_MAPPINGS) {
            accessLevel = AuthWorkspaceHelper.getAccessLevel(userId, mapping.getRightNameManage(), mapping.getRightNameViewDesign());
            AuthWorkspaceHelper.checkRightAndUpdateLevels(workspace, mapping.getMappedNodes(), accessLevel);
        }
        accessLevel = AuthWorkspaceHelper.getAccessLevel(userId, "UPLOADHTMLFOLDER", "DOWNLOADHTMLFOLDER");
        AuthWorkspaceHelper.checkRightAndUpdateLevels(workspace, AuthWorkspaceHelper.getWkspFolders(workspace), accessLevel);
    }

    private static void checkRightAndUpdateLevels(BeanWorkspaceDefinition workspace, final Map<String, SessionType> nodeNamesAndTypes, int accessLevel) throws ServiceUnavailableException, DashboardServiceException {
        List<BeanWorkspaceSession> sessionList = WorkspaceHelper.getSessionsByFilter((TreeNode<Object>)workspace.getSessionGroupNode(), new TreeNodeFilter(){

            @Override
            public boolean matches(BeanWorkspaceSession workspaceSession) {
                String objectName = workspaceSession.getName();
                return nodeNamesAndTypes.get(objectName) != null && ((SessionType)nodeNamesAndTypes.get(objectName)).equals((Object)workspaceSession.getType());
            }
        });
        for (BeanWorkspaceSession session : sessionList) {
            LOG.debug((Object)("For '" + session.getName() + "' set access level: " + accessLevel));
            session.setAccessLevel(Integer.valueOf(accessLevel));
        }
    }

    private static int getAccessLevel(long userId, String manageRight, String viewRight) throws ServiceUnavailableException, DashboardServiceException {
        IDashboardManager dashboardManager = DashboardManager.getInstance();
        int accessLevel = 0;
        if (dashboardManager.userHasRight(userId, manageRight)) {
            accessLevel = 2;
        } else if (dashboardManager.userHasRight(userId, viewRight)) {
            accessLevel = 1;
        }
        return accessLevel;
    }

    public static void addAllObjectsToWorkspace(BeanWorkspaceDefinition workspace) {
        TreeNode<Object> myDocsGroup = WorkspaceHelper.getGroupByName((TreeNode<Object>)workspace.getSessionGroupNode(), MY_DOCS_DIR);
        TreeNode<Object> adminGroup = WorkspaceHelper.getGroupByName((TreeNode<Object>)workspace.getSessionGroupNode(), ADMIN_DIR);
        for (BeanWorkspaceSession session : workspace.getMoreSessionList()) {
            Collection<SessionType> sessionTypes = MYDOCS_DIR_OBJECT_TYPES.values();
            if (sessionTypes.contains(session.getType())) {
                AuthWorkspaceHelper.addObjectToFolder(session, myDocsGroup);
                LOG.debug((Object)("Added object: " + session.getName() + " to: " + MY_DOCS_DIR));
                continue;
            }
            if (!ADMIN_DIR_OBJECT_TYPES.contains(session.getType())) continue;
            AuthWorkspaceHelper.addObjectToFolder(session, adminGroup);
            LOG.debug((Object)("Added object: " + session.getName() + " to: " + ADMIN_DIR));
        }
    }

    private static void addObjectToFolder(BeanWorkspaceSession session, TreeNode<Object> sessionGroup) {
        DefaultMutableTreeNode newNode = new DefaultMutableTreeNode();
        newNode.setUserObject((Object)session);
        newNode.setParent(sessionGroup);
        sessionGroup.getChildren().add(newNode);
    }

    private static Map<String, SessionType> getWkspFolders(BeanWorkspaceDefinition workspace) {
        List<BeanWorkspaceSession> sessionList = WorkspaceHelper.getSessionsByFilter((TreeNode<Object>)workspace.getSessionGroupNode(), new TreeNodeFilter(){

            @Override
            public boolean matches(BeanWorkspaceSession workspaceSession) {
                return SessionType.FILE.equals((Object)workspaceSession.getType());
            }
        });
        HashMap<String, SessionType> result = new HashMap<String, SessionType>();
        for (BeanWorkspaceSession session : sessionList) {
            result.put(session.getName(), SessionType.FILE);
        }
        LOG.debug((Object)("Folder names: " + result));
        return result;
    }

    static {
        ADMIN_DIR_OBJECT_TYPES = new ArrayList<SessionType>();
        PASSPORT_MAPPINGS = new ArrayList<PassPortToWDMapping>();
        MYDOCS_DIR_OBJECT_TYPES = new HashMap<ResourceTypes, SessionType>();
        MYDOCS_DIR_OBJECT_TYPES.put(ResourceTypes.HTML_REPORT, SessionType.DOCUMENT);
        MYDOCS_DIR_OBJECT_TYPES.put(ResourceTypes.HTML_DASHBOARD, SessionType.DASHBOARD);
        MYDOCS_DIR_OBJECT_TYPES.put(ResourceTypes.HTML_FORM, SessionType.FORM);
        MYDOCS_DIR_OBJECT_TYPES.put(ResourceTypes.HTML_EXTERNAL_COMPONENT, SessionType.EXTERN);
        ADMIN_DIR_OBJECT_TYPES.add(SessionType.FILE);
        PASSPORT_MAPPINGS.add(new PassPortToWDMapping("MANAGEHTMLDASHBOARD", "VIEWDESIGNHTMLDASHBOARD", AuthWorkspaceHelper.getSpecificMap(new String[]{"DashBoard", "DynLink", "ExtSession", "Report", "Text"})));
        PASSPORT_MAPPINGS.add(new PassPortToWDMapping("MANAGEHTMLSTRATEGYMAP", "VIEWDESIGNHTMLSTRATEGYMAP", AuthWorkspaceHelper.getSpecificMap(new String[]{"Perspective", "StratObj", "ControlsPanel", "Metrics", "StrategyMap", "Metric"}, new SessionType[]{SessionType.SYSTEM, SessionType.SYSTEM, SessionType.CONTROL_PANEL, SessionType.METRIC_PANEL, SessionType.STRATEGY_MAP, SessionType.SYSTEM})));
        PASSPORT_MAPPINGS.add(new PassPortToWDMapping("MANAGEHTMLFORM", "VIEWDESIGNHTMLFORM", AuthWorkspaceHelper.getSpecificMap(new String[]{"Form"})));
        PASSPORT_MAPPINGS.add(new PassPortToWDMapping("MANAGEHTMLSYSTEMSETTINGS", "VIEWDESIGNHTMLSYSTEMSETTINGS", AuthWorkspaceHelper.getSpecificMap(new String[]{"Language", "MaintPer", "PRPInfo", "ImportXML", "ExportXML", "Workspace", "SessionGroup"})));
        PASSPORT_MAPPINGS.add(new PassPortToWDMapping("MANAGEHTMLTASK", "VIEWDESIGNHTMLTASK", AuthWorkspaceHelper.getSpecificMap(new String[]{"TaskGroup", "Task", "TaskMgr", "ControlGroup", "Control", "MsgType"})));
        PASSPORT_MAPPINGS.add(new PassPortToWDMapping("MANAGEHTMLDATADICTIONARY", "VIEWDESIGNHTMLDATADICTIONARY", AuthWorkspaceHelper.getSpecificMap(new String[]{"Query", "ImportExcel", "FieldGroup"})));
        PASSPORT_MAPPINGS.add(new PassPortToWDMapping("MANAGEHTMLWORLD", "VIEWDESIGNHTMLWORLD", AuthWorkspaceHelper.getSpecificMap(new String[]{"World", "Driver"})));
        PASSPORT_MAPPINGS.add(new PassPortToWDMapping("MANAGEHTMLLOOKANDFEEL", "VIEWDESIGNHTMLLOOKANDFEEL", AuthWorkspaceHelper.getSpecificMap(new String[]{"ColorList", "Page", "PageLayout", "StrokeType", "Style", "Theme"})));
        PASSPORT_MAPPINGS.add(new PassPortToWDMapping("MANAGEHTMLHTMLENTITY", "VIEWDESIGNHTMLENTITY", AuthWorkspaceHelper.getSpecificMap(new String[]{"Entity"})));
        PASSPORT_MAPPINGS.add(new PassPortToWDMapping("MANAGEHTMLPERSONALIZEDFIELD", "VIEWDESIGNHTMLPERSONALIZEDFIELD", AuthWorkspaceHelper.getSpecificMap(new String[]{"PersFld"})));
        PASSPORT_MAPPINGS.add(new PassPortToWDMapping("MANAGEHTMLSYSTEMSETTINGS", "VIEWDESIGNHTMLSYSTEMSETTINGS", AuthWorkspaceHelper.getSpecificMap(new String[]{"ConnectedUsers"})));
        PASSPORT_MAPPINGS.add(new PassPortToWDMapping("MANAGEHTMLFOLDER", "VIEWDESIGNHTMLFOLDER", AuthWorkspaceHelper.getSpecificMap(new String[]{"Folder"})));
    }
}

