/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.task;

import com.prelytis.dashboard.util.ConversionHelper;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Locale;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;

public class LogReader
implements XMLReader {
    private ContentHandler contentHandler;
    private ErrorHandler errorHandler;
    private String nameSpaceURI = "";
    private String prefix = "";
    private boolean fNamespaces = false;
    private boolean fNamespacePrefixes = false;
    private EntityResolver entityResolver;
    private DTDHandler dtdHandler;

    @Override
    public void parse(InputSource input) throws IOException, SAXException {
        ConversionHelper xmlConv = ConversionHelper.getXMLConverter();
        AttributesImpl attributes = new AttributesImpl();
        ContentHandler contentHandler = this.contentHandler;
        String nameSpaceURI = this.nameSpaceURI;
        String prefix = this.prefix;
        BufferedReader reader = new BufferedReader(new InputStreamReader(input.getByteStream(), input.getEncoding()));
        attributes.clear();
        contentHandler.startDocument();
        contentHandler.startPrefixMapping(prefix, "http://www.prelytis.com/schemas/livedasboard/4.6/datamart.xsd");
        String line = reader.readLine();
        attributes.addAttribute(nameSpaceURI, "nbcols", prefix + "nbcols", "CDATA", "10");
        contentHandler.startElement(nameSpaceURI, "table", prefix + "table", attributes);
        attributes.clear();
        contentHandler.startElement(nameSpaceURI, "definition", prefix + "definition", attributes);
        String[] fields = new String[]{"site", "user", "datetime", "method", "page", "protocol", "status", "size", "referer", "browser"};
        int[] dataType = new int[]{12, 12, 93, 12, 12, 12, 4, 4, 12, 12};
        int[] fieldSize = new int[]{100, 30, 12, 10, 255, 15, 8, 8, 255, 200};
        for (int i = 0; i < fields.length; ++i) {
            attributes.clear();
            attributes.addAttribute(nameSpaceURI, "col", prefix + "col", "CDATA", String.valueOf(i + 1));
            attributes.addAttribute(nameSpaceURI, "name", prefix + "name", "CDATA", fields[i]);
            attributes.addAttribute(nameSpaceURI, "description", prefix + "description", "CDATA", fields[i]);
            attributes.addAttribute(nameSpaceURI, "datatype", prefix + "datatype", "CDATA", String.valueOf(dataType[i]));
            if (dataType[i] == 4) {
                attributes.addAttribute(nameSpaceURI, "fieldscale", prefix + "fieldscale", "CDATA", "0");
                attributes.addAttribute(nameSpaceURI, "fieldprecision", prefix + "fieldprecision", "CDATA", String.valueOf(fieldSize[i]));
            } else {
                attributes.addAttribute(nameSpaceURI, "fieldsize", prefix + "fieldsize", "CDATA", String.valueOf(fieldSize[i]));
            }
            contentHandler.startElement(nameSpaceURI, "fielddefinition", prefix + "fielddefinition", attributes);
            contentHandler.endElement(nameSpaceURI, "fielddefinition", prefix + "fielddefinition");
        }
        contentHandler.endElement(nameSpaceURI, "definition", prefix + "definition");
        SimpleDateFormat sdf = new SimpleDateFormat("dd/MMM/yyyy:HH:mm:ss Z", Locale.ENGLISH);
        while (line != null) {
            attributes.clear();
            contentHandler.startElement(nameSpaceURI, "record", prefix + "record", attributes);
            int lPos1 = line.indexOf(" -");
            String lElt = line.substring(0, lPos1);
            attributes.clear();
            attributes.addAttribute(nameSpaceURI, "col", prefix + "col", "CDATA", "1");
            contentHandler.startElement(nameSpaceURI, "fielddefinition", prefix + "fielddefinition", attributes);
            contentHandler.characters(lElt.toCharArray(), 0, Math.min(fieldSize[0], lElt.length()));
            contentHandler.endElement(nameSpaceURI, "fielddefinition", prefix + "fielddefinition");
            int lPos2 = line.indexOf(" [", lPos1 + 3);
            lElt = line.substring(lPos1 + 3, lPos2);
            attributes.clear();
            attributes.addAttribute(nameSpaceURI, "col", prefix + "col", "CDATA", "2");
            contentHandler.startElement(nameSpaceURI, "fielddefinition", prefix + "fielddefinition", attributes);
            contentHandler.characters(lElt.toCharArray(), 0, Math.min(fieldSize[1], lElt.length()));
            contentHandler.endElement(nameSpaceURI, "fielddefinition", prefix + "fielddefinition");
            lPos1 = line.indexOf("] ", lPos2);
            try {
                lElt = xmlConv.format((Object)new Timestamp(sdf.parse(line.substring(lPos2 + 2, lPos1)).getTime()));
            }
            catch (ParseException e) {
                throw new IOException(e.getMessage());
            }
            attributes.clear();
            attributes.addAttribute(nameSpaceURI, "col", prefix + "col", "CDATA", "3");
            contentHandler.startElement(nameSpaceURI, "fielddefinition", prefix + "fielddefinition", attributes);
            contentHandler.characters(lElt.toCharArray(), 0, lElt.length());
            contentHandler.endElement(nameSpaceURI, "fielddefinition", prefix + "fielddefinition");
            lPos2 = line.indexOf("\"", lPos1 + 3);
            String lTmp = line.substring(lPos1 + 3, lPos2);
            String[] lPage = lTmp.split(" ");
            lElt = lPage[0];
            attributes.clear();
            attributes.addAttribute(nameSpaceURI, "col", prefix + "col", "CDATA", "4");
            contentHandler.startElement(nameSpaceURI, "fielddefinition", prefix + "fielddefinition", attributes);
            contentHandler.characters(lElt.toCharArray(), 0, Math.min(fieldSize[3], lElt.length()));
            contentHandler.endElement(nameSpaceURI, "fielddefinition", prefix + "fielddefinition");
            lElt = lPage[1];
            attributes.clear();
            attributes.addAttribute(nameSpaceURI, "col", prefix + "col", "CDATA", "5");
            contentHandler.startElement(nameSpaceURI, "fielddefinition", prefix + "fielddefinition", attributes);
            contentHandler.characters(lElt.toCharArray(), 0, Math.min(fieldSize[4], lElt.length()));
            contentHandler.endElement(nameSpaceURI, "fielddefinition", prefix + "fielddefinition");
            lElt = lPage[2];
            attributes.clear();
            attributes.addAttribute(nameSpaceURI, "col", prefix + "col", "CDATA", "6");
            contentHandler.startElement(nameSpaceURI, "fielddefinition", prefix + "fielddefinition", attributes);
            contentHandler.characters(lElt.toCharArray(), 0, Math.min(fieldSize[5], lElt.length()));
            contentHandler.endElement(nameSpaceURI, "fielddefinition", prefix + "fielddefinition");
            lPos1 = line.indexOf(" ", lPos2 + 2);
            lElt = line.substring(lPos2 + 2, lPos1);
            attributes.clear();
            attributes.addAttribute(nameSpaceURI, "col", prefix + "col", "CDATA", "7");
            contentHandler.startElement(nameSpaceURI, "fielddefinition", prefix + "fielddefinition", attributes);
            contentHandler.characters(lElt.toCharArray(), 0, Math.min(fieldSize[6], lElt.length()));
            contentHandler.endElement(nameSpaceURI, "fielddefinition", prefix + "fielddefinition");
            lPos2 = line.indexOf(" ", lPos1 + 1);
            lElt = line.substring(lPos1 + 1, lPos2);
            if ("-".equals(lElt)) {
                lElt = "";
            }
            attributes.clear();
            attributes.addAttribute(nameSpaceURI, "col", prefix + "col", "CDATA", "8");
            contentHandler.startElement(nameSpaceURI, "fielddefinition", prefix + "fielddefinition", attributes);
            contentHandler.characters(lElt.toCharArray(), 0, Math.min(fieldSize[7], lElt.length()));
            contentHandler.endElement(nameSpaceURI, "fielddefinition", prefix + "fielddefinition");
            lPos1 = line.indexOf("\"", lPos2 + 1);
            lPos2 = line.indexOf("\"", lPos1 + 1);
            lElt = line.substring(lPos1 + 1, lPos2);
            attributes.clear();
            attributes.addAttribute(nameSpaceURI, "col", prefix + "col", "CDATA", "9");
            contentHandler.startElement(nameSpaceURI, "fielddefinition", prefix + "fielddefinition", attributes);
            contentHandler.characters(lElt.toCharArray(), 0, Math.min(fieldSize[8], lElt.length()));
            contentHandler.endElement(nameSpaceURI, "fielddefinition", prefix + "fielddefinition");
            lPos1 = line.indexOf("\"", lPos2 + 1);
            lPos2 = line.indexOf("\"", lPos1 + 1);
            lElt = line.substring(lPos1 + 1, lPos2);
            attributes.clear();
            attributes.addAttribute(nameSpaceURI, "col", prefix + "col", "CDATA", "10");
            contentHandler.startElement(nameSpaceURI, "fielddefinition", prefix + "fielddefinition", attributes);
            contentHandler.characters(lElt.toCharArray(), 0, Math.min(fieldSize[9], lElt.length()));
            contentHandler.endElement(nameSpaceURI, "fielddefinition", prefix + "fielddefinition");
            contentHandler.endElement(nameSpaceURI, "record", prefix + "record");
            line = reader.readLine();
        }
        contentHandler.endElement(nameSpaceURI, "table", prefix + "table");
        contentHandler.endPrefixMapping(prefix);
        contentHandler.endDocument();
    }

    @Override
    public void setContentHandler(ContentHandler contentHandler) {
        this.contentHandler = contentHandler;
    }

    @Override
    public ContentHandler getContentHandler() {
        return this.contentHandler;
    }

    @Override
    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    @Override
    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    @Override
    public void parse(String systemId) throws IOException, SAXException {
    }

    @Override
    public DTDHandler getDTDHandler() {
        return this.dtdHandler;
    }

    @Override
    public EntityResolver getEntityResolver() {
        return this.entityResolver;
    }

    @Override
    public void setEntityResolver(EntityResolver resolver) {
        this.entityResolver = resolver;
    }

    @Override
    public void setDTDHandler(DTDHandler handler) {
        this.dtdHandler = handler;
    }

    @Override
    public Object getProperty(String name) {
        return null;
    }

    @Override
    public void setProperty(String name, Object value) {
    }

    @Override
    public void setFeature(String name, boolean value) {
        if ("http://xml.org/sax/features/namespaces".equals(name)) {
            this.fNamespaces = value;
        }
        if ("http://xml.org/sax/features/namespace-prefixes".equals(name)) {
            this.fNamespacePrefixes = value;
        }
        if (this.fNamespacePrefixes && this.fNamespaces) {
            this.nameSpaceURI = "http://www.prelytis.com/schemas/livedasboard/4.6/datamart.xsd";
            this.prefix = "dm:";
        } else {
            this.nameSpaceURI = "";
            this.prefix = "";
        }
    }

    @Override
    public boolean getFeature(String name) {
        if ("http://xml.org/sax/features/namespaces".equals(name)) {
            return this.fNamespaces;
        }
        if ("http://xml.org/sax/features/namespace-prefixes".equals(name)) {
            return this.fNamespacePrefixes;
        }
        return false;
    }
}

