/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.task;

import com.prelytis.dashboard.helper.FieldMetaDataHelper;
import com.prelytis.dashboard.helper.MessageListener;
import com.prelytis.dashboard.interfaces.DashboardException;
import com.prelytis.dashboard.task.WarningException;
import com.prelytis.dashboard.task.execution.TableExecutionAutoCommit;
import com.prelytis.dashboard.task.execution.TableExecutionBatchInsert;
import com.prelytis.dashboard.task.execution.TableExecutionBatchReplace;
import com.prelytis.dashboard.task.execution.TableExecutionBatchUpdate;
import com.prelytis.dashboard.task.execution.TableExecutionCommit;
import com.prelytis.dashboard.task.execution.TableExecutionDataSource;
import com.prelytis.dashboard.task.execution.TableExecutionDirectInsert;
import com.prelytis.dashboard.task.execution.TableExecutionDirectReplace;
import com.prelytis.dashboard.task.execution.TableExecutionDirectUpdate;
import com.prelytis.dashboard.task.execution.TableExecutionRoot;
import com.prelytis.dashboard.task.execution.TableExecutionUpdateInsert;
import com.prelytis.dashboard.util.ConversionHelper;
import com.prelytis.dashboard.util.sql.SQLKey;
import com.prelytis.dashboard.util.sql.SQLKeyType;
import com.prelytis.dashboard.util.sql.SQLTable;
import com.prelytis.dashboard.util.sql.SQLTableHelper;
import com.prelytis.dashboard.value.util.DataType;
import com.prelytis.dashboard.value.util.ExecutionMessage;
import com.prelytis.dashboard.value.util.ExecutionMessageI18n;
import com.prelytis.dashboard.value.util.ExecutionMessageStd;
import com.prelytis.dashboard.value.util.FieldMetaData;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class TableHandler
extends DefaultHandler {
    private StringBuffer textBuffer;
    private String[] values;
    private Map<Integer, FieldMetaData> fields;
    private int nbCols;
    private boolean definition;
    private int insertedLines;
    private int updatedLines;
    private int ignoredLines;
    private final boolean emptyTable;
    private final boolean createTable;
    private int fieldNum;
    private Locator locator;
    private int nbWarning;
    private final int insertType;
    private final int deleteType;
    private final int batchType;
    private final int batchNbLine;
    private final int commitType;
    private final int commitNbLine;
    private final String catalog;
    private final String schema;
    private final boolean createPrimaryKey;
    private final MessageListener messageListener;
    private final SQLTableHelper sqlTableHelper;
    private SQLTable sqlTable;
    private SQLKey primaryKey;
    private SQLTable updateSqlTable;
    private TableExecutionRoot tableExecution;
    private Set<Integer> ignoreSet = new HashSet<Integer>();
    private int[] cols;
    private final boolean mbcs;
    private static final Logger log = LogManager.getLogger(TableHandler.class);
    private static final String ELT_TABLE = "table";
    private static final String ELT_RECORD = "record";
    private static final String ELT_DEFINITION = "definition";
    private static final String ELT_FIELDDEFINITION = "fielddefinition";
    private static final String ELT_FIELD = "field";
    private static final String ATT_COL = "col";
    private static final String ATT_NBCOLS = "nbcols";
    private static final String ATT_NAME = "name";
    private static final String ATT_DESCRIPTION = "description";
    private static final String ATT_DATATYPE = "datatype";
    private static final String ATT_FIELDSIZE = "fieldsize";
    private static final String ATT_FIELDPRECISION = "fieldprecision";
    private static final String ATT_FIELDSCALE = "fieldscale";

    private TableHandler(SQLTableHelper sqlTableHelper, MessageListener messageListener, String defaultTable, boolean emptyTable, boolean createTable, int insertType, int deleteType, String catalog, String schema, boolean createPrimaryKey, int batchType, int batchNbLines, int commitType, int commitNbLine, boolean mbcs) {
        this.sqlTableHelper = sqlTableHelper;
        this.messageListener = messageListener;
        this.definition = true;
        this.emptyTable = emptyTable;
        this.createTable = createTable;
        this.definition = false;
        this.insertedLines = 0;
        this.updatedLines = 0;
        this.ignoredLines = 0;
        this.nbWarning = 0;
        this.insertType = insertType;
        this.deleteType = deleteType;
        this.catalog = catalog;
        this.schema = schema;
        this.createPrimaryKey = createPrimaryKey;
        this.sqlTable = new SQLTable(this.catalog, this.schema, defaultTable);
        this.primaryKey = new SQLKey();
        this.primaryKey.setType(SQLKeyType.PRIMARY_KEY);
        this.batchType = batchType;
        this.batchNbLine = batchNbLines;
        this.commitType = commitType;
        this.commitNbLine = commitNbLine;
        this.mbcs = mbcs;
    }

    @Override
    public void startDocument() throws SAXException {
        this.fields = new HashMap<Integer, FieldMetaData>();
    }

    @Override
    public void endDocument() throws SAXException {
        this.values = null;
        try {
            if (this.tableExecution != null) {
                this.tableExecution.end();
                this.insertedLines = this.tableExecution.getInsertedLines();
                this.updatedLines = this.tableExecution.getUpdatedLines();
                this.ignoredLines = this.tableExecution.getIgnoredLines();
            }
        }
        catch (Exception e) {
            if (e instanceof SAXException) {
                throw (SAXException)e;
            }
            this.throwException(e.getMessage());
        }
        this.tableExecution = null;
        if (log.isDebugEnabled()) {
            log.debug((Object)"TableExecution > TableHandler > Close");
        }
        this.addMessage(1, "taskMsg.linesInserted", this.insertedLines);
        this.addMessage(1, "taskMsg.linesUpdated", this.updatedLines);
        this.addMessage(1, "taskMsg.linesIgnored", this.ignoredLines);
    }

    @Override
    public void startElement(String namespaceURI, String sName, String qName, Attributes attrs) throws SAXException {
        block19: {
            block24: {
                FieldMetaData fmd;
                DataType dataType;
                int fieldNum;
                block23: {
                    block22: {
                        block21: {
                            block20: {
                                block18: {
                                    this.textBuffer = null;
                                    if (!this.isElement(namespaceURI, sName, qName, ELT_TABLE)) break block18;
                                    String tmp = this.getValue(attrs, namespaceURI, ATT_NBCOLS);
                                    try {
                                        this.nbCols = Integer.parseInt(tmp);
                                    }
                                    catch (Exception e) {
                                        this.throwException("nbcols attribute missing");
                                    }
                                    if (this.sqlTable.getName() != null) break block19;
                                    this.sqlTable.setName(this.getValue(attrs, namespaceURI, ATT_NAME));
                                    break block19;
                                }
                                if (!this.isElement(namespaceURI, sName, qName, ELT_RECORD)) break block20;
                                for (int i = 0; i < this.values.length; ++i) {
                                    this.values[i] = null;
                                }
                                break block19;
                            }
                            if (!this.isElement(namespaceURI, sName, qName, ELT_DEFINITION)) break block21;
                            this.fields.clear();
                            this.definition = true;
                            break block19;
                        }
                        if (!this.isElement(namespaceURI, sName, qName, "primarykey")) break block22;
                        this.primaryKey.setName(this.getValue(attrs, namespaceURI, ATT_NAME));
                        break block19;
                    }
                    if (!this.isElement(namespaceURI, sName, qName, "pkfield")) break block23;
                    this.primaryKey.getFieldList().add(this.getValue(attrs, namespaceURI, ATT_NAME));
                    break block19;
                }
                if (!this.isElement(namespaceURI, sName, qName, ELT_FIELDDEFINITION)) break block24;
                String name = this.getValue(attrs, namespaceURI, ATT_NAME);
                String description = this.getValue(attrs, namespaceURI, ATT_DESCRIPTION);
                String tmp = this.getValue(attrs, namespaceURI, ATT_COL);
                try {
                    fieldNum = Integer.parseInt(tmp);
                }
                catch (Exception e) {
                    fieldNum = this.fields.size();
                }
                tmp = this.getValue(attrs, namespaceURI, ATT_DATATYPE);
                try {
                    dataType = DataType.valueOf((int)Integer.parseInt(tmp));
                }
                catch (Exception e) {
                    dataType = DataType.VARCHAR;
                }
                if (dataType == DataType.CHAR || dataType == DataType.VARCHAR) {
                    int fieldSize;
                    tmp = this.getValue(attrs, namespaceURI, ATT_FIELDSIZE);
                    try {
                        fieldSize = Integer.parseInt(tmp);
                    }
                    catch (Exception e) {
                        fieldSize = 10;
                    }
                    if (dataType == DataType.VARCHAR && this.mbcs) {
                        fieldSize *= 3;
                    }
                    fmd = new FieldMetaData(0, name, description, dataType, fieldSize);
                } else {
                    int fieldPrecision;
                    int fieldScale;
                    tmp = this.getValue(attrs, namespaceURI, ATT_FIELDSCALE);
                    try {
                        fieldScale = Integer.parseInt(tmp);
                    }
                    catch (Exception e) {
                        fieldScale = 2;
                    }
                    tmp = this.getValue(attrs, namespaceURI, ATT_FIELDPRECISION);
                    try {
                        fieldPrecision = Integer.parseInt(tmp);
                    }
                    catch (Exception e) {
                        fieldPrecision = 10;
                    }
                    fmd = new FieldMetaData(0, name, description, dataType, fieldPrecision, fieldScale);
                }
                tmp = this.getValue(attrs, namespaceURI, "nullable");
                fmd.setNullable(!"0".equals(tmp));
                this.fields.put(fieldNum, fmd);
                tmp = this.getValue(attrs, namespaceURI, "ignore");
                if (!"1".equals(tmp)) break block19;
                this.ignoreSet.add(fieldNum);
                break block19;
            }
            if (!this.isElement(namespaceURI, sName, qName, ELT_FIELD)) break block19;
            String tmp = this.getValue(attrs, namespaceURI, ATT_COL);
            try {
                this.fieldNum = Integer.parseInt(tmp);
            }
            catch (Exception e) {
                this.fieldNum = 0;
            }
        }
    }

    @Override
    public void endElement(String namespaceURI, String sName, String qName) throws SAXException {
        int i;
        if (this.isElement(namespaceURI, sName, qName, ELT_DEFINITION)) {
            List fieldList;
            if (this.nbCols == 0) {
                this.throwException("No Column Found");
            }
            if (this.sqlTableHelper.getTableExists(this.sqlTable)) {
                try {
                    this.sqlTableHelper.refreshFieldList(this.sqlTable);
                }
                catch (Exception e) {
                    this.throwException("Error while refreshing field list (" + e.toString() + ")");
                }
                if (this.sqlTable.getFieldList().isEmpty()) {
                    this.throwException("No Column Found");
                }
            } else {
                try {
                    this.sqlTableHelper.updateFieldName(this.sqlTable);
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (this.createTable) {
                    fieldList = this.sqlTable.getFieldList();
                    for (int i2 = 0; i2 < this.nbCols; ++i2) {
                        fieldList.add(this.fields.get(i2 + 1));
                    }
                    try {
                        this.addMessage(1, "taskMsg.creatingTable", this.sqlTable.getName());
                        this.sqlTable = this.sqlTableHelper.createTable(this.sqlTable);
                        this.addStdMessage(1, "Script:\n" + this.sqlTableHelper.getLastSQL());
                    }
                    catch (Exception e) {
                        this.addMessage(3, "taskMsg.errCreatingTable", this.sqlTable.getName());
                        this.throwException("Error while creating table (" + e.toString() + ")");
                    }
                } else {
                    this.addMessage(3, "taskMsg.invalidTable", this.sqlTable.getName());
                    this.throwException("Table \"" + this.sqlTable.getName() + "\" does not exist");
                }
            }
            try {
                if (this.createPrimaryKey && !this.sqlTableHelper.isPrimaryKeyExist(this.sqlTable, this.primaryKey.getName())) {
                    this.sqlTableHelper.createPrimaryKey(this.sqlTable, this.primaryKey);
                }
            }
            catch (Exception e) {
                this.addMessage(3, "taskMsg.errCreatingScript", this.sqlTable.getName());
                this.throwException("Error while creating primary key:\n" + e.toString());
            }
            try {
                if (this.emptyTable) {
                    this.addMessage(1, "taskMsg.emptyingTable", this.sqlTable.getName());
                    this.sqlTableHelper.emptyTable(this.sqlTable, this.deleteType);
                }
            }
            catch (Exception e) {
                this.addMessage(3, "taskMsg.errEmptyingTable", this.sqlTable.getName());
                this.throwException("Error while emptying table:\n" + e.toString());
            }
            fieldList = this.sqlTable.getFieldList();
            try {
                if (this.nbCols != fieldList.size()) {
                    this.addMessage(3, "taskMsg.invNbrOfField", new Integer[]{fieldList.size(), this.nbCols});
                    this.throwException("Invalid number of fields (table contains: " + fieldList.size() + ", data provides: " + this.nbCols);
                }
            }
            catch (SAXException e) {
                throw e;
            }
            catch (Exception e) {
                this.addMessage(3, "taskMsg.errGettingFieldList");
                this.throwException("Error while determining field list:\n" + e.toString());
            }
            try {
                this.cols = new int[this.nbCols - this.ignoreSet.size()];
                int cpt = 0;
                this.updateSqlTable = new SQLTable(this.sqlTable.getCatalog(), this.sqlTable.getSchema(), this.sqlTable.getName());
                for (i = 0; i < fieldList.size(); ++i) {
                    if (this.ignoreSet.contains(i + 1)) continue;
                    this.cols[cpt] = i;
                    ++cpt;
                    FieldMetaData fmd = FieldMetaDataHelper.getCopy((FieldMetaData)fieldList.get(i));
                    fmd.setObjectID(i + 1);
                    this.updateSqlTable.getFieldList().add(fmd);
                }
                this.ignoreSet.clear();
                this.init();
                this.tableExecution.start();
            }
            catch (Exception e) {
                this.addMessage(3, "taskMsg.preparingStatement");
                this.throwException("Error while preparing statement: " + e.toString());
            }
            this.values = new String[fieldList.size()];
            this.definition = false;
        }
        if (!this.definition) {
            List updateFieldList = this.updateSqlTable.getFieldList();
            if (this.isElement(namespaceURI, sName, qName, ELT_FIELD)) {
                if (this.textBuffer != null && this.fieldNum > 0 && this.fieldNum <= this.values.length) {
                    this.values[this.fieldNum - 1] = this.textBuffer.toString();
                }
            } else if (this.isElement(namespaceURI, sName, qName, ELT_RECORD)) {
                try {
                    String[] newValues = new String[updateFieldList.size()];
                    for (i = 0; i < updateFieldList.size(); ++i) {
                        newValues[i] = this.values[this.cols[i]];
                    }
                    this.tableExecution.insert(newValues);
                }
                catch (Exception e) {
                    this.throwException(e.getMessage());
                }
            } else if (this.isElement(namespaceURI, sName, qName, ELT_TABLE)) {
                String message = null;
                if (this.nbWarning > 1) {
                    message = this.nbWarning + " warnings";
                } else if (this.nbWarning == 1) {
                    message = "1 warning";
                }
                if (message != null) {
                    this.addMessage(2, "taskMsg.warningSummary", String.valueOf(this.nbWarning));
                    throw new WarningException(message);
                }
            }
        }
    }

    @Override
    public void characters(char[] buf, int offset, int len) throws SAXException {
        String s = new String(buf, offset, len);
        if (this.textBuffer == null) {
            this.textBuffer = new StringBuffer(s);
        } else {
            this.textBuffer.append(s);
        }
    }

    private void throwException(String message) throws SAXException {
        try {
            if (this.tableExecution != null) {
                DashboardException de = new DashboardException();
                de.setLocalizedMessage(message);
                this.tableExecution.error(de);
                this.tableExecution = null;
            }
        }
        catch (Exception e) {
            log.warn((Object)e);
        }
        throw new SAXException(message);
    }

    public int getInsertedLines() {
        return this.insertedLines;
    }

    public int getUpdatedLines() {
        return this.updatedLines;
    }

    public int getIgnoredLines() {
        return this.ignoredLines;
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    public Locator getDocumentLocator() {
        return this.locator;
    }

    @Override
    public void error(SAXParseException exception) throws SAXException {
        try {
            if (this.tableExecution != null) {
                this.tableExecution.error(new DashboardException((Throwable)exception));
            }
        }
        catch (Exception e) {
            log.warn((Object)e);
        }
        throw exception;
    }

    @Override
    public void fatalError(SAXParseException exception) throws SAXException {
        try {
            if (this.tableExecution != null) {
                this.tableExecution.error(new DashboardException((Throwable)exception));
            }
        }
        catch (Exception e) {
            log.warn((Object)e);
        }
        throw exception;
    }

    @Override
    public void warning(SAXParseException exception) throws SAXException {
        log.info((Object)exception.getMessage());
        ++this.nbWarning;
    }

    private void addMessage(int severity, String msgKey) {
        this.messageListener.log((ExecutionMessage)new ExecutionMessageI18n(severity, msgKey, (Object[])null));
    }

    private void addMessage(int severity, String msgKey, int param) {
        Object[] params = new Object[]{param};
        this.messageListener.log((ExecutionMessage)new ExecutionMessageI18n(severity, msgKey, params));
    }

    private void addMessage(int severity, String msgKey, String param) {
        this.messageListener.log((ExecutionMessage)new ExecutionMessageI18n(severity, msgKey, param));
    }

    private void addMessage(int severity, String msgKey, Object[] param) {
        this.messageListener.log((ExecutionMessage)new ExecutionMessageI18n(severity, msgKey, param));
    }

    private void addStdMessage(int severity, String msg) {
        this.messageListener.log((ExecutionMessage)new ExecutionMessageStd(severity, msg));
    }

    private void init() throws DashboardException {
        ConversionHelper conversionHelper = ConversionHelper.getXMLConverter();
        TableExecutionDataSource ds = null;
        block2 : switch (this.insertType) {
            case 1: {
                switch (this.batchType) {
                    case 2: 
                    case 3: {
                        TableExecutionBatchInsert batchInsert;
                        try {
                            TableExecutionBatchUpdate batchUpdate = new TableExecutionBatchUpdate(this.sqlTableHelper, this.updateSqlTable, this.sqlTableHelper.getPrimaryKey(this.updateSqlTable), conversionHelper);
                            batchUpdate.setNbBatchRows(this.batchNbLine);
                            batchInsert = new TableExecutionBatchInsert(this.sqlTableHelper, this.updateSqlTable, conversionHelper);
                            batchInsert.setNbBatchRows(this.batchNbLine);
                            ds = new TableExecutionUpdateInsert(batchUpdate, batchInsert);
                        }
                        catch (Exception e) {
                            batchInsert = new TableExecutionBatchInsert(this.sqlTableHelper, this.updateSqlTable, conversionHelper);
                            batchInsert.setNbBatchRows(this.batchNbLine);
                            ds = batchInsert;
                        }
                        break block2;
                    }
                }
                try {
                    TableExecutionDirectUpdate directUpdate = new TableExecutionDirectUpdate(this.sqlTableHelper, this.updateSqlTable, this.sqlTableHelper.getPrimaryKey(this.updateSqlTable), conversionHelper);
                    TableExecutionDirectInsert directInsert = new TableExecutionDirectInsert(this.sqlTableHelper, this.updateSqlTable, conversionHelper);
                    ds = new TableExecutionUpdateInsert(directUpdate, directInsert);
                }
                catch (Exception e) {
                    ds = new TableExecutionDirectInsert(this.sqlTableHelper, this.updateSqlTable, conversionHelper);
                }
                break;
            }
            default: {
                switch (this.batchType) {
                    case 2: 
                    case 3: {
                        TableExecutionBatchInsert batchInsert = new TableExecutionBatchInsert(this.sqlTableHelper, this.updateSqlTable, conversionHelper);
                        batchInsert.setNbBatchRows(this.batchNbLine);
                        ds = batchInsert;
                        break block2;
                    }
                }
                ds = new TableExecutionDirectInsert(this.sqlTableHelper, this.updateSqlTable, conversionHelper);
                break;
            }
            case 4: {
                switch (this.batchType) {
                    case 2: 
                    case 3: {
                        TableExecutionBatchReplace batchReplace = new TableExecutionBatchReplace(this.sqlTableHelper, this.updateSqlTable, conversionHelper);
                        batchReplace.setNbBatchRows(this.batchNbLine);
                        ds = batchReplace;
                        break block2;
                    }
                    case 1: {
                        ds = new TableExecutionDirectReplace(this.sqlTableHelper, this.updateSqlTable, conversionHelper);
                    }
                }
            }
        }
        switch (this.commitType) {
            default: {
                TableExecutionAutoCommit autoCommit = new TableExecutionAutoCommit();
                autoCommit.setTableExecution(ds);
                this.tableExecution = autoCommit;
                break;
            }
            case 2: 
            case 3: {
                TableExecutionCommit commit = new TableExecutionCommit();
                commit.setNbCommitRows(this.commitNbLine);
                commit.setTableExecution(ds);
                this.tableExecution = commit;
            }
        }
    }

    private String getValue(Attributes attrs, String uri, String name) {
        String value = attrs.getValue(name);
        if (value != null) {
            return value;
        }
        return attrs.getValue(uri, name);
    }

    private boolean isElement(String namespaceURI, String sName, String qName, String elt) {
        return sName.equals(elt) || qName.equals(elt);
    }

    public List<FieldMetaData> getFieldList() {
        return this.sqlTable.getFieldList();
    }

    public static class Builder {
        private final SQLTableHelper sqlTableHelper;
        private final MessageListener messageListener;
        private String catalog;
        private String schema;
        private String defaultTable;
        private boolean emptyTable = false;
        private boolean createTable = true;
        private boolean createPrimaryKey = true;
        private int insertType = 5;
        private int deleteType = 1;
        private int batchType = 1;
        private int batchNbLines = -1;
        private int commitType = 1;
        private int commitNbLine = -1;
        private boolean mbcs = false;

        public Builder(SQLTableHelper sqlTableHelper, MessageListener messageListener) {
            this.sqlTableHelper = sqlTableHelper;
            this.messageListener = messageListener;
        }

        public Builder defaultTable(String catalog, String schema, String defaultTable) {
            this.catalog = catalog;
            this.schema = schema;
            this.defaultTable = defaultTable;
            return this;
        }

        public Builder create(boolean createTable, boolean createPrimaryKey) {
            this.createTable = createTable;
            this.createPrimaryKey = createPrimaryKey;
            return this;
        }

        public Builder empty(boolean emptyTable) {
            this.emptyTable = emptyTable;
            return this;
        }

        public Builder type(int insertType, int deleteType, int batchType, int batchNbLines, int commitType, int commitNbLine) {
            this.insertType = insertType;
            this.deleteType = deleteType;
            this.batchType = batchType;
            this.batchNbLines = batchType == 2 ? -1 : batchNbLines;
            this.commitType = commitNbLine;
            this.commitNbLine = commitType == 2 ? -1 : commitNbLine;
            return this;
        }

        public Builder mbcs(boolean mbcs) {
            this.mbcs = mbcs;
            return this;
        }

        public TableHandler build() {
            return new TableHandler(this.sqlTableHelper, this.messageListener, this.defaultTable, this.emptyTable, this.createTable, this.insertType, this.deleteType, this.catalog, this.schema, this.createPrimaryKey, this.batchType, this.batchNbLines, this.commitType, this.commitNbLine, this.mbcs);
        }
    }
}

