/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.task;

import com.axway.defence.util.StringUtil;
import com.prelytis.dashboard.dao.ControlResultDao;
import com.prelytis.dashboard.dao.ControlUserDao;
import com.prelytis.dashboard.dao.DaoFactory;
import com.prelytis.dashboard.dao.LengthUnitDao;
import com.prelytis.dashboard.dao.PageLayoutDao;
import com.prelytis.dashboard.dao.ThemeDao;
import com.prelytis.dashboard.dao.UserDao;
import com.prelytis.dashboard.dao.WorkspaceDao;
import com.prelytis.dashboard.dao.filter.DbDefaultFilter;
import com.prelytis.dashboard.dao.filter.DbUserFilter;
import com.prelytis.dashboard.data.engine.ExecutionContext;
import com.prelytis.dashboard.data.helper.EngineHelper;
import com.prelytis.dashboard.data.transformation.ControlDataHandler;
import com.prelytis.dashboard.data.transformation.DataTransformer;
import com.prelytis.dashboard.data.transformation.ResultsetDataReader;
import com.prelytis.dashboard.db.operation.OperationFinal;
import com.prelytis.dashboard.db.sql.Result;
import com.prelytis.dashboard.document.factory.PDFiTextFactoryTable;
import com.prelytis.dashboard.document.factory.PageLayout;
import com.prelytis.dashboard.document.factory.XLSFactoryTable;
import com.prelytis.dashboard.helper.ExpressionEvaluationDataHelper;
import com.prelytis.dashboard.helper.MessageListener;
import com.prelytis.dashboard.helper.ReportDocumentHelper;
import com.prelytis.dashboard.interfaces.DashboardException;
import com.prelytis.dashboard.interfaces.DashboardRuntimeException;
import com.prelytis.dashboard.interfaces.IQueryDefinition;
import com.prelytis.dashboard.message.AbstractSendMessage;
import com.prelytis.dashboard.message.Message;
import com.prelytis.dashboard.message.MessageAttachment;
import com.prelytis.dashboard.message.MessageBody;
import com.prelytis.dashboard.message.MessageSubject;
import com.prelytis.dashboard.message.SendMessageListHelper;
import com.prelytis.dashboard.model.helper.ControlHelper;
import com.prelytis.dashboard.model.helper.QueryHelper;
import com.prelytis.dashboard.model.helper.ReportHelper;
import com.prelytis.dashboard.model.helper.StyleHelper;
import com.prelytis.dashboard.persistence.helper.ListHelper;
import com.prelytis.dashboard.security.util.SettingsHelper;
import com.prelytis.dashboard.task.AIPreparedQuery;
import com.prelytis.dashboard.task.AbstractTaskExecution;
import com.prelytis.dashboard.task.TaskExceptionHandler;
import com.prelytis.dashboard.task.TaskExecutionException;
import com.prelytis.dashboard.task.TaskExecutionListener;
import com.prelytis.dashboard.util.ExpressionEvaluationHelper;
import com.prelytis.dashboard.value.data.AbstractBeanReport;
import com.prelytis.dashboard.value.data.AbstractBeanReportAvlField;
import com.prelytis.dashboard.value.data.AbstractBeanReportFilter;
import com.prelytis.dashboard.value.data.BeanLengthUnit;
import com.prelytis.dashboard.value.data.BeanPRPInfo;
import com.prelytis.dashboard.value.data.BeanPageLayout;
import com.prelytis.dashboard.value.data.BeanPersFieldValue;
import com.prelytis.dashboard.value.data.BeanReportCrossTable;
import com.prelytis.dashboard.value.data.BeanReportDataUsedField;
import com.prelytis.dashboard.value.data.BeanReportStd;
import com.prelytis.dashboard.value.data.BeanReportStdUsedField;
import com.prelytis.dashboard.value.data.BeanStyleDefinition;
import com.prelytis.dashboard.value.data.BeanTaskControl;
import com.prelytis.dashboard.value.data.BeanTaskControlResult;
import com.prelytis.dashboard.value.data.BeanTaskControlUser;
import com.prelytis.dashboard.value.data.BeanThemeDefinition;
import com.prelytis.dashboard.value.data.BeanUser;
import com.prelytis.dashboard.value.data.BeanUserDefinition;
import com.prelytis.dashboard.value.data.BeanUserMessageType;
import com.prelytis.dashboard.value.data.BeanWorkspaceControlLevel;
import com.prelytis.dashboard.value.data.ReportFilter;
import com.prelytis.dashboard.value.structure.AbstractDocument;
import com.prelytis.dashboard.value.structure.ImageDocument;
import com.prelytis.dashboard.value.structure.ReportDocument;
import com.prelytis.dashboard.value.structure.Task;
import com.prelytis.dashboard.value.util.Expression;
import com.prelytis.dashboard.value.util.ExpressionEvaluationData;
import com.prelytis.dashboard.value.util.Threshold;
import com.prelytis.dashboard.value.util.ThresholdInterval;
import com.prelytis.dashboard.value.util.ThresholdUsage;
import com.prelytis.dashboard.value.util.Thresholds;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.mail.internet.MimeUtility;

public class TaskControlExecution
extends AbstractTaskExecution {
    public TaskControlExecution(MessageListener messageListener, TaskExecutionListener listener) {
        super(messageListener, listener);
    }

    @Override
    public int execute(DaoFactory daoFactory, Task task) throws TaskExecutionException {
        log.debug((Object)"Entering TaskControlExecution.execute");
        try {
            BeanPRPInfo info = daoFactory.getPrelytisInfoDao().getPrelytisInfo();
            ControlHelper taskHelper = ControlHelper.getInstance(daoFactory);
            BeanTaskControl control = taskHelper.getDefinition(task.getName());
            ReportHelper reportDao = ReportHelper.getInstance(daoFactory);
            AbstractBeanReport report = reportDao.getDefinition(control.getCalculationReportName());
            if (report instanceof BeanReportStd) {
                return this.execute(daoFactory, control, (BeanReportStd)report, info);
            }
            return this.execute(daoFactory, control, (BeanReportCrossTable)report, info);
        }
        catch (Exception e) {
            log.error((Object)e);
            throw new TaskExecutionException(e, true);
        }
    }

    private int execute(DaoFactory daoFactory, BeanTaskControl task, BeanReportCrossTable report, BeanPRPInfo info) throws TaskExecutionException {
        String fieldName = task.getFieldName();
        int fieldNum = -1;
        AbstractBeanReportAvlField ctrlField = null;
        int status = 0;
        List fieldList = report.getDataFieldList();
        for (int i = 0; i < fieldList.size(); ++i) {
            BeanReportDataUsedField usedField = (BeanReportDataUsedField)fieldList.get(i);
            if (!fieldName.equals(usedField.getName())) continue;
            fieldNum = report.getSectionList().size() + i;
            ctrlField = usedField.getField();
            break;
        }
        if (fieldNum < 0) {
            this.addMessage(3, "taskMsg.fieldNotFound", fieldName);
            return -2;
        }
        Map<AIPreparedQuery, Map<Thresholds, List<UserInfo>>> queryMap = this.getQueryMap(daoFactory, task, (AbstractBeanReport)report);
        for (Map.Entry<AIPreparedQuery, Map<Thresholds, List<UserInfo>>> entry : queryMap.entrySet()) {
            try {
                AIPreparedQuery aiPreparedQuery = entry.getKey();
                Map<Thresholds, List<UserInfo>> thresholdMap = entry.getValue();
                int localStatus = this.execute(daoFactory, task, aiPreparedQuery, thresholdMap, fieldNum, (AbstractBeanReport)report, ctrlField, info);
                status = Math.min(status, localStatus);
            }
            catch (Exception e) {
                status = -2;
                this.addMessage(3, "taskMsg.errExecuTask", null);
                log.error((Object)e);
            }
        }
        return status;
    }

    private int execute(DaoFactory daoFactory, BeanTaskControl task, BeanReportStd report, BeanPRPInfo info) {
        String fieldName = task.getFieldName();
        int fieldNum = -1;
        AbstractBeanReportAvlField ctrlField = null;
        int status = 0;
        List fieldList = report.getFieldList();
        for (int i = 0; i < fieldList.size(); ++i) {
            BeanReportStdUsedField usedField = (BeanReportStdUsedField)fieldList.get(i);
            if (!fieldName.equals(usedField.getName())) continue;
            fieldNum = report.getSectionList().size() + i;
            ctrlField = usedField.getField();
            break;
        }
        if (fieldNum < 0) {
            this.addMessage(3, "taskMsg.fieldNotFound", fieldName);
            status = -2;
        }
        try {
            Map<AIPreparedQuery, Map<Thresholds, List<UserInfo>>> queryMap = this.getQueryMap(daoFactory, task, (AbstractBeanReport)report);
            for (Map.Entry<AIPreparedQuery, Map<Thresholds, List<UserInfo>>> entry : queryMap.entrySet()) {
                try {
                    AIPreparedQuery aiPreparedQuery = entry.getKey();
                    Map<Thresholds, List<UserInfo>> thresholdMap = entry.getValue();
                    status = Math.min(status, this.execute(daoFactory, task, aiPreparedQuery, thresholdMap, fieldNum, (AbstractBeanReport)report, ctrlField, info));
                }
                catch (Exception e) {
                    status = -2;
                    this.addMessage(3, "taskMsg.errExecuTask", null);
                    log.error((Object)e);
                }
            }
        }
        catch (Exception e) {
            status = -2;
            this.addMessage(3, "taskMsg.errExecuTask", null);
            log.error((Object)e);
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int execute(DaoFactory daoFactory, BeanTaskControl task, AIPreparedQuery aiPreparedQuery, Map<Thresholds, List<UserInfo>> thresholdMap, int col, AbstractBeanReport report, AbstractBeanReportAvlField ctrlField, BeanPRPInfo info) throws TaskExecutionException {
        int[] severities = null;
        int status = -3;
        Thresholds[] thresholds = new Thresholds[thresholdMap.size()];
        int cpt = 0;
        for (Thresholds t : thresholdMap.keySet()) {
            thresholds[cpt++] = t;
        }
        try {
            EngineHelper eh = EngineHelper.getInstance(daoFactory);
            try (Result result = eh.getResult(aiPreparedQuery.getOperation());){
                ResultsetDataReader dataReader = new ResultsetDataReader(result);
                ControlDataHandler handler = new ControlDataHandler();
                handler.setCol(col);
                handler.setThresholds(thresholds);
                DataTransformer transformer = new DataTransformer();
                transformer.transform(dataReader, handler);
                severities = handler.getSeverities();
                status = 0;
            }
        }
        catch (Exception e) {
            try {
                status = e instanceof TaskExecutionException ? ((TaskExecutionException)e).getStatus() : -2;
                throw this.getException(e);
            }
            catch (Throwable throwable) {
                status = Math.min(status, this.saveStatus(daoFactory, task, thresholdMap, thresholds, status, severities, report, ctrlField, info));
                throw throwable;
            }
        }
        status = Math.min(status, this.saveStatus(daoFactory, task, thresholdMap, thresholds, status, severities, report, ctrlField, info));
        return status;
    }

    private int saveStatus(DaoFactory daoFactory, BeanTaskControl task, Map<Thresholds, List<UserInfo>> thresholdMap, Thresholds[] thresholds, int calcStatus, int[] severities, AbstractBeanReport report, AbstractBeanReportAvlField ctrlField, BeanPRPInfo info) {
        int localStatus = 0;
        if (severities == null) {
            severities = new int[thresholds.length];
        }
        for (int i = 0; i < thresholds.length; ++i) {
            List<UserInfo> userList = thresholdMap.get(thresholds[i]);
            try {
                localStatus = Math.min(localStatus, this.saveStatus(daoFactory, task, userList, thresholds[i], calcStatus, severities[i], report, ctrlField, info));
                continue;
            }
            catch (Exception e) {
                log.info((Object)e);
            }
        }
        return localStatus;
    }

    private int saveStatus(DaoFactory daoFactory, BeanTaskControl task, List<UserInfo> userList, Thresholds thresholds, int calcStatus, int severity, AbstractBeanReport report, AbstractBeanReportAvlField ctrlField, BeanPRPInfo info) throws DashboardException {
        int localStatus = 0;
        ThresholdUsage thresholdUsage = new ThresholdUsage();
        thresholdUsage.setRemoveInfo(task.getRemoveInfoLines());
        thresholdUsage.setFieldName(task.getQueryFieldName());
        thresholdUsage.setAgregation(task.getAgregation());
        thresholdUsage.setThresholds(thresholds);
        MessageSender ms = new MessageSender(daoFactory, thresholdUsage, report, ctrlField);
        ControlResultDao mgr = daoFactory.getControlResultDao();
        for (UserInfo userInfo : userList) {
            ExpressionEvaluationData data = userInfo.getData();
            BeanTaskControlResult result = mgr.open(task, data.getUserOid().intValue(), data.getExecutionContextOid().intValue());
            result.setPreviousCalcValue(result.getCalcValue());
            result.setCalcThresholdTypeOID(task.getThresholdTypeOID());
            result.setCalcThresholdTypeName(task.getThresholdTypeName());
            result.setCalcThresholds(thresholds);
            result.setCalcValue(severity);
            result.setCalcStatus(calcStatus);
            result.setCalcDate(new Date());
            try {
                mgr.save(result);
            }
            catch (Exception e) {
                log.warn((Object)e);
                this.addMessage(1, e.getMessage());
                localStatus = Math.min(localStatus, -1);
            }
            try {
                boolean[][] msgPolicy = task.getMessagePolicy();
                if (!userInfo.getSendMessage() || result.getPreviousCalcValue() != -1 && !msgPolicy[result.getPreviousCalcValue()][result.getCalcValue()]) continue;
                localStatus = Math.min(localStatus, ms.send(result, userInfo, info));
            }
            catch (Exception ex) {
                log.warn((Object)ex);
                this.addMessage(1, ex.getMessage());
                localStatus = Math.min(localStatus, -1);
            }
        }
        return localStatus;
    }

    private Map<AIPreparedQuery, Map<Thresholds, List<UserInfo>>> getQueryMap(DaoFactory daoFactory, BeanTaskControl task, AbstractBeanReport report) throws TaskExecutionException {
        try {
            WorkspaceDao mgrWorkspace = daoFactory.getWorkspaceDao();
            List controlLevelList = mgrWorkspace.listControlLevelForTask(task.getObjectID());
            Map additionalUserMap = ListHelper.getInstance().getMapById(task.getMessageUserList());
            if (controlLevelList.isEmpty() && additionalUserMap.isEmpty()) {
                this.addMessage(2, "taskMsg.nobodyConcerned", null);
                throw new TaskExecutionException("No body is concerned by this task", 1);
            }
            boolean sendMessageToWorkspace = task.getSendMessage() == 2 || task.getSendMessage() == 3;
            boolean sendMessageToUser = task.getSendMessage() == 1 || task.getSendMessage() == 3;
            Helper helper = new Helper(daoFactory, task);
            ExpressionEvaluationDataHelper dh = ExpressionEvaluationDataHelper.getInstance(daoFactory);
            UserDao userDao = daoFactory.getUserDao();
            boolean isPassportFGAC = SettingsHelper.getInstance().usesPassportAuthorization();
            for (int i = 0; i < controlLevelList.size(); ++i) {
                BeanWorkspaceControlLevel controlLevel = (BeanWorkspaceControlLevel)controlLevelList.get(i);
                DbUserFilter userFilter = new DbUserFilter();
                userFilter.setWorkspaceOid(Integer.valueOf(controlLevel.getObjectID()));
                userFilter.setActive(Boolean.TRUE);
                List userList = userDao.listAll((DbDefaultFilter)userFilter, 2);
                for (int j = 0; j < userList.size(); ++j) {
                    BeanUserDefinition user = (BeanUserDefinition)userList.get(j);
                    Object tmp = additionalUserMap.remove(user.getObjectID());
                    boolean userMsgAccess = user.getMsgAccess();
                    if (isPassportFGAC) {
                        log.debug((Object)"PassPort FGAC is used, setting user messaging access to true.");
                        userMsgAccess = true;
                    }
                    boolean sendMessage = (tmp != null && sendMessageToUser || sendMessageToWorkspace) && userMsgAccess;
                    ExpressionEvaluationData data = dh.getExpressionEvaluationData((BeanUser)user);
                    helper.addUser(data, user.getBeanUserMessageTypeList(), controlLevel.getAccessLevel() == 2, sendMessage);
                }
            }
            if (!additionalUserMap.isEmpty()) {
                DbUserFilter userFilter = new DbUserFilter();
                Integer[] tmp = new Integer[additionalUserMap.keySet().size()];
                userFilter.setObjectId(additionalUserMap.keySet().toArray(tmp));
                List userList = userDao.listAll((DbDefaultFilter)userFilter, 2);
                for (int j = 0; j < userList.size(); ++j) {
                    BeanUserDefinition user = (BeanUserDefinition)userList.get(j);
                    ExpressionEvaluationData data = dh.getExpressionEvaluationData((BeanUser)user);
                    boolean userMsgAccess = user.getMsgAccess();
                    if (isPassportFGAC) {
                        log.debug((Object)"PassPort FGAC is used, setting user messaging access to true.");
                        userMsgAccess = true;
                    }
                    helper.addUser(data, user.getBeanUserMessageTypeList(), false, sendMessageToUser && userMsgAccess);
                }
            }
            return helper.getMap();
        }
        catch (Exception e) {
            throw this.getException(e);
        }
    }

    private List<ReportFilter> getReportFilterList(DaoFactory daoFactory, AbstractBeanReport report, IQueryDefinition query, ExpressionEvaluationData data) throws DashboardException {
        ReportHelper reportHelper = ReportHelper.getInstance(daoFactory);
        List<ReportFilter> list = reportHelper.getFilterList(report, query, data);
        return this.cleanValueList(ExpressionEvaluationHelper.getInstance(), list, new ArrayList<ReportFilter>(), data);
    }

    private List<ReportFilter> cleanValueList(ExpressionEvaluationHelper helper, List<ReportFilter> filterList, List<ReportFilter> valueFilterList, ExpressionEvaluationData data) throws DashboardException {
        HashMap<String, ReportFilter> filterMap = new HashMap<String, ReportFilter>();
        for (ReportFilter filter : filterList) {
            filterMap.put(filter.getName(), filter);
        }
        return this.cleanValueList(helper, filterList, filterMap, data);
    }

    private List<ReportFilter> cleanValueList(ExpressionEvaluationHelper helper, List<ReportFilter> filterList, Map<String, ReportFilter> valueFilterMap, ExpressionEvaluationData data) throws DashboardException {
        if (filterList == null) {
            return null;
        }
        ArrayList<ReportFilter> dstFilterList = new ArrayList<ReportFilter>();
        for (int i = 0; i < filterList.size(); ++i) {
            ReportFilter filterValue;
            ReportFilter filter = filterList.get(i);
            if (!filter.isVisible()) continue;
            Object[] values = filter.getValues();
            if (values != null) {
                for (int j = 0; j < values.length; ++j) {
                    if (!(values[j] instanceof Expression)) continue;
                    values[j] = helper.evaluateExpression((Expression)values[j], data);
                }
            }
            if ((filterValue = valueFilterMap.get(filter.getName())) != null) {
                filter.setUseFilter(filterValue.getUseFilter());
                if (filterValue.getUseFilter()) {
                    filter.setValues(filterValue.getValues());
                }
            }
            dstFilterList.add(filter);
        }
        return dstFilterList;
    }

    private class MessageSender {
        private final DaoFactory daoFactory;
        private final AbstractBeanReport report;
        private final AbstractBeanReportAvlField field;
        private final BeanStyleDefinition style;
        private final ThresholdUsage thresholdUsage;

        public MessageSender() {
            this.thresholdUsage = null;
            this.report = null;
            this.field = null;
            this.daoFactory = null;
            this.style = null;
        }

        public MessageSender(DaoFactory daoFactory, ThresholdUsage thresholdUsage, AbstractBeanReport report, AbstractBeanReportAvlField field) throws DashboardException {
            this.thresholdUsage = thresholdUsage;
            this.report = report;
            this.field = field;
            this.daoFactory = daoFactory;
            StyleHelper styleHelper = StyleHelper.getInstance(daoFactory);
            this.style = styleHelper.getDefinition(report.getStyleName());
        }

        public int send(BeanTaskControlResult controlResult, UserInfo userInfo, BeanPRPInfo info) throws DashboardException {
            ExpressionEvaluationData data = userInfo.getData();
            if (userInfo.getSendMessage()) {
                List<ReportFilter> reportFilterList;
                QueryHelper queryHelper = QueryHelper.getInstance(this.daoFactory);
                IQueryDefinition query = queryHelper.getFinal(this.report.getQueryOID());
                if (query.getQueryType() == 2) {
                    reportFilterList = TaskControlExecution.this.getReportFilterList(this.daoFactory, this.report, query, data);
                } else {
                    reportFilterList = new ArrayList();
                    List beanReportFilterList = this.report.getFilterList();
                    for (AbstractBeanReportFilter flt : beanReportFilterList) {
                        ReportFilter filter = new ReportFilter();
                        filter.setDatatype(flt.getDataType());
                        filter.setDescription((String)flt.getDescriptionMap().get(data.getLocale()));
                        filter.setName(flt.getName());
                        reportFilterList.add(filter);
                    }
                }
                ReportDocumentHelper.Builder rdhb = new ReportDocumentHelper.Builder(this.daoFactory, new TaskExceptionHandler(), this.report, data, false);
                rdhb.thresholdUsage(this.thresholdUsage);
                rdhb.filterList(reportFilterList);
                ReportDocumentHelper reportDocumentHelper = rdhb.build();
                ReportDocument reportDocument = reportDocumentHelper.getReportDocument();
                int sendStatus = -3;
                if (controlResult.getMessageAttachmentType() != null) {
                    switch (controlResult.getMessageAttachmentType()) {
                        case PDF: {
                            PDFiTextFactoryTable pdfFactory = new PDFiTextFactoryTable(this.daoFactory, (AbstractDocument)reportDocument, data.getLocale(), this.getPageLayout(data), data.getPersFieldList());
                            pdfFactory.setReportFilterList(reportFilterList);
                            pdfFactory.setDisplayReportTop(info.isDisplayReportFilterTop());
                            sendStatus = this.sendMessage(userInfo, controlResult, pdfFactory.getImageDocument());
                            break;
                        }
                        case XLS: {
                            ThemeDao themeDao = this.daoFactory.getThemeDao();
                            BeanThemeDefinition theme = (BeanThemeDefinition)themeDao.getDefinition(data.getThemeOid().intValue());
                            XLSFactoryTable xlsFactory = new XLSFactoryTable((AbstractDocument)reportDocument, data.getLocale(), this.style, theme, data.getPersFieldList());
                            sendStatus = this.sendMessage(userInfo, controlResult, xlsFactory.getImageDocument());
                        }
                    }
                } else {
                    sendStatus = this.sendMessage(userInfo, controlResult, null);
                }
                return sendStatus;
            }
            return 1;
        }

        private PageLayout getPageLayout(ExpressionEvaluationData data) throws DashboardException {
            PageLayoutDao pageLayoutDao = this.daoFactory.getPageLayoutDao();
            BeanPageLayout pl = (BeanPageLayout)pageLayoutDao.getCore(this.report.getPageLayoutOID());
            LengthUnitDao lengthUnitDao = this.daoFactory.getLengthUnitDao();
            BeanLengthUnit lengthUnit = (BeanLengthUnit)lengthUnitDao.getCore(pl.getLengthUnitOID());
            ThemeDao themeDao = this.daoFactory.getThemeDao();
            BeanThemeDefinition theme = (BeanThemeDefinition)themeDao.getDefinition(data.getThemeOid().intValue());
            PageLayout pageLayout = new PageLayout(pl, lengthUnit, theme);
            return pageLayout;
        }

        private int sendMessage(UserInfo userInfo, BeanTaskControlResult controlResult, ImageDocument attachment) throws DashboardException {
            try {
                ExpressionEvaluationData data = userInfo.getData();
                if (!userInfo.getSendMessage()) {
                    TaskControlExecution.this.addMessage(2, "taskMsg.noMsgAccess", data.getUserName());
                    return -1;
                }
                List<AbstractSendMessage> sendMessageList = SendMessageListHelper.getInstance(data, userInfo.getMessageTypeList(), controlResult.getName());
                if (sendMessageList.isEmpty()) {
                    return 0;
                }
                int localStatus = 0;
                String messageSubject = this.getMessage(controlResult, controlResult.getMessageSubjectMap(), data);
                String messageBody = this.getMessage(controlResult, controlResult.getMessageBodyMap(), data);
                for (int i = 0; i < sendMessageList.size(); ++i) {
                    AbstractSendMessage sendMessage = sendMessageList.get(i);
                    String baseURL = sendMessage.getBaseURL();
                    StringBuffer url = baseURL != null ? new StringBuffer(baseURL) : new StringBuffer("");
                    Message message = new Message();
                    MessageSubject subject = new MessageSubject();
                    subject.setText(this.replace(messageSubject, "{url}", url.toString()));
                    message.setSubject(subject);
                    MessageBody body = new MessageBody();
                    body.setText(this.replace(messageBody, "{url}", url.toString()));
                    message.setBody(body);
                    if (attachment != null) {
                        MessageAttachment msg = new MessageAttachment();
                        msg.setName(MimeUtility.encodeText((String)attachment.getFileName(), (String)"UTF-8", null));
                        msg.setContentType(attachment.getContentType());
                        msg.setData(attachment.getData());
                        message.add(msg);
                    }
                    try {
                        if (!sendMessage.sendMessage(message)) continue;
                        TaskControlExecution.this.addMessage(1, "taskMsg.messageSendOk", data.getUserName());
                        continue;
                    }
                    catch (Exception e) {
                        TaskControlExecution.this.addMessage(2, "taskMsg.mailnotSend", data.getUserName());
                        localStatus = Math.min(localStatus, -1);
                        AbstractTaskExecution.log.error((Object)e);
                    }
                }
                return localStatus;
            }
            catch (Exception ex) {
                if (ex instanceof DashboardException) {
                    throw (DashboardException)((Object)ex);
                }
                throw new DashboardException((Throwable)ex);
            }
        }

        private String getMessage(BeanTaskControlResult controlResult, Map<Locale, String> descMap, ExpressionEvaluationData data) {
            Locale locale = data.getLocale();
            ResourceBundle bundle = ResourceBundle.getBundle("com.prelytis.dashboard.resources.Messages", locale);
            String message = descMap.get(locale);
            message = this.replace(message, "{TaskDescription}", descMap.get(locale));
            message = this.replace(message, "{InitialState}", this.getSeverity(controlResult.getPreviousCalcValue(), bundle));
            message = this.replace(message, "{FinalState}", this.getSeverity(controlResult.getPreviousCalcValue(), bundle));
            message = this.replace(message, "{ReportDescription}", (String)this.report.getDescriptionMap().get(locale));
            message = this.replace(message, "{ReportField}", (String)this.field.getDescriptionMap().get(locale));
            message = this.replace(message, "{t:TaskDescription}", descMap.get(locale));
            message = this.replace(message, "{t:InitialState}", this.getSeverity(controlResult.getPreviousCalcValue(), bundle));
            message = this.replace(message, "{t:FinalState}", this.getSeverity(controlResult.getPreviousCalcValue(), bundle));
            message = this.replace(message, "{t:ReportDescription}", (String)this.report.getDescriptionMap().get(locale));
            message = this.replace(message, "{t:ReportField}", (String)this.field.getDescriptionMap().get(locale));
            String format = "{0}";
            MessageFormat mf = new MessageFormat(format, locale);
            Thresholds thresholds = controlResult.getCalcThresholds();
            ThresholdInterval interval = thresholds.getFirstInterval();
            int cpt = 0;
            while (interval != null && interval.getAfter() != null) {
                Threshold threshold = interval.getAfter();
                message = this.replace(message, "{Threshold" + ++cpt + "}", mf.format(new Object[]{threshold.getValue()}));
                message = this.replace(message, "{t:Threshold" + cpt + "}", mf.format(new Object[]{threshold.getValue()}));
                interval = threshold.getAfter();
            }
            message = this.replacePersonalizedFields(message, data);
            return message;
        }

        private String replacePersonalizedFields(String message, ExpressionEvaluationData data) {
            List persFieldValues = data.getPersFieldList();
            for (BeanPersFieldValue persField : persFieldValues) {
                String valueToReplace;
                String formatPersField;
                block8: {
                    formatPersField = "{p:" + persField.getName() + "}";
                    ExpressionEvaluationHelper helper = ExpressionEvaluationHelper.getInstance();
                    Object defValue = persField.getDefValues();
                    Object value = persField.getValues();
                    Object result = null;
                    valueToReplace = "";
                    if (value instanceof Expression) {
                        if (value == null) {
                            valueToReplace = this.replacePersFieldWithDefault(defValue, data);
                        } else {
                            try {
                                result = helper.evaluateExpression((Expression)value, data);
                                if (result != null) {
                                    valueToReplace = result.toString();
                                    break block8;
                                }
                                valueToReplace = "null";
                            }
                            catch (DashboardException e) {
                                AbstractTaskExecution.log.error((Object)e);
                            }
                        }
                    } else {
                        String valueString = value.toString().trim();
                        valueToReplace = StringUtil.isEmptyOrNull((String)valueString) ? this.replacePersFieldWithDefault(defValue, data) : value.toString();
                    }
                }
                message = this.replace(message, formatPersField, valueToReplace);
            }
            return message;
        }

        private String replacePersFieldWithDefault(Object defValue, ExpressionEvaluationData data) {
            String valueToReplace;
            block7: {
                ExpressionEvaluationHelper helper = ExpressionEvaluationHelper.getInstance();
                Object result = null;
                valueToReplace = "";
                if (defValue instanceof Expression) {
                    if (defValue == null) {
                        valueToReplace = "";
                    } else {
                        try {
                            result = helper.evaluateExpression((Expression)defValue, data);
                            if (result != null) {
                                valueToReplace = result.toString();
                                break block7;
                            }
                            valueToReplace = "null";
                        }
                        catch (DashboardException e) {
                            AbstractTaskExecution.log.error((Object)e);
                        }
                    }
                } else {
                    String defValueString = defValue.toString().trim();
                    valueToReplace = StringUtil.isEmptyOrNull((String)defValueString) ? "" : defValue.toString();
                }
            }
            return valueToReplace;
        }

        private String getSeverity(int severity, ResourceBundle bundle) {
            switch (severity) {
                default: {
                    return bundle.getString("threshold.unknown");
                }
                case 0: {
                    return bundle.getString("threshold.info");
                }
                case 1: {
                    return bundle.getString("threshold.warning");
                }
                case 2: 
            }
            return bundle.getString("threshold.error");
        }

        private String replace(String source, String replace, String by) {
            int index;
            if (by == null) {
                by = "";
            }
            String src = source;
            do {
                if ((index = src.toLowerCase().indexOf(replace.toLowerCase())) < 0) continue;
                src = src.substring(0, index) + by + src.substring(index + replace.length());
            } while (index >= 0);
            return src;
        }
    }

    private static class UserInfo {
        private List<BeanUserMessageType> messageTypeList;
        private ExpressionEvaluationData data;
        private boolean sendMessage = false;

        private UserInfo() {
        }

        public ExpressionEvaluationData getData() {
            return this.data;
        }

        public void setData(ExpressionEvaluationData data) {
            this.data = data;
        }

        public boolean getSendMessage() {
            return this.sendMessage;
        }

        public void setSendMessage(boolean sendMessage) {
            this.sendMessage = sendMessage;
        }

        public List<BeanUserMessageType> getMessageTypeList() {
            return this.messageTypeList;
        }

        public void setMessageTypeList(List<BeanUserMessageType> messageTypeList) {
            this.messageTypeList = messageTypeList;
        }
    }

    private static class Helper {
        private BeanTaskControl task;
        private Map<AIPreparedQuery, Map<Thresholds, List<UserInfo>>> map;
        private ControlUserDao mgrTask;
        private AbstractBeanReport report;
        private DaoFactory daoFactory;

        private Helper(DaoFactory daoFactory, BeanTaskControl task) throws DashboardRuntimeException, DashboardException {
            this.daoFactory = daoFactory;
            this.task = task;
            this.map = new HashMap<AIPreparedQuery, Map<Thresholds, List<UserInfo>>>();
            this.mgrTask = daoFactory.getControlUserDao();
            ReportHelper reportDao = ReportHelper.getInstance(daoFactory);
            this.report = reportDao.getDefinition(task.getCalculationReportName());
        }

        public Map<AIPreparedQuery, Map<Thresholds, List<UserInfo>>> getMap() {
            return this.map;
        }

        private void addUser(ExpressionEvaluationData data, List<BeanUserMessageType> messageTypeList, boolean checkCustomization, boolean sendMessage) throws DashboardException {
            List<UserInfo> userList;
            BeanTaskControlUser taskUser = null;
            Thresholds thresholds = this.task.getThresholds();
            if (checkCustomization) {
                try {
                    taskUser = this.mgrTask.open(this.task, data.getUserOid().intValue(), data.getExecutionContextOid().intValue());
                    thresholds = taskUser.getThresholds();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            for (int i = 0; i < thresholds.size(); ++i) {
                Threshold th = thresholds.getThreshold(i);
                if (!(th.getValue() instanceof Expression)) continue;
                Object value = ExpressionEvaluationHelper.getInstance().evaluateExpression((Expression)th.getValue(), data);
                if (value instanceof String) {
                    value = new Double((String)value);
                }
                th.setValue(value);
            }
            EngineHelper eh = EngineHelper.getInstance(this.daoFactory);
            ExecutionContext context = eh.getExecutionContext(this.report, data, null, true);
            OperationFinal operation = eh.getOperation(this.report, context);
            operation.setStreamed(true);
            AIPreparedQuery aiPreparedQuery = new AIPreparedQuery();
            aiPreparedQuery.setOperation(operation);
            Map<Thresholds, List<UserInfo>> thresholdList = this.map.get(aiPreparedQuery);
            if (thresholdList == null) {
                thresholdList = new HashMap<Thresholds, List<UserInfo>>();
                this.map.put(aiPreparedQuery, thresholdList);
            }
            if ((userList = thresholdList.get(thresholds)) == null) {
                userList = new ArrayList<UserInfo>();
                thresholdList.put(thresholds, userList);
            }
            UserInfo userInfo = new UserInfo();
            userInfo.setData(data);
            userInfo.setSendMessage(sendMessage);
            userInfo.setMessageTypeList(messageTypeList);
            userList.add(userInfo);
        }
    }
}

