/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.task;

import com.prelytis.dashboard.dao.DaoFactory;
import com.prelytis.dashboard.dao.UserDao;
import com.prelytis.dashboard.helper.BatchHelper;
import com.prelytis.dashboard.helper.DashboardDocumentHelper;
import com.prelytis.dashboard.helper.ExpressionEvaluationDataHelper;
import com.prelytis.dashboard.helper.MessageListener;
import com.prelytis.dashboard.helper.ReportDocumentHelper;
import com.prelytis.dashboard.helper.TableHelper;
import com.prelytis.dashboard.helper.TaskDocExpFilterHelper;
import com.prelytis.dashboard.interfaces.DashboardException;
import com.prelytis.dashboard.interfaces.OutputFormat;
import com.prelytis.dashboard.interfaces.SessionType;
import com.prelytis.dashboard.model.ResponseFactory;
import com.prelytis.dashboard.model.helper.DashBoardHelper;
import com.prelytis.dashboard.model.helper.ReportHelper;
import com.prelytis.dashboard.model.helper.TaskHelper;
import com.prelytis.dashboard.task.AIPreparedQuery;
import com.prelytis.dashboard.task.AbstractTaskExecution;
import com.prelytis.dashboard.task.TaskExceptionHandler;
import com.prelytis.dashboard.task.TaskExecutionException;
import com.prelytis.dashboard.task.TaskExecutionListener;
import com.prelytis.dashboard.value.DocumentRequest;
import com.prelytis.dashboard.value.DocumentResponse;
import com.prelytis.dashboard.value.Request;
import com.prelytis.dashboard.value.data.AbstractBeanReport;
import com.prelytis.dashboard.value.data.BeanDashBoardBlock;
import com.prelytis.dashboard.value.data.BeanDashBoardBlockReport;
import com.prelytis.dashboard.value.data.BeanDashBoardDefinition;
import com.prelytis.dashboard.value.data.BeanDashBoardFilter;
import com.prelytis.dashboard.value.data.BeanDashBoardTemplate;
import com.prelytis.dashboard.value.data.BeanDashboardFilterLinkedField;
import com.prelytis.dashboard.value.data.BeanReportFinal;
import com.prelytis.dashboard.value.data.BeanTaskDocExport;
import com.prelytis.dashboard.value.data.BeanUser;
import com.prelytis.dashboard.value.data.DashBoardFilter;
import com.prelytis.dashboard.value.data.ReportFilter;
import com.prelytis.dashboard.value.data.TaskExpDocFilter;
import com.prelytis.dashboard.value.data.TaskExpDocFilterList;
import com.prelytis.dashboard.value.structure.BatchDocument;
import com.prelytis.dashboard.value.structure.DashboardBlock;
import com.prelytis.dashboard.value.structure.DashboardDocument;
import com.prelytis.dashboard.value.structure.DashboardTemplate;
import com.prelytis.dashboard.value.structure.Document;
import com.prelytis.dashboard.value.structure.ReportDocument;
import com.prelytis.dashboard.value.structure.Task;
import com.prelytis.dashboard.value.structure.UserExecutionContext;
import com.prelytis.dashboard.value.util.ExpressionEvaluationData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TaskDocExportExecution
extends AbstractTaskExecution {
    public TaskDocExportExecution(MessageListener messageListener, TaskExecutionListener listener) {
        super(messageListener, listener);
    }

    @Override
    public int execute(DaoFactory daoFactory, Task task) throws TaskExecutionException {
        log.debug((Object)"Entering TaskDocExportExecution.execute");
        int status = 0;
        try {
            TaskHelper taskHelper = TaskHelper.getInstance(daoFactory);
            ExpressionEvaluationData data = null;
            BeanTaskDocExport taskDocExport = (BeanTaskDocExport)taskHelper.getDefinition(task.getName());
            if (taskDocExport.getDataType() == 1) {
                String reportName = taskDocExport.getReportName();
                ReportHelper reportHelper = ReportHelper.getInstance(daoFactory);
                AbstractBeanReport reportAbstract = reportHelper.getDefinition(reportName);
                BeanReportFinal reportFinal = reportHelper.getFinal(reportAbstract, data);
                UserDao userDao = daoFactory.getUserDao();
                List userList = userDao.listDocExportUserForTask(taskDocExport.getReportOid().intValue(), SessionType.DOCUMENT);
                if (userList == null || userList.isEmpty()) {
                    status = -1;
                    this.addMessage(2, "taskMsg.nobodyConcerned", null);
                    throw new TaskExecutionException("Nobody is concerned by this task", 1);
                }
                ExpressionEvaluationDataHelper helper = ExpressionEvaluationDataHelper.getInstance(daoFactory);
                ArrayList<ExpressionEvaluationData> dataList = new ArrayList<ExpressionEvaluationData>();
                for (BeanUser u : userList) {
                    dataList.add(helper.getExpressionEvaluationData(u));
                }
                List<TaskExpDocFilterList> filterList = taskDocExport.getFilterList();
                if (filterList.isEmpty()) {
                    filterList = this.createDefaultReportFilter(reportFinal);
                }
                Map<AIPreparedQuery, ReportValueMap> map = this.createReportMap(daoFactory, reportAbstract, reportFinal, filterList, dataList);
                status = this.writeReport(daoFactory, map, reportAbstract, task);
                try {
                    this.deleteOldBatchFile(daoFactory, taskDocExport, task.getObjectID());
                }
                catch (Exception e) {
                    log.error((Object)e);
                    status = -1;
                    this.addMessage(2, "taskMsg.deleteOldFiles", null);
                }
            } else if (taskDocExport.getDataType() == 2) {
                DashBoardHelper dashboardHelper = DashBoardHelper.getInstance(daoFactory);
                BeanDashBoardDefinition dashBoard = dashboardHelper.getDefinition(taskDocExport.getDashboardName());
                List dashFilterList = dashBoard.getFilterList();
                UserDao userDao = daoFactory.getUserDao();
                List userList = userDao.listDocExportUserForTask(dashBoard.getObjectID(), SessionType.DASHBOARD);
                if (userList == null || userList.isEmpty()) {
                    status = -1;
                    this.addMessage(2, "taskMsg.nobodyConcerned", null);
                    throw new TaskExecutionException("Nobody is concerned by this task", 1);
                }
                ExpressionEvaluationDataHelper helper = ExpressionEvaluationDataHelper.getInstance(daoFactory);
                ArrayList<ExpressionEvaluationData> dataList = new ArrayList<ExpressionEvaluationData>();
                for (BeanUser u : userList) {
                    dataList.add(helper.getExpressionEvaluationData(u));
                }
                List<TaskExpDocFilterList> filterList = taskDocExport.getFilterList();
                if (filterList.isEmpty()) {
                    filterList = this.createDefaultDashBoardFilter(dashFilterList);
                }
                Map<DashboardKey, DashboardValueMap> map = this.createDashBoardMap(daoFactory, dashBoard, filterList, dataList);
                status = this.writeDashboard(daoFactory, map, dashBoard, task);
                try {
                    this.deleteOldBatchFile(daoFactory, taskDocExport, task.getObjectID());
                }
                catch (Exception e) {
                    log.error((Object)e);
                    status = -1;
                    this.addMessage(2, "taskMsg.deleteOldFiles", null);
                }
            } else {
                log.error((Object)"Type de document non support\u00e9");
            }
        }
        catch (Exception e) {
            log.error((Object)e);
            throw new TaskExecutionException(e, true);
        }
        return status;
    }

    private int writeReport(DaoFactory daoFactory, Map<AIPreparedQuery, ReportValueMap> map, AbstractBeanReport reportAbstract, Task task) throws DashboardException {
        int status = 0;
        int i = 0;
        for (ReportValueMap value : map.values()) {
            status = this.writeReport(daoFactory, value, reportAbstract, task, ++i);
        }
        return status;
    }

    private int writeReport(DaoFactory daoFactory, ReportValueMap value, AbstractBeanReport reportAbstract, Task task, int i) throws DashboardException {
        int status = 0;
        TableHelper tableHelper = value.getTableHelper();
        ReportDocumentHelper.Builder helper = new ReportDocumentHelper.Builder(daoFactory, new TaskExceptionHandler(), reportAbstract, tableHelper.getData(), false);
        ReportDocument document = helper.build(tableHelper, 0).getReportDocument();
        if (document instanceof BatchDocument) {
            ReportDocument batchDocument = document;
            batchDocument.setDateHisto(task.getPlannedDate());
            batchDocument.setFilterName(value.getFilterName());
            batchDocument.setBatchNumber(i);
            batchDocument.setTaskName(task.getName());
            batchDocument.setUserList(value.getUserList());
            status = this.writeDocument(daoFactory, task.getObjectID(), (BatchDocument)batchDocument);
        }
        return status;
    }

    private List<TaskExpDocFilterList> createDefaultReportFilter(BeanReportFinal reportFinal) {
        ArrayList<TaskExpDocFilterList> filterList = new ArrayList<TaskExpDocFilterList>();
        TaskExpDocFilterList taskList = new TaskExpDocFilterList();
        taskList.setCheck(true);
        taskList.setFilterGrpNum(1);
        taskList.setName("defaultFilter");
        taskList.setDescriptionKey("default filter");
        ArrayList<TaskExpDocFilter> list = new ArrayList<TaskExpDocFilter>();
        for (ReportFilter reportFilter : reportFinal.getFilterList()) {
            TaskExpDocFilter filter = new TaskExpDocFilter();
            filter.setFilterNum(1);
            filter.setName(reportFilter.getName());
            filter.setDescription(reportFilter.getDescription());
            filter.setMandatory(Boolean.valueOf(reportFilter.getMandatory()));
            filter.setUse(reportFilter.getMandatory() || reportFilter.getUseFilter());
            filter.setValue(reportFilter.getValue());
            list.add(filter);
        }
        taskList.setTaskExpDocFilterList(list);
        filterList.add(taskList);
        return filterList;
    }

    private Map<AIPreparedQuery, ReportValueMap> createReportMap(DaoFactory daoFactory, AbstractBeanReport reportAbstract, BeanReportFinal reportFinal, List<TaskExpDocFilterList> filterList, List<ExpressionEvaluationData> allUserList) throws DashboardException {
        HashMap<AIPreparedQuery, ReportValueMap> map = new HashMap<AIPreparedQuery, ReportValueMap>();
        for (int i = 0; i < filterList.size(); ++i) {
            TaskExpDocFilterList docFilterList = filterList.get(i);
            for (ExpressionEvaluationData data : allUserList) {
                List<UserExecutionContext> userList;
                TaskDocExpFilterHelper reportFilterHelper = TaskDocExpFilterHelper.getInstance();
                List<ReportFilter> reportFilterList = reportFilterHelper.createReportFilterList(reportFinal, docFilterList);
                TableHelper tableHelper = TableHelper.getInstance(daoFactory);
                tableHelper.setReport(reportAbstract);
                tableHelper.setFilterList(reportFilterList);
                tableHelper.setData(data);
                AIPreparedQuery aiPreparedQuery = new AIPreparedQuery();
                aiPreparedQuery.setOperation(tableHelper.getOperation());
                ReportValueMap reportValueMap = (ReportValueMap)map.get(aiPreparedQuery);
                if (reportValueMap == null) {
                    userList = new ArrayList<UserExecutionContext>();
                    reportValueMap = new ReportValueMap(tableHelper, userList, docFilterList.getName());
                    map.put(aiPreparedQuery, reportValueMap);
                } else {
                    userList = reportValueMap.getUserList();
                }
                UserExecutionContext uec = new UserExecutionContext();
                uec.setUserOID(data.getUserOid().intValue());
                uec.setExecCtxOID(data.getExecutionContextOid().intValue());
                userList.add(uec);
            }
        }
        return map;
    }

    private void deleteOldBatchFile(DaoFactory daoFactory, BeanTaskDocExport taskDocExport, int objectID) throws DashboardException, SQLException {
        if (taskDocExport.isLimiteHistory()) {
            BatchHelper helper = BatchHelper.getInstance(daoFactory);
            helper.cleanHistory(taskDocExport, objectID);
        }
    }

    private List<TaskExpDocFilterList> createDefaultDashBoardFilter(List<BeanDashBoardFilter> dashFilterList) {
        ArrayList<TaskExpDocFilterList> filterList = new ArrayList<TaskExpDocFilterList>();
        TaskExpDocFilterList taskList = new TaskExpDocFilterList();
        taskList.setCheck(true);
        taskList.setFilterGrpNum(1);
        taskList.setName("defaultFilter");
        taskList.setDescriptionKey("default filter");
        ArrayList<TaskExpDocFilter> list = new ArrayList<TaskExpDocFilter>();
        TaskExpDocFilter filter = null;
        for (BeanDashBoardFilter dashFilter : dashFilterList) {
            filter = new TaskExpDocFilter();
            filter.setFilterNum(1);
            filter.setName(dashFilter.getName());
            filter.setDescription(dashFilter.getDescriptionKey());
            filter.setMandatory(Boolean.valueOf(dashFilter.isMandatory()));
            filter.setUse(dashFilter.isMandatory() || dashFilter.isUseFilter());
            filter.setValue(dashFilter.getDefaultValue());
            list.add(filter);
        }
        taskList.setTaskExpDocFilterList(list);
        filterList.add(taskList);
        return filterList;
    }

    private Map<DashboardKey, DashboardValueMap> createDashBoardMap(DaoFactory daoFactory, BeanDashBoardDefinition beanDashBoard, List<TaskExpDocFilterList> filterList, List<ExpressionEvaluationData> dataList) throws DashboardException {
        ReportHelper reportHelper = ReportHelper.getInstance(daoFactory);
        HashMap<DashboardKey, DashboardValueMap> map = new HashMap<DashboardKey, DashboardValueMap>();
        for (TaskExpDocFilterList docFilterList : filterList) {
            for (ExpressionEvaluationData data : dataList) {
                List<UserExecutionContext> userList;
                TaskDocExpFilterHelper dashFilterHelper = TaskDocExpFilterHelper.getInstance();
                List<DashBoardFilter> dashboardFilterList = dashFilterHelper.createDashFilterList(beanDashBoard, docFilterList, data);
                DashboardKey dashboardKey = new DashboardKey();
                DashboardValueMap dashboardValueMap = new DashboardValueMap();
                dashboardValueMap.setFilterName(docFilterList.getName());
                dashboardValueMap.setFilterList(dashboardFilterList);
                List templateList = beanDashBoard.getTemplateList();
                for (BeanDashBoardTemplate template : templateList) {
                    List blockList = template.getBlockList();
                    for (BeanDashBoardBlock block : blockList) {
                        if (!(block instanceof BeanDashBoardBlockReport)) continue;
                        List<ReportFilter> reportFilterList = this.createFilter(dashboardFilterList, template.getId(), block.getId());
                        BeanDashBoardBlockReport blockReport = (BeanDashBoardBlockReport)block;
                        AbstractBeanReport abstractBeanReport = reportHelper.getDefinition(blockReport.getReportName());
                        TableHelper tableHelper = TableHelper.getInstance(daoFactory);
                        tableHelper.setReport(abstractBeanReport);
                        tableHelper.setFilterList(reportFilterList);
                        tableHelper.setData(data);
                        AIPreparedQuery aiPreparedQuery = new AIPreparedQuery();
                        aiPreparedQuery.setOperation(tableHelper.getOperation());
                        dashboardKey.getKey().add(aiPreparedQuery);
                        dashboardValueMap.getHelperList().add(tableHelper);
                    }
                }
                DashboardValueMap valueMap = (DashboardValueMap)map.get(dashboardKey);
                if (valueMap == null) {
                    userList = dashboardValueMap.getUserList();
                    map.put(dashboardKey, dashboardValueMap);
                } else {
                    userList = valueMap.getUserList();
                }
                UserExecutionContext uec = new UserExecutionContext();
                uec.setUserOID(data.getUserOid().intValue());
                uec.setExecCtxOID(data.getExecutionContextOid().intValue());
                userList.add(uec);
            }
        }
        return map;
    }

    private int writeDashboard(DaoFactory daoFactory, Map<DashboardKey, DashboardValueMap> map, BeanDashBoardDefinition dashboard, Task task) throws DashboardException {
        int status = 0;
        int i = 0;
        for (DashboardValueMap value : map.values()) {
            status = this.writeDashboard(daoFactory, value, dashboard, task, ++i);
        }
        return status;
    }

    private int writeDashboard(DaoFactory daoFactory, DashboardValueMap value, BeanDashBoardDefinition dashboard, Task task, int i) throws DashboardException {
        int status = 0;
        List<TableHelper> helperList = value.getHelperList();
        TableHelper helper = helperList.get(0);
        ExpressionEvaluationData data = helper.getData();
        DashboardDocumentHelper documentHelper = DashboardDocumentHelper.getInstance(daoFactory, new TaskExceptionHandler());
        documentHelper.setData(data);
        documentHelper.setDashboard(dashboard);
        documentHelper.setFilterList(value.getFilterList());
        documentHelper.initDashboard();
        DashboardDocument document = documentHelper.getDashboardData();
        this.initHolder(daoFactory, document, helperList, task, data);
        if (document instanceof BatchDocument) {
            DashboardDocument batchDocument = document;
            batchDocument.setDateHisto(task.getPlannedDate());
            batchDocument.setFilterName(value.getFilterName());
            batchDocument.setBatchNumber(i);
            batchDocument.setTaskName(task.getName());
            batchDocument.setUserList(value.getUserList());
            status = this.writeDocument(daoFactory, task.getObjectID(), (BatchDocument)batchDocument);
        }
        return status;
    }

    private int writeDocument(DaoFactory daoFactory, int taskOid, BatchDocument document) {
        int status = -2;
        try {
            BatchHelper helper = BatchHelper.getInstance(daoFactory);
            helper.writeFile(taskOid, document);
            status = 0;
        }
        catch (Exception e) {
            status = e instanceof TaskExecutionException ? ((TaskExecutionException)e).getStatus() : -2;
        }
        return status;
    }

    public void initHolder(DaoFactory daoFactory, DashboardDocument document, List<TableHelper> helperList, Task task, ExpressionEvaluationData data) throws DashboardException {
        ReportHelper reportHelper = ReportHelper.getInstance(daoFactory);
        List templateList = document.getTemplateList();
        for (DashboardTemplate template : templateList) {
            List blockList = template.getBlockList();
            for (DashboardBlock block : blockList) {
                switch (block.getBlockType()) {
                    case DOCUMENT: {
                        TableHelper tableHelper = this.getTableHelper(helperList, block.getObjectName());
                        AbstractBeanReport reportAbstract = reportHelper.getDefinition(block.getObjectName());
                        ReportDocumentHelper.Builder rdhb = new ReportDocumentHelper.Builder(daoFactory, new TaskExceptionHandler(), reportAbstract, data, false);
                        ReportDocument rd = null;
                        try {
                            rd = rdhb.build(tableHelper, reportAbstract.getExecutionMode()).getReportDocument();
                        }
                        catch (DashboardException dbe) {
                            rd = new ReportDocument();
                            rd.setObjectID(reportAbstract.getObjectID());
                            rd.setName(reportAbstract.getName());
                            rd.setDescription((String)reportAbstract.getDescriptionMap().get(data.getLocale()));
                            rd.getDescriptionMap().putAll(reportAbstract.getDescriptionMap());
                        }
                        block.setUserObject((Document)rd);
                        block.setDescription((String)reportAbstract.getDescriptionMap().get(data.getLocale()));
                        break;
                    }
                    case CONTROL: {
                        DocumentRequest request = new DocumentRequest();
                        DocumentResponse response = null;
                        request.setDocumentType(SessionType.CONTROL);
                        request.setOutputFormat(OutputFormat.DATA);
                        request.setName(block.getObjectName());
                        request.setPreferredWidth(block.getWidth() - 10);
                        request.setPreferredHeight(block.getHeight() - 35);
                        try {
                            ResponseFactory factory = ResponseFactory.getResponseBuilder((Request)request);
                            response = (DocumentResponse)factory.create((Request)request, data, daoFactory);
                        }
                        catch (Exception e) {
                            log.error((Object)e);
                        }
                        ReportDocument doc = null;
                        if (response == null || response.getDocument() == null) break;
                        doc = (ReportDocument)response.getDocument().getElement();
                        block.setUserObject((Document)doc);
                        block.setDescription(doc.getDescription());
                    }
                }
            }
        }
    }

    private List<ReportFilter> createFilter(List<DashBoardFilter> dashboardFilterList, int templateId, int blockId) {
        ArrayList<ReportFilter> reportFilterList = new ArrayList<ReportFilter>();
        for (DashBoardFilter dashFilter : dashboardFilterList) {
            for (BeanDashboardFilterLinkedField field : dashFilter.getReportFilterMap()) {
                if (field.getTemplateId() != templateId || field.getBlockId() != blockId) continue;
                ReportFilter reportFilter = new ReportFilter();
                reportFilter.setDatatype(dashFilter.getDatatype());
                reportFilter.setDescription(dashFilter.getDescription());
                reportFilter.setMandatory(dashFilter.getMandatory());
                reportFilter.setName(field.getFieldName());
                reportFilter.setPromptType(dashFilter.getPromptType());
                reportFilter.setUseFilter(dashFilter.getUseFilter());
                reportFilter.setValues(dashFilter.getValues());
                reportFilter.setVisible(true);
                reportFilterList.add(reportFilter);
            }
        }
        return reportFilterList;
    }

    private TableHelper getTableHelper(List<TableHelper> helperList, String name) {
        for (TableHelper helper : helperList) {
            if (!helper.getReport().getName().equals(name)) continue;
            return helper;
        }
        return null;
    }

    class ReportValueMap {
        private TableHelper tableHelper;
        private List<UserExecutionContext> userList;
        private String filterName;

        private ReportValueMap(TableHelper tableHelper, List<UserExecutionContext> userList, String filterName) {
            this.tableHelper = tableHelper;
            this.userList = userList;
            this.filterName = filterName;
        }

        public TableHelper getTableHelper() {
            return this.tableHelper;
        }

        public List<UserExecutionContext> getUserList() {
            return this.userList;
        }

        public String getFilterName() {
            return this.filterName;
        }
    }

    private static class DashboardValueMap {
        private List<DashBoardFilter> filterList;
        private List<TableHelper> helperList = new ArrayList<TableHelper>();
        private List<UserExecutionContext> userList = new ArrayList<UserExecutionContext>();
        private String filterName = null;

        private DashboardValueMap() {
        }

        public String getFilterName() {
            return this.filterName;
        }

        public void setFilterName(String filterName) {
            this.filterName = filterName;
        }

        public List<TableHelper> getHelperList() {
            return this.helperList;
        }

        public List<UserExecutionContext> getUserList() {
            return this.userList;
        }

        public List<DashBoardFilter> getFilterList() {
            return this.filterList;
        }

        public void setFilterList(List<DashBoardFilter> filterList) {
            this.filterList = filterList;
        }
    }

    static class DashboardKey
    implements Comparable<DashboardKey> {
        private List<AIPreparedQuery> key = new ArrayList<AIPreparedQuery>();

        public List<AIPreparedQuery> getKey() {
            return this.key;
        }

        public void setKey(List<AIPreparedQuery> key) {
            this.key = key;
        }

        public boolean equals(Object obj) {
            return this.compareTo((DashboardKey)obj) == 0;
        }

        public int hashCode() {
            return this.key.size();
        }

        @Override
        public int compareTo(DashboardKey o) {
            int resu = 0;
            DashboardKey keyComp = o;
            if (keyComp.key.size() != this.key.size()) {
                resu = 1;
            }
            for (int i = 0; i < this.key.size(); ++i) {
                AIPreparedQuery preparedQuery2;
                AIPreparedQuery preparedQuery1 = this.key.get(i);
                if (preparedQuery1.equals(preparedQuery2 = keyComp.getKey().get(i))) continue;
                resu = 1;
            }
            return resu;
        }
    }
}

