/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.task;

import com.prelytis.dashboard.dao.DaoFactory;
import com.prelytis.dashboard.dao.EntityDao;
import com.prelytis.dashboard.dao.filter.DbDefaultFilter;
import com.prelytis.dashboard.dao.filter.DbEntityFilter;
import com.prelytis.dashboard.helper.DashboardDocumentHelper;
import com.prelytis.dashboard.helper.ExpressionEvaluationDataHelper;
import com.prelytis.dashboard.helper.FileHelper;
import com.prelytis.dashboard.helper.MessageListener;
import com.prelytis.dashboard.helper.ReportDocumentHelper;
import com.prelytis.dashboard.interfaces.DashboardException;
import com.prelytis.dashboard.model.helper.DashBoardHelper;
import com.prelytis.dashboard.model.helper.FolderHelper;
import com.prelytis.dashboard.model.helper.ReportHelper;
import com.prelytis.dashboard.model.helper.TaskHelper;
import com.prelytis.dashboard.task.AbstractTaskExecution;
import com.prelytis.dashboard.task.TaskEvent;
import com.prelytis.dashboard.task.TaskExceptionHandler;
import com.prelytis.dashboard.task.TaskExecutionException;
import com.prelytis.dashboard.task.TaskExecutionListener;
import com.prelytis.dashboard.util.Compare;
import com.prelytis.dashboard.util.ConversionHelper;
import com.prelytis.dashboard.value.data.AbstractBeanReport;
import com.prelytis.dashboard.value.data.BeanDashBoardDefinition;
import com.prelytis.dashboard.value.data.BeanEntity;
import com.prelytis.dashboard.value.data.BeanFile;
import com.prelytis.dashboard.value.data.BeanPersFieldValue;
import com.prelytis.dashboard.value.data.BeanTaskDocGeneration;
import com.prelytis.dashboard.value.data.TaskType;
import com.prelytis.dashboard.value.structure.ImageDocument;
import com.prelytis.dashboard.value.structure.Task;
import com.prelytis.dashboard.value.util.ExpressionEvaluationData;
import java.io.FileOutputStream;
import java.text.ParseException;
import java.util.Date;
import java.util.List;

public class TaskDocGenerationExecution
extends AbstractTaskExecution {
    public TaskDocGenerationExecution(MessageListener messageListener, TaskExecutionListener listener) {
        super(messageListener, listener);
    }

    @Override
    public int execute(DaoFactory daoFactory, Task task) throws TaskExecutionException {
        try {
            TaskHelper taskHelper = TaskHelper.getInstance(daoFactory);
            BeanTaskDocGeneration docGeneration = (BeanTaskDocGeneration)taskHelper.getDefinition(task.getName());
            int retVal = 0;
            DocGenerationExecution docGenerationExecution = new DocGenerationExecution(daoFactory, docGeneration);
            EntityDao entityDao = daoFactory.getEntityDao();
            DbEntityFilter f = new DbEntityFilter();
            f.setActive(Boolean.TRUE);
            List list = entityDao.listAll((DbDefaultFilter)f, 1);
            ExpressionEvaluationDataHelper edh = ExpressionEvaluationDataHelper.getInstance(daoFactory);
            switch (docGeneration.getExecOn()) {
                case 1: {
                    retVal = Math.min(retVal, this.execute(daoFactory, docGenerationExecution, task.getName(), edh.getDefaultData()));
                    return retVal;
                }
                case 2: {
                    this.addMessage(1, "taskMsg.allEntitiesExecution", null);
                    for (int i = 0; i < list.size(); ++i) {
                        BeanEntity entity = (BeanEntity)list.get(i);
                        try {
                            ExpressionEvaluationData data = edh.getExpressionEvaluationData(entity);
                            retVal = Math.min(retVal, this.execute(daoFactory, docGenerationExecution, task.getName(), data));
                            continue;
                        }
                        catch (Exception e) {
                            this.addMessage(3, e.getMessage());
                            log.error((Object)e);
                            retVal = -2;
                        }
                    }
                    return retVal;
                }
                case 3: {
                    for (int i = 0; i < list.size(); ++i) {
                        BeanEntity entity = (BeanEntity)list.get(i);
                        try {
                            ExpressionEvaluationData data = edh.getExpressionEvaluationData(entity);
                            BeanPersFieldValue persFieldValue = this.getPersFieldValue(data.getPersFieldList(), docGeneration.getFieldOID());
                            Object value = persFieldValue.getValues();
                            Object v = null;
                            if (value instanceof Object[]) {
                                Object[] values = (Object[])value;
                                if (values != null && values.length > 0) {
                                    v = values[0];
                                }
                            } else {
                                v = value;
                            }
                            Object refValue = null;
                            ConversionHelper conversionHelper = ConversionHelper.getDBConverter();
                            try {
                                refValue = conversionHelper.parse(persFieldValue.getDataType(), docGeneration.getFieldValue());
                            }
                            catch (ParseException parseException) {
                                // empty catch block
                            }
                            if (!Compare.compare((Object)value, (int)docGeneration.getFieldOperator(), (Object)refValue)) continue;
                            retVal = Math.min(retVal, this.execute(daoFactory, docGenerationExecution, task.getName(), data));
                            continue;
                        }
                        catch (Exception e) {
                            this.addMessage(3, e.getMessage());
                            log.error((Object)e);
                            retVal = -2;
                        }
                    }
                    return retVal;
                }
            }
            return retVal;
        }
        catch (Exception ex) {
            throw new TaskExecutionException(ex, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int execute(DaoFactory daoFactory, DocGenerationExecution docGenerationExecution, String taskName, ExpressionEvaluationData data) {
        int status = -3;
        TaskEvent event = this.startTask(taskName, data.getEntityName());
        try {
            if (data.getEntityName() != null) {
                this.addMessage(1, "taskMsg.entityExecution", data.getEntityName());
            }
            status = docGenerationExecution.calc(daoFactory, data);
        }
        catch (Exception e) {
            log.error((Object)("Task '" + taskName + "' : " + e.getMessage()));
            status = -2;
        }
        finally {
            this.endTask(event, status);
        }
        return status;
    }

    private TaskEvent startTask(String name, String entity) {
        TaskEvent current = new TaskEvent();
        current.setStart(new Date());
        current.setEntityName(entity);
        current.setTaskName(name);
        current.setTaskType(TaskType.TASK_TYPE_DOC_GENERATION);
        this.startTask(current);
        return current;
    }

    private void endTask(TaskEvent event, int status) {
        event.setEnd(new Date());
        event.setStatus(status);
        this.endTask(event);
    }

    private class DocGenerationExecution {
        private FileHelper fileHelper;
        private int sourceType;
        private AbstractBeanReport report;
        private BeanDashBoardDefinition dashboard;

        private DocGenerationExecution(DaoFactory daoFactory, BeanTaskDocGeneration task) throws DashboardException {
            FolderHelper folderHelper = FolderHelper.getInstance(daoFactory);
            BeanFile folder = folderHelper.getDefinition(task.getFolderName());
            this.fileHelper = FileHelper.getInstance(folder, task.getFileName());
            this.sourceType = task.getSourceType();
            switch (this.sourceType) {
                case 2: {
                    DashBoardHelper dashboardHelper = DashBoardHelper.getInstance(daoFactory);
                    this.dashboard = dashboardHelper.getDefinition(task.getDashboardName());
                    break;
                }
                case 1: {
                    ReportHelper reportHelper = ReportHelper.getInstance(daoFactory);
                    this.report = reportHelper.getDefinition(task.getReportName());
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int calc(DaoFactory daoFactory, ExpressionEvaluationData data) throws TaskExecutionException {
            try {
                ImageDocument id = null;
                switch (this.sourceType) {
                    case 2: {
                        DashboardDocumentHelper ddh = DashboardDocumentHelper.getInstance(daoFactory, new TaskExceptionHandler());
                        ddh.setFilterList(null);
                        ddh.setDashboard(this.dashboard);
                        ddh.setData(data);
                        ddh.init();
                        ddh.initHolder();
                        id = ddh.getPdfDashboard(data.getBaseDir(), null);
                        break;
                    }
                    default: {
                        ReportDocumentHelper.Builder rdhb = new ReportDocumentHelper.Builder(daoFactory, new TaskExceptionHandler(), this.report, data, false);
                        ReportDocumentHelper rdh = rdhb.build();
                        id = rdh.getPdfDocument();
                    }
                }
                try (FileOutputStream fis = null;){
                    fis = new FileOutputStream(this.fileHelper.getFile(data));
                    if (id != null) {
                        fis.write(id.getData());
                    }
                }
                return 0;
            }
            catch (Exception e) {
                AbstractTaskExecution.log.error((Object)e, (Throwable)e);
                TaskDocGenerationExecution.this.addMessage(3, e.getMessage());
                return -2;
            }
        }
    }
}

